@extends('admin.layouts.admin')

@section('title', 'Create Shipping Zone')

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="mb-0">Create Shipping Zone</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.shipping-zones.store') }}" method="POST">
                        @csrf
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="city" class="form-label">City <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('city') is-invalid @enderror" 
                                       id="city" 
                                       name="city" 
                                       value="{{ old('city') }}" 
                                       required>
                                @error('city')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                                <label for="state" class="form-label">State <span class="text-danger">*</span></label>
                                <select class="form-select @error('state') is-invalid @enderror" 
                                        id="state" 
                                        name="state" 
                                        required>
                                    <option value="">Select State</option>
                                    @foreach($states as $code => $name)
                                        <option value="{{ $code }}" {{ old('state') == $code ? 'selected' : '' }}>
                                            {{ $name }} ({{ $code }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('state')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="postcode_range" class="form-label">Postcode Range</label>
                            <input type="text" 
                                   class="form-control @error('postcode_range') is-invalid @enderror" 
                                   id="postcode_range" 
                                   name="postcode_range" 
                                   value="{{ old('postcode_range') }}"
                                   placeholder="e.g., 2000-2999">
                            <small class="text-muted">Enter a single postcode or range (e.g., 2000-2999)</small>
                            @error('postcode_range')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <hr class="my-4">
                        <h5 class="mb-3">Shipping Rates</h5>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label for="standard_rate" class="form-label">Standard Rate ($) <span class="text-danger">*</span></label>
                                <input type="number" 
                                       class="form-control @error('standard_rate') is-invalid @enderror" 
                                       id="standard_rate" 
                                       name="standard_rate" 
                                       value="{{ old('standard_rate', 10) }}" 
                                       step="0.01" 
                                       min="0" 
                                       required>
                                @error('standard_rate')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label for="express_rate" class="form-label">Express Rate ($) <span class="text-danger">*</span></label>
                                <input type="number" 
                                       class="form-control @error('express_rate') is-invalid @enderror" 
                                       id="express_rate" 
                                       name="express_rate" 
                                       value="{{ old('express_rate', 15) }}" 
                                       step="0.01" 
                                       min="0" 
                                       required>
                                @error('express_rate')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label for="priority_rate" class="form-label">Priority Rate ($) <span class="text-danger">*</span></label>
                                <input type="number" 
                                       class="form-control @error('priority_rate') is-invalid @enderror" 
                                       id="priority_rate" 
                                       name="priority_rate" 
                                       value="{{ old('priority_rate', 25) }}" 
                                       step="0.01" 
                                       min="0" 
                                       required>
                                @error('priority_rate')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="free_shipping_threshold" class="form-label">Free Shipping Threshold ($)</label>
                                <input type="number" 
                                       class="form-control @error('free_shipping_threshold') is-invalid @enderror" 
                                       id="free_shipping_threshold" 
                                       name="free_shipping_threshold" 
                                       value="{{ old('free_shipping_threshold') }}" 
                                       step="0.01" 
                                       min="0">
                                <small class="text-muted">Leave empty for no free shipping</small>
                                @error('free_shipping_threshold')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                                <label for="sort_order" class="form-label">Sort Order</label>
                                <input type="number" 
                                       class="form-control @error('sort_order') is-invalid @enderror" 
                                       id="sort_order" 
                                       name="sort_order" 
                                       value="{{ old('sort_order', 0) }}">
                                @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input type="checkbox" 
                                       class="form-check-input" 
                                       id="is_active" 
                                       name="is_active" 
                                       value="1" 
                                       {{ old('is_active', true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    Active (Enable this shipping zone)
                                </label>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('admin.shipping-zones.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Create Zone
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="fas fa-info-circle"></i> Help</h5>
                </div>
                <div class="card-body">
                    <h6>Shipping Zone Guidelines</h6>
                    <ul class="small">
                        <li>Set <strong>$0 standard rate</strong> for free shipping to specific cities</li>
                        <li>Use <strong>postcode ranges</strong> to cover multiple areas</li>
                        <li>Set a <strong>free shipping threshold</strong> to offer free delivery on larger orders</li>
                        <li>Express and Priority rates should be higher than Standard</li>
                        <li>The "Other" zone is used as default for unmatched locations</li>
                    </ul>
                    
                    <h6 class="mt-3">Australian Postcode Ranges</h6>
                    <ul class="small">
                        <li>NSW: 2000-2999</li>
                        <li>VIC: 3000-3999</li>
                        <li>QLD: 4000-4999</li>
                        <li>SA: 5000-5999</li>
                        <li>WA: 6000-6999</li>
                        <li>TAS: 7000-7999</li>
                        <li>NT: 0800-0899</li>
                        <li>ACT: 2600-2699</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection