@extends('admin.layouts.admin')

@section('title', 'Create Style Guide')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Create New Style Guide</h3>
                    <a href="{{ route('admin.style-guides.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Back to Style Guides
                    </a>
                </div>

                <form action="{{ route('admin.style-guides.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="card-body">
                        <div class="row">
                            <!-- Basic Information -->
                            <div class="col-md-8">
                                <h5 class="mb-3">Basic Information</h5>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group mb-3">
                                            <label for="name" class="form-label">City Name *</label>
                                            <input type="text" 
                                                   class="form-control @error('name') is-invalid @enderror" 
                                                   id="name" 
                                                   name="name" 
                                                   value="{{ old('name') }}" 
                                                   required>
                                            @error('name')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group mb-3">
                                            <label for="slug" class="form-label">Slug</label>
                                            <input type="text" 
                                                   class="form-control @error('slug') is-invalid @enderror" 
                                                   id="slug" 
                                                   name="slug" 
                                                   value="{{ old('slug') }}">
                                            <small class="form-text text-muted">Leave blank to auto-generate from name</small>
                                            @error('slug')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group mb-3">
                                    <label for="tagline" class="form-label">Tagline *</label>
                                    <input type="text" 
                                           class="form-control @error('tagline') is-invalid @enderror" 
                                           id="tagline" 
                                           name="tagline" 
                                           value="{{ old('tagline') }}" 
                                           placeholder="e.g., Creative Capital Style" 
                                           required>
                                    @error('tagline')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group mb-3">
                                    <label for="description" class="form-label">Description *</label>
                                    <textarea class="form-control @error('description') is-invalid @enderror" 
                                              id="description" 
                                              name="description" 
                                              rows="3" 
                                              required>{{ old('description') }}</textarea>
                                    @error('description')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group mb-3">
                                            <label for="region" class="form-label">Region *</label>
                                            <input type="text" 
                                                   class="form-control @error('region') is-invalid @enderror" 
                                                   id="region" 
                                                   name="region" 
                                                   value="{{ old('region') }}" 
                                                   placeholder="e.g., Victoria" 
                                                   required>
                                            @error('region')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-3">
                                            <label for="population" class="form-label">Population *</label>
                                            <input type="text" 
                                                   class="form-control @error('population') is-invalid @enderror" 
                                                   id="population" 
                                                   name="population" 
                                                   value="{{ old('population') }}" 
                                                   placeholder="e.g., 5.2M" 
                                                   required>
                                            @error('population')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-3">
                                            <label for="climate" class="form-label">Climate *</label>
                                            <input type="text" 
                                                   class="form-control @error('climate') is-invalid @enderror" 
                                                   id="climate" 
                                                   name="climate" 
                                                   value="{{ old('climate') }}" 
                                                   placeholder="e.g., Variable - layers essential" 
                                                   required>
                                            @error('climate')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group mb-3">
                                            <label for="fashion_score" class="form-label">Fashion Score *</label>
                                            <input type="number" 
                                                   class="form-control @error('fashion_score') is-invalid @enderror" 
                                                   id="fashion_score" 
                                                   name="fashion_score" 
                                                   value="{{ old('fashion_score', 7) }}" 
                                                   min="1" 
                                                   max="10" 
                                                   required>
                                            @error('fashion_score')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-3">
                                            <label for="streetwear_popularity" class="form-label">Streetwear Popularity *</label>
                                            <input type="number" 
                                                   class="form-control @error('streetwear_popularity') is-invalid @enderror" 
                                                   id="streetwear_popularity" 
                                                   name="streetwear_popularity" 
                                                   value="{{ old('streetwear_popularity', 75) }}" 
                                                   min="1" 
                                                   max="100" 
                                                   required>
                                            <small class="form-text text-muted">Percentage (1-100)</small>
                                            @error('streetwear_popularity')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-3">
                                            <label for="vibe" class="form-label">Vibe *</label>
                                            <input type="text" 
                                                   class="form-control @error('vibe') is-invalid @enderror" 
                                                   id="vibe" 
                                                   name="vibe" 
                                                   value="{{ old('vibe') }}" 
                                                   placeholder="e.g., Artistic, Creative, Experimental" 
                                                   required>
                                            @error('vibe')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <hr class="my-4">

                                <!-- SEO Information -->
                                <h5 class="mb-3">SEO Information</h5>
                                
                                <div class="form-group mb-3">
                                    <label for="meta_title" class="form-label">Meta Title *</label>
                                    <textarea class="form-control @error('meta_title') is-invalid @enderror" 
                                              id="meta_title" 
                                              name="meta_title" 
                                              rows="2" 
                                              required>{{ old('meta_title') }}</textarea>
                                    @error('meta_title')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group mb-3">
                                    <label for="meta_description" class="form-label">Meta Description *</label>
                                    <textarea class="form-control @error('meta_description') is-invalid @enderror" 
                                              id="meta_description" 
                                              name="meta_description" 
                                              rows="3" 
                                              required>{{ old('meta_description') }}</textarea>
                                    @error('meta_description')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group mb-3">
                                    <label for="keywords" class="form-label">Keywords *</label>
                                    <textarea class="form-control @error('keywords') is-invalid @enderror" 
                                              id="keywords" 
                                              name="keywords" 
                                              rows="2" 
                                              placeholder="Comma-separated keywords" 
                                              required>{{ old('keywords') }}</textarea>
                                    @error('keywords')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Settings & Image -->
                            <div class="col-md-4">
                                <h5 class="mb-3">Settings & Image</h5>
                                
                                <div class="form-group mb-3">
                                    <label for="hero_image" class="form-label">Hero Image</label>
                                    <input type="file" 
                                           class="form-control @error('hero_image') is-invalid @enderror" 
                                           id="hero_image" 
                                           name="hero_image" 
                                           accept="image/*">
                                    <small class="form-text text-muted">Recommended size: 1200x600px</small>
                                    @error('hero_image')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" 
                                               type="checkbox" 
                                               id="is_active" 
                                               name="is_active" 
                                               value="1" 
                                               {{ old('is_active', true) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_active">
                                            Active
                                        </label>
                                    </div>
                                </div>

                                <div class="form-group mb-3">
                                    <label for="sort_order" class="form-label">Sort Order</label>
                                    <input type="number" 
                                           class="form-control @error('sort_order') is-invalid @enderror" 
                                           id="sort_order" 
                                           name="sort_order" 
                                           value="{{ old('sort_order', 0) }}" 
                                           min="0">
                                    @error('sort_order')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="card bg-light mt-4">
                                    <div class="card-body">
                                        <h6 class="card-title">Need Help?</h6>
                                        <p class="card-text small">After creating the basic style guide, you can edit it to add more detailed information like styling tips, characteristics, and gallery images.</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Content -->
                        <h5 class="mb-3">Content</h5>
                        <div class="form-group mb-3">
                            <label for="content" class="form-label">Content (HTML)</label>
                            <textarea class="form-control @error('content') is-invalid @enderror" 
                                      id="content" 
                                      name="content" 
                                      rows="10">{{ old('content') }}</textarea>
                            <small class="form-text text-muted">HTML content for the style guide. You can use the editor after creating the guide.</small>
                            @error('content')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="card-footer">
                        <div class="row">
                            <div class="col-md-6">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Create Style Guide
                                </button>
                                <a href="{{ route('admin.style-guides.index') }}" class="btn btn-secondary ms-2">
                                    Cancel
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-generate slug from name
    $('#name').on('input', function() {
        const name = $(this).val();
        const slug = name.toLowerCase()
            .replace(/[^\w\s-]/g, '')
            .replace(/[\s_-]+/g, '-')
            .replace(/^-+|-+$/g, '');
        $('#slug').val(slug);
    });
});
</script>
@endpush