<div class="row">
    <!-- Basic Information -->
    <div class="col-md-8">
        <h5 class="mb-3">Basic Information</h5>
        
        <div class="row">
            <div class="col-md-6">
                <div class="form-group mb-3">
                    <label for="name" class="form-label">City Name *</label>
                    <input type="text" 
                           class="form-control @error('name') is-invalid @enderror" 
                           id="name" 
                           name="name" 
                           value="{{ old('name', $styleGuide->name) }}" 
                           required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group mb-3">
                    <label for="slug" class="form-label">Slug</label>
                    <input type="text" 
                           class="form-control @error('slug') is-invalid @enderror" 
                           id="slug" 
                           name="slug" 
                           value="{{ old('slug', $styleGuide->slug) }}">
                    <small class="form-text text-muted">Leave blank to auto-generate from name</small>
                    @error('slug')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>

        <div class="form-group mb-3">
            <label for="tagline" class="form-label">Tagline *</label>
            <input type="text" 
                   class="form-control @error('tagline') is-invalid @enderror" 
                   id="tagline" 
                   name="tagline" 
                   value="{{ old('tagline', $styleGuide->tagline) }}" 
                   placeholder="e.g., Creative Capital Style" 
                   required>
            @error('tagline')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group mb-3">
            <label for="description" class="form-label">Description *</label>
            <textarea class="form-control @error('description') is-invalid @enderror" 
                      id="description" 
                      name="description" 
                      rows="3" 
                      required>{{ old('description', $styleGuide->description) }}</textarea>
            @error('description')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="row">
            <div class="col-md-4">
                <div class="form-group mb-3">
                    <label for="region" class="form-label">Region *</label>
                    <input type="text" 
                           class="form-control @error('region') is-invalid @enderror" 
                           id="region" 
                           name="region" 
                           value="{{ old('region', $styleGuide->region) }}" 
                           placeholder="e.g., Victoria" 
                           required>
                    @error('region')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group mb-3">
                    <label for="population" class="form-label">Population *</label>
                    <input type="text" 
                           class="form-control @error('population') is-invalid @enderror" 
                           id="population" 
                           name="population" 
                           value="{{ old('population', $styleGuide->population) }}" 
                           placeholder="e.g., 5.2M" 
                           required>
                    @error('population')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group mb-3">
                    <label for="climate" class="form-label">Climate *</label>
                    <input type="text" 
                           class="form-control @error('climate') is-invalid @enderror" 
                           id="climate" 
                           name="climate" 
                           value="{{ old('climate', $styleGuide->climate) }}" 
                           placeholder="e.g., Variable - layers essential" 
                           required>
                    @error('climate')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-4">
                <div class="form-group mb-3">
                    <label for="fashion_score" class="form-label">Fashion Score *</label>
                    <input type="number" 
                           class="form-control @error('fashion_score') is-invalid @enderror" 
                           id="fashion_score" 
                           name="fashion_score" 
                           value="{{ old('fashion_score', $styleGuide->fashion_score) }}" 
                           min="1" 
                           max="10" 
                           required>
                    @error('fashion_score')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group mb-3">
                    <label for="streetwear_popularity" class="form-label">Streetwear Popularity *</label>
                    <input type="number" 
                           class="form-control @error('streetwear_popularity') is-invalid @enderror" 
                           id="streetwear_popularity" 
                           name="streetwear_popularity" 
                           value="{{ old('streetwear_popularity', $styleGuide->streetwear_popularity) }}" 
                           min="1" 
                           max="100" 
                           required>
                    <small class="form-text text-muted">Percentage (1-100)</small>
                    @error('streetwear_popularity')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group mb-3">
                    <label for="vibe" class="form-label">Vibe *</label>
                    <input type="text" 
                           class="form-control @error('vibe') is-invalid @enderror" 
                           id="vibe" 
                           name="vibe" 
                           value="{{ old('vibe', $styleGuide->vibe) }}" 
                           placeholder="e.g., Artistic, Creative, Experimental" 
                           required>
                    @error('vibe')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>
    </div>

    <!-- Settings & Image -->
    <div class="col-md-4">
        <h5 class="mb-3">Settings & Image</h5>
        
        <div class="form-group mb-3">
            <label for="hero_image" class="form-label">Hero Image</label>
            @if($styleGuide->hero_image)
                <div class="current-image mb-2">
                    <img src="{{ $styleGuide->hero_image_url }}" 
                         alt="Current hero image" 
                         class="img-thumbnail" 
                         style="max-width: 200px;">
                    <p class="small text-muted mt-1">Current image</p>
                </div>
            @endif
            <input type="file" 
                   class="form-control @error('hero_image') is-invalid @enderror" 
                   id="hero_image" 
                   name="hero_image" 
                   accept="image/*">
            <small class="form-text text-muted">
                Recommended size: 1200x600px. Leave empty to keep current image.
            </small>
            <div class="image-preview"></div>
            @error('hero_image')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group mb-3">
            <div class="form-check">
                <input class="form-check-input" 
                       type="checkbox" 
                       id="is_active" 
                       name="is_active" 
                       value="1" 
                       {{ old('is_active', $styleGuide->is_active) ? 'checked' : '' }}>
                <label class="form-check-label" for="is_active">
                    Active
                </label>
            </div>
        </div>

        <div class="form-group mb-3">
            <label for="sort_order" class="form-label">Sort Order</label>
            <input type="number" 
                   class="form-control @error('sort_order') is-invalid @enderror" 
                   id="sort_order" 
                   name="sort_order" 
                   value="{{ old('sort_order', $styleGuide->sort_order) }}" 
                   min="0">
            @error('sort_order')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="card bg-light">
            <div class="card-body">
                <h6 class="card-title">Quick Stats</h6>
                <ul class="list-unstyled mb-0">
                    <li><strong>Created:</strong> {{ $styleGuide->created_at->format('M j, Y') }}</li>
                    <li><strong>Updated:</strong> {{ $styleGuide->updated_at->format('M j, Y') }}</li>
                    <li><strong>Status:</strong> 
                        <span class="badge {{ $styleGuide->is_active ? 'badge-success' : 'badge-secondary' }}">
                            {{ $styleGuide->is_active ? 'Active' : 'Inactive' }}
                        </span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>