<div class="row">
    <div class="col-12">
        <h5 class="mb-3">Style Gallery</h5>
        <p class="text-muted mb-4">Add style inspiration images with descriptions and style types.</p>
        
        <div id="gallery-container">
            @if(old('style_gallery', $styleGuide->style_gallery))
                @foreach(old('style_gallery', $styleGuide->style_gallery) as $index => $galleryItem)
                    <div class="array-item gallery-item mb-4">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Gallery Item #{{ $index + 1 }}</h6>
                                <button type="button" class="btn btn-outline-danger btn-sm remove-item">
                                    <i class="fas fa-trash"></i> Remove
                                </button>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Image</label>
                                            @if(isset($galleryItem['image']) && $galleryItem['image'])
                                                <div class="current-image mb-2">
                                                    <img src="{{ \App\Helpers\ImageHelper::getImageUrl($galleryItem['image']) }}" 
                                                         alt="Gallery image" 
                                                         class="img-thumbnail d-block" 
                                                         style="max-width: 150px;">
                                                    <small class="text-muted">Current image</small>
                                                </div>
                                                <input type="hidden" 
                                                       name="style_gallery[{{ $index }}][image]" 
                                                       value="{{ $galleryItem['image'] }}">
                                            @endif
                                            <input type="file" 
                                                   class="form-control gallery-image-input" 
                                                   name="style_gallery_images[{{ $index }}]" 
                                                   accept="image/*">
                                            <div class="image-preview mt-2"></div>
                                            <small class="form-text text-muted">
                                                Recommended: 400x300px. Leave empty to keep current image.
                                            </small>
                                        </div>
                                    </div>
                                    <div class="col-md-8">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label class="form-label">Description</label>
                                                    <input type="text" 
                                                           class="form-control" 
                                                           name="style_gallery[{{ $index }}][description]" 
                                                           value="{{ $galleryItem['description'] ?? '' }}" 
                                                           placeholder="e.g., Classic Melbourne all-black">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label class="form-label">Style Type</label>
                                                    <select class="form-control" name="style_gallery[{{ $index }}][style_type]">
                                                        <option value="">Select style type</option>
                                                        <option value="Minimalist" {{ ($galleryItem['style_type'] ?? '') == 'Minimalist' ? 'selected' : '' }}>Minimalist</option>
                                                        <option value="Creative" {{ ($galleryItem['style_type'] ?? '') == 'Creative' ? 'selected' : '' }}>Creative</option>
                                                        <option value="Urban" {{ ($galleryItem['style_type'] ?? '') == 'Urban' ? 'selected' : '' }}>Urban</option>
                                                        <option value="Relaxed" {{ ($galleryItem['style_type'] ?? '') == 'Relaxed' ? 'selected' : '' }}>Relaxed</option>
                                                        <option value="Bold" {{ ($galleryItem['style_type'] ?? '') == 'Bold' ? 'selected' : '' }}>Bold</option>
                                                        <option value="Practical" {{ ($galleryItem['style_type'] ?? '') == 'Practical' ? 'selected' : '' }}>Practical</option>
                                                        <option value="Expressive" {{ ($galleryItem['style_type'] ?? '') == 'Expressive' ? 'selected' : '' }}>Expressive</option>
                                                        <option value="Cultural" {{ ($galleryItem['style_type'] ?? '') == 'Cultural' ? 'selected' : '' }}>Cultural</option>
                                                        <option value="Conscious" {{ ($galleryItem['style_type'] ?? '') == 'Conscious' ? 'selected' : '' }}>Conscious</option>
                                                        <option value="Smart-Casual" {{ ($galleryItem['style_type'] ?? '') == 'Smart-Casual' ? 'selected' : '' }}>Smart-Casual</option>
                                                        <option value="Versatile" {{ ($galleryItem['style_type'] ?? '') == 'Versatile' ? 'selected' : '' }}>Versatile</option>
                                                        <option value="Active" {{ ($galleryItem['style_type'] ?? '') == 'Active' ? 'selected' : '' }}>Active</option>
                                                        <option value="Unique" {{ ($galleryItem['style_type'] ?? '') == 'Unique' ? 'selected' : '' }}>Unique</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label class="form-label">Alt Text (for accessibility)</label>
                                            <input type="text" 
                                                   class="form-control" 
                                                   name="style_gallery[{{ $index }}][alt_text]" 
                                                   value="{{ $galleryItem['alt_text'] ?? '' }}" 
                                                   placeholder="Describe the image for screen readers">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>

        <div class="text-center">
            <button type="button" id="add-gallery-item" class="btn btn-outline-primary">
                <i class="fas fa-plus"></i> Add Gallery Item
            </button>
        </div>

        <div class="alert alert-info mt-4">
            <h6><i class="fas fa-info-circle"></i> Gallery Tips:</h6>
            <ul class="mb-0">
                <li>Upload high-quality images (400x300px recommended)</li>
                <li>Use descriptive captions that explain the style</li>
                <li>Choose appropriate style types to categorize looks</li>
                <li>Add alt text for accessibility and SEO</li>
                <li>Aim for 4-6 gallery items per style guide</li>
            </ul>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    let galleryIndex = $('#gallery-container .gallery-item').length;

    // Add gallery item
    $('#add-gallery-item').click(function() {
        const template = `
            <div class="array-item gallery-item mb-4">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Gallery Item #${galleryIndex + 1}</h6>
                        <button type="button" class="btn btn-outline-danger btn-sm remove-item">
                            <i class="fas fa-trash"></i> Remove
                        </button>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label class="form-label">Image</label>
                                    <input type="file" 
                                           class="form-control gallery-image-input" 
                                           name="style_gallery_images[${galleryIndex}]" 
                                           accept="image/*">
                                    <div class="image-preview mt-2"></div>
                                    <small class="form-text text-muted">Recommended: 400x300px</small>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Description</label>
                                            <input type="text" 
                                                   class="form-control" 
                                                   name="style_gallery[${galleryIndex}][description]" 
                                                   placeholder="e.g., Classic Melbourne all-black">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Style Type</label>
                                            <select class="form-control" name="style_gallery[${galleryIndex}][style_type]">
                                                <option value="">Select style type</option>
                                                <option value="Minimalist">Minimalist</option>
                                                <option value="Creative">Creative</option>
                                                <option value="Urban">Urban</option>
                                                <option value="Relaxed">Relaxed</option>
                                                <option value="Bold">Bold</option>
                                                <option value="Practical">Practical</option>
                                                <option value="Expressive">Expressive</option>
                                                <option value="Cultural">Cultural</option>
                                                <option value="Conscious">Conscious</option>
                                                <option value="Smart-Casual">Smart-Casual</option>
                                                <option value="Versatile">Versatile</option>
                                                <option value="Active">Active</option>
                                                <option value="Unique">Unique</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group mb-3">
                                    <label class="form-label">Alt Text (for accessibility)</label>
                                    <input type="text" 
                                           class="form-control" 
                                           name="style_gallery[${galleryIndex}][alt_text]" 
                                           placeholder="Describe the image for screen readers">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        $('#gallery-container').append(template);
        galleryIndex++;
        updateItemNumbers();
    });

    // Remove gallery item
    $(document).on('click', '.remove-item', function() {
        $(this).closest('.gallery-item').remove();
        updateItemNumbers();
    });

    // Update item numbers
    function updateItemNumbers() {
        $('#gallery-container .gallery-item').each(function(index) {
            $(this).find('.card-header h6').text(`Gallery Item #${index + 1}`);
        });
    }

    // Image preview
    $(document).on('change', '.gallery-image-input', function() {
        const input = this;
        const preview = $(this).siblings('.image-preview');
        
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                preview.html(`
                    <img src="${e.target.result}" 
                         class="img-thumbnail" 
                         style="max-width: 150px;">
                    <p class="small text-muted mt-1">New image preview</p>
                `);
            }
            
            reader.readAsDataURL(input.files[0]);
        } else {
            preview.empty();
        }
    });
});
</script>
@endpush