<div class="row">
    <div class="col-12">
        <h5 class="mb-3">SEO Information</h5>
        
        <div class="row">
            <div class="col-md-8">
                <div class="form-group mb-3">
                    <label for="meta_title" class="form-label">Meta Title *</label>
                    <textarea class="form-control @error('meta_title') is-invalid @enderror" 
                              id="meta_title" 
                              name="meta_title" 
                              rows="2" 
                              maxlength="60" 
                              required>{{ old('meta_title', $styleGuide->meta_title) }}</textarea>
                    <div class="d-flex justify-content-between">
                        <small class="form-text text-muted">This appears as the title in search results</small>
                        <small class="text-muted">
                            <span id="meta_title_count">{{ strlen(old('meta_title', $styleGuide->meta_title)) }}</span>/60
                        </small>
                    </div>
                    @error('meta_title')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="meta_description" class="form-label">Meta Description *</label>
                    <textarea class="form-control @error('meta_description') is-invalid @enderror" 
                              id="meta_description" 
                              name="meta_description" 
                              rows="3" 
                              maxlength="160" 
                              required>{{ old('meta_description', $styleGuide->meta_description) }}</textarea>
                    <div class="d-flex justify-content-between">
                        <small class="form-text text-muted">This appears as the description in search results</small>
                        <small class="text-muted">
                            <span id="meta_description_count">{{ strlen(old('meta_description', $styleGuide->meta_description)) }}</span>/160
                        </small>
                    </div>
                    @error('meta_description')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="keywords" class="form-label">Keywords *</label>
                    <textarea class="form-control @error('keywords') is-invalid @enderror" 
                              id="keywords" 
                              name="keywords" 
                              rows="2" 
                              placeholder="Comma-separated keywords (e.g., melbourne streetwear, melbourne fashion, creative style melbourne)" 
                              required>{{ old('keywords', $styleGuide->keywords) }}</textarea>
                    <small class="form-text text-muted">
                        Separate keywords with commas. Focus on location-specific and style-related terms.
                    </small>
                    @error('keywords')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="col-md-4">
                <!-- SEO Preview -->
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-search"></i> Search Preview</h6>
                    </div>
                    <div class="card-body p-3">
                        <div class="seo-preview">
                            <div class="seo-title mb-1" 
                                 style="color: #1a0dab; font-size: 18px; font-family: arial,sans-serif; line-height: 1.2;">
                                {{ old('meta_title', $styleGuide->meta_title) ?: 'Your meta title will appear here' }}
                            </div>
                            <div class="seo-url mb-1" 
                                 style="color: #006621; font-size: 14px; font-family: arial,sans-serif;">
                                {{ route('style-guide.show', old('slug', $styleGuide->slug) ?: 'city-name') }}
                            </div>
                            <div class="seo-description" 
                                 style="color: #545454; font-size: 14px; font-family: arial,sans-serif; line-height: 1.4;">
                                {{ old('meta_description', $styleGuide->meta_description) ?: 'Your meta description will appear here to give users a preview of the page content.' }}
                            </div>
                        </div>
                    </div>
                </div>

                <!-- SEO Tips -->
                <div class="card mt-3">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-lightbulb"></i> SEO Tips</h6>
                    </div>
                    <div class="card-body">
                        <ul class="list-unstyled mb-0 small">
                            <li class="mb-2">
                                <i class="fas fa-check text-success"></i>
                                Include the city name in title and description
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-check text-success"></i>
                                Use "streetwear" and "fashion" keywords
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-check text-success"></i>
                                Keep title under 60 characters
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-check text-success"></i>
                                Keep description under 160 characters
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-check text-success"></i>
                                Make it compelling and actionable
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Weather Information -->
                <div class="card mt-3">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-cloud-sun"></i> Weather Info</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group mb-3">
                                    <label class="form-label">Average Temperature</label>
                                    <input type="text" 
                                           class="form-control" 
                                           name="weather[avg_temp]" 
                                           value="{{ old('weather.avg_temp', $styleGuide->weather['avg_temp'] ?? '') }}" 
                                           placeholder="e.g., 15-20°C">
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group mb-3">
                                    <label class="form-label">Rainfall</label>
                                    <input type="text" 
                                           class="form-control" 
                                           name="weather[rainfall]" 
                                           value="{{ old('weather.rainfall', $styleGuide->weather['rainfall'] ?? '') }}" 
                                           placeholder="e.g., Moderate, year-round">
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group mb-3">
                                    <label class="form-label">Best Months</label>
                                    <input type="text" 
                                           class="form-control" 
                                           name="weather[best_months]" 
                                           value="{{ old('weather.best_months', $styleGuide->weather['best_months'] ?? '') }}" 
                                           placeholder="e.g., Mar-May, Sep-Nov">
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group mb-3">
                                    <label class="form-label">Style Note</label>
                                    <textarea class="form-control" 
                                              name="weather[style_note]" 
                                              rows="2" 
                                              placeholder="Weather-related styling advice">{{ old('weather.style_note', $styleGuide->weather['style_note'] ?? '') }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // Character counters
    function updateCharacterCount(input, countElement, maxLength) {
        const currentLength = $(input).val().length;
        $(countElement).text(currentLength);
        
        // Color coding
        if (currentLength > maxLength * 0.9) {
            $(countElement).removeClass('text-muted text-warning').addClass('text-danger');
        } else if (currentLength > maxLength * 0.75) {
            $(countElement).removeClass('text-muted text-danger').addClass('text-warning');
        } else {
            $(countElement).removeClass('text-warning text-danger').addClass('text-muted');
        }
    }

    // Meta title counter
    $('#meta_title').on('input', function() {
        updateCharacterCount(this, '#meta_title_count', 60);
        updateSeoPreview();
    });

    // Meta description counter
    $('#meta_description').on('input', function() {
        updateCharacterCount(this, '#meta_description_count', 160);
        updateSeoPreview();
    });

    // Update SEO preview
    function updateSeoPreview() {
        const title = $('#meta_title').val() || 'Your meta title will appear here';
        const description = $('#meta_description').val() || 'Your meta description will appear here to give users a preview of the page content.';
        const slug = $('#slug').val() || 'city-name';
        
        $('.seo-title').text(title);
        $('.seo-description').text(description);
        $('.seo-url').text(`{{ url('/style-guide') }}/${slug}`);
    }

    // Update slug in SEO preview when slug changes
    $('#slug').on('input', updateSeoPreview);

    // Initial character count
    updateCharacterCount('#meta_title', '#meta_title_count', 60);
    updateCharacterCount('#meta_description', '#meta_description_count', 160);
    
    // Initial SEO preview
    updateSeoPreview();
});
</script>
@endpush