@extends('admin.layouts.admin')

@section('title', 'Create Tax Rate')

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="mb-0">Create Tax Rate</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.tax-rates.store') }}" method="POST">
                        @csrf
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="city" class="form-label">City <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('city') is-invalid @enderror" 
                                       id="city" 
                                       name="city" 
                                       value="{{ old('city') }}" 
                                       required>
                                @error('city')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                                <label for="state" class="form-label">State <span class="text-danger">*</span></label>
                                <select class="form-select @error('state') is-invalid @enderror" 
                                        id="state" 
                                        name="state" 
                                        required>
                                    <option value="">Select State</option>
                                    @foreach($states as $code => $name)
                                        <option value="{{ $code }}" {{ old('state') == $code ? 'selected' : '' }}>
                                            {{ $name }} ({{ $code }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('state')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="tax_name" class="form-label">Tax Name <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('tax_name') is-invalid @enderror" 
                                       id="tax_name" 
                                       name="tax_name" 
                                       value="{{ old('tax_name', 'GST') }}" 
                                       required>
                                <small class="text-muted">e.g., GST, VAT, Sales Tax</small>
                                @error('tax_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                                <label for="rate" class="form-label">Tax Rate <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="number" 
                                           class="form-control @error('rate') is-invalid @enderror" 
                                           id="rate" 
                                           name="rate" 
                                           value="{{ old('rate', 10) }}" 
                                           step="0.01" 
                                           min="0" 
                                           max="100"
                                           required>
                                    <span class="input-group-text">%</span>
                                </div>
                                @error('rate')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-check">
                                    <input type="checkbox" 
                                           class="form-check-input" 
                                           id="is_percentage" 
                                           name="is_percentage" 
                                           value="1" 
                                           {{ old('is_percentage', true) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_percentage">
                                        Calculate as Percentage (uncheck for fixed amount)
                                    </label>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <label for="sort_order" class="form-label">Sort Order</label>
                                <input type="number" 
                                       class="form-control @error('sort_order') is-invalid @enderror" 
                                       id="sort_order" 
                                       name="sort_order" 
                                       value="{{ old('sort_order', 0) }}">
                                @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input type="checkbox" 
                                       class="form-check-input" 
                                       id="is_active" 
                                       name="is_active" 
                                       value="1" 
                                       {{ old('is_active', true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    Active (Enable this tax rate)
                                </label>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('admin.tax-rates.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Create Tax Rate
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="fas fa-info-circle"></i> Australian GST Information</h5>
                </div>
                <div class="card-body">
                    <h6>Standard GST Rate</h6>
                    <p>The standard GST rate in Australia is <strong>10%</strong> and applies uniformly across all states and territories.</p>
                    
                    <h6>GST-Free Items</h6>
                    <ul class="small">
                        <li>Most basic foods</li>
                        <li>Some education courses</li>
                        <li>Some medical and health services</li>
                        <li>Some childcare services</li>
                        <li>Exports</li>
                    </ul>
                    
                    <h6>Important Notes</h6>
                    <ul class="small mb-0">
                        <li>Prices must be displayed GST-inclusive for consumers</li>
                        <li>GST is calculated on the subtotal before shipping</li>
                        <li>Shipping charges may also be subject to GST</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Toggle between percentage and fixed amount
document.getElementById('is_percentage').addEventListener('change', function() {
    const rateInput = document.getElementById('rate');
    const inputGroup = rateInput.closest('.input-group');
    const groupText = inputGroup.querySelector('.input-group-text');
    
    if (this.checked) {
        groupText.textContent = '%';
        rateInput.setAttribute('max', '100');
    } else {
        groupText.textContent = '$';
        rateInput.removeAttribute('max');
    }
});
</script>
@endpush