@extends('admin.layouts.admin')

@section('title', 'Edit Tax Rate')

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="mb-0">Edit Tax Rate: {{ $taxRate->city }}, {{ $taxRate->state }}</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.tax-rates.update', $taxRate) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="city" class="form-label">City <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('city') is-invalid @enderror" 
                                       id="city" 
                                       name="city" 
                                       value="{{ old('city', $taxRate->city) }}" 
                                       required>
                                @error('city')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                                <label for="state" class="form-label">State <span class="text-danger">*</span></label>
                                <select class="form-select @error('state') is-invalid @enderror" 
                                        id="state" 
                                        name="state" 
                                        required>
                                    <option value="">Select State</option>
                                    @foreach($states as $code => $name)
                                        <option value="{{ $code }}" {{ old('state', $taxRate->state) == $code ? 'selected' : '' }}>
                                            {{ $name }} ({{ $code }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('state')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="tax_name" class="form-label">Tax Name <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('tax_name') is-invalid @enderror" 
                                       id="tax_name" 
                                       name="tax_name" 
                                       value="{{ old('tax_name', $taxRate->tax_name) }}" 
                                       required>
                                <small class="text-muted">e.g., GST, VAT, Sales Tax</small>
                                @error('tax_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                                <label for="rate" class="form-label">Tax Rate <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="number" 
                                           class="form-control @error('rate') is-invalid @enderror" 
                                           id="rate" 
                                           name="rate" 
                                           value="{{ old('rate', $taxRate->rate) }}" 
                                           step="0.01" 
                                           min="0" 
                                           max="{{ $taxRate->is_percentage ? 100 : '' }}"
                                           required>
                                    <span class="input-group-text">{{ $taxRate->is_percentage ? '%' : '$' }}</span>
                                </div>
                                @error('rate')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-check">
                                    <input type="checkbox" 
                                           class="form-check-input" 
                                           id="is_percentage" 
                                           name="is_percentage" 
                                           value="1" 
                                           {{ old('is_percentage', $taxRate->is_percentage) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_percentage">
                                        Calculate as Percentage (uncheck for fixed amount)
                                    </label>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <label for="sort_order" class="form-label">Sort Order</label>
                                <input type="number" 
                                       class="form-control @error('sort_order') is-invalid @enderror" 
                                       id="sort_order" 
                                       name="sort_order" 
                                       value="{{ old('sort_order', $taxRate->sort_order) }}">
                                @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input type="checkbox" 
                                       class="form-check-input" 
                                       id="is_active" 
                                       name="is_active" 
                                       value="1" 
                                       {{ old('is_active', $taxRate->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    Active (Enable this tax rate)
                                </label>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('admin.tax-rates.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Tax Rate
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <!-- Current Settings -->
            <div class="card mb-3">
                <div class="card-header bg-secondary text-white">
                    <h5 class="mb-0">Current Settings</h5>
                </div>
                <div class="card-body">
                    <dl class="row mb-0">
                        <dt class="col-sm-6">Tax Name:</dt>
                        <dd class="col-sm-6">{{ $taxRate->tax_name }}</dd>
                        
                        <dt class="col-sm-6">Rate:</dt>
                        <dd class="col-sm-6">
                            <span class="badge bg-info">{{ $taxRate->formatted_rate }}</span>
                        </dd>
                        
                        <dt class="col-sm-6">Type:</dt>
                        <dd class="col-sm-6">
                            {{ $taxRate->is_percentage ? 'Percentage' : 'Fixed Amount' }}
                        </dd>
                        
                        <dt class="col-sm-6">Status:</dt>
                        <dd class="col-sm-6">
                            @if($taxRate->is_active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-danger">Inactive</span>
                            @endif
                        </dd>
                        
                        <dt class="col-sm-6">Created:</dt>
                        <dd class="col-sm-6">{{ $taxRate->created_at->format('M d, Y') }}</dd>
                        
                        <dt class="col-sm-6">Updated:</dt>
                        <dd class="col-sm-6">{{ $taxRate->updated_at->format('M d, Y') }}</dd>
                    </dl>
                </div>
            </div>

            <!-- Help Card -->
            <div class="card">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="fas fa-info-circle"></i> Tax Guidelines</h5>
                </div>
                <div class="card-body">
                    <h6>GST in Australia</h6>
                    <ul class="small">
                        <li>Standard rate: 10%</li>
                        <li>Applies to most goods and services</li>
                        <li>Some items are GST-free</li>
                        <li>Businesses must register if turnover exceeds $75,000</li>
                    </ul>
                    
                    <h6>Best Practices</h6>
                    <ul class="small mb-0">
                        <li>Keep rates consistent with government regulations</li>
                        <li>Display prices as GST-inclusive</li>
                        <li>Maintain accurate records for tax reporting</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Toggle between percentage and fixed amount
document.getElementById('is_percentage').addEventListener('change', function() {
    const rateInput = document.getElementById('rate');
    const inputGroup = rateInput.closest('.input-group');
    const groupText = inputGroup.querySelector('.input-group-text');
    
    if (this.checked) {
        groupText.textContent = '%';
        rateInput.setAttribute('max', '100');
    } else {
        groupText.textContent = '$';
        rateInput.removeAttribute('max');
    }
});
</script>
@endpush