<!-- resources/views/admin/testimonials/index.blade.php -->
@extends('admin.layouts.admin')

@section('title', 'Testimonials')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Testimonials</h1>
    <a href="{{ route('admin.testimonials.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Add New Testimonial
    </a>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Client</th>
                        <th>Company</th>
                        <th>Country</th>
                        <th>Rating</th>
                        <th>Content</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($testimonials as $testimonial)
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                @if($testimonial->client_image)
                                <img src="{{ asset('storage/' . $testimonial->client_image) }}" 
                                     alt="{{ $testimonial->client_name }}" 
                                     width="40" height="40" 
                                     class="rounded-circle me-2">
                                @endif
                                <div>
                                    {{ $testimonial->client_name }}
                                    @if($testimonial->client_position)
                                        <br><small class="text-muted">{{ $testimonial->client_position }}</small>
                                    @endif
                                </div>
                            </div>
                        </td>
                        <td>{{ $testimonial->client_company ?: '-' }}</td>
                        <td>{{ $testimonial->client_country }}</td>
                        <td>
                            @for($i = 1; $i <= 5; $i++)
                                <i class="fas fa-star {{ $i <= $testimonial->rating ? 'text-warning' : 'text-muted' }} small"></i>
                            @endfor
                        </td>
                        <td>{{ Str::limit($testimonial->content, 50) }}</td>
                        <td>
                            <span class="badge bg-{{ $testimonial->is_active ? 'success' : 'danger' }}">
                                {{ $testimonial->is_active ? 'Active' : 'Inactive' }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('admin.testimonials.edit', $testimonial) }}" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.testimonials.destroy', $testimonial) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center">No testimonials found</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        {{ $testimonials->links() }}
    </div>
</div>
@endsection