@extends('admin.layouts.admin')

@section('title', 'Style Predictions Management')

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3">Style Predictions Management</h1>
            <p class="text-muted">Manage future fashion predictions and trend forecasts</p>
        </div>
        <div>
            <a href="{{ route('trends.predictions') }}" class="btn btn-info me-2" target="_blank">
                <i class="fas fa-eye me-2"></i>View Live
            </a>
            <a href="{{ route('admin.trends.create-predictions') }}" class="btn btn-success">
                <i class="fas fa-plus me-2"></i>Add New Prediction
            </a>
        </div>
    </div>

    <!-- Predictions Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-start border-primary border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-primary text-uppercase mb-1">Total Predictions</div>
                            <div class="h5">{{ count($stylePredictions) }}</div>
                        </div>
                        <i class="fas fa-crystal-ball fa-2x text-primary"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-success border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-success text-uppercase mb-1">2024 Predictions</div>
                            <div class="h5">{{ collect($stylePredictions)->where('year', 2024)->count() }}</div>
                        </div>
                        <i class="fas fa-calendar-check fa-2x text-success"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-warning border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-warning text-uppercase mb-1">2025 Predictions</div>
                            <div class="h5">{{ collect($stylePredictions)->where('year', 2025)->count() }}</div>
                        </div>
                        <i class="fas fa-calendar-plus fa-2x text-warning"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-info border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-info text-uppercase mb-1">High Confidence</div>
                            <div class="h5">{{ collect($stylePredictions)->where('confidence', '>=', 80)->count() }}</div>
                        </div>
                        <i class="fas fa-chart-line fa-2x text-info"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Style Predictions List -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Style Predictions</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th style="width: 80px;">Image</th>
                            <th>Prediction</th>
                            <th style="width: 100px;">Category</th>
                            <th style="width: 80px;">Year</th>
                            <th style="width: 100px;">Confidence</th>
                            <th style="width: 120px;">Impact Level</th>
                            <th style="width: 150px;" class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($stylePredictions as $prediction)
                        <tr>
                            <td>
                                <img src="{{ \App\Helpers\ImageHelper::getImageUrl($prediction['image']) }}" 
                                     class="rounded" 
                                     style="width: 60px; height: 60px; object-fit: cover;" 
                                     alt="{{ $prediction['title'] }}">
                            </td>
                            <td>
                                <h6 class="mb-1">{{ $prediction['title'] }}</h6>
                                <p class="text-muted small mb-0">{{ Str::limit($prediction['description'], 100) }}</p>
                            </td>
                            <td>
                                <span class="badge 
                                    @if($prediction['category'] === 'Technology') bg-primary
                                    @elseif($prediction['category'] === 'Sustainability') bg-success
                                    @elseif($prediction['category'] === 'Materials') bg-info
                                    @else bg-warning text-dark
                                    @endif
                                ">
                                    @if($prediction['category'] === 'Technology')
                                        <i class="fas fa-microchip me-1"></i>
                                    @elseif($prediction['category'] === 'Sustainability')
                                        <i class="fas fa-leaf me-1"></i>
                                    @elseif($prediction['category'] === 'Materials')
                                        <i class="fas fa-vial me-1"></i>
                                    @else
                                        <i class="fas fa-palette me-1"></i>
                                    @endif
                                    {{ $prediction['category'] }}
                                </span>
                            </td>
                            <td>
                                <span class="fw-bold">{{ $prediction['year'] }}</span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="progress me-2" style="width: 60px; height: 20px;">
                                        <div class="progress-bar 
                                            @if($prediction['confidence'] >= 80) bg-success
                                            @elseif($prediction['confidence'] >= 60) bg-warning
                                            @else bg-danger
                                            @endif
                                        " 
                                        style="width: {{ $prediction['confidence'] }}%"></div>
                                    </div>
                                    <small class="fw-bold">{{ $prediction['confidence'] }}%</small>
                                </div>
                            </td>
                            <td>
                                <span class="badge 
                                    @if($prediction['impact_level'] === 'Revolutionary') bg-danger
                                    @elseif($prediction['impact_level'] === 'Significant') bg-warning text-dark
                                    @else bg-info
                                    @endif
                                ">
                                    @if($prediction['impact_level'] === 'Revolutionary')
                                        <i class="fas fa-rocket me-1"></i>
                                    @elseif($prediction['impact_level'] === 'Significant')
                                        <i class="fas fa-star me-1"></i>
                                    @else
                                        <i class="fas fa-wave-square me-1"></i>
                                    @endif
                                    {{ $prediction['impact_level'] }}
                                </span>
                            </td>
                            <td class="text-center">
                                <div class="btn-group" role="group">
                                    <a href="{{ route('trends.predictions') }}#{{ $prediction['slug'] }}" 
                                       class="btn btn-sm btn-outline-info" title="View" target="_blank">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.trends.edit-predictions', $prediction['slug']) }}" 
                                       class="btn btn-sm btn-outline-primary" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-outline-danger" 
                                            onclick="confirmDelete('{{ $prediction['slug'] }}', '{{ $prediction['title'] }}')" 
                                            title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center py-5">
                                <i class="fas fa-crystal-ball fa-3x text-muted mb-3"></i>
                                <p class="text-muted">No style predictions found. Create your first prediction to get started!</p>
                                <a href="{{ route('admin.trends.create-predictions') }}" class="btn btn-success">
                                    <i class="fas fa-plus me-2"></i>Add New Prediction
                                </a>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Predictions Analytics -->
    <div class="row mt-4">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Prediction Timeline</h6>
                </div>
                <div class="card-body">
                    @php
                        $years = collect($stylePredictions)->groupBy('year')->sortKeys();
                    @endphp
                    
                    @foreach($years as $year => $yearPredictions)
                    <div class="row mb-4">
                        <div class="col-2">
                            <div class="text-center">
                                <div class="badge bg-primary fs-6">{{ $year }}</div>
                            </div>
                        </div>
                        <div class="col-10">
                            <div class="row">
                                @foreach($yearPredictions->take(3) as $prediction)
                                <div class="col-md-4">
                                    <div class="card border-0 bg-light">
                                        <div class="card-body p-3">
                                            <h6 class="small mb-1">{{ Str::limit($prediction['title'], 40) }}</h6>
                                            <div class="d-flex justify-content-between align-items-center">
                                                <small class="text-muted">{{ $prediction['category'] }}</small>
                                                <span class="badge bg-success">{{ $prediction['confidence'] }}%</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Confidence Overview</h6>
                </div>
                <div class="card-body">
                    @php
                        $highConfidence = collect($stylePredictions)->where('confidence', '>=', 80)->count();
                        $mediumConfidence = collect($stylePredictions)->whereBetween('confidence', [60, 79])->count();
                        $lowConfidence = collect($stylePredictions)->where('confidence', '<', 60)->count();
                        $total = count($stylePredictions);
                    @endphp
                    
                    <div class="mb-3">
                        <div class="d-flex justify-content-between">
                            <small>High Confidence (80%+)</small>
                            <small>{{ $highConfidence }}</small>
                        </div>
                        <div class="progress mb-2" style="height: 8px;">
                            <div class="progress-bar bg-success" style="width: {{ $total > 0 ? ($highConfidence / $total * 100) : 0 }}%"></div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="d-flex justify-content-between">
                            <small>Medium Confidence (60-79%)</small>
                            <small>{{ $mediumConfidence }}</small>
                        </div>
                        <div class="progress mb-2" style="height: 8px;">
                            <div class="progress-bar bg-warning" style="width: {{ $total > 0 ? ($mediumConfidence / $total * 100) : 0 }}%"></div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="d-flex justify-content-between">
                            <small>Low Confidence (<60%)</small>
                            <small>{{ $lowConfidence }}</small>
                        </div>
                        <div class="progress mb-2" style="height: 8px;">
                            <div class="progress-bar bg-danger" style="width: {{ $total > 0 ? ($lowConfidence / $total * 100) : 0 }}%"></div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="mt-3">
                        <h6 class="small fw-bold">Key Categories:</h6>
                        <div class="d-flex flex-wrap gap-1">
                            <span class="badge bg-primary">Technology</span>
                            <span class="badge bg-success">Sustainability</span>
                            <span class="badge bg-info">Materials</span>
                            <span class="badge bg-warning text-dark">Color Trends</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete the prediction "<span id="deletePredictionTitle"></span>"?</p>
                <p class="text-muted small">This action cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete Prediction</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(slug, title) {
    document.getElementById('deletePredictionTitle').textContent = title;
    document.getElementById('deleteForm').action = `/admin/trends/predictions/${slug}`;
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}
</script>
@endsection