@extends('admin.layouts.admin')

@section('title', 'Seasonal Forecasts Management')

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3">Seasonal Forecasts Management</h1>
            <p class="text-muted">Manage seasonal fashion forecasts and predictions</p>
        </div>
        <div>
            <a href="{{ route('trends.seasonal') }}" class="btn btn-info me-2" target="_blank">
                <i class="fas fa-eye me-2"></i>View Live
            </a>
            <a href="{{ route('admin.trends.create-seasonal') }}" class="btn btn-success">
                <i class="fas fa-plus me-2"></i>Add New Forecast
            </a>
        </div>
    </div>

    <!-- Seasonal Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-start border-warning border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-warning text-uppercase mb-1">Spring Forecasts</div>
                            <div class="h5">{{ collect($seasonalForecasts)->where('season', 'Spring')->count() }}</div>
                        </div>
                        <i class="fas fa-seedling fa-2x text-warning"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-success border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-success text-uppercase mb-1">Summer Forecasts</div>
                            <div class="h5">{{ collect($seasonalForecasts)->where('season', 'Summer')->count() }}</div>
                        </div>
                        <i class="fas fa-sun fa-2x text-success"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-info border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-info text-uppercase mb-1">Autumn Forecasts</div>
                            <div class="h5">{{ collect($seasonalForecasts)->where('season', 'Autumn')->count() }}</div>
                        </div>
                        <i class="fas fa-leaf fa-2x text-info"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-primary border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-primary text-uppercase mb-1">Winter Forecasts</div>
                            <div class="h5">{{ collect($seasonalForecasts)->where('season', 'Winter')->count() }}</div>
                        </div>
                        <i class="fas fa-snowflake fa-2x text-primary"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Seasonal Forecasts List -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Seasonal Forecasts</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th style="width: 80px;">Image</th>
                            <th>Title</th>
                            <th style="width: 100px;">Season</th>
                            <th style="width: 120px;">Year</th>
                            <th style="width: 100px;">Status</th>
                            <th style="width: 120px;">Updated</th>
                            <th style="width: 150px;" class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($seasonalForecasts as $forecast)
                        <tr>
                            <td>
                                <img src="{{ \App\Helpers\ImageHelper::getImageUrl($forecast['image']) }}" 
                                     class="rounded" 
                                     style="width: 60px; height: 60px; object-fit: cover;" 
                                     alt="{{ $forecast['title'] }}">
                            </td>
                            <td>
                                <h6 class="mb-1">{{ $forecast['title'] }}</h6>
                                <p class="text-muted small mb-0">{{ Str::limit($forecast['description'], 80) }}</p>
                            </td>
                            <td>
                                <span class="badge 
                                    @if($forecast['season'] === 'Spring') bg-warning text-dark
                                    @elseif($forecast['season'] === 'Summer') bg-success
                                    @elseif($forecast['season'] === 'Autumn') bg-info
                                    @else bg-primary
                                    @endif
                                ">
                                    @if($forecast['season'] === 'Spring')
                                        <i class="fas fa-seedling me-1"></i>
                                    @elseif($forecast['season'] === 'Summer')
                                        <i class="fas fa-sun me-1"></i>
                                    @elseif($forecast['season'] === 'Autumn')
                                        <i class="fas fa-leaf me-1"></i>
                                    @else
                                        <i class="fas fa-snowflake me-1"></i>
                                    @endif
                                    {{ $forecast['season'] }}
                                </span>
                            </td>
                            <td>
                                <span class="fw-bold">{{ $forecast['year'] }}</span>
                            </td>
                            <td>
                                <span class="badge bg-{{ $forecast['status'] === 'active' ? 'success' : 'secondary' }}">
                                    {{ ucfirst($forecast['status']) }}
                                </span>
                            </td>
                            <td>
                                <small class="text-muted">
                                    {{ date('M j, Y', strtotime($forecast['updated_at'])) }}
                                </small>
                            </td>
                            <td class="text-center">
                                <div class="btn-group" role="group">
                                    <a href="{{ route('trends.seasonal') }}#{{ $forecast['slug'] }}" 
                                       class="btn btn-sm btn-outline-info" title="View" target="_blank">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.trends.edit-seasonal', $forecast['slug']) }}" 
                                       class="btn btn-sm btn-outline-primary" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-outline-danger" 
                                            onclick="confirmDelete('{{ $forecast['slug'] }}', '{{ $forecast['title'] }}')" 
                                            title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center py-5">
                                <i class="fas fa-calendar-alt fa-3x text-muted mb-3"></i>
                                <p class="text-muted">No seasonal forecasts found. Create your first forecast to get started!</p>
                                <a href="{{ route('admin.trends.create-seasonal') }}" class="btn btn-success">
                                    <i class="fas fa-plus me-2"></i>Add New Forecast
                                </a>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Season Overview -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Current Season Focus</h6>
                </div>
                <div class="card-body">
                    @php
                        $currentMonth = date('n');
                        $currentSeason = $currentMonth >= 3 && $currentMonth <= 5 ? 'Spring' :
                                        ($currentMonth >= 6 && $currentMonth <= 8 ? 'Summer' :
                                        ($currentMonth >= 9 && $currentMonth <= 11 ? 'Autumn' : 'Winter'));
                        $currentForecasts = collect($seasonalForecasts)->where('season', $currentSeason)->take(3);
                    @endphp
                    
                    <div class="mb-3">
                        <span class="badge bg-info fs-6">{{ $currentSeason }} {{ date('Y') }}</span>
                    </div>
                    
                    @foreach($currentForecasts as $forecast)
                    <div class="d-flex align-items-center mb-3 {{ !$loop->last ? 'border-bottom pb-3' : '' }}">
                        <img src="{{ \App\Helpers\ImageHelper::getImageUrl($forecast['image']) }}" 
                             class="rounded me-3" 
                             style="width: 50px; height: 50px; object-fit: cover;" 
                             alt="{{ $forecast['title'] }}">
                        <div class="flex-grow-1">
                            <h6 class="mb-1 small">{{ Str::limit($forecast['title'], 50) }}</h6>
                            <div class="d-flex align-items-center gap-2">
                                <span class="badge bg-light text-dark small">{{ $forecast['year'] }}</span>
                                <small class="text-muted">{{ ucfirst($forecast['status']) }}</small>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Forecast Analytics</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6">
                            <div class="text-center">
                                <div class="h4 text-success">{{ collect($seasonalForecasts)->where('status', 'active')->count() }}</div>
                                <small class="text-muted">Active Forecasts</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="text-center">
                                <div class="h4 text-warning">{{ collect($seasonalForecasts)->where('year', date('Y'))->count() }}</div>
                                <small class="text-muted">This Year</small>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="mt-3">
                        <h6 class="small fw-bold">Upcoming Seasons:</h6>
                        <div class="d-flex flex-wrap gap-1">
                            @php
                                $nextSeasons = ['Spring', 'Summer', 'Autumn', 'Winter'];
                                $nextYear = date('Y') + 1;
                            @endphp
                            @foreach($nextSeasons as $season)
                                <span class="badge bg-light text-dark">{{ $season }} {{ $nextYear }}</span>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete the forecast "<span id="deleteForecastTitle"></span>"?</p>
                <p class="text-muted small">This action cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete Forecast</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(slug, title) {
    document.getElementById('deleteForecastTitle').textContent = title;
    document.getElementById('deleteForm').action = `/admin/trends/seasonal/${slug}`;
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}
</script>
@endsection