@extends('layouts.app')

@section('title', 'Frequently Asked Questions | Edition By Punjab Australia')

@section('meta')
<meta name="description" content="Get answers to common questions about Edition By Punjab streetwear. Shipping, sizing, cultural authenticity, product care, returns and more.">
<meta name="keywords" content="edition by punjab faq, streetwear questions, punjabi clothing faq, australian shipping, size guide, cultural fashion questions">
@endsection

@section('content')
<x-breadcrumb />

<!-- Hero Section -->
<section class="faq-hero py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center text-white">
                <h1 class="display-4 fw-bold mb-4">Frequently Asked Questions</h1>
                <p class="lead mb-4">Everything you need to know about Edition By Punjab - from ordering and sizing to cultural authenticity and care instructions.</p>
                <div class="search-box bg-white rounded p-2 d-inline-flex align-items-center">
                    <input type="text" id="faqSearch" class="form-control border-0" placeholder="Search FAQs..." style="box-shadow: none;">
                    <i class="fas fa-search text-muted ms-2"></i>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Quick Links -->
<section class="quick-links py-4 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="d-flex flex-wrap justify-content-center gap-2">
                    @foreach($faqs as $index => $category)
                        <a href="#category-{{ $index }}" class="btn btn-outline-primary btn-sm">
                            {{ $category['category'] }}
                        </a>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Categories -->
<section class="faq-content py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                @foreach($faqs as $index => $category)
                    <div id="category-{{ $index }}" class="faq-category mb-5">
                        <div class="category-header text-center mb-4">
                            <h2 class="text-primary mb-2">{{ $category['category'] }}</h2>
                            <div class="category-divider mx-auto" style="width: 60px; height: 3px; background: linear-gradient(to right, #667eea, #764ba2);"></div>
                        </div>
                        
                        <div class="accordion" id="accordion-{{ $index }}">
                            @foreach($category['questions'] as $qIndex => $qa)
                                <div class="accordion-item border-0 mb-3 shadow-sm rounded faq-item">
                                    <h3 class="accordion-header">
                                        <button class="accordion-button collapsed fw-bold text-dark bg-light" 
                                                type="button" 
                                                data-bs-toggle="collapse" 
                                                data-bs-target="#collapse-{{ $index }}-{{ $qIndex }}" 
                                                aria-expanded="false">
                                            <i class="fas fa-question-circle text-primary me-3"></i>
                                            {{ $qa['q'] }}
                                        </button>
                                    </h3>
                                    <div id="collapse-{{ $index }}-{{ $qIndex }}" 
                                         class="accordion-collapse collapse" 
                                         data-bs-parent="#accordion-{{ $index }}">
                                        <div class="accordion-body bg-white p-4">
                                            <div class="d-flex align-items-start">
                                                <i class="fas fa-check-circle text-success me-3 mt-1"></i>
                                                <p class="mb-0">{{ $qa['a'] }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>

<!-- Still Have Questions -->
<section class="contact-section py-5 bg-primary text-white">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h2 class="mb-4">Still Have Questions?</h2>
                <p class="lead mb-4">Can't find what you're looking for? Our customer service team is here to help!</p>
                
                <div class="row g-4 mb-4">
                    <div class="col-md-4">
                        <div class="contact-method p-3">
                            <i class="fas fa-envelope fa-2x mb-3"></i>
                            <h5>Email Us</h5>
                            <p class="mb-0">hello@editionbypunjab.com</p>
                            <small>Response within 24 hours</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="contact-method p-3">
                            <i class="fas fa-phone fa-2x mb-3"></i>
                            <h5>Call Us</h5>
                            <p class="mb-0">1800 EDITION</p>
                            <small>Mon-Fri 9AM-5PM AEST</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="contact-method p-3">
                            <i class="fas fa-comments fa-2x mb-3"></i>
                            <h5>Live Chat</h5>
                            <p class="mb-0">Instant Help</p>
                            <small>Available during business hours</small>
                        </div>
                    </div>
                </div>
                
                <a href="{{ route('contact') }}" class="btn btn-light btn-lg">
                    Contact Us <i class="fas fa-arrow-right ms-2"></i>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Popular Searches -->
<section class="popular-searches py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h3 class="mb-4">Popular Questions</h3>
                <div class="popular-tags">
                    <span class="badge bg-primary me-2 mb-2 p-2">Shipping to Australia</span>
                    <span class="badge bg-success me-2 mb-2 p-2">Size Guide</span>
                    <span class="badge bg-info me-2 mb-2 p-2">Cultural Authenticity</span>
                    <span class="badge bg-warning me-2 mb-2 p-2">Return Policy</span>
                    <span class="badge bg-danger me-2 mb-2 p-2">Product Care</span>
                    <span class="badge bg-secondary me-2 mb-2 p-2">Ethical Manufacturing</span>
                    <span class="badge bg-dark me-2 mb-2 p-2">Sustainable Materials</span>
                    <span class="badge bg-primary me-2 mb-2 p-2">Punjabi Heritage</span>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Related Resources -->
<section class="related-resources py-5">
    <div class="container">
        <div class="row">
            <div class="col-12 mb-4">
                <h3 class="text-center mb-4">Helpful Resources</h3>
            </div>
        </div>
        
        <div class="row g-4">
            <div class="col-lg-3 col-md-6">
                <div class="resource-card h-100 bg-white rounded shadow-sm p-4 text-center">
                    <i class="fas fa-ruler-combined fa-3x text-primary mb-3"></i>
                    <h5 class="mb-3">Size Guides</h5>
                    <p class="text-muted mb-3">Detailed sizing information for all product categories</p>
                    <a href="{{ route('size-guide.index') }}" class="btn btn-outline-primary">
                        View Guides
                    </a>
                </div>
            </div>
            
            <div class="col-lg-3 col-md-6">
                <div class="resource-card h-100 bg-white rounded shadow-sm p-4 text-center">
                    <i class="fas fa-shipping-fast fa-3x text-success mb-3"></i>
                    <h5 class="mb-3">Shipping Info</h5>
                    <p class="text-muted mb-3">Delivery options and tracking information</p>
                    <a href="{{ route('legal.show', 'shipping-policy') }}" class="btn btn-outline-success">
                        Learn More
                    </a>
                </div>
            </div>
            
            <div class="col-lg-3 col-md-6">
                <div class="resource-card h-100 bg-white rounded shadow-sm p-4 text-center">
                    <i class="fas fa-undo fa-3x text-info mb-3"></i>
                    <h5 class="mb-3">Returns</h5>
                    <p class="text-muted mb-3">Easy returns and exchange process</p>
                    <a href="{{ route('legal.show', 'returns-exchanges') }}" class="btn btn-outline-info">
                        Return Policy
                    </a>
                </div>
            </div>
            
            <div class="col-lg-3 col-md-6">
                <div class="resource-card h-100 bg-white rounded shadow-sm p-4 text-center">
                    <i class="fas fa-heart fa-3x text-danger mb-3"></i>
                    <h5 class="mb-3">Product Care</h5>
                    <p class="text-muted mb-3">Keep your streetwear looking fresh</p>
                    <a href="{{ route('blogs.index') }}" class="btn btn-outline-danger">
                        Care Tips
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

@push('styles')
<style>
    .faq-hero {
        min-height: 400px;
        display: flex;
        align-items: center;
    }
    
    .search-box {
        max-width: 400px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    }
    
    .faq-item {
        transition: transform 0.2s ease;
    }
    
    .faq-item:hover {
        transform: translateY(-2px);
    }
    
    .accordion-button:not(.collapsed) {
        background-color: #667eea;
        color: white;
    }
    
    .accordion-button:focus {
        box-shadow: none;
        border-color: transparent;
    }
    
    .category-divider {
        border-radius: 2px;
    }
    
    .contact-method {
        transition: transform 0.3s ease;
    }
    
    .contact-method:hover {
        transform: translateY(-5px);
    }
    
    .resource-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .resource-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 20px 40px rgba(0,0,0,0.1);
    }
    
    .popular-tags .badge {
        cursor: pointer;
        transition: transform 0.2s ease;
    }
    
    .popular-tags .badge:hover {
        transform: scale(1.05);
    }
    
    .quick-links .btn {
        transition: all 0.2s ease;
    }
    
    .quick-links .btn:hover {
        transform: translateY(-2px);
    }
    
    /* Search highlighting */
    .highlight {
        background-color: yellow;
        padding: 2px 4px;
        border-radius: 3px;
    }
    
    .faq-item.hidden {
        display: none;
    }
</style>
@endpush

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('faqSearch');
    const faqItems = document.querySelectorAll('.faq-item');
    
    searchInput.addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase().trim();
        
        faqItems.forEach(item => {
            const question = item.querySelector('.accordion-button').textContent.toLowerCase();
            const answer = item.querySelector('.accordion-body p').textContent.toLowerCase();
            
            if (searchTerm === '') {
                item.classList.remove('hidden');
                // Remove any existing highlights
                removeHighlights(item);
            } else if (question.includes(searchTerm) || answer.includes(searchTerm)) {
                item.classList.remove('hidden');
                highlightText(item, searchTerm);
            } else {
                item.classList.add('hidden');
            }
        });
    });
    
    function highlightText(item, searchTerm) {
        // Remove existing highlights
        removeHighlights(item);
        
        const questionElement = item.querySelector('.accordion-button');
        const answerElement = item.querySelector('.accordion-body p');
        
        questionElement.innerHTML = highlightMatch(questionElement.textContent, searchTerm);
        answerElement.innerHTML = highlightMatch(answerElement.textContent, searchTerm);
    }
    
    function removeHighlights(item) {
        const highlighted = item.querySelectorAll('.highlight');
        highlighted.forEach(el => {
            el.outerHTML = el.textContent;
        });
    }
    
    function highlightMatch(text, searchTerm) {
        const regex = new RegExp(`(${searchTerm})`, 'gi');
        return text.replace(regex, '<span class="highlight">$1</span>');
    }
    
    // Popular tag click functionality
    document.querySelectorAll('.popular-tags .badge').forEach(badge => {
        badge.addEventListener('click', function() {
            const searchTerm = this.textContent.trim();
            searchInput.value = searchTerm;
            searchInput.dispatchEvent(new Event('input'));
            
            // Scroll to search box
            searchInput.scrollIntoView({ behavior: 'smooth', block: 'center' });
        });
    });
});
</script>
@endpush

<!-- JSON-LD for FAQ -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "FAQPage",
    "mainEntity": [
        @foreach($faqs as $category)
            @foreach($category['questions'] as $qa)
            {
                "@type": "Question",
                "name": "{{ $qa['q'] }}",
                "acceptedAnswer": {
                    "@type": "Answer",
                    "text": "{{ $qa['a'] }}"
                }
            }{{ !$loop->parent->last || !$loop->last ? ',' : '' }}
            @endforeach
        @endforeach
    ],
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "{{ route('home') }}"
    }
}
</script>
@endsection