@if(count($breadcrumbs) > 1)
<!-- Breadcrumb Navigation with SEO Schema -->
<nav aria-label="breadcrumb" class="breadcrumb-nav py-2" style="background: #f8f9fa;">
    <div class="container">
        <ol class="breadcrumb mb-0">
            @foreach($breadcrumbs as $key => $breadcrumb)
                @if($key === count($breadcrumbs) - 1)
                    <!-- Current page - no link -->
                    <li class="breadcrumb-item active" aria-current="page">
                        <span>{{ $breadcrumb['name'] }}</span>
                    </li>
                @else
                    <!-- Previous pages - with links -->
                    <li class="breadcrumb-item">
                        <a href="{{ $breadcrumb['url'] }}" class="text-decoration-none">
                            {{ $breadcrumb['name'] }}
                        </a>
                    </li>
                @endif
            @endforeach
        </ol>
    </div>
</nav>

<!-- JSON-LD Structured Data for SEO -->
<script type="application/ld+json">
{!! json_encode($jsonLd, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
</script>

@once
@push('styles')
<style>
    .breadcrumb-nav {
        border-bottom: 1px solid rgba(0,0,0,0.1);
    }
    
    .breadcrumb {
        font-size: 0.875rem;
        margin-bottom: 0;
    }
    
    .breadcrumb-item + .breadcrumb-item::before {
        content: "›";
        color: #6c757d;
        font-weight: bold;
    }
    
    .breadcrumb-item a {
        color: #495057;
        transition: color 0.2s ease;
    }
    
    .breadcrumb-item a:hover {
        color: #007bff;
        text-decoration: none !important;
    }
    
    .breadcrumb-item.active span {
        color: #6c757d;
        font-weight: 500;
    }
    
    @media (max-width: 768px) {
        .breadcrumb {
            font-size: 0.75rem;
        }
        
        .breadcrumb-item span,
        .breadcrumb-item a {
            max-width: 120px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            display: inline-block;
            vertical-align: top;
        }
    }
</style>
@endpush
@endonce
@endif