@extends('layouts.app')

@section('title', 'Contact Us')
@section('meta_description', 'Get in touch with us for inquiries and business opportunities')

@section('content')
<!-- Contact Hero -->
<section class="contact-hero-premium">
    <div class="hero-pattern"></div>
    <div class="container">
        <div class="hero-content-contact" data-aos="fade-up">
            <h1 class="contact-hero-title">GET IN TOUCH</h1>
            <p class="contact-hero-subtitle">We'd love to hear from you</p>
        </div>
    </div>
</section>

<!-- Contact Main -->
<section class="contact-main-premium">
    <div class="container">
        <div class="row">
            <!-- Contact Form -->
            <div class="col-lg-8">
                <div class="contact-form-card" data-aos="fade-right">
                    <div class="form-header-premium">
                        <span class="form-label">SEND MESSAGE</span>
                        <h2 class="form-title">Let's Start a Conversation</h2>
                    </div>
                    
                    @if(session('success'))
                    <div class="alert-premium success" data-aos="fade-down">
                        <i class="fas fa-check-circle"></i>
                        <span>{{ session('success') }}</span>
                        <button class="alert-close" onclick="this.parentElement.style.display='none'">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    @endif

                    <form action="{{ route('contact.submit') }}" method="POST" class="contact-form-premium">
                        @csrf
                        <div class="form-grid">
                            <div class="form-group-premium">
                                <input type="text" 
                                       class="form-input-premium @error('name') error @enderror" 
                                       id="name" 
                                       name="name" 
                                       value="{{ old('name') }}" 
                                       placeholder=" "
                                       required>
                                <label for="name" class="form-label-floating">Your Name *</label>
                                @error('name')
                                    <span class="error-text">{{ $message }}</span>
                                @enderror
                            </div>
                            
                            <div class="form-group-premium">
                                <input type="email" 
                                       class="form-input-premium @error('email') error @enderror" 
                                       id="email" 
                                       name="email" 
                                       value="{{ old('email') }}" 
                                       placeholder=" "
                                       required>
                                <label for="email" class="form-label-floating">Email Address *</label>
                                @error('email')
                                    <span class="error-text">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="form-grid">
                            <div class="form-group-premium">
                                <input type="tel" 
                                       class="form-input-premium @error('phone') error @enderror" 
                                       id="phone" 
                                       name="phone" 
                                       value="{{ old('phone') }}"
                                       placeholder=" ">
                                <label for="phone" class="form-label-floating">Phone Number</label>
                                @error('phone')
                                    <span class="error-text">{{ $message }}</span>
                                @enderror
                            </div>
                            
                            <div class="form-group-premium">
                                <input type="text" 
                                       class="form-input-premium @error('company') error @enderror" 
                                       id="company" 
                                       name="company" 
                                       value="{{ old('company') }}"
                                       placeholder=" ">
                                <label for="company" class="form-label-floating">Company</label>
                                @error('company')
                                    <span class="error-text">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="form-grid">
                            <div class="form-group-premium">
                                <input type="text" 
                                       class="form-input-premium @error('country') error @enderror" 
                                       id="country" 
                                       name="country" 
                                       value="{{ old('country') }}" 
                                       placeholder=" "
                                       required>
                                <label for="country" class="form-label-floating">Country *</label>
                                @error('country')
                                    <span class="error-text">{{ $message }}</span>
                                @enderror
                            </div>
                            
                            <div class="form-group-premium">
                                <input type="text" 
                                       class="form-input-premium @error('subject') error @enderror" 
                                       id="subject" 
                                       name="subject" 
                                       value="{{ old('subject') }}" 
                                       placeholder=" "
                                       required>
                                <label for="subject" class="form-label-floating">Subject *</label>
                                @error('subject')
                                    <span class="error-text">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="form-group-premium">
                            <textarea class="form-textarea-premium @error('message') error @enderror" 
                                      id="message" 
                                      name="message" 
                                      rows="6" 
                                      placeholder=" "
                                      required>{{ old('message') }}</textarea>
                            <label for="message" class="form-label-floating">Your Message *</label>
                            @error('message')
                                <span class="error-text">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <button type="submit" class="btn-submit-premium">
                            <span class="btn-text">SEND MESSAGE</span>
                            <i class="fas fa-paper-plane"></i>
                        </button>
                    </form>
                </div>
            </div>
            
            <!-- Contact Information -->
            <div class="col-lg-4">
                <!-- Quick Contact -->
                <div class="contact-info-card" data-aos="fade-left">
                    <h3 class="info-title">Quick Contact</h3>
                    
                    @if($companyInfo)
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="info-content">
                            <h5>Address</h5>
                            <p>{{ $companyInfo->address }}</p>
                        </div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-phone"></i>
                        </div>
                        <div class="info-content">
                            <h5>Phone</h5>
                            <a href="tel:{{ $companyInfo->phone }}">{{ $companyInfo->phone }}</a>
                        </div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="info-content">
                            <h5>Email</h5>
                            <a href="mailto:{{ $companyInfo->email }}">{{ $companyInfo->email }}</a>
                        </div>
                    </div>
                    
                    @if($companyInfo->whatsapp)
                    <div class="info-item">
                        <div class="info-icon whatsapp">
                            <i class="fab fa-whatsapp"></i>
                        </div>
                        <div class="info-content">
                            <h5>WhatsApp</h5>
                            <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $companyInfo->whatsapp) }}" 
                               target="_blank">
                                {{ $companyInfo->whatsapp }}
                            </a>
                        </div>
                    </div>
                    @endif
                    @endif
                </div>
                
                <!-- Business Hours -->
                <div class="hours-card" data-aos="fade-left" data-aos-delay="100">
                    <h3 class="hours-title">Business Hours</h3>
                    <div class="hours-list">
                        <div class="hour-item">
                            <span class="day">Monday - Friday</span>
                            <span class="time">9:00 AM - 6:00 PM</span>
                        </div>
                        <div class="hour-item">
                            <span class="day">Saturday</span>
                            <span class="time">10:00 AM - 4:00 PM</span>
                        </div>
                        <div class="hour-item closed">
                            <span class="day">Sunday</span>
                            <span class="time">Closed</span>
                        </div>
                    </div>
                </div>
                
                <!-- Social Links -->
                <div class="social-card" data-aos="fade-left" data-aos-delay="200">
                    <h3 class="social-title">Follow Us</h3>
                    <div class="social-links-premium">
                        @if($companyInfo && $companyInfo->social_links)
                            @if(!empty($companyInfo->social_links['facebook']))
                            <a href="{{ $companyInfo->social_links['facebook'] }}" target="_blank" class="social-link-premium">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            @endif
                            @if(!empty($companyInfo->social_links['instagram']))
                            <a href="{{ $companyInfo->social_links['instagram'] }}" target="_blank" class="social-link-premium">
                                <i class="fab fa-instagram"></i>
                            </a>
                            @endif
                            @if(!empty($companyInfo->social_links['twitter']))
                            <a href="{{ $companyInfo->social_links['twitter'] }}" target="_blank" class="social-link-premium">
                                <i class="fab fa-twitter"></i>
                            </a>
                            @endif
                            @if(!empty($companyInfo->social_links['linkedin']))
                            <a href="{{ $companyInfo->social_links['linkedin'] }}" target="_blank" class="social-link-premium">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                            @endif
                            @if(!empty($companyInfo->social_links['tiktok']))
                            <a href="{{ $companyInfo->social_links['tiktok'] }}" target="_blank" class="social-link-premium">
                                <i class="fab fa-tiktok"></i>
                            </a>
                            @endif
                            @if(!empty($companyInfo->social_links['youtube']))
                            <a href="{{ $companyInfo->social_links['youtube'] }}" target="_blank" class="social-link-premium">
                                <i class="fab fa-youtube"></i>
                            </a>
                            @endif
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Map Section -->
<section class="map-section-premium">
    <div class="map-container">
        <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3152.0!2d144.9630!3d-37.8136!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMzfCsDQ4JzQ5LjAiUyAxNDTCsDU3JzQ2LjgiRQ!5e0!3m2!1sen!2sau!4v1234567890" 
                width="100%" 
                height="450" 
                style="border:0;" 
                allowfullscreen="" 
                loading="lazy">
        </iframe>
        <div class="map-overlay">
            <div class="map-info">
                <h3>Visit Our Office</h3>
                <p>{{ $companyInfo->address ?? 'Your Address Here' }}</p>
                <a href="https://maps.google.com" target="_blank" class="btn-directions">
                    GET DIRECTIONS
                    <i class="fas fa-arrow-right"></i>
                </a>
            </div>
        </div>
    </div>
</section>

@push('styles')
<style>
/* Contact Hero */
.contact-hero-premium {
    height: 40vh;
    min-height: 350px;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    position: relative;
    display: flex;
    align-items: center;
    overflow: hidden;
}

.hero-pattern {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-image: repeating-linear-gradient(
        45deg,
        transparent,
        transparent 35px,
        rgba(255,255,255,.02) 35px,
        rgba(255,255,255,.02) 70px
    );
}

.hero-content-contact {
    text-align: center;
    color: white;
    position: relative;
    z-index: 2;
}

.contact-hero-title {
    font-size: clamp(2.5rem, 5vw, 4rem);
    font-weight: 900;
    letter-spacing: 0.05em;
    margin-bottom: 1rem;
    font-family: 'Space Grotesk', sans-serif;
}

.contact-hero-subtitle {
    font-size: 1.25rem;
    opacity: 0.9;
}

/* Contact Main */
.contact-main-premium {
    padding: 5rem 0;
    background: #fafafa;
}

/* Contact Form Card */
.contact-form-card {
    background: white;
    padding: 3rem;
    box-shadow: 0 10px 40px rgba(0,0,0,0.05);
    margin-bottom: 2rem;
}

.form-header-premium {
    margin-bottom: 3rem;
}

.form-label {
    display: inline-block;
    padding: 0.25rem 0.75rem;
    background: #000;
    color: white;
    font-size: 0.625rem;
    letter-spacing: 0.2em;
    font-weight: 600;
    margin-bottom: 1rem;
}

.form-title {
    font-size: 2rem;
    font-weight: 900;
    font-family: 'Space Grotesk', sans-serif;
}

/* Premium Alert */
.alert-premium {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 1.5rem;
    margin-bottom: 2rem;
    background: white;
    border-left: 4px solid;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    position: relative;
}

.alert-premium.success {
    border-color: #4CAF50;
    color: #4CAF50;
}

.alert-close {
    position: absolute;
    right: 1rem;
    background: none;
    border: none;
    color: inherit;
    cursor: pointer;
    opacity: 0.5;
    transition: opacity 0.3s;
}

.alert-close:hover {
    opacity: 1;
}

/* Form Styles */
.form-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1.5rem;
    margin-bottom: 1.5rem;
}

.form-group-premium {
    position: relative;
}

.form-input-premium,
.form-textarea-premium {
    width: 100%;
    padding: 1rem 0;
    border: none;
    border-bottom: 2px solid #e0e0e0;
    background: transparent;
    font-size: 1rem;
    transition: all 0.3s;
}

.form-input-premium:focus,
.form-textarea-premium:focus {
    outline: none;
    border-color: #000;
}

.form-label-floating {
    position: absolute;
    left: 0;
    top: 1rem;
    font-size: 1rem;
    color: #999;
    pointer-events: none;
    transition: all 0.3s;
}

.form-input-premium:focus ~ .form-label-floating,
.form-input-premium:not(:placeholder-shown) ~ .form-label-floating,
.form-textarea-premium:focus ~ .form-label-floating,
.form-textarea-premium:not(:placeholder-shown) ~ .form-label-floating {
    top: -0.5rem;
    font-size: 0.75rem;
    color: #000;
}

.form-input-premium.error,
.form-textarea-premium.error {
    border-color: #ff3333;
}

.error-text {
    display: block;
    color: #ff3333;
    font-size: 0.75rem;
    margin-top: 0.5rem;
}

.btn-submit-premium {
    display: inline-flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 3rem;
    background: #000;
    color: white;
    border: 2px solid #000;
    font-weight: 700;
    letter-spacing: 0.05em;
    cursor: pointer;
    transition: all 0.3s;
    margin-top: 2rem;
}

.btn-submit-premium:hover {
    background: transparent;
    color: #000;
    transform: translateY(-2px);
}

/* Contact Information Cards */
.contact-info-card,
.hours-card,
.social-card {
    background: white;
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: 0 10px 40px rgba(0,0,0,0.05);
}

.info-title,
.hours-title,
.social-title {
    font-size: 1.25rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
    padding-bottom: 1rem;
    border-bottom: 2px solid #f0f0f0;
}

.info-item {
    display: flex;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.info-icon {
    width: 40px;
    height: 40px;
    background: #f8f8f8;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #000;
    flex-shrink: 0;
}

.info-icon.whatsapp {
    background: #25D366;
    color: white;
}

.info-content h5 {
    font-size: 0.875rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
    color: #666;
}

.info-content p,
.info-content a {
    color: #000;
    text-decoration: none;
    transition: all 0.3s;
}

.info-content a:hover {
    color: #666;
}

/* Business Hours */
.hours-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.hour-item {
    display: flex;
    justify-content: space-between;
    padding: 0.75rem 0;
    border-bottom: 1px solid #f0f0f0;
}

.hour-item:last-child {
    border-bottom: none;
}

.day {
    font-weight: 600;
}

.time {
    color: #666;
}

.hour-item.closed .time {
    color: #ff3333;
}

/* Social Links */
.social-links-premium {
    display: flex;
    gap: 1rem;
}

.social-link-premium {
    width: 45px;
    height: 45px;
    background: #000;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    transition: all 0.3s;
}

.social-link-premium:hover {
    background: #333;
    transform: translateY(-3px);
}

/* Map Section */
.map-section-premium {
    position: relative;
    height: 450px;
}

.map-container {
    position: relative;
    width: 100%;
    height: 100%;
}

.map-container iframe {
    filter: grayscale(100%);
    transition: filter 0.3s;
}

.map-container:hover iframe {
    filter: grayscale(0%);
}

.map-overlay {
    position: absolute;
    bottom: 2rem;
    left: 2rem;
    background: white;
    padding: 2rem;
    box-shadow: 0 10px 40px rgba(0,0,0,0.1);
    max-width: 300px;
}

.map-info h3 {
    font-size: 1.25rem;
    font-weight: 700;
    margin-bottom: 1rem;
}

.map-info p {
    color: #666;
    margin-bottom: 1.5rem;
}

.btn-directions {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: #000;
    color: white;
    text-decoration: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    transition: all 0.3s;
}

.btn-directions:hover {
    background: #333;
    color: white;
}

/* Responsive */
@media (max-width: 768px) {
    .contact-hero-title {
        font-size: 2rem;
    }
    
    .form-grid {
        grid-template-columns: 1fr;
    }
    
    .contact-form-card {
        padding: 2rem;
    }
    
    .map-overlay {
        left: 1rem;
        right: 1rem;
        max-width: none;
    }
}
</style>
@endpush

@push('scripts')
<script>
// Form validation and animation
document.querySelectorAll('.form-input-premium, .form-textarea-premium').forEach(input => {
    input.addEventListener('focus', function() {
        this.parentElement.classList.add('focused');
    });
    
    input.addEventListener('blur', function() {
        if (!this.value) {
            this.parentElement.classList.remove('focused');
        }
    });
});

// Smooth form submission
document.querySelector('.contact-form-premium')?.addEventListener('submit', function(e) {
    const button = this.querySelector('.btn-submit-premium');
    const btnText = button.querySelector('.btn-text');
    btnText.textContent = 'SENDING...';
    button.disabled = true;
});
</script>
@endpush
@endsection