<x-app-layout>
    <x-slot name="header">
        <div class="dashboard-header-premium">
            <h2 class="dashboard-title">Dashboard</h2>
            <p class="dashboard-welcome">Welcome back, {{ auth()->user()->name }}!</p>
        </div>
    </x-slot>

    <div class="dashboard-premium">
        <div class="container-fluid">
            <!-- Stats Overview -->
            <div class="stats-grid" data-aos="fade-up">
                <div class="stat-card-premium">
                    <div class="stat-icon orders">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                    <div class="stat-content">
                        <span class="stat-value">{{ $totalOrders ?? 0 }}</span>
                        <span class="stat-label">Total Orders</span>
                    </div>
                </div>
                
                <div class="stat-card-premium">
                    <div class="stat-icon wishlist">
                        <i class="fas fa-heart"></i>
                    </div>
                    <div class="stat-content">
                        <span class="stat-value">{{ $wishlistCount ?? 0 }}</span>
                        <span class="stat-label">Wishlist Items</span>
                    </div>
                </div>
                
                <div class="stat-card-premium">
                    <div class="stat-icon rewards">
                        <i class="fas fa-star"></i>
                    </div>
                    <div class="stat-content">
                        <span class="stat-value">{{ $rewardPoints ?? 0 }}</span>
                        <span class="stat-label">Reward Points</span>
                    </div>
                </div>
                
                <div class="stat-card-premium">
                    <div class="stat-icon reviews">
                        <i class="fas fa-comment"></i>
                    </div>
                    <div class="stat-content">
                        <span class="stat-value">{{ $reviewsCount ?? 0 }}</span>
                        <span class="stat-label">Reviews</span>
                    </div>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="quick-actions-grid" data-aos="fade-up" data-aos-delay="100">
                <a href="{{ route('account.orders') }}" class="action-card-premium">
                    <i class="fas fa-list"></i>
                    <span>View Orders</span>
                </a>
                
                <a href="{{ route('account.profile') }}" class="action-card-premium">
                    <i class="fas fa-user"></i>
                    <span>Edit Profile</span>
                </a>
                
                <a href="{{ route('account.addresses') }}" class="action-card-premium">
                    <i class="fas fa-map-marker-alt"></i>
                    <span>Addresses</span>
                </a>
                
                <a href="{{ route('account.wishlist') }}" class="action-card-premium">
                    <i class="fas fa-heart"></i>
                    <span>Wishlist</span>
                </a>
                
                <a href="{{ route('account.settings') }}" class="action-card-premium">
                    <i class="fas fa-cog"></i>
                    <span>Settings</span>
                </a>
                
                <a href="{{ route('shop.index') }}" class="action-card-premium">
                    <i class="fas fa-shopping-cart"></i>
                    <span>Shop Now</span>
                </a>
            </div>
            
            <!-- Recent Orders -->
            @if(isset($recentOrders) && $recentOrders->count() > 0)
            <div class="recent-orders-section" data-aos="fade-up" data-aos-delay="200">
                <div class="section-header-dashboard">
                    <h3>Recent Orders</h3>
                    <a href="{{ route('account.orders') }}">View All</a>
                </div>
                
                <div class="orders-table-premium">
                    @foreach($recentOrders as $order)
                    <div class="order-row-dashboard">
                        <div class="order-info">
                            <span class="order-number">#{{ $order->order_number }}</span>
                            <span class="order-date">{{ $order->created_at->format('M d, Y') }}</span>
                        </div>
                        <div class="order-status">
                            <span class="status-badge {{ $order->status }}">
                                {{ ucfirst(str_replace('_', ' ', $order->status)) }}
                            </span>
                        </div>
                        <div class="order-total">${{ number_format($order->total_amount, 2) }}</div>
                        <div class="order-actions">
                            <a href="{{ route('account.order.detail', $order->order_number) }}" class="btn-view">
                                View
                            </a>
                            <a href="{{ route('order.track.index') }}?order_number={{ $order->order_number }}" class="btn-track">
                                Track
                            </a>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>
</x-app-layout>