<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice - {{ $order->order_number }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Helvetica Neue', Arial, sans-serif;
            color: #333;
            line-height: 1.6;
        }
        .invoice-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 30px;
        }
        .invoice-header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 40px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        .company-details {
            flex: 1;
        }
        .company-name {
            font-size: 28px;
            font-weight: bold;
            color: #333;
            margin-bottom: 10px;
        }
        .invoice-title {
            text-align: right;
            flex: 1;
        }
        .invoice-title h1 {
            font-size: 36px;
            color: #333;
            margin-bottom: 10px;
        }
        .invoice-details {
            margin-bottom: 30px;
        }
        .invoice-details table {
            width: 100%;
        }
        .invoice-details td {
            padding: 5px 0;
        }
        .addresses {
            display: flex;
            justify-content: space-between;
            margin-bottom: 40px;
        }
        .address-block {
            flex: 1;
        }
        .address-block h3 {
            font-size: 16px;
            margin-bottom: 10px;
            color: #666;
            text-transform: uppercase;
        }
        .items-table {
            width: 100%;
            margin-bottom: 30px;
            border-collapse: collapse;
        }
        .items-table thead {
            background: #f8f9fa;
        }
        .items-table th {
            padding: 12px;
            text-align: left;
            font-weight: 600;
            border-bottom: 2px solid #dee2e6;
        }
        .items-table td {
            padding: 12px;
            border-bottom: 1px solid #dee2e6;
        }
        .items-table .text-right {
            text-align: right;
        }
        .totals {
            margin-left: auto;
            width: 300px;
            margin-bottom: 40px;
        }
        .totals table {
            width: 100%;
        }
        .totals td {
            padding: 8px 0;
        }
        .totals .total-row {
            font-size: 18px;
            font-weight: bold;
            border-top: 2px solid #333;
            padding-top: 10px;
        }
        .footer {
            margin-top: 50px;
            padding-top: 20px;
            border-top: 1px solid #dee2e6;
            text-align: center;
            color: #666;
            font-size: 14px;
        }
        .badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
        }
        .badge-success {
            background: #d4edda;
            color: #155724;
        }
        .badge-warning {
            background: #fff3cd;
            color: #856404;
        }
        .badge-info {
            background: #d1ecf1;
            color: #0c5460;
        }
        @media print {
            .invoice-container {
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <div class="invoice-container">
        <!-- Header -->
        <div class="invoice-header">
            <div class="company-details">
                <div class="company-name">{{ $companyInfo->company_name ?? 'Edition By Punjab' }}</div>
                <div>{{ $companyInfo->address ?? 'Sydney, Australia' }}</div>
                <div>Email: {{ $companyInfo->email ?? 'info@editionbypunjab.com' }}</div>
                <div>Phone: {{ $companyInfo->phone ?? '+61 000 000 000' }}</div>
                @if($companyInfo->tax_number)
                <div>ABN: {{ $companyInfo->tax_number }}</div>
                @endif
            </div>
            <div class="invoice-title">
                <h1>INVOICE</h1>
                <div style="font-size: 18px; color: #666;">
                    #{{ $order->order_number }}
                </div>
            </div>
        </div>

        <!-- Invoice Details -->
        <div class="invoice-details">
            <table>
                <tr>
                    <td><strong>Invoice Date:</strong></td>
                    <td>{{ $order->created_at->format('F d, Y') }}</td>
                    <td style="width: 100px;"></td>
                    <td><strong>Payment Status:</strong></td>
                    <td>
                        <span class="badge badge-{{ $order->payment_status == 'paid' ? 'success' : 'warning' }}">
                            {{ ucfirst($order->payment_status) }}
                        </span>
                    </td>
                </tr>
                <tr>
                    <td><strong>Payment Method:</strong></td>
                    <td>{{ ucfirst($order->payment_method) }}</td>
                    <td></td>
                    <td><strong>Order Status:</strong></td>
                    <td>
                        <span class="badge badge-info">
                            {{ ucfirst(str_replace('_', ' ', $order->status)) }}
                        </span>
                    </td>
                </tr>
                @if($order->transaction_id)
                <tr>
                    <td><strong>Transaction ID:</strong></td>
                    <td colspan="4">{{ $order->transaction_id }}</td>
                </tr>
                @endif
            </table>
        </div>

        <!-- Addresses -->
        <div class="addresses">
            <div class="address-block">
                <h3>Bill To</h3>
                <div>
                    <strong>{{ $order->customer_name }}</strong><br>
                    {{ $order->customer_email }}<br>
                    {{ $order->customer_phone }}
                </div>
            </div>
            <div class="address-block">
                <h3>Ship To</h3>
                @if($order->shippingAddress)
                <div>
                    <strong>{{ $order->shippingAddress->first_name }} {{ $order->shippingAddress->last_name }}</strong><br>
                    {{ $order->shippingAddress->address_line_1 }}<br>
                    @if($order->shippingAddress->address_line_2)
                        {{ $order->shippingAddress->address_line_2 }}<br>
                    @endif
                    {{ $order->shippingAddress->city }}, {{ $order->shippingAddress->state }} {{ $order->shippingAddress->postal_code }}<br>
                    {{ $order->shippingAddress->country }}
                </div>
                @endif
            </div>
        </div>

        <!-- Items Table -->
        <table class="items-table">
            <thead>
                <tr>
                    <th>Item</th>
                    <th>SKU</th>
                    <th>Quantity</th>
                    <th class="text-right">Unit Price</th>
                    <th class="text-right">Total</th>
                </tr>
            </thead>
            <tbody>
                @foreach($order->items as $item)
                <tr>
                    <td>
                        <strong>{{ $item->product_name }}</strong>
                        @if($item->product_options)
                            @php $options = json_decode($item->product_options, true); @endphp
                            @if($options)
                            <br>
                            <small>
                                @if(isset($options['size'])) Size: {{ $options['size'] }} @endif
                                @if(isset($options['color'])) | Color: {{ $options['color'] }} @endif
                            </small>
                            @endif
                        @endif
                    </td>
                    <td>{{ $item->product_sku ?? 'N/A' }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td class="text-right">${{ number_format($item->price, 2) }}</td>
                    <td class="text-right">${{ number_format($item->subtotal, 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <!-- Totals -->
        <div class="totals">
            <table>
                <tr>
                    <td><strong>Subtotal:</strong></td>
                    <td class="text-right">${{ number_format($order->subtotal, 2) }}</td>
                </tr>
                @if($order->discount_amount > 0)
                <tr>
                    <td><strong>Discount:</strong></td>
                    <td class="text-right" style="color: #dc3545;">-${{ number_format($order->discount_amount, 2) }}</td>
                </tr>
                @endif
                <tr>
                    <td>
                        <strong>
                            Tax
                            @if($taxRate && $taxRate->tax_name)
                                ({{ $taxRate->tax_name }})
                            @elseif($taxRate && $taxRate->is_percentage)
                                ({{ $taxRate->rate }}%)
                            @else
                                (GST 10%)
                            @endif:
                        </strong>
                    </td>
                    <td class="text-right">
                        @if(isset($order->calculated_tax_amount))
                            ${{ number_format($order->calculated_tax_amount, 2) }}
                        @else
                            ${{ number_format($order->tax_amount, 2) }}
                        @endif
                    </td>
                </tr>
                <tr>
                    <td>
                        <strong>
                            Shipping
                            @if($order->shipping_method)
                                ({{ ucfirst($order->shipping_method) }} Shipping)
                            @endif:
                        </strong>
                    </td>
                    <td class="text-right">
                        @if($order->shipping_amount == 0)
                            FREE
                        @else
                            ${{ number_format($order->shipping_amount, 2) }}
                        @endif
                    </td>
                </tr>
                <tr class="total-row">
                    <td><strong>Total:</strong></td>
                    <td class="text-right">
                        @if(isset($order->calculated_total_amount))
                            ${{ number_format($order->calculated_total_amount, 2) }}
                        @else
                            ${{ number_format($order->total_amount, 2) }}
                        @endif
                    </td>
                </tr>
            </table>
        </div>

        <!-- Notes -->
        @if($order->notes)
        <div style="margin-bottom: 30px;">
            <h3 style="font-size: 16px; margin-bottom: 10px;">Order Notes:</h3>
            <p>{{ $order->notes }}</p>
        </div>
        @endif

        <!-- Footer -->
        <div class="footer">
            <p><strong>Thank you for your business!</strong></p>
            <p>If you have any questions about this invoice, please contact us at {{ $companyInfo->email ?? 'info@editionbypunjab.com' }}</p>
            <p style="margin-top: 20px;">© {{ date('Y') }} {{ $companyInfo->company_name ?? 'Edition By Punjab' }}. All rights reserved.</p>
        </div>
    </div>
</body>
</html>