<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', config('app.name', 'Edition By Punjab'))</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ \App\Helpers\ImageHelper::getFaviconUrl() }}">
    <link rel="shortcut icon" type="image/png" href="{{ \App\Helpers\ImageHelper::getFaviconUrl() }}">
    <link rel="apple-touch-icon" href="{{ \App\Helpers\ImageHelper::getFaviconUrl() }}">

    <!-- Meta -->
    <meta name="description" content="@yield('meta_description', optional($companyInfo)->meta_description ?? 'Leading Australian Export Business - Premium Products & International Trade Solutions')">
    <meta name="keywords" content="@yield('meta_keywords', optional($companyInfo)->meta_keywords ?? 'Australian exports, international trade, export business Australia, global supply chain, export solutions')">
    <meta name="author" content="{{ optional($companyInfo)->company_name ?? 'Edition By Punjab' }}">
    <meta name="robots" content="index, follow">
    <meta name="googlebot" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    <meta name="bingbot" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    
    <!-- Geo Tags for Australian Business -->
    <meta name="geo.region" content="AU">
    <meta name="geo.placename" content="Australia">
    <meta name="geo.position" content="-25.2744;133.7751">
    <meta name="ICBM" content="-25.2744, 133.7751">
    
    <!-- Language -->
    <meta http-equiv="content-language" content="en-AU">
    <link rel="alternate" hreflang="en-AU" href="{{ url()->current() }}">
    <link rel="alternate" hreflang="en" href="{{ url()->current() }}">

    <!-- Open Graph -->
    <meta property="og:title" content="@yield('title', config('app.name', 'Edition By Punjab'))">
    <meta property="og:description" content="@yield('meta_description', 'Leading Australian Export Business - Premium Products & International Trade Solutions')">
    <meta property="og:image" content="{{ asset(optional($companyInfo)->og_image ?? 'images/editionbypunjab.png') }}">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_AU">
    <meta property="og:site_name" content="{{ optional($companyInfo)->company_name ?? 'Edition By Punjab' }}">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="@yield('title', config('app.name', 'Edition By Punjab'))">
    <meta name="twitter:description" content="@yield('meta_description', 'Leading Australian Export Business - Premium Products & International Trade Solutions')">
    <meta name="twitter:image" content="{{ asset(optional($companyInfo)->og_image ?? 'images/editionbypunjab.png') }}">
    
    <!-- Structured Data for Organization -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Organization",
        "name": "{{ optional($companyInfo)->company_name ?? 'Edition By Punjab' }}",
        "description": "{{ optional($companyInfo)->meta_description ?? 'Leading Australian Export Business - Premium Products & International Trade Solutions' }}",
        "url": "{{ url('/') }}",
        "logo": "{{ asset('images/editionbypunjab.png') }}",
        "address": {
            "@type": "PostalAddress",
            "addressCountry": "AU",
            "addressRegion": "Australia"
        },
        "sameAs": [
            @if(optional($companyInfo)->social_links)
                @if(!empty($companyInfo->social_links['facebook']))
                    "{{ $companyInfo->social_links['facebook'] }}",
                @endif
                @if(!empty($companyInfo->social_links['instagram']))
                    "{{ $companyInfo->social_links['instagram'] }}",
                @endif
                @if(!empty($companyInfo->social_links['twitter']))
                    "{{ $companyInfo->social_links['twitter'] }}",
                @endif
                @if(!empty($companyInfo->social_links['linkedin']))
                    "{{ $companyInfo->social_links['linkedin'] }}"
                @endif
            @endif
        ]
    }
    </script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Playfair+Display:wght@400;700;900&family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- CSS Libraries -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.4/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11.2/swiper-bundle.min.css"/>

    <!-- Vite -->
    @if (app()->isLocal())
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    @else
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    @endif

    <!-- Premium Custom Styles -->
    <style>
        :root {
            --primary-color: #000000;
            --secondary-color: #1a1a1a;
            --accent-color: #ff3333;
            --text-primary: #000000;
            --text-secondary: #666666;
            --text-light: #999999;
            --bg-primary: #ffffff;
            --bg-secondary: #f5f5f5;
            --bg-dark: #0a0a0a;
            --border-color: #e0e0e0;
            --shadow-sm: 0 2px 4px rgba(0,0,0,0.05);
            --shadow-md: 0 4px 12px rgba(0,0,0,0.08);
            --shadow-lg: 0 8px 24px rgba(0,0,0,0.12);
            --shadow-xl: 0 12px 48px rgba(0,0,0,0.16);
            --transition-base: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            --transition-slow: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
            --transition-fast: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background-color: var(--bg-primary);
            color: var(--text-primary);
            line-height: 1.6;
            overflow-x: hidden;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }

        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 10px;
        }

        ::-webkit-scrollbar-track {
            background: var(--bg-secondary);
        }

        ::-webkit-scrollbar-thumb {
            background: var(--text-secondary);
            border-radius: 5px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: var(--text-primary);
        }

        /* Premium Typography */
        h1, h2, h3, h4, h5, h6 {
            font-family: 'Space Grotesk', sans-serif;
            font-weight: 700;
            letter-spacing: -0.02em;
            line-height: 1.2;
        }

        .display-1, .display-2, .display-3 {
            font-family: 'Playfair Display', serif;
            font-weight: 900;
        }

        /* Premium Navbar */
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border-bottom: 1px solid var(--border-color);
            padding: 1rem 0;
            transition: var(--transition-base);
            z-index: 1000;
        }

        .navbar.scrolled {
            box-shadow: var(--shadow-lg);
            padding: 0.5rem 0;
        }

        .navbar-brand {
            font-family: 'Space Grotesk', sans-serif;
            font-weight: 800;
            font-size: 1.5rem;
            letter-spacing: -0.03em;
            color: var(--text-primary) !important;
            transition: var(--transition-fast);
        }

        .navbar-brand:hover {
            transform: scale(1.05);
        }

        .nav-link {
            font-weight: 500;
            color: var(--text-primary) !important;
            position: relative;
            padding: 0.5rem 1rem !important;
            transition: var(--transition-fast);
        }

        .nav-link::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            width: 0;
            height: 2px;
            background: var(--accent-color);
            transform: translateX(-50%);
            transition: var(--transition-fast);
        }

        .nav-link:hover::after,
        .nav-link.active::after {
            width: 80%;
        }

        /* Premium Buttons */
        .btn {
            font-family: 'Inter', sans-serif;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            padding: 0.75rem 2rem;
            border-radius: 0;
            transition: var(--transition-base);
            position: relative;
            overflow: hidden;
            border: none;
        }

        .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.6s;
        }

        .btn:hover::before {
            left: 100%;
        }

        .btn-primary {
            background: var(--text-primary);
            color: white;
            border: 2px solid var(--text-primary);
        }

        .btn-primary:hover {
            background: transparent;
            color: var(--text-primary);
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
        }

        .btn-outline-primary {
            background: transparent;
            color: var(--text-primary);
            border: 2px solid var(--text-primary);
        }

        .btn-outline-primary:hover {
            background: var(--text-primary);
            color: white;
            transform: translateY(-2px);
        }

        /* Premium Cards */
        .card {
            border: none;
            border-radius: 0;
            background: white;
            transition: var(--transition-base);
            overflow: hidden;
        }

        .card:hover {
            transform: translateY(-8px);
            box-shadow: var(--shadow-xl);
        }

        /* Premium Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes slideInLeft {
            from {
                opacity: 0;
                transform: translateX(-100px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(100px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        @keyframes pulse {
            0%, 100% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
        }

        @keyframes float {
            0%, 100% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-10px);
            }
        }

        .animate-fade-in-up {
            animation: fadeInUp 0.8s ease-out;
        }

        .animate-slide-in-left {
            animation: slideInLeft 0.8s ease-out;
        }

        .animate-slide-in-right {
            animation: slideInRight 0.8s ease-out;
        }

        .animate-pulse {
            animation: pulse 2s infinite;
        }

        .animate-float {
            animation: float 3s ease-in-out infinite;
        }

        /* Loading Animation */
        .loader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: white;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            transition: opacity 0.5s, visibility 0.5s;
        }

        .loader.hidden {
            opacity: 0;
            visibility: hidden;
        }

        .loader-spinner {
            width: 50px;
            height: 50px;
            border: 3px solid var(--border-color);
            border-top-color: var(--text-primary);
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }

        /* Premium Footer */
        footer {
            background: var(--bg-dark);
            color: white;
            padding: 4rem 0 2rem;
            margin-top: 5rem;
            position: relative;
        }

        footer::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 1px;
            background: linear-gradient(90deg, transparent, var(--text-secondary), transparent);
        }

        footer a {
            color: var(--text-light);
            text-decoration: none;
            transition: var(--transition-fast);
        }

        footer a:hover {
            color: white;
            transform: translateX(5px);
        }

        /* Premium Hover Effects */
        .hover-lift {
            transition: var(--transition-base);
        }

        .hover-lift:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow-lg);
        }

        .hover-scale {
            transition: var(--transition-base);
        }

        .hover-scale:hover {
            transform: scale(1.05);
        }

        .hover-shadow {
            transition: var(--transition-base);
        }

        .hover-shadow:hover {
            box-shadow: var(--shadow-xl);
        }

        /* Parallax Effect */
        .parallax {
            background-attachment: fixed;
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            position: relative;
        }

        /* Glass Morphism */
        .glass {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        /* Text Gradient */
        .text-gradient {
            background: linear-gradient(135deg, var(--text-primary) 0%, var(--accent-color) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        /* Premium Badge */
        .badge {
            font-weight: 600;
            letter-spacing: 0.05em;
            padding: 0.5rem 1rem;
            border-radius: 0;
        }

        /* Mobile Menu Animation */
        .navbar-toggler {
            border: none;
            padding: 0;
            width: 30px;
            height: 30px;
            position: relative;
        }

        .navbar-toggler-icon {
            background: none;
            position: relative;
            width: 100%;
            height: 2px;
            background: var(--text-primary);
            transition: var(--transition-fast);
        }

        .navbar-toggler-icon::before,
        .navbar-toggler-icon::after {
            content: '';
            position: absolute;
            left: 0;
            width: 100%;
            height: 2px;
            background: var(--text-primary);
            transition: var(--transition-fast);
        }

        .navbar-toggler-icon::before {
            top: -8px;
        }

        .navbar-toggler-icon::after {
            bottom: -8px;
        }

        .navbar-toggler[aria-expanded="true"] .navbar-toggler-icon {
            background: transparent;
        }

        .navbar-toggler[aria-expanded="true"] .navbar-toggler-icon::before {
            transform: rotate(45deg);
            top: 0;
        }

        .navbar-toggler[aria-expanded="true"] .navbar-toggler-icon::after {
            transform: rotate(-45deg);
            bottom: 0;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .display-1 {
                font-size: 3rem;
            }
            
            .display-2 {
                font-size: 2.5rem;
            }
            
            .display-3 {
                font-size: 2rem;
            }
        }
    </style>

    @stack('styles')
</head>
<body>
    <!-- Page Loader -->
    <div class="loader" id="pageLoader">
        <div class="loader-spinner"></div>
    </div>

    <div id="app" class="min-h-screen d-flex flex-column">

        {{-- Navigation --}}
        @include('layouts.navigation')

        {{-- Optional Page Heading --}}
        @hasSection('header')
            <header class="bg-white shadow">
                <div class="container max-w-7xl mx-auto py-4 px-3">
                    <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                        @yield('header')
                    </h2>
                </div>
            </header>
        @endif

        {{-- Main Content --}}
        <main class="flex-fill">
            @yield('content')
        </main>

        {{-- Premium Footer --}}
        <footer>
            <div class="container">
                <div class="row gy-4">
                    <!-- Company Info -->
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">{{ optional($companyInfo)->company_name ?? 'Edition By Punjab' }}</h3>
                        <p class="text-light mb-4">
                            {{ optional($companyInfo)->about_us ?? 'Elevating fashion with premium streetwear and lifestyle products.' }}
                        </p>
                        <div class="social-links d-flex gap-3">
                            @if(optional($companyInfo)->social_links)
                                @if(!empty($companyInfo->social_links['facebook']))
                                    <a href="{{ $companyInfo->social_links['facebook'] }}" class="social-link" target="_blank" rel="noopener noreferrer" aria-label="Facebook">
                                        <i class="fab fa-facebook-f fa-lg"></i>
                                    </a>
                                @endif
                                @if(!empty($companyInfo->social_links['instagram']))
                                    <a href="{{ $companyInfo->social_links['instagram'] }}" class="social-link" target="_blank" rel="noopener noreferrer" aria-label="Instagram">
                                        <i class="fab fa-instagram fa-lg"></i>
                                    </a>
                                @endif
                                @if(!empty($companyInfo->social_links['twitter']))
                                    <a href="{{ $companyInfo->social_links['twitter'] }}" class="social-link" target="_blank" rel="noopener noreferrer" aria-label="Twitter">
                                        <i class="fab fa-twitter fa-lg"></i>
                                    </a>
                                @endif
                                @if(!empty($companyInfo->social_links['linkedin']))
                                    <a href="{{ $companyInfo->social_links['linkedin'] }}" class="social-link" target="_blank" rel="noopener noreferrer" aria-label="LinkedIn">
                                        <i class="fab fa-linkedin-in fa-lg"></i>
                                    </a>
                                @endif
                                @if(!empty($companyInfo->social_links['tiktok']))
                                    <a href="{{ $companyInfo->social_links['tiktok'] }}" class="social-link" target="_blank" rel="noopener noreferrer" aria-label="TikTok">
                                        <i class="fab fa-tiktok fa-lg"></i>
                                    </a>
                                @endif
                                @if(!empty($companyInfo->social_links['youtube']))
                                    <a href="{{ $companyInfo->social_links['youtube'] }}" class="social-link" target="_blank" rel="noopener noreferrer" aria-label="YouTube">
                                        <i class="fab fa-youtube fa-lg"></i>
                                    </a>
                                @endif
                            @endif
                        </div>
                    </div>

                    <!-- Quick Links -->
                    <div class="col-lg-2 col-md-6">
                        <h5 class="text-white mb-3">Quick Links</h5>
                        <ul class="list-unstyled">
                            @if(Route::has('home'))
                                <li class="mb-2"><a href="{{ route('home') }}">Home</a></li>
                            @endif
                            @if(Route::has('shop.index'))
                                <li class="mb-2"><a href="{{ route('shop.index') }}">Shop</a></li>
                            @endif
                            @if(Route::has('blogs.index'))
                                <li class="mb-2"><a href="{{ route('blogs.index') }}">Blog</a></li>
                            @endif
                            @if(Route::has('about'))
                                <li class="mb-2"><a href="{{ route('about') }}">About</a></li>
                            @endif
                            @if(Route::has('contact'))
                                <li class="mb-2"><a href="{{ route('contact') }}">Contact</a></li>
                            @endif
                        </ul>
                    </div>

                    <!-- Customer Service -->
                    <div class="col-lg-2 col-md-6">
                        <h5 class="text-white mb-3">Customer Service</h5>
                        <ul class="list-unstyled">
                            @if(Route::has('order.track.index'))
                                <li class="mb-2">
                                    <a href="{{ route('order.track.index') }}">
                                        Track Order
                                    </a>
                                </li>
                            @endif
                            @if(Route::has('account.dashboard'))
                                <li class="mb-2"><a href="{{ route('account.dashboard') }}">My Account</a></li>
                            @endif
                            @if(Route::has('cart.index'))
                                <li class="mb-2"><a href="{{ route('cart.index') }}">Cart</a></li>
                            @endif
                            @if(Route::has('account.wishlist'))
                                <li class="mb-2"><a href="{{ route('account.wishlist') }}">Wishlist</a></li>
                            @endif
                            @if(Route::has('community.index'))
                                <li class="mb-2"><a href="{{ route('community.index') }}">Community</a></li>
                            @endif
                            @if(Route::has('size-guide.index'))
                                <li class="mb-2"><a href="{{ route('size-guide.index') }}">Size Guide</a></li>
                            @endif
                        </ul>
                    </div>

                    <!-- Legal Section - FIXED -->
                    <div class="col-lg-2 col-md-6">
                        <h5 class="text-white mb-3">Legal</h5>
                        <ul class="list-unstyled">
                            @if(Route::has('privacy'))
                                <li class="mb-2"><a href="{{ route('privacy') }}">Privacy Policy</a></li>
                            @endif
                            @if(Route::has('terms'))
                                <li class="mb-2"><a href="{{ route('terms') }}">Terms of Service</a></li>
                            @endif
                            @if(Route::has('refund'))
                                <li class="mb-2"><a href="{{ route('refund') }}">Refund & Return</a></li>
                            @endif
                            @if(Route::has('shipping'))
                                <li class="mb-2"><a href="{{ route('shipping') }}">Shipping Policy</a></li>
                            @endif
                        </ul>
                    </div>

                    <!-- Newsletter -->
                    <div class="col-lg-3 col-md-6">
                        <h5 class="text-white mb-3">Stay Updated</h5>
                        <p class="text-light mb-3">Subscribe for exclusive offers and new product launches</p>
                        <form action="{{ route('newsletter.subscribe') }}" method="POST" class="newsletter-form">
                            @csrf
                            <div class="input-group">
                                <input type="email" name="email" class="form-control" placeholder="Your email" required>
                                <button class="btn btn-primary" type="submit">
                                    <i class="fas fa-arrow-right"></i>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <hr class="my-4 border-secondary">

                <div class="row align-items-center">
                    <div class="col-md-6">
                        <p class="mb-0 text-light">&copy; {{ date('Y') }} {{ optional($companyInfo)->company_name ?? 'Edition By Punjab' }}. All rights reserved.</p>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <div class="payment-icons d-flex justify-content-md-end gap-2">
                            <i class="fab fa-cc-visa fa-2x text-light"></i>
                            <i class="fab fa-cc-mastercard fa-2x text-light"></i>
                            <i class="fab fa-cc-paypal fa-2x text-light"></i>
                            <i class="fab fa-cc-stripe fa-2x text-light"></i>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
    </div>

    <!-- JS Libraries -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11.2/swiper-bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.13.0/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.13.0/ScrollTrigger.min.js"></script>

    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.14.9/dist/cdn.min.js"></script>

    <script>
        // Page Loader
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(function() {
                document.getElementById('pageLoader').classList.add('hidden');
            }, 500);
        });

        // Initialize AOS with premium settings
        AOS.init({
            duration: 1000,
            once: true,
            offset: 100,
            easing: 'ease-out-cubic'
        });

        // Navbar scroll effect
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.classList.add('scrolled');
            } else {
                navbar.classList.remove('scrolled');
            }
        });

        // GSAP Animations
        gsap.registerPlugin(ScrollTrigger);

        // Animate elements on scroll
        gsap.utils.toArray('.animate-on-scroll').forEach(element => {
            gsap.from(element, {
                y: 50,
                opacity: 0,
                duration: 1,
                scrollTrigger: {
                    trigger: element,
                    start: 'top 80%',
                    end: 'bottom 20%',
                    toggleActions: 'play none none reverse'
                }
            });
        });

        // Parallax effect
        gsap.utils.toArray('.parallax-element').forEach(element => {
            gsap.to(element, {
                yPercent: -50,
                ease: 'none',
                scrollTrigger: {
                    trigger: element,
                    start: 'top bottom',
                    end: 'bottom top',
                    scrub: true
                }
            });
        });

        // Premium Toastr Configuration
        toastr.options = {
            "closeButton": true,
            "progressBar": true,
            "positionClass": "toast-bottom-right",
            "timeOut": "4000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        };

        // Show flash messages
        @if(session('success'))
            toastr.success({!! json_encode(session('success')) !!});
        @endif

        @if(session('error'))
            toastr.error({!! json_encode(session('error')) !!});
        @endif

        @if(session('info'))
            toastr.info({!! json_encode(session('info')) !!});
        @endif

        @if(session('warning'))
            toastr.warning({!! json_encode(session('warning')) !!});
        @endif

        // Smooth scroll for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Add hover animation to cards
        document.querySelectorAll('.card').forEach(card => {
            card.addEventListener('mouseenter', function() {
                gsap.to(this, {
                    scale: 1.02,
                    duration: 0.3,
                    ease: 'power2.out'
                });
            });
            
            card.addEventListener('mouseleave', function() {
                gsap.to(this, {
                    scale: 1,
                    duration: 0.3,
                    ease: 'power2.out'
                });
            });
        });

        // Newsletter subscription handling for footer form
        document.addEventListener('DOMContentLoaded', function() {
            const newsletterForm = document.querySelector('.newsletter-form');
            if (newsletterForm) {
                newsletterForm.addEventListener('submit', function(e) {
                    e.preventDefault();
                    
                    const emailInput = this.querySelector('input[name="email"]');
                    const submitBtn = this.querySelector('button[type="submit"]');
                    const email = emailInput.value.trim();
                    
                    if (!email) {
                        toastr.error('Please enter a valid email address');
                        return;
                    }
                    
                    // Show loading state
                    const originalBtnContent = submitBtn.innerHTML;
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
                    
                    fetch('{{ route("newsletter.subscribe") }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify({ email: email })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            toastr.success(data.message);
                            if (data.discount_code) {
                                setTimeout(() => {
                                    toastr.info('Your discount code: ' + data.discount_code);
                                }, 1000);
                            }
                            emailInput.value = '';
                            
                            // Set cookie/session to remember subscription
                            document.cookie = 'newsletter_subscribed=true; path=/; max-age=' + (365 * 24 * 60 * 60);
                        } else {
                            toastr.error(data.message || 'Subscription failed. Please try again.');
                        }
                    })
                    .catch(error => {
                        console.error('Newsletter subscription error:', error);
                        toastr.error('An error occurred. Please try again.');
                    })
                    .finally(() => {
                        // Reset button state
                        submitBtn.disabled = false;
                        submitBtn.innerHTML = originalBtnContent;
                    });
                });
            }
        });
    </script>

    @stack('scripts')
</body>
</html>