<!-- resources/views/home.blade.php -->
@extends('layouts.app')

@section('title', 'Home')

@section('content')
<!-- Hero Section -->
<section class="hero-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6" data-aos="fade-right">
                <h1 class="display-4 fw-bold mb-4">Global Export Solutions for Your Business</h1>
                <p class="lead mb-4">Leading manufacturer and exporter of premium quality products. Trusted by businesses worldwide for over a decade.</p>
                <div>
                    <a href="{{ route('products') }}" class="btn btn-primary btn-lg me-3">View Products</a>
                    <a href="{{ route('contact') }}" class="btn btn-outline-light btn-lg">Get Quote</a>
                </div>
            </div>
            <div class="col-lg-6" data-aos="fade-left">
                <div class="position-relative">
                    <img src="/api/placeholder/600/400" alt="Export Business" class="img-fluid rounded-3 shadow-lg">

                    <!-- Sale Timer Banner -->
                    @php
                        $activeSaleCampaign = \App\Models\DiscountCampaign::withTimer()->first();
                    @endphp
                    @if($activeSaleCampaign)
                    <div class="sale-timer-banner position-absolute top-0 end-0 m-3" data-aos="zoom-in" data-aos-delay="500">
                        <div class="timer-card bg-gradient-danger text-white p-3 rounded shadow-lg">
                            <div class="text-center mb-2">
                                <i class="fas fa-fire text-warning"></i>
                                <h6 class="mb-1 fw-bold">{{ $activeSaleCampaign->name }}</h6>
                                <small class="opacity-75">{{ $activeSaleCampaign->discount_percentage }}% OFF</small>
                            </div>
                            <div class="timer-display d-flex justify-content-center gap-1"
                                 data-end-time="{{ $activeSaleCampaign->ends_at->toISOString() }}">
                                <div class="timer-unit text-center">
                                    <div class="timer-number bg-white text-dark px-2 py-1 rounded fw-bold" data-days>00</div>
                                    <small class="d-block mt-1">Days</small>
                                </div>
                                <div class="timer-unit text-center">
                                    <div class="timer-number bg-white text-dark px-2 py-1 rounded fw-bold" data-hours>00</div>
                                    <small class="d-block mt-1">Hrs</small>
                                </div>
                                <div class="timer-unit text-center">
                                    <div class="timer-number bg-white text-dark px-2 py-1 rounded fw-bold" data-minutes>00</div>
                                    <small class="d-block mt-1">Min</small>
                                </div>
                                <div class="timer-unit text-center">
                                    <div class="timer-number bg-white text-dark px-2 py-1 rounded fw-bold" data-seconds>00</div>
                                    <small class="d-block mt-1">Sec</small>
                                </div>
                            </div>
                            <div class="text-center mt-2">
                                <a href="{{ route('shop.index', ['collection' => 'sale']) }}"
                                   class="btn btn-warning btn-sm fw-bold">
                                    Shop Sale <i class="fas fa-arrow-right ms-1"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="stats-section">
    <div class="container">
        <div class="row g-4">
            <div class="col-md-3" data-aos="fade-up" data-aos-delay="100">
                <div class="stat-card">
                    <i class="fas fa-globe"></i>
                    <h3>50+</h3>
                    <p class="mb-0">Countries Served</p>
                </div>
            </div>
            <div class="col-md-3" data-aos="fade-up" data-aos-delay="200">
                <div class="stat-card">
                    <i class="fas fa-box"></i>
                    <h3>{{ $companyInfo->products_count }}+</h3>
                    <p class="mb-0">Products</p>
                </div>
            </div>
            <div class="col-md-3" data-aos="fade-up" data-aos-delay="300">
                <div class="stat-card">
                    <i class="fas fa-users"></i>
                    <h3>{{ $companyInfo->happy_clients }}+</h3>
                    <p class="mb-0">Happy Clients</p>
                </div>
            </div>
            <div class="col-md-3" data-aos="fade-up" data-aos-delay="400">
                <div class="stat-card">
                    <i class="fas fa-award"></i>
                    <h3>{{ $companyInfo->years_experience }}+</h3>
                    <p class="mb-0">Years Experience</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Categories Section -->
<section class="py-5">
    <div class="container">
        <div class="text-center mb-5" data-aos="fade-up">
            <h2 class="display-5 fw-bold">Product Categories</h2>
            <p class="lead text-muted">Explore our wide range of export products</p>
        </div>
        <div class="row g-4">
            @foreach($categories as $category)
            <div class="col-lg-4 col-md-6" data-aos="fade-up">
                <a href="{{ route('products', ['category' => $category->slug]) }}" class="text-decoration-none">
                    <div class="category-card">
                        <img src="{{ asset('storage/' . $category->image) }}" alt="{{ $category->name }}" class="w-100 h-100 object-fit-cover">
                        <div class="overlay">
                            <div>
                                <h4 class="mb-2">{{ $category->name }}</h4>
                                <p class="mb-0">{{ $category->activeProducts->count() }} Products</p>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
            @endforeach
        </div>
    </div>
</section>

<!-- Featured Products -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="text-center mb-5" data-aos="fade-up">
            <h2 class="display-5 fw-bold">Featured Products</h2>
            <p class="lead text-muted">Our best-selling export products</p>
        </div>
        <div class="row g-4">
            @foreach($featuredProducts as $product)
            <div class="col-lg-3 col-md-6" data-aos="fade-up">
                <div class="card product-card">
                    <img src="{{ asset('storage/' . $product->featured_image) }}" class="card-img-top" alt="{{ $product->name }}">
                    <div class="card-body">
                        <span class="badge bg-primary mb-2">{{ $product->category->name }}</span>
                        <h5 class="card-title">{{ $product->name }}</h5>
                        <p class="card-text text-muted">{{ Str::limit($product->description, 100) }}</p>
                        <div class="d-flex justify-content-between align-items-center">
                            @if($product->price)
                            <span class="h5 mb-0 text-primary">${{ number_format($product->price, 2) }}</span>
                            @else
                            <span class="text-muted">Contact for price</span>
                            @endif
                            <a href="{{ route('product.detail', $product->slug) }}" class="btn btn-sm btn-outline-primary">View Details</a>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        <div class="text-center mt-5">
            <a href="{{ route('products') }}" class="btn btn-primary btn-lg">View All Products</a>
        </div>
    </div>
</section>

<!-- Testimonials -->
@if($testimonials->count() > 0)
<section class="py-5">
    <div class="container">
        <div class="text-center mb-5" data-aos="fade-up">
            <h2 class="display-5 fw-bold">Client Testimonials</h2>
            <p class="lead text-muted">What our global clients say about us</p>
        </div>
        <div class="row g-4">
            @foreach($testimonials as $testimonial)
            <div class="col-lg-4" data-aos="fade-up">
                <div class="card h-100 shadow-sm">
                    <div class="card-body">
                        <div class="mb-3">
                            @for($i = 1; $i <= 5; $i++)
                                <i class="fas fa-star {{ $i <= $testimonial->rating ? 'text-warning' : 'text-muted' }}"></i>
                            @endfor
                        </div>
                        <p class="card-text">"{{ $testimonial->content }}"</p>
                        <div class="d-flex align-items-center mt-3">
                            @if($testimonial->client_image)
                            <img src="{{ asset('storage/' . $testimonial->client_image) }}" alt="{{ $testimonial->client_name }}" class="rounded-circle me-3" width="50" height="50">
                            @endif
                            <div>
                                <h6 class="mb-0">{{ $testimonial->client_name }}</h6>
                                <small class="text-muted">{{ $testimonial->client_company }}, {{ $testimonial->client_country }}</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
@endif

<!-- CTA Section -->
<section class="py-5 bg-primary text-white">
    <div class="container text-center">
        <h2 class="display-5 fw-bold mb-4">Ready to Start Importing?</h2>
        <p class="lead mb-4">Get in touch with us for competitive prices and reliable supply</p>
        <a href="{{ route('contact') }}" class="btn btn-light btn-lg">Contact Us Now</a>
    </div>
</section>

@if($activeSaleCampaign ?? false)
<style>
/* Sale Timer Banner Styles */
.sale-timer-banner {
    z-index: 10;
    max-width: 200px;
}

.timer-card {
    background: linear-gradient(135deg, #dc3545 0%, #c62d42 100%) !important;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.timer-unit {
    flex: 1;
    min-width: 35px;
}

.timer-number {
    font-size: 0.875rem;
    line-height: 1.2;
    min-height: 28px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.timer-unit small {
    font-size: 0.625rem;
    font-weight: 500;
}

.bg-gradient-danger {
    background: linear-gradient(135deg, #dc3545 0%, #c62d42 100%);
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .sale-timer-banner {
        position: relative !important;
        top: auto !important;
        end: auto !important;
        margin: 1rem auto 0 !important;
        max-width: 250px;
    }
}

/* Animation for timer numbers */
.timer-number {
    transition: all 0.3s ease;
}

.timer-number.updated {
    transform: scale(1.1);
    background: #ffc107 !important;
    color: #000 !important;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const timerDisplay = document.querySelector('.timer-display');
    if (!timerDisplay) return;

    const endTime = new Date(timerDisplay.dataset.endTime).getTime();

    function updateTimer() {
        const now = new Date().getTime();
        const timeLeft = endTime - now;

        if (timeLeft <= 0) {
            // Timer expired
            document.querySelector('.sale-timer-banner').style.display = 'none';
            return;
        }

        const days = Math.floor(timeLeft / (1000 * 60 * 60 * 24));
        const hours = Math.floor((timeLeft % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        const minutes = Math.floor((timeLeft % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((timeLeft % (1000 * 60)) / 1000);

        // Update display with animation
        updateTimerUnit('[data-days]', days.toString().padStart(2, '0'));
        updateTimerUnit('[data-hours]', hours.toString().padStart(2, '0'));
        updateTimerUnit('[data-minutes]', minutes.toString().padStart(2, '0'));
        updateTimerUnit('[data-seconds]', seconds.toString().padStart(2, '0'));
    }

    function updateTimerUnit(selector, value) {
        const element = document.querySelector(selector);
        if (element && element.textContent !== value) {
            element.textContent = value;
            element.classList.add('updated');
            setTimeout(() => {
                element.classList.remove('updated');
            }, 300);
        }
    }

    // Initialize timer
    updateTimer();

    // Update every second
    setInterval(updateTimer, 1000);
});
</script>
@endif
@endsection