@extends('layouts.app')

@section('title', $legalPage->title)
@section('meta_description', $legalPage->meta_description ?: 'Legal information from Edition By Punjab')

@section('content')
<!-- Premium Legal Hero -->
<section class="legal-hero-premium">
    <div class="hero-overlay"></div>
    <div class="container">
        <div class="hero-content-center" data-aos="fade-up">
            <span class="hero-label">LEGAL</span>
            <h1 class="hero-title-premium">{{ $legalPage->title }}</h1>
            @if($legalPage->meta_description)
                <p class="hero-subtitle">{{ $legalPage->meta_description }}</p>
            @endif
            <p class="hero-date">Last updated: {{ $legalPage->updated_at->format('F d, Y') }}</p>
        </div>
    </div>
    <div class="scroll-indicator">
        <span></span>
    </div>
</section>

<!-- Legal Content -->
<section class="legal-content-premium">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <!-- Back Navigation -->
                <div class="back-navigation" data-aos="fade-up">
                    <a href="{{ route('legal.index') }}" class="back-link">
                        <i class="fas fa-arrow-left"></i>
                        Back to Legal Documents
                    </a>
                </div>

                <!-- Main Content -->
                <div class="legal-main-content">
                    <!-- Dynamic Content from Database -->
                    <div class="legal-section" data-aos="fade-up">
                        <div class="legal-section-content dynamic-content">
                            {!! $legalPage->content !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="legal-cta-premium">
    <div class="container">
        <div class="cta-content" data-aos="zoom-in">
            <h2 class="cta-title">Have Questions About This Document?</h2>
            <p class="cta-subtitle">We're here to help clarify any concerns</p>
            <div class="cta-buttons">
                <a href="{{ route('contact') }}" class="btn-cta-primary">
                    CONTACT US
                </a>
                <a href="{{ route('legal.index') }}" class="btn-cta-secondary">
                    VIEW ALL LEGAL DOCS
                </a>
            </div>
        </div>
    </div>
</section>

@push('styles')
<style>
/* Legal Hero */
.legal-hero-premium {
    height: 50vh;
    min-height: 400px;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
}

.legal-hero-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-image: url('/images/legal-hero.jpg');
    background-size: cover;
    background-position: center;
    opacity: 0.2;
}

.hero-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: radial-gradient(circle at center, transparent 0%, rgba(0,0,0,0.7) 100%);
}

.hero-content-center {
    text-align: center;
    color: white;
    position: relative;
    z-index: 2;
}

.hero-label {
    display: inline-block;
    padding: 0.5rem 1.5rem;
    background: rgba(255,255,255,0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255,255,255,0.2);
    font-size: 0.75rem;
    letter-spacing: 0.2em;
    font-weight: 600;
    margin-bottom: 2rem;
}

.hero-title-premium {
    font-size: clamp(2.5rem, 6vw, 4rem);
    font-weight: 900;
    margin-bottom: 1rem;
    font-family: 'Space Grotesk', sans-serif;
}

.hero-subtitle {
    font-size: 1.25rem;
    opacity: 0.9;
    margin-bottom: 1rem;
}

.hero-date {
    font-size: 0.875rem;
    opacity: 0.7;
    font-style: italic;
}

.scroll-indicator {
    position: absolute;
    bottom: 2rem;
    left: 50%;
    transform: translateX(-50%);
}

.scroll-indicator span {
    display: block;
    width: 24px;
    height: 36px;
    border: 2px solid white;
    border-radius: 12px;
    position: relative;
}

.scroll-indicator span::after {
    content: '';
    position: absolute;
    top: 6px;
    left: 50%;
    transform: translateX(-50%);
    width: 4px;
    height: 8px;
    background: white;
    border-radius: 2px;
    animation: scroll-down 2s infinite;
}

@keyframes scroll-down {
    0% { transform: translateX(-50%) translateY(0); opacity: 1; }
    100% { transform: translateX(-50%) translateY(12px); opacity: 0; }
}

/* Legal Content */
.legal-content-premium {
    padding: 5rem 0;
    background: white;
    position: relative;
}

/* Back Navigation */
.back-navigation {
    margin-bottom: 3rem;
}

.back-link {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    color: #666;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.3s ease;
}

.back-link:hover {
    color: #000;
    transform: translateX(-5px);
}

/* Main Content */
.legal-main-content {
    max-width: none;
}

.legal-section {
    position: relative;
}

.legal-section-content {
    color: #333;
    line-height: 1.8;
}

/* Dynamic Content Styles */
.dynamic-content {
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
}

.dynamic-content h1,
.dynamic-content h2,
.dynamic-content h3,
.dynamic-content h4,
.dynamic-content h5,
.dynamic-content h6 {
    margin-top: 2rem;
    margin-bottom: 1rem;
    font-weight: 600;
    color: #000;
}

.dynamic-content h1 {
    font-size: 2.5rem;
    border-bottom: 2px solid #eee;
    padding-bottom: 0.5rem;
}

.dynamic-content h2 {
    font-size: 2rem;
}

.dynamic-content h3 {
    font-size: 1.5rem;
}

.dynamic-content h4 {
    font-size: 1.25rem;
}

.dynamic-content p {
    margin-bottom: 1rem;
}

.dynamic-content ul,
.dynamic-content ol {
    margin-bottom: 1rem;
    padding-left: 2rem;
}

.dynamic-content li {
    margin-bottom: 0.5rem;
}

.dynamic-content blockquote {
    border-left: 4px solid #ddd;
    padding-left: 1rem;
    margin: 1.5rem 0;
    font-style: italic;
    color: #666;
    background: #f8f8f8;
    padding: 1rem;
}

.dynamic-content a {
    color: #0066cc;
    text-decoration: underline;
}

.dynamic-content a:hover {
    color: #004499;
}

.dynamic-content code {
    background: #f5f5f5;
    padding: 0.25rem 0.5rem;
    border-radius: 0.25rem;
    font-family: 'Courier New', monospace;
    font-size: 0.9em;
}

.dynamic-content pre {
    background: #f5f5f5;
    padding: 1rem;
    border-radius: 0.25rem;
    overflow-x: auto;
    margin: 1rem 0;
}

.dynamic-content table {
    width: 100%;
    border-collapse: collapse;
    margin: 1rem 0;
}

.dynamic-content th,
.dynamic-content td {
    border: 1px solid #ddd;
    padding: 0.75rem;
    text-align: left;
}

.dynamic-content th {
    background: #f5f5f5;
    font-weight: 600;
}

.dynamic-content img {
    max-width: 100%;
    height: auto;
    margin: 1rem 0;
}

.dynamic-content hr {
    border: none;
    border-top: 1px solid #ddd;
    margin: 2rem 0;
}

.dynamic-content strong {
    font-weight: 600;
}

.dynamic-content em {
    font-style: italic;
}

/* Legal CTA */
.legal-cta-premium {
    padding: 4rem 0;
    background: #f8f8f8;
}

.cta-content {
    text-align: center;
}

.cta-title {
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 1rem;
}

.cta-subtitle {
    font-size: 1.125rem;
    color: #666;
    margin-bottom: 2rem;
}

.cta-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
}

.btn-cta-primary {
    padding: 1rem 2.5rem;
    background: #000;
    color: white;
    text-decoration: none;
    font-weight: 700;
    letter-spacing: 0.05em;
    transition: all 0.3s;
}

.btn-cta-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
}

.btn-cta-secondary {
    padding: 1rem 2.5rem;
    background: transparent;
    color: #000;
    border: 2px solid #000;
    text-decoration: none;
    font-weight: 700;
    letter-spacing: 0.05em;
    transition: all 0.3s;
}

.btn-cta-secondary:hover {
    background: #000;
    color: white;
}

/* Responsive */
@media (max-width: 768px) {
    .hero-title-premium {
        font-size: 2rem;
    }
    
    .dynamic-content h1 {
        font-size: 2rem;
    }
    
    .dynamic-content h2 {
        font-size: 1.5rem;
    }
    
    .cta-title {
        font-size: 2rem;
    }
}
</style>
@endpush
@endsection