@extends('layouts.app')

@section('title', $lookbook['meta_title'])

@section('meta')
<meta name="description" content="{{ $lookbook['meta_description'] }}">
<meta name="keywords" content="{{ $lookbook['keywords'] }}">
@endsection

@section('content')
<x-breadcrumb />

<!-- Hero Section -->
<section class="lookbook-hero py-5" style="background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), url('{{ asset('images/' . $lookbook['hero_image']) }}'); background-size: cover; background-position: center;">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center text-white">
                <h1 class="display-4 fw-bold mb-4">{{ $lookbook['title'] }}</h1>
                <p class="lead mb-4">{{ $lookbook['description'] }}</p>
                <div class="lookbook-stats d-flex justify-content-center gap-4 mb-4">
                    <div class="stat-item">
                        <div class="stat-number h5 mb-0">{{ $lookbook['product_count'] }}</div>
                        <small>Featured Pieces</small>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number h5 mb-0">{{ $lookbook['style_count'] }}</div>
                        <small>Style Looks</small>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number h5 mb-0">{{ $lookbook['inspiration_count'] }}</div>
                        <small>Inspirations</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Lookbook Gallery -->
<section class="lookbook-gallery py-5">
    <div class="container">
        <!-- Style Looks -->
        <div class="row mb-5">
            <div class="col-12">
                <h2 class="mb-4">{{ $lookbook['title'] }} Looks</h2>
                <div class="row g-4">
                    @foreach($lookbook['looks'] as $look)
                        <div class="col-md-4">
                            <div class="look-card position-relative">
                                <x-lazy-image 
                                    src="{{ $look['image'] }}" 
                                    alt="{{ $look['title'] }}"
                                    class="img-fluid rounded"
                                    style="height: 400px; object-fit: cover;"
                                />
                                <div class="look-overlay position-absolute bottom-0 start-0 end-0 p-3 text-white">
                                    <h5 class="mb-1">{{ $look['title'] }}</h5>
                                    <p class="small mb-2">{{ $look['description'] }}</p>
                                    <div class="look-products">
                                        @foreach($look['products'] as $product)
                                            <span class="badge bg-light text-dark me-1">{{ $product }}</span>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Featured Products from this Collection -->
        <div class="row mb-5">
            <div class="col-12">
                <h3 class="mb-4">Shop This Collection</h3>
                <div class="row g-4">
                    @foreach($lookbook['featured_products'] as $product)
                        <div class="col-md-3 col-sm-6">
                            <div class="product-card h-100">
                                <div class="product-image-wrapper position-relative">
                                    <x-lazy-image 
                                        src="{{ $product['image'] }}" 
                                        alt="{{ $product['name'] }}"
                                        class="img-fluid product-image rounded"
                                        style="height: 250px; object-fit: cover;"
                                    />
                                    <div class="product-overlay position-absolute top-0 start-0 end-0 bottom-0 d-flex align-items-center justify-content-center opacity-0">
                                        <a href="{{ $product['url'] }}" class="btn btn-primary">Shop Now</a>
                                    </div>
                                </div>
                                <div class="product-info p-3">
                                    <h6 class="product-name mb-2">{{ $product['name'] }}</h6>
                                    <div class="product-price">
                                        <span class="fw-bold">${{ $product['price'] }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Styling Tips -->
        <div class="row mb-5">
            <div class="col-lg-8">
                <h3 class="mb-4">Styling Tips for {{ $lookbook['title'] }}</h3>
                <div class="styling-tips">
                    @foreach($lookbook['styling_tips'] as $tip)
                        <div class="tip-item mb-4 p-4 bg-light rounded">
                            <h5 class="text-primary mb-2">{{ $tip['title'] }}</h5>
                            <p class="mb-0">{{ $tip['description'] }}</p>
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="col-lg-4">
                <div class="lookbook-sidebar">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Get The Look</h5>
                            <p class="card-text">Complete your style with these essential pieces from our {{ $lookbook['title'] }} collection.</p>
                            <a href="{{ route('shop.index') }}" class="btn btn-primary w-100 mb-2">
                                Shop Collection
                            </a>
                            <a href="{{ route('community.submit') }}" class="btn btn-outline-primary w-100">
                                Share Your Style
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- More Collections -->
<section class="related-collections py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <h3 class="mb-4 text-center">Explore More Collections</h3>
                <div class="row g-4">
                    @foreach($relatedLookbooks as $related)
                        <div class="col-md-4">
                            <div class="collection-card h-100">
                                <x-lazy-image 
                                    src="{{ $related['image'] }}" 
                                    alt="{{ $related['title'] }}"
                                    class="card-img-top"
                                    style="height: 200px; object-fit: cover;"
                                />
                                <div class="card-body d-flex flex-column">
                                    <h5 class="card-title">{{ $related['title'] }}</h5>
                                    <p class="card-text flex-grow-1">{{ $related['description'] }}</p>
                                    <a href="{{ route('lookbook.show', $related['slug']) }}" class="btn btn-outline-primary">
                                        Explore Collection
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>

@push('styles')
<style>
    .lookbook-hero {
        min-height: 500px;
        display: flex;
        align-items: center;
    }
    
    .look-card {
        border-radius: 1rem;
        overflow: hidden;
        cursor: pointer;
        transition: transform 0.3s ease;
    }
    
    .look-card:hover {
        transform: translateY(-5px);
    }
    
    .look-overlay {
        background: linear-gradient(transparent, rgba(0,0,0,0.8));
        border-radius: 0 0 1rem 1rem;
    }
    
    .product-card {
        transition: transform 0.3s ease;
        border: 1px solid #e9ecef;
        border-radius: 1rem;
        overflow: hidden;
    }
    
    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    }
    
    .product-card:hover .product-overlay {
        opacity: 1 !important;
    }
    
    .product-overlay {
        background: rgba(0,0,0,0.7);
        border-radius: 1rem;
        transition: opacity 0.3s ease;
    }
    
    .tip-item {
        border-left: 4px solid #007bff;
    }
    
    .collection-card {
        border: none;
        border-radius: 1rem;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        transition: transform 0.3s ease;
    }
    
    .collection-card:hover {
        transform: translateY(-5px);
    }
</style>
@endpush

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "CreativeWork",
    "name": "{{ $lookbook['title'] }}",
    "description": "{{ $lookbook['description'] }}",
    "url": "{{ route('lookbook.show', $lookbook['slug']) }}",
    "image": "{{ asset('images/' . $lookbook['hero_image']) }}",
    "author": {
        "@type": "Organization",
        "name": "Edition By Punjab"
    },
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "{{ route('home') }}"
    },
    "mainEntity": {
        "@type": "ItemList",
        "itemListElement": [
            @foreach($lookbook['featured_products'] as $index => $product)
            {
                "@type": "Product",
                "position": {{ $index + 1 }},
                "name": "{{ $product['name'] }}",
                "image": "{{ asset('images/' . $product['image']) }}",
                "offers": {
                    "@type": "Offer",
                    "price": "{{ $product['price'] }}",
                    "priceCurrency": "AUD"
                }
            }{{ !$loop->last ? ',' : '' }}
            @endforeach
        ]
    }
}
</script>
@endsection