@extends('layouts.app')

@section('title', 'Checkout')

@section('content')
<div class="checkout-page-premium">
    <!-- Checkout Header -->
    <section class="checkout-header-premium">
        <div class="container">
            <h1 class="checkout-title" data-aos="fade-up">CHECKOUT</h1>
            <div class="checkout-steps" data-aos="fade-up" data-aos-delay="100">
                <div class="step completed">
                    <span class="step-number">1</span>
                    <span class="step-label">CART</span>
                </div>
                <div class="step-line"></div>
                <div class="step active">
                    <span class="step-number">2</span>
                    <span class="step-label">CHECKOUT</span>
                </div>
                <div class="step-line"></div>
                <div class="step">
                    <span class="step-number">3</span>
                    <span class="step-label">COMPLETE</span>
                </div>
            </div>
        </div>
    </section>

    <div class="container">
        @if($cartItems->isEmpty())
            <div class="empty-cart-notice">
                <i class="fas fa-shopping-bag"></i>
                <p>Your cart is empty. <a href="{{ route('shop.index') }}">Continue Shopping</a></p>
            </div>
        @else
        <form action="{{ route('checkout.process') }}" method="POST" id="checkoutForm" class="checkout-form-premium">
            @csrf
            <div class="row">
                <!-- Checkout Form -->
                <div class="col-lg-8">
                    <!-- Express Checkout -->
                    <div class="express-checkout-section" data-aos="fade-right">
                        <h3 class="section-title-premium">EXPRESS CHECKOUT</h3>
                        <div class="express-options">
                            <button type="button" class="express-btn paypal">
                                <i class="fab fa-paypal"></i> PayPal
                            </button>
                            <button type="button" class="express-btn apple-pay">
                                <i class="fab fa-apple"></i> Apple Pay
                            </button>
                            <button type="button" class="express-btn google-pay">
                                <i class="fab fa-google"></i> Google Pay
                            </button>
                        </div>
                        <div class="divider-text">
                            <span>OR</span>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="checkout-section" data-aos="fade-right" data-aos-delay="100">
                        <h3 class="section-title-premium">CONTACT INFORMATION</h3>
                        <div class="form-group-premium">
                            <input type="email" 
                                   class="form-input-premium @error('email') error @enderror" 
                                   id="email" 
                                   name="email" 
                                   value="{{ old('email', auth()->user()->email ?? '') }}" 
                                   required>
                            <label for="email" class="form-label-premium">Email Address</label>
                            @error('email')
                                <span class="error-message">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="newsletter-opt">
                            <label class="checkbox-premium">
                                <input type="checkbox" name="newsletter" value="1">
                                <span class="checkbox-mark"></span>
                                <span class="checkbox-label">Email me with news and offers</span>
                            </label>
                        </div>
                    </div>

                    <!-- Shipping Information -->
                    <div class="checkout-section" data-aos="fade-right" data-aos-delay="200">
                        <h3 class="section-title-premium">SHIPPING ADDRESS</h3>
                        
                        <div class="form-row">
                            <div class="form-group-premium">
                                <input type="text" 
                                       class="form-input-premium @error('first_name') error @enderror" 
                                       id="first_name" 
                                       name="first_name" 
                                       value="{{ old('first_name', auth()->user()->name ?? '') }}" 
                                       required>
                                <label for="first_name" class="form-label-premium">First Name</label>
                                @error('first_name')
                                    <span class="error-message">{{ $message }}</span>
                                @enderror
                            </div>
                            
                            <div class="form-group-premium">
                                <input type="text" 
                                       class="form-input-premium @error('last_name') error @enderror" 
                                       id="last_name" 
                                       name="last_name" 
                                       value="{{ old('last_name') }}" 
                                       required>
                                <label for="last_name" class="form-label-premium">Last Name</label>
                                @error('last_name')
                                    <span class="error-message">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group-premium">
                            <input type="tel" 
                                   class="form-input-premium @error('phone') error @enderror" 
                                   id="phone" 
                                   name="phone" 
                                   value="{{ old('phone') }}" 
                                   required>
                            <label for="phone" class="form-label-premium">Phone Number</label>
                            @error('phone')
                                <span class="error-message">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group-premium">
                            <input type="text" 
                                   class="form-input-premium @error('address_line_1') error @enderror" 
                                   id="address_line_1" 
                                   name="address_line_1" 
                                   value="{{ old('address_line_1') }}" 
                                   required>
                            <label for="address_line_1" class="form-label-premium">Address Line 1</label>
                            @error('address_line_1')
                                <span class="error-message">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group-premium">
                            <input type="text" 
                                   class="form-input-premium @error('address_line_2') error @enderror" 
                                   id="address_line_2" 
                                   name="address_line_2" 
                                   value="{{ old('address_line_2') }}">
                            <label for="address_line_2" class="form-label-premium">Apartment, suite, etc. (optional)</label>
                            @error('address_line_2')
                                <span class="error-message">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-row-three">
                            <div class="form-group-premium">
                                <input type="text" 
                                       class="form-input-premium @error('city') error @enderror" 
                                       id="city" 
                                       name="city" 
                                       value="{{ old('city') }}" 
                                       required>
                                <label for="city" class="form-label-premium">City</label>
                                @error('city')
                                    <span class="error-message">{{ $message }}</span>
                                @enderror
                            </div>
                            
                            <div class="form-group-premium">
                                <input type="text" 
                                       class="form-input-premium @error('state') error @enderror" 
                                       id="state" 
                                       name="state" 
                                       value="{{ old('state') }}" 
                                       required>
                                <label for="state" class="form-label-premium">State/Province</label>
                                @error('state')
                                    <span class="error-message">{{ $message }}</span>
                                @enderror
                            </div>
                            
                            <div class="form-group-premium">
                                <input type="text" 
                                       class="form-input-premium @error('postal_code') error @enderror" 
                                       id="postal_code" 
                                       name="postal_code" 
                                       value="{{ old('postal_code') }}" 
                                       required>
                                <label for="postal_code" class="form-label-premium">ZIP Code</label>
                                @error('postal_code')
                                    <span class="error-message">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group-premium">
                            <select class="form-select-premium @error('country') error @enderror" 
                                    id="country" 
                                    name="country" 
                                    required>
                                <option value="">Select Country</option>
                                <option value="Pakistan" {{ old('country') == 'Pakistan' ? 'selected' : '' }}>Pakistan</option>
                                <option value="India" {{ old('country') == 'India' ? 'selected' : '' }}>India</option>
                                <option value="United States" {{ old('country') == 'United States' ? 'selected' : '' }}>United States</option>
                                <option value="United Kingdom" {{ old('country') == 'United Kingdom' ? 'selected' : '' }}>United Kingdom</option>
                                <option value="Canada" {{ old('country') == 'Canada' ? 'selected' : '' }}>Canada</option>
                                <option value="Australia" {{ old('country') == 'Australia' ? 'selected' : '' }}>Australia</option>
                                <option value="Other" {{ old('country') == 'Other' ? 'selected' : '' }}>Other</option>
                            </select>
                            <label for="country" class="form-label-premium select-label">Country</label>
                            @error('country')
                                <span class="error-message">{{ $message }}</span>
                            @enderror
                        </div>

                        @auth
                        <div class="save-address">
                            <label class="checkbox-premium">
                                <input type="checkbox" name="save_address" value="1">
                                <span class="checkbox-mark"></span>
                                <span class="checkbox-label">Save this address for future orders</span>
                            </label>
                        </div>
                        @endauth
                    </div>

                    <!-- Shipping Method -->
                    <div class="checkout-section" data-aos="fade-right" data-aos-delay="300">
                        <h3 class="section-title-premium">SHIPPING METHOD</h3>
                        <div class="shipping-options">
                            @php
                                // Get shipping rates from the current zone or default fallback
                                $standardRate = 0;
                                $expressRate = 15;
                                $priorityRate = 25;
                                
                                if ($shippingZone) {
                                    $standardRate = $shippingZone->getShippingRate('standard', $subtotal);
                                    $expressRate = $shippingZone->getShippingRate('express', $subtotal);
                                    $priorityRate = $shippingZone->getShippingRate('priority', $subtotal);
                                }
                            @endphp
                            
                            <label class="radio-option-premium">
                                <input type="radio" name="shipping_method" value="standard" checked>
                                <div class="radio-card">
                                    <div class="radio-mark"></div>
                                    <div class="option-content">
                                        <div class="option-header">
                                            <span class="option-title">Standard Shipping</span>
                                            <span class="option-price">
                                                @if($standardRate == 0)
                                                    FREE
                                                @else
                                                    ${{ number_format($standardRate, 2) }}
                                                @endif
                                            </span>
                                        </div>
                                        <span class="option-desc">5-7 business days</span>
                                    </div>
                                </div>
                            </label>
                            
                            <label class="radio-option-premium">
                                <input type="radio" name="shipping_method" value="express">
                                <div class="radio-card">
                                    <div class="radio-mark"></div>
                                    <div class="option-content">
                                        <div class="option-header">
                                            <span class="option-title">Express Shipping</span>
                                            <span class="option-price">
                                                @if($expressRate == 0)
                                                    FREE
                                                @else
                                                    ${{ number_format($expressRate, 2) }}
                                                @endif
                                            </span>
                                        </div>
                                        <span class="option-desc">2-3 business days</span>
                                    </div>
                                </div>
                            </label>
                            
                            <label class="radio-option-premium">
                                <input type="radio" name="shipping_method" value="priority">
                                <div class="radio-card">
                                    <div class="radio-mark"></div>
                                    <div class="option-content">
                                        <div class="option-header">
                                            <span class="option-title">Priority Shipping</span>
                                            <span class="option-price">
                                                @if($priorityRate == 0)
                                                    FREE
                                                @else
                                                    ${{ number_format($priorityRate, 2) }}
                                                @endif
                                            </span>
                                        </div>
                                        <span class="option-desc">1-2 business days</span>
                                    </div>
                                </div>
                            </label>
                        </div>
                    </div>

                    <!-- Payment Method -->
                    <div class="checkout-section" data-aos="fade-right" data-aos-delay="400">
                        <h3 class="section-title-premium">PAYMENT METHOD</h3>
                        <div class="payment-options">
                            <label class="radio-option-premium">
                                <input type="radio" name="payment_method" value="stripe" checked>
                                <div class="radio-card">
                                    <div class="radio-mark"></div>
                                    <div class="option-content">
                                        <span class="option-title">Credit/Debit Card</span>
                                        <div class="payment-icons-inline">
                                            <i class="fab fa-cc-visa"></i>
                                            <i class="fab fa-cc-mastercard"></i>
                                            <i class="fab fa-cc-amex"></i>
                                            <i class="fab fa-cc-discover"></i>
                                        </div>
                                    </div>
                                </div>
                            </label>
                            
                            <div class="card-fields" id="cardFields">
                                <div class="form-group-premium">
                                    <input type="text" 
                                           class="form-input-premium" 
                                           maxlength="19">
                                    <label class="form-label-premium">Card Number</label>
                                    <span class="card-icon"><i class="far fa-credit-card"></i></span>
                                </div>
                                
                                <div class="form-row">
                                    <div class="form-group-premium">
                                        <input type="text" 
                                               class="form-input-premium" 
                                               maxlength="5">
                                        <label class="form-label-premium">Expiry Date (MM/YY)</label>
                                    </div>
                                    
                                    <div class="form-group-premium">
                                        <input type="text" 
                                               class="form-input-premium" 
                                               maxlength="4">
                                        <label class="form-label-premium">Security Code (CVV)</label>
                                        <span class="cvv-icon"><i class="fas fa-question-circle"></i></span>
                                    </div>
                                </div>
                            </div>
                            
                            <label class="radio-option-premium">
                                <input type="radio" name="payment_method" value="paypal">
                                <div class="radio-card">
                                    <div class="radio-mark"></div>
                                    <div class="option-content">
                                        <span class="option-title"><i class="fab fa-paypal"></i> PayPal</span>
                                    </div>
                                </div>
                            </label>
                            
                            <label class="radio-option-premium">
                                <input type="radio" name="payment_method" value="bank_transfer">
                                <div class="radio-card">
                                    <div class="radio-mark"></div>
                                    <div class="option-content">
                                        <span class="option-title"><i class="fas fa-university"></i> Bank Transfer</span>
                                    </div>
                                </div>
                            </label>
                        </div>
                    </div>

                    <!-- Order Notes -->
                    <div class="checkout-section" data-aos="fade-right" data-aos-delay="500">
                        <h3 class="section-title-premium">ORDER NOTES (OPTIONAL)</h3>
                        <div class="form-group-premium">
                            <textarea class="form-textarea-premium" 
                                      id="notes" 
                                      name="notes" 
                                      rows="4">{{ old('notes') }}</textarea>
                            <label for="notes" class="form-label-premium textarea-label">Notes about your order, e.g. special notes for delivery</label>
                        </div>
                    </div>
                </div>

                <!-- Order Summary Sidebar -->
                <div class="col-lg-4">
                    <div class="order-summary-sidebar" data-aos="fade-left">
                        <h3 class="summary-title">ORDER SUMMARY</h3>
                        
                        <!-- Cart Items Preview -->
                        <div class="cart-items-preview">
                            @foreach($cartItems as $item)
                            <div class="preview-item">
                                <div class="preview-image">
                                    <img src="{{ Storage::url($item->product->featured_image) }}" 
                                         alt="{{ $item->product->name }}">
                                    <span class="preview-qty">{{ $item->quantity }}</span>
                                </div>
                                <div class="preview-details">
                                    <h5>{{ $item->product->name }}</h5>
                                    @if($item->attributes)
                                    <p class="preview-attrs">
                                        @foreach($item->attributes as $key => $value)
                                            {{ ucfirst($key) }}: {{ $value }}
                                        @endforeach
                                    </p>
                                    @endif
                                </div>
                                <div class="preview-price">
                                    ${{ number_format($item->price * $item->quantity, 2) }}
                                </div>
                            </div>
                            @endforeach
                        </div>
                        
                        <!-- Discount Code -->
                        <div class="discount-code-section">
                            <div class="discount-toggle">
                                <i class="fas fa-tag"></i>
                                <span>Have a discount code?</span>
                            </div>
                            <div class="discount-form">
                                <input type="text" placeholder="Enter code">
                                <button type="button">APPLY</button>
                            </div>
                        </div>
                        
                        <!-- Summary Totals -->
                        <div class="summary-totals">
                            <div class="total-row">
                                <span>Subtotal</span>
                                <strong>${{ number_format($subtotal, 2) }}</strong>
                            </div>
                            
                            @if($discount > 0)
                            <div class="total-row discount">
                                <span>Discount</span>
                                <strong>-${{ number_format($discount, 2) }}</strong>
                            </div>
                            @endif
                            
                            <div class="total-row">
                                <span>Tax</span>
                                <strong>${{ number_format($tax, 2) }}</strong>
                            </div>
                            
                            <div class="total-row">
                                <span>Shipping</span>
                                <strong id="shippingAmount">
                                    @if($shipping > 0)
                                        ${{ number_format($shipping, 2) }}
                                    @else
                                        FREE
                                    @endif
                                </strong>
                            </div>
                            
                            <div class="total-divider"></div>
                            
                            <div class="total-row final">
                                <span>Total</span>
                                <strong id="totalAmount">${{ number_format($total, 2) }}</strong>
                            </div>
                        </div>
                        
                        <!-- Terms & Place Order -->
                        <div class="checkout-actions">
                            <label class="checkbox-premium terms">
                                <input type="checkbox" id="terms" required>
                                <span class="checkbox-mark"></span>
                                <span class="checkbox-label">
                                    I agree to the <a href="{{ route('terms') }}" target="_blank">Terms & Conditions</a>
                                    and <a href="{{ route('privacy') }}" target="_blank">Privacy Policy</a>
                                </span>
                            </label>
                            
                            <button type="submit" class="btn-place-order">
                                <span class="btn-text">PLACE ORDER</span>
                                <span class="btn-total">${{ number_format($total, 2) }}</span>
                            </button>
                            
                            <div class="security-info">
                                <i class="fas fa-lock"></i>
                                <span>Your payment information is encrypted and secure</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        @endif
    </div>
</div>

@push('styles')
<style>
/* Checkout Page Premium Styles */
.checkout-page-premium {
    min-height: 100vh;
    padding-bottom: 4rem;
    background: #fafafa;
}

/* Checkout Header */
.checkout-header-premium {
    background: white;
    padding: 2rem 0;
    border-bottom: 1px solid #e0e0e0;
    margin-bottom: 3rem;
}

.checkout-title {
    text-align: center;
    font-size: 2rem;
    font-weight: 900;
    letter-spacing: 0.1em;
    margin-bottom: 2rem;
    font-family: 'Space Grotesk', sans-serif;
}

/* Checkout Steps */
.checkout-steps {
    display: flex;
    justify-content: center;
    align-items: center;
    max-width: 500px;
    margin: 0 auto;
}

.step {
    display: flex;
    flex-direction: column;
    align-items: center;
    position: relative;
}

.step-number {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #e0e0e0;
    color: #999;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    margin-bottom: 0.5rem;
    transition: all 0.3s;
}

.step.completed .step-number {
    background: #4CAF50;
    color: white;
}

.step.active .step-number {
    background: #000;
    color: white;
    box-shadow: 0 0 0 4px rgba(0,0,0,0.1);
}

.step-label {
    font-size: 0.75rem;
    font-weight: 600;
    letter-spacing: 0.05em;
    color: #999;
}

.step.active .step-label,
.step.completed .step-label {
    color: #000;
}

.step-line {
    flex: 1;
    height: 2px;
    background: #e0e0e0;
    margin: 0 1rem;
    margin-bottom: 1.5rem;
}

/* Express Checkout */
.express-checkout-section {
    background: white;
    padding: 2rem;
    margin-bottom: 2rem;
    border: 1px solid #e0e0e0;
}

.section-title-premium {
    font-size: 1rem;
    font-weight: 700;
    letter-spacing: 0.1em;
    margin-bottom: 1.5rem;
}

.express-options {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
}

.express-btn {
    padding: 1rem;
    background: white;
    border: 2px solid #e0e0e0;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
}

.express-btn:hover {
    border-color: #000;
    transform: translateY(-2px);
}

.express-btn.paypal {
    color: #0070ba;
}

.express-btn.apple-pay {
    color: #000;
}

.express-btn.google-pay {
    color: #4285f4;
}

.divider-text {
    text-align: center;
    margin: 2rem 0 0;
    position: relative;
}

.divider-text::before {
    content: '';
    position: absolute;
    left: 0;
    top: 50%;
    width: 100%;
    height: 1px;
    background: #e0e0e0;
}

.divider-text span {
    background: white;
    padding: 0 1rem;
    position: relative;
    color: #999;
    font-size: 0.875rem;
}

/* Checkout Sections */
.checkout-section {
    background: white;
    padding: 2rem;
    margin-bottom: 2rem;
    border: 1px solid #e0e0e0;
}

/* Form Styles */
.form-row {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
}

.form-row-three {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
}

.form-group-premium {
    position: relative;
    margin-bottom: 1.5rem;
}

.form-input-premium,
.form-select-premium,
.form-textarea-premium {
    width: 100%;
    padding: 1rem;
    padding-top: 1.5rem;
    border: 1px solid #ddd;
    background: white;
    font-size: 0.875rem;
    transition: all 0.3s;
}

.form-input-premium:focus,
.form-select-premium:focus,
.form-textarea-premium:focus {
    outline: none;
    border-color: #000;
}

.form-label-premium {
    position: absolute;
    left: 1rem;
    top: 0.5rem;
    font-size: 0.75rem;
    color: #666;
    pointer-events: none;
    transition: all 0.3s;
    background: white;
    padding: 0 0.25rem;
}

/* Select label special handling */
.form-label-premium.select-label {
    top: 0.5rem;
}

/* Textarea label special handling */
.form-label-premium.textarea-label {
    top: 0.5rem;
}

.form-input-premium:focus + .form-label-premium,
.form-select-premium:focus + .form-label-premium,
.form-textarea-premium:focus + .form-label-premium {
    color: #000;
}

.form-input-premium.error {
    border-color: #ff3333;
}

.error-message {
    display: block;
    color: #ff3333;
    font-size: 0.75rem;
    margin-top: 0.25rem;
}

/* Checkbox Styles */
.checkbox-premium {
    display: flex;
    align-items: flex-start;
    cursor: pointer;
    user-select: none;
    position: relative;
    padding-left: 2rem;
}

.checkbox-premium input {
    position: absolute;
    opacity: 0;
}

.checkbox-mark {
    position: absolute;
    left: 0;
    top: 2px;
    width: 20px;
    height: 20px;
    border: 2px solid #ddd;
    background: white;
    transition: all 0.3s;
}

.checkbox-premium input:checked ~ .checkbox-mark {
    background: #000;
    border-color: #000;
}

.checkbox-mark::after {
    content: '';
    position: absolute;
    left: 6px;
    top: 2px;
    width: 6px;
    height: 10px;
    border: solid white;
    border-width: 0 2px 2px 0;
    transform: rotate(45deg);
    opacity: 0;
    transition: opacity 0.3s;
}

.checkbox-premium input:checked ~ .checkbox-mark::after {
    opacity: 1;
}

.checkbox-label {
    font-size: 0.875rem;
}

/* Radio Options */
.radio-option-premium {
    display: block;
    margin-bottom: 1rem;
    cursor: pointer;
}

.radio-option-premium input {
    display: none;
}

.radio-card {
    padding: 1.25rem;
    border: 2px solid #e0e0e0;
    background: white;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    gap: 1rem;
}

.radio-option-premium input:checked ~ .radio-card {
    border-color: #000;
    background: #fafafa;
}

.radio-mark {
    width: 20px;
    height: 20px;
    border: 2px solid #ddd;
    border-radius: 50%;
    position: relative;
    transition: all 0.3s;
}

.radio-option-premium input:checked ~ .radio-card .radio-mark {
    border-color: #000;
}

.radio-mark::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 10px;
    height: 10px;
    border-radius: 50%;
    background: #000;
    opacity: 0;
    transition: opacity 0.3s;
}

.radio-option-premium input:checked ~ .radio-card .radio-mark::after {
    opacity: 1;
}

.option-content {
    flex: 1;
}

.option-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 0.25rem;
}

.option-title {
    font-weight: 600;
}

.option-price {
    font-weight: 700;
}

.option-desc {
    font-size: 0.875rem;
    color: #666;
}

.payment-icons-inline {
    display: flex;
    gap: 0.5rem;
    font-size: 1.25rem;
    color: #666;
}

/* Card Fields */
.card-fields {
    padding: 1rem;
    background: #fafafa;
    margin: 1rem 0;
}

.card-icon,
.cvv-icon {
    position: absolute;
    right: 1rem;
    top: 1.5rem;
    color: #999;
}

/* Order Summary Sidebar */
.order-summary-sidebar {
    background: white;
    border: 1px solid #e0e0e0;
    padding: 2rem;
    position: sticky;
    top: 100px;
}

.summary-title {
    font-size: 1rem;
    font-weight: 700;
    letter-spacing: 0.1em;
    margin-bottom: 1.5rem;
}

/* Cart Items Preview */
.cart-items-preview {
    max-height: 300px;
    overflow-y: auto;
    margin-bottom: 1.5rem;
}

.preview-item {
    display: flex;
    gap: 1rem;
    padding: 1rem 0;
    border-bottom: 1px solid #f0f0f0;
}

.preview-image {
    position: relative;
    width: 60px;
    height: 70px;
}

.preview-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.preview-qty {
    position: absolute;
    top: -8px;
    right: -8px;
    width: 20px;
    height: 20px;
    background: #000;
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.625rem;
    font-weight: 700;
}

.preview-details {
    flex: 1;
}

.preview-details h5 {
    font-size: 0.875rem;
    margin-bottom: 0.25rem;
}

.preview-attrs {
    font-size: 0.75rem;
    color: #666;
    margin: 0;
}

.preview-price {
    font-weight: 700;
}

/* Discount Code */
.discount-code-section {
    padding: 1rem 0;
    border-top: 1px solid #e0e0e0;
    border-bottom: 1px solid #e0e0e0;
    margin-bottom: 1.5rem;
}

.discount-toggle {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    cursor: pointer;
    font-size: 0.875rem;
    color: #666;
}

.discount-form {
    display: flex;
    gap: 0.5rem;
    margin-top: 1rem;
}

.discount-form input {
    flex: 1;
    padding: 0.5rem;
    border: 1px solid #ddd;
}

.discount-form button {
    padding: 0.5rem 1rem;
    background: #000;
    color: white;
    border: none;
    font-weight: 600;
    cursor: pointer;
}

/* Summary Totals */
.summary-totals {
    margin-bottom: 1.5rem;
}

.total-row {
    display: flex;
    justify-content: space-between;
    padding: 0.5rem 0;
    font-size: 0.875rem;
}

.total-row.discount {
    color: #4CAF50;
}

.total-row.final {
    font-size: 1.125rem;
    font-weight: 700;
}

.total-divider {
    height: 1px;
    background: #e0e0e0;
    margin: 1rem 0;
}

/* Checkout Actions */
.btn-place-order {
    width: 100%;
    padding: 1.25rem;
    background: #000;
    color: white;
    border: none;
    font-weight: 700;
    letter-spacing: 0.05em;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin: 1.5rem 0;
}

.btn-place-order:hover {
    background: #333;
    transform: translateY(-2px);
}

.security-info {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    font-size: 0.75rem;
    color: #666;
}

.security-info i {
    color: #4CAF50;
}

/* Responsive */
@media (max-width: 991px) {
    .express-options {
        grid-template-columns: 1fr;
    }
    
    .form-row,
    .form-row-three {
        grid-template-columns: 1fr;
    }
    
    .order-summary-sidebar {
        position: static;
        margin-top: 2rem;
    }
}

@media (max-width: 576px) {
    .checkout-title {
        font-size: 1.5rem;
    }
    
    .checkout-section {
        padding: 1rem;
    }
}
</style>
@endpush

@push('scripts')
<script>
document.getElementById('checkoutForm')?.addEventListener('submit', function(e) {
    const btn = e.target.querySelector('.btn-place-order');
    const btnText = btn.querySelector('.btn-text');
    btnText.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
    btn.disabled = true;
});

// Update shipping cost based on selection
document.querySelectorAll('input[name="shipping_method"]').forEach(radio => {
    radio.addEventListener('change', function() {
        const shippingCosts = {
            'standard': {{ $standardRate }},
            'express': {{ $expressRate }},
            'priority': {{ $priorityRate }}
        };
        
        const shipping = shippingCosts[this.value];
        const shippingElement = document.getElementById('shippingAmount');
        const totalElement = document.getElementById('totalAmount');
        const btnTotal = document.querySelector('.btn-total');
        
        if (shipping === 0) {
            shippingElement.textContent = 'FREE';
        } else {
            shippingElement.textContent = `$${shipping.toFixed(2)}`;
        }
        
        // Update total (you'll need to calculate this properly with your backend values)
        const subtotal = {{ $subtotal }};
        const tax = {{ $tax }};
        const discount = {{ $discount }};
        const newTotal = subtotal - discount + tax + shipping;
        
        totalElement.textContent = `$${newTotal.toFixed(2)}`;
        btnTotal.textContent = `$${newTotal.toFixed(2)}`;
    });
});
</script>
@endpush
@endsection