@extends('layouts.app')

@section('title', 'Shop - ' . ($companyInfo->company_name ?? 'Edition By Punjab'))

@section('content')
<div class="shop-premium">
    <!-- Shop Header -->
    <section class="shop-header-premium">
        <div class="container">
            <div class="shop-header-content">
                <h1 class="shop-title" data-aos="fade-up">SHOP</h1>
                <nav aria-label="breadcrumb" data-aos="fade-up" data-aos-delay="100">
                    <ol class="breadcrumb-premium">
                        <li><a href="{{ route('home') }}">HOME</a></li>
                        <li class="separator">/</li>
                        <li class="active">SHOP</li>
                    </ol>
                </nav>
            </div>
        </div>
    </section>

    <!-- Shop Toolbar -->
    <section class="shop-toolbar-premium">
        <div class="container">
            <div class="toolbar-content">
                <div class="toolbar-left">
                    <button class="filter-toggle-btn d-lg-none" id="filterToggle">
                        <i class="fas fa-filter"></i>
                        <span>FILTERS</span>
                    </button>
                    <span class="results-count">{{ $products->total() }} PRODUCTS</span>
                </div>
                
                <div class="toolbar-right">
                    <div class="sort-wrapper">
                        <label for="sortSelect">SORT BY:</label>
                        <select id="sortSelect" class="sort-select" onchange="window.location.href=this.value">
                            <option value="{{ route('shop.index') }}">DEFAULT</option>
                            <option value="{{ route('shop.index', ['sort' => 'price_low']) }}" {{ request('sort') == 'price_low' ? 'selected' : '' }}>PRICE: LOW TO HIGH</option>
                            <option value="{{ route('shop.index', ['sort' => 'price_high']) }}" {{ request('sort') == 'price_high' ? 'selected' : '' }}>PRICE: HIGH TO LOW</option>
                            <option value="{{ route('shop.index', ['sort' => 'newest']) }}" {{ request('sort') == 'newest' ? 'selected' : '' }}>NEWEST</option>
                            <option value="{{ route('shop.index', ['sort' => 'popular']) }}" {{ request('sort') == 'popular' ? 'selected' : '' }}>MOST POPULAR</option>
                        </select>
                    </div>
                    
                    <div class="view-options">
                        <button class="view-btn active" data-view="grid-3">
                            <i class="fas fa-th"></i>
                        </button>
                        <button class="view-btn" data-view="grid-2">
                            <i class="fas fa-th-large"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Main Shop Content -->
    <section class="shop-main-premium">
        <div class="container">
            <div class="row">
                <!-- Filters Sidebar -->
                <div class="col-lg-3">
                    <div class="filters-sidebar-premium" id="filtersSidebar">
                        <div class="filter-header d-lg-none">
                            <h4>FILTERS</h4>
                            <button class="filter-close" id="filterClose">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                        
                        <!-- Search Filter -->
                        <div class="filter-block">
                            <h5 class="filter-title">SEARCH</h5>
                            <form action="{{ route('shop.search') }}" method="GET" class="search-form">
                                <div class="search-input-wrapper">
                                    <input type="text" name="q" placeholder="Search products..." value="{{ request('q') }}" class="filter-search-input">
                                    <button type="submit" class="search-btn">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </form>
                        </div>

                        <!-- Categories Filter -->
                        <div class="filter-block">
                            <h5 class="filter-title">CATEGORIES</h5>
                            <div class="filter-options">
                                <a href="{{ route('shop.index') }}" class="filter-option {{ !request('category') ? 'active' : '' }}">
                                    <span>ALL CATEGORIES</span>
                                    <span class="count">({{ $products->total() }})</span>
                                </a>
                                @foreach($categories as $category)
                                <a href="{{ route('shop.category', $category->slug) }}" 
                                   class="filter-option {{ request()->is('shop/category/' . $category->slug) ? 'active' : '' }}">
                                    <span>{{ strtoupper($category->name) }}</span>
                                    <span class="count">({{ $category->products_count }})</span>
                                </a>
                                @endforeach
                            </div>
                        </div>

                        <!-- Price Range Filter -->
                        <div class="filter-block">
                            <h5 class="filter-title">PRICE RANGE</h5>
                            <form method="GET" action="{{ route('shop.index') }}" class="price-filter-form">
                                <div class="price-inputs">
                                    <input type="number" name="min_price" placeholder="MIN" value="{{ request('min_price') }}" class="price-input">
                                    <span class="price-separator">-</span>
                                    <input type="number" name="max_price" placeholder="MAX" value="{{ request('max_price') }}" class="price-input">
                                </div>
                                <button type="submit" class="filter-apply-btn">APPLY</button>
                            </form>
                        </div>

                        <!-- Sizes Filter -->
                        @if($sizes->count() > 0)
                        <div class="filter-block">
                            <h5 class="filter-title">SIZES</h5>
                            <div class="size-grid">
                                @foreach($sizes as $size)
                                <label class="size-option-premium">
                                    <input type="checkbox" name="sizes[]" value="{{ $size }}" class="size-checkbox">
                                    <span class="size-box">{{ $size }}</span>
                                </label>
                                @endforeach
                            </div>
                        </div>
                        @endif

                        <!-- Colors Filter -->
                        @if($colors->count() > 0)
                        <div class="filter-block">
                            <h5 class="filter-title">COLORS</h5>
                            <div class="color-grid">
                                @foreach($colors as $color)
                                <label class="color-option-premium" title="{{ $color }}">
                                    <input type="checkbox" name="colors[]" value="{{ $color }}" class="color-checkbox">
                                    <span class="color-circle" style="background-color: {{ $color }}"></span>
                                </label>
                                @endforeach
                            </div>
                        </div>
                        @endif

                        <!-- Clear Filters -->
                        @if(request()->hasAny(['category', 'min_price', 'max_price', 'sizes', 'colors', 'q']))
                        <div class="filter-block">
                            <a href="{{ route('shop.index') }}" class="clear-filters-btn">
                                <i class="fas fa-times"></i> CLEAR ALL FILTERS
                            </a>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Products Grid -->
                <div class="col-lg-9">
                    <div class="products-grid-premium grid-3" id="productsGrid">
                        @forelse($products as $index => $product)
                        <div class="product-item-premium" data-aos="fade-up" data-aos-delay="{{ $index * 50 }}">
                            <div class="product-card-shop">
                                <div class="product-image-wrapper">
                                    @if($product->is_on_campaign_sale)
                                    <span class="product-label sale">
                                        -{{ $product->campaign_discount_percentage }}%
                                    </span>
                                    @elseif($product->compare_price && $product->compare_price > $product->price)
                                    <span class="product-label sale">
                                        -{{ round((($product->compare_price - $product->price) / $product->compare_price) * 100) }}%
                                    </span>
                                    @endif
                                    
                                    @if($product->is_featured)
                                    <span class="product-label hot">HOT</span>
                                    @endif

                                    @if($product->created_at->diffInDays() < 7)
                                    <span class="product-label new">NEW</span>
                                    @endif
                                    
                                    <a href="{{ route('shop.product', $product->slug) }}" class="product-image-link">
                                        <img src="{{ \App\Helpers\ImageHelper::getImageUrl($product->featured_image) }}" 
                                             class="product-img primary" 
                                             alt="{{ $product->name }}"
                                             onerror="this.src='{{ asset('images/placeholder-product.jpg') }}'">
                                        @if($product->hover_image)
                                        <img src="{{ \App\Helpers\ImageHelper::getImageUrl($product->hover_image) }}" 
                                             class="product-img secondary" 
                                             alt="{{ $product->name }}"
                                             onerror="this.src='{{ asset('images/placeholder-product.jpg') }}'">
                                        @endif
                                    </a>
                                    
                                    <div class="product-overlay">
                                        <div class="overlay-buttons">
                                            <button class="overlay-btn quick-view-btn" data-product-id="{{ $product->id }}" title="Quick View">
                                                <i class="far fa-eye"></i>
                                            </button>
                                            <button class="overlay-btn wishlist-btn {{ in_array($product->id, $wishlistItems) ? 'active' : '' }}" 
                                                    data-product-id="{{ $product->id }}" title="Add to Wishlist">
                                                <i class="{{ in_array($product->id, $wishlistItems) ? 'fas' : 'far' }} fa-heart"></i>
                                            </button>
                                            @if($product->stock > 0)
                                            <button class="overlay-btn add-to-cart-btn" data-product-id="{{ $product->id }}" title="Add to Cart">
                                                <i class="fas fa-shopping-bag"></i>
                                            </button>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="product-info">
                                    <div class="product-cat">{{ strtoupper($product->category->name) }}</div>
                                    <h3 class="product-title">
                                        <a href="{{ route('shop.product', $product->slug) }}">{{ $product->name }}</a>
                                    </h3>
                                    <div class="product-price-wrapper">
                                        @if($product->is_on_campaign_sale)
                                        <span class="price-old">${{ number_format($product->price, 2) }}</span>
                                        <span class="price-current sale-price">${{ number_format($product->best_sale_price, 2) }}</span>
                                        @elseif($product->compare_price && $product->compare_price > $product->price)
                                        <span class="price-old">${{ number_format($product->compare_price, 2) }}</span>
                                        <span class="price-current">${{ number_format($product->price, 2) }}</span>
                                        @else
                                        <span class="price-current">${{ number_format($product->price, 2) }}</span>
                                        @endif
                                    </div>
                                    @if($product->stock <= 5 && $product->stock > 0)
                                    <div class="stock-warning">
                                        <i class="fas fa-fire"></i> Only {{ $product->stock }} left
                                    </div>
                                    @elseif($product->stock == 0)
                                    <div class="out-of-stock">
                                        OUT OF STOCK
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @empty
                        <div class="col-12">
                            <div class="no-products">
                                <i class="fas fa-search fa-4x mb-3"></i>
                                <h3>NO PRODUCTS FOUND</h3>
                                <p>Try adjusting your filters or search terms</p>
                                <a href="{{ route('shop.index') }}" class="btn-back-shop">VIEW ALL PRODUCTS</a>
                            </div>
                        </div>
                        @endforelse
                    </div>

                    <!-- Pagination -->
                    @if($products->hasPages())
                    <div class="pagination-wrapper">
                        {{ $products->withQueryString()->links('pagination::bootstrap-5') }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Quick View Modal -->
<div class="modal fade quick-view-modal" id="quickViewModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <button type="button" class="btn-close-modal" data-bs-dismiss="modal">
                <i class="fas fa-times"></i>
            </button>
            <div class="modal-body">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
/* Shop Premium Styles */
.shop-premium {
    min-height: 100vh;
    padding-top: 2rem;
}

/* Shop Header */
.shop-header-premium {
    padding: 3rem 0;
    background: linear-gradient(135deg, #f8f8f8 0%, #ffffff 100%);
    border-bottom: 1px solid #e0e0e0;
}

.shop-header-content {
    text-align: center;
}

.shop-title {
    font-size: 3rem;
    font-weight: 900;
    letter-spacing: 0.1em;
    margin-bottom: 1rem;
    font-family: 'Space Grotesk', sans-serif;
}

/* Breadcrumb */
.breadcrumb-premium {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 1rem;
    list-style: none;
    margin: 0;
    padding: 0;
}

.breadcrumb-premium li {
    font-size: 0.875rem;
    letter-spacing: 0.05em;
}

.breadcrumb-premium a {
    color: #666;
    text-decoration: none;
    transition: all 0.3s;
}

.breadcrumb-premium a:hover {
    color: #000;
}

.breadcrumb-premium .active {
    color: #000;
    font-weight: 600;
}

.separator {
    color: #999;
}

/* Shop Toolbar */
.shop-toolbar-premium {
    padding: 1.5rem 0;
    background: white;
    border-bottom: 1px solid #e0e0e0;
    position: sticky;
    top: 80px;
    z-index: 100;
}

.toolbar-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1rem;
}

.toolbar-left {
    display: flex;
    align-items: center;
    gap: 2rem;
}

.filter-toggle-btn {
    background: #000;
    color: white;
    border: none;
    padding: 0.5rem 1rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
    letter-spacing: 0.05em;
    cursor: pointer;
    transition: all 0.3s;
}

.filter-toggle-btn:hover {
    background: #333;
}

.results-count {
    font-size: 0.875rem;
    color: #666;
    font-weight: 500;
}

.toolbar-right {
    display: flex;
    align-items: center;
    gap: 2rem;
}

.sort-wrapper {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.sort-wrapper label {
    font-size: 0.875rem;
    font-weight: 600;
    margin: 0;
}

.sort-select {
    padding: 0.5rem 2rem 0.5rem 1rem;
    border: 1px solid #000;
    background: white;
    font-size: 0.875rem;
    font-weight: 500;
    cursor: pointer;
    appearance: none;
    background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='none' stroke='currentColor' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3e%3cpolyline points='6 9 12 15 18 9'%3e%3c/polyline%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: right 0.5rem center;
    background-size: 1rem;
}

.view-options {
    display: flex;
    gap: 0.5rem;
}

.view-btn {
    width: 35px;
    height: 35px;
    border: 1px solid #ddd;
    background: white;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s;
}

.view-btn.active,
.view-btn:hover {
    background: #000;
    color: white;
    border-color: #000;
}

/* Filters Sidebar */
.filters-sidebar-premium {
    background: white;
    padding: 2rem;
    border: 1px solid #e0e0e0;
    margin-bottom: 2rem;
}

.filter-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2rem;
}

.filter-close {
    background: none;
    border: none;
    font-size: 1.5rem;
    cursor: pointer;
}

.filter-block {
    margin-bottom: 2rem;
    padding-bottom: 2rem;
    border-bottom: 1px solid #e0e0e0;
}

.filter-block:last-child {
    border-bottom: none;
}

.filter-title {
    font-size: 0.875rem;
    font-weight: 700;
    letter-spacing: 0.1em;
    margin-bottom: 1rem;
}

/* Search Filter */
.search-input-wrapper {
    position: relative;
}

.filter-search-input {
    width: 100%;
    padding: 0.75rem 2.5rem 0.75rem 1rem;
    border: 1px solid #ddd;
    font-size: 0.875rem;
    transition: all 0.3s;
}

.filter-search-input:focus {
    outline: none;
    border-color: #000;
}

.search-btn {
    position: absolute;
    right: 0.75rem;
    top: 50%;
    transform: translateY(-50%);
    background: none;
    border: none;
    cursor: pointer;
}

/* Category Filter */
.filter-options {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.filter-option {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.5rem 0;
    color: #666;
    text-decoration: none;
    font-size: 0.875rem;
    transition: all 0.3s;
}

.filter-option:hover,
.filter-option.active {
    color: #000;
    font-weight: 600;
}

.filter-option .count {
    font-size: 0.75rem;
    opacity: 0.7;
}

/* Price Filter */
.price-inputs {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1rem;
}

.price-input {
    flex: 1;
    padding: 0.5rem;
    border: 1px solid #ddd;
    font-size: 0.875rem;
}

.price-separator {
    color: #666;
}

.filter-apply-btn {
    width: 100%;
    padding: 0.75rem;
    background: #000;
    color: white;
    border: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    cursor: pointer;
    transition: all 0.3s;
}

.filter-apply-btn:hover {
    background: #333;
}

/* Size Filter */
.size-grid {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 0.5rem;
}

.size-option-premium {
    position: relative;
    cursor: pointer;
}

.size-checkbox {
    position: absolute;
    opacity: 0;
}

.size-box {
    display: block;
    padding: 0.75rem;
    border: 1px solid #ddd;
    text-align: center;
    font-size: 0.875rem;
    transition: all 0.3s;
}

.size-checkbox:checked ~ .size-box {
    background: #000;
    color: white;
    border-color: #000;
}

/* Color Filter */
.color-grid {
    display: grid;
    grid-template-columns: repeat(6, 1fr);
    gap: 0.5rem;
}

.color-option-premium {
    position: relative;
    cursor: pointer;
}

.color-checkbox {
    position: absolute;
    opacity: 0;
}

.color-circle {
    display: block;
    width: 30px;
    height: 30px;
    border-radius: 50%;
    border: 2px solid #ddd;
    transition: all 0.3s;
}

.color-checkbox:checked ~ .color-circle {
    border-color: #000;
    box-shadow: 0 0 0 3px rgba(0,0,0,0.1);
}

/* Clear Filters */
.clear-filters-btn {
    display: inline-block;
    padding: 0.75rem 1.5rem;
    background: #f5f5f5;
    color: #000;
    text-decoration: none;
    font-size: 0.875rem;
    font-weight: 600;
    letter-spacing: 0.05em;
    text-align: center;
    transition: all 0.3s;
}

.clear-filters-btn:hover {
    background: #000;
    color: white;
}

/* Products Grid */
.products-grid-premium {
    display: grid;
    gap: 2rem;
    margin-bottom: 3rem;
}

.products-grid-premium.grid-3 {
    grid-template-columns: repeat(3, 1fr);
}

.products-grid-premium.grid-2 {
    grid-template-columns: repeat(2, 1fr);
}

/* Product Card */
.product-card-shop {
    background: white;
    transition: all 0.3s;
}

.product-card-shop:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.product-image-wrapper {
    position: relative;
    overflow: hidden;
    aspect-ratio: 3/4;
    background: #f5f5f5;
}

.product-img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: all 0.5s;
}

.product-img.secondary {
    position: absolute;
    top: 0;
    left: 0;
    opacity: 0;
}

.product-card-shop:hover .product-img.secondary {
    opacity: 1;
}

.product-card-shop:hover .product-img.primary {
    transform: scale(1.05);
}

/* Product Labels */
.product-label {
    position: absolute;
    top: 1rem;
    z-index: 2;
    padding: 0.25rem 0.75rem;
    font-size: 0.625rem;
    font-weight: 700;
    letter-spacing: 0.05em;
    color: white;
}

.product-label.sale {
    left: 1rem;
    background: #ff3333;
}

.product-label.hot {
    right: 1rem;
    background: #000;
}

.product-label.new {
    left: 1rem;
    top: 3rem;
    background: #4CAF50;
}

/* Product Overlay */
.product-overlay {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: rgba(255,255,255,0.95);
    padding: 1rem;
    transform: translateY(100%);
    transition: all 0.3s;
}

.product-card-shop:hover .product-overlay {
    transform: translateY(0);
}

.overlay-buttons {
    display: flex;
    justify-content: center;
    gap: 0.5rem;
}

.overlay-btn {
    width: 40px;
    height: 40px;
    border: 1px solid #000;
    background: white;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s;
}

.overlay-btn:hover,
.overlay-btn.active {
    background: #000;
    color: white;
}

/* Product Info */
.product-info {
    padding: 1.5rem;
    text-align: center;
}

.product-cat {
    font-size: 0.625rem;
    letter-spacing: 0.1em;
    color: #999;
    margin-bottom: 0.5rem;
}

.product-title {
    font-size: 1rem;
    font-weight: 600;
    margin-bottom: 0.75rem;
}

.product-title a {
    color: #000;
    text-decoration: none;
    transition: all 0.3s;
}

.product-title a:hover {
    color: #666;
}

.product-price-wrapper {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 0.75rem;
}

.price-old {
    text-decoration: line-through;
    color: #999;
    font-size: 0.875rem;
}

.price-current {
    font-size: 1.125rem;
    font-weight: 700;
    color: #000;
}

.stock-warning {
    margin-top: 0.5rem;
    color: #ff3333;
    font-size: 0.75rem;
    font-weight: 600;
}

.out-of-stock {
    margin-top: 0.5rem;
    padding: 0.25rem 0.75rem;
    background: #f5f5f5;
    color: #999;
    font-size: 0.75rem;
    font-weight: 600;
    letter-spacing: 0.05em;
    display: inline-block;
}

/* No Products */
.no-products {
    text-align: center;
    padding: 5rem 0;
    color: #666;
}

.no-products h3 {
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 1rem;
}

.btn-back-shop {
    display: inline-block;
    margin-top: 1rem;
    padding: 1rem 2rem;
    background: #000;
    color: white;
    text-decoration: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    transition: all 0.3s;
}

.btn-back-shop:hover {
    background: #333;
    color: white;
}

/* Pagination */
.pagination-wrapper {
    display: flex;
    justify-content: center;
    margin-top: 3rem;
}

.pagination {
    gap: 0.5rem;
}

.page-link {
    color: #000;
    border: 1px solid #ddd;
    padding: 0.75rem 1rem;
    font-weight: 500;
    transition: all 0.3s;
}

.page-link:hover {
    background: #000;
    color: white;
    border-color: #000;
}

.page-item.active .page-link {
    background: #000;
    color: white;
    border-color: #000;
}

/* Sale Price Styling */
.price-current.sale-price {
    color: #dc3545 !important;
    font-weight: 700;
}

.product-label.sale {
    background: linear-gradient(135deg, #dc3545 0%, #c62d42 100%);
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% {
        transform: scale(1);
    }
    50% {
        transform: scale(1.05);
    }
}

/* Quick View Modal */
.quick-view-modal .modal-content {
    border: none;
    border-radius: 0;
}

.btn-close-modal {
    position: absolute;
    top: 1rem;
    right: 1rem;
    z-index: 1000;
    width: 40px;
    height: 40px;
    background: white;
    border: 1px solid #ddd;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-close-modal:hover {
    background: #000;
    color: white;
}

/* Mobile Filters Overlay */
@media (max-width: 991px) {
    .filters-sidebar-premium {
        position: fixed;
        top: 0;
        left: -100%;
        width: 80%;
        max-width: 350px;
        height: 100vh;
        overflow-y: auto;
        z-index: 1100;
        transition: left 0.3s;
    }
    
    .filters-sidebar-premium.active {
        left: 0;
    }
    
    .filters-overlay {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0,0,0,0.5);
        z-index: 1099;
        display: none;
    }
    
    .filters-overlay.active {
        display: block;
    }
    
    .products-grid-premium.grid-3 {
        grid-template-columns: repeat(2, 1fr);
        gap: 1rem;
    }
}

@media (max-width: 576px) {
    .shop-title {
        font-size: 2rem;
    }
    
    .products-grid-premium.grid-3,
    .products-grid-premium.grid-2 {
        grid-template-columns: repeat(2, 1fr);
        gap: 0.75rem;
    }
    
    .toolbar-content {
        justify-content: center;
    }
    
    .view-options {
        display: none;
    }
}
</style>
@endpush

@push('scripts')
<script>
$(document).ready(function() {
    // Filter toggle for mobile
    $('#filterToggle').click(function() {
        $('#filtersSidebar').addClass('active');
        $('body').append('<div class="filters-overlay active"></div>');
        $('body').css('overflow', 'hidden');
    });
    
    $('#filterClose, .filters-overlay').click(function() {
        $('#filtersSidebar').removeClass('active');
        $('.filters-overlay').remove();
        $('body').css('overflow', '');
    });
    
    // View toggle
    $('.view-btn').click(function() {
        $('.view-btn').removeClass('active');
        $(this).addClass('active');
        
        const view = $(this).data('view');
        $('#productsGrid').removeClass('grid-2 grid-3').addClass(view);
    });
    
    // Add to cart
    $('.add-to-cart-btn').click(function() {
        var productId = $(this).data('product-id');
        var button = $(this);
        
        $.ajax({
            url: '{{ route("cart.add") }}',
            method: 'POST',
            data: {
                product_id: productId,
                quantity: 1,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if(response.success) {
                    updateCartCount();
                    toastr.success('Added to cart!');
                    
                    button.html('<i class="fas fa-check"></i>');
                    setTimeout(function() {
                        button.html('<i class="fas fa-shopping-bag"></i>');
                    }, 2000);
                }
            },
            error: function(xhr) {
                toastr.error('Failed to add to cart');
            }
        });
    });
    
    // Wishlist toggle
    $('.wishlist-btn').click(function() {
        var productId = $(this).data('product-id');
        var button = $(this);
        
        @auth
        $.ajax({
            url: '{{ route("shop.wishlist.toggle") }}',
            method: 'POST',
            data: {
                product_id: productId,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if(response.added) {
                    button.addClass('active');
                    button.find('i').removeClass('far').addClass('fas');
                    toastr.success('Added to wishlist!');
                } else {
                    button.removeClass('active');
                    button.find('i').removeClass('fas').addClass('far');
                    toastr.info('Removed from wishlist');
                }
            },
            error: function(xhr) {
                toastr.error('Failed to update wishlist');
            }
        });
        @else
        window.location.href = '{{ route("login") }}';
        @endauth
    });
    
    // Quick view
    $('.quick-view-btn').click(function() {
        var productId = $(this).data('product-id');
        
        $.ajax({
            url: '{{ route("shop.quick-view", "") }}/' + productId,
            method: 'GET',
            success: function(response) {
                $('#quickViewModal .modal-body').html(response);
                $('#quickViewModal').modal('show');
            },
            error: function(xhr) {
                toastr.error('Failed to load product');
            }
        });
    });
});

function updateCartCount() {
    $.ajax({
        url: '{{ route("cart.count") }}',
        method: 'GET',
        success: function(response) {
            $('.cart-count').text(response.count);
        }
    });
}
</script>
@endpush
@endsection