@extends('layouts.app')

@section('title', 'Order Tracking - ' . $order->order_number)

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">Order #{{ $order->order_number }}</h4>
                </div>
                <div class="card-body">
                    <!-- Order Status -->
                    <div class="mb-4">
                        <h5>Order Status</h5>
                        <div class="progress" style="height: 30px;">
                            @php
                                $statusProgress = [
                                    'pending' => 20,
                                    'processing' => 40,
                                    'shipped' => 60,
                                    'out_for_delivery' => 80,
                                    'delivered' => 100
                                ];
                                $progress = $statusProgress[$order->status] ?? 0;
                            @endphp
                            <div class="progress-bar bg-success" role="progressbar" style="width: {{ $progress }}%">
                                {{ ucfirst(str_replace('_', ' ', $order->status)) }}
                            </div>
                        </div>
                    </div>
                    
                    <!-- Tracking Information -->
                    @if($order->tracking_number)
                    <div class="mb-4">
                        <h5>Tracking Information</h5>
                        <table class="table">
                            <tr>
                                <td><strong>Tracking Number:</strong></td>
                                <td>{{ $order->tracking_number }}</td>
                            </tr>
                            @if($order->carrier)
                            <tr>
                                <td><strong>Carrier:</strong></td>
                                <td>{{ $order->carrier }}</td>
                            </tr>
                            @endif
                            @if($order->estimated_delivery)
                            <tr>
                                <td><strong>Estimated Delivery:</strong></td>
                                <td>{{ \Carbon\Carbon::parse($order->estimated_delivery)->format('F d, Y') }}</td>
                            </tr>
                            @endif
                        </table>
                    </div>
                    @endif
                    
                    <!-- Tracking Updates -->
                    @if(count($trackingUpdates) > 0)
                    <div class="mb-4">
                        <h5>Tracking Updates</h5>
                        <div class="timeline">
                            @foreach(array_reverse($trackingUpdates) as $update)
                            <div class="timeline-item">
                                <div class="timeline-marker"></div>
                                <div class="timeline-content">
                                    <h6 class="mb-1">{{ $update['message'] }}</h6>
                                    <small class="text-muted">
                                        {{ \Carbon\Carbon::parse($update['date'])->format('F d, Y g:i A') }}
                                    </small>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif
                    
                    <!-- Order Details -->
                    <div class="mb-4">
                        <h5>Order Details</h5>
                        <table class="table">
                            <tr>
                                <td><strong>Order Date:</strong></td>
                                <td>{{ $order->created_at->format('F d, Y') }}</td>
                            </tr>
                            <tr>
                                <td><strong>Total Amount:</strong></td>
                                <td>${{ number_format($order->total_amount, 2) }}</td>
                            </tr>
                            <tr>
                                <td><strong>Payment Status:</strong></td>
                                <td>
                                    <span class="badge bg-{{ $order->payment_status == 'paid' ? 'success' : 'warning' }}">
                                        {{ ucfirst($order->payment_status) }}
                                    </span>
                                </td>
                            </tr>
                        </table>
                    </div>
                    
                    <div class="text-center">
                        <a href="{{ route('order.track.index') }}" class="btn btn-primary">
                            <i class="fas fa-search me-2"></i>Track Another Order
                        </a>
                        <a href="{{ route('contact') }}" class="btn btn-outline-primary">
                            <i class="fas fa-question-circle me-2"></i>Need Help?
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.timeline {
    position: relative;
    padding: 20px 0;
}

.timeline-item {
    position: relative;
    padding-left: 40px;
    margin-bottom: 20px;
}

.timeline-item:before {
    content: '';
    position: absolute;
    left: 9px;
    top: 20px;
    height: calc(100% + 10px);
    width: 2px;
    background: #dee2e6;
}

.timeline-item:last-child:before {
    display: none;
}

.timeline-marker {
    position: absolute;
    left: 0;
    top: 0;
    width: 20px;
    height: 20px;
    border-radius: 50%;
    background: #fff;
    border: 3px solid #3b82f6;
}
</style>
@endsection