@extends('layouts.app')

@section('title', 'Weekly Fashion Trends - Edition By Punjab')

@section('content')
<div class="container-fluid px-0">
    <!-- Hero Section -->
    <section class="weekly-trends-hero py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4">This Week in Streetwear</h1>
                        <p class="lead mb-4">Discover the hottest trends dominating Australian streetwear culture this week</p>
                        <div class="hero-stats d-flex justify-content-center gap-5 mt-4">
                            <div class="stat-item">
                                <h3 class="fw-bold">{{ count($weeklyTrends) }}</h3>
                                <p class="mb-0">Trending Styles</p>
                            </div>
                            <div class="stat-item">
                                <h3 class="fw-bold">{{ date('W') }}</h3>
                                <p class="mb-0">Week of {{ date('Y') }}</p>
                            </div>
                            <div class="stat-item">
                                <h3 class="fw-bold">100%</h3>
                                <p class="mb-0">Fresh Content</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Weekly Trends Section -->
    <section class="weekly-trends-content py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="section-header text-center mb-5">
                        <h2 class="display-5 fw-bold text-dark">Weekly Trend Report</h2>
                        <p class="lead text-muted">Updated every Monday with the latest streetwear movements</p>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                @foreach($weeklyTrends as $index => $trend)
                <div class="col-12">
                    <div class="trend-item card border-0 shadow-sm overflow-hidden mb-4">
                        <div class="row g-0">
                            <div class="col-md-5">
                                <div class="trend-image position-relative">
                                    <img src="{{ asset('storage/' . $trend['image']) }}" 
                                         class="img-fluid h-100 w-100" 
                                         alt="{{ $trend['title'] }}"
                                         style="object-fit: cover; min-height: 300px;">
                                    
                                    <!-- Trend Level Badge -->
                                    <div class="trend-level-badge position-absolute top-0 start-0 m-3">
                                        @if($trend['trend_level'] === 'Rising Fast')
                                            <span class="badge bg-danger px-3 py-2 rounded-pill">
                                                <i class="fas fa-rocket me-1"></i>{{ $trend['trend_level'] }}
                                            </span>
                                        @elseif($trend['trend_level'] === 'Mainstream')
                                            <span class="badge bg-success px-3 py-2 rounded-pill">
                                                <i class="fas fa-star me-1"></i>{{ $trend['trend_level'] }}
                                            </span>
                                        @else
                                            <span class="badge bg-warning text-dark px-3 py-2 rounded-pill">
                                                <i class="fas fa-trending-up me-1"></i>{{ $trend['trend_level'] }}
                                            </span>
                                        @endif
                                    </div>

                                    <!-- Popularity Score -->
                                    <div class="popularity-score position-absolute top-0 end-0 m-3">
                                        <div class="score-circle bg-white text-dark d-flex align-items-center justify-content-center rounded-circle shadow" 
                                             style="width: 60px; height: 60px;">
                                            <div class="text-center">
                                                <div class="fw-bold">{{ $trend['popularity'] }}</div>
                                                <small style="font-size: 0.7rem;">Score</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-7">
                                <div class="card-body p-4 d-flex flex-column h-100">
                                    <!-- Trend Number -->
                                    <div class="trend-number mb-3">
                                        <span class="badge bg-primary px-3 py-2 rounded-pill">
                                            Trend #{{ $index + 1 }}
                                        </span>
                                    </div>

                                    <!-- Title and Description -->
                                    <h3 class="card-title fw-bold text-dark mb-3">{{ $trend['title'] }}</h3>
                                    <p class="card-text text-muted mb-4">{{ $trend['description'] }}</p>

                                    <!-- Key Pieces -->
                                    <div class="key-pieces mb-4 flex-grow-1">
                                        <h6 class="fw-bold text-dark mb-3">Key Pieces to Watch:</h6>
                                        <div class="row g-2">
                                            @foreach($trend['key_pieces'] as $piece)
                                            <div class="col-md-4 col-6">
                                                <span class="badge bg-light text-dark w-100 text-start p-2 border">
                                                    <i class="fas fa-tshirt me-2 text-primary"></i>{{ $piece }}
                                                </span>
                                            </div>
                                            @endforeach
                                        </div>
                                    </div>

                                    <!-- Popularity Progress Bar -->
                                    <div class="popularity-bar mb-3">
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <span class="fw-bold text-dark">Popularity Trend</span>
                                            <span class="text-muted">{{ $trend['popularity'] }}%</span>
                                        </div>
                                        <div class="progress" style="height: 8px;">
                                            <div class="progress-bar bg-primary" 
                                                 role="progressbar" 
                                                 style="width: {{ $trend['popularity'] }}%"
                                                 aria-valuenow="{{ $trend['popularity'] }}" 
                                                 aria-valuemin="0" 
                                                 aria-valuemax="100">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Action Buttons -->
                                    <div class="action-buttons">
                                        <a href="{{ route('shop.index') }}" 
                                           class="btn btn-primary me-3">
                                            <i class="fas fa-shopping-cart me-1"></i>Shop This Trend
                                        </a>
                                        <a href="{{ route('style-guide.index') }}" class="btn btn-outline-primary">
                                            <i class="fas fa-map-marked-alt me-1"></i>Style Guide
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>

    <!-- Trend Analysis Section -->
    <section class="trend-analysis py-5">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h3 class="text-center mb-5 fw-bold">Weekly Trend Analysis</h3>
                </div>
            </div>
            <div class="row g-4">
                <div class="col-lg-3 col-md-6">
                    <div class="analysis-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-chart-line fa-3x text-success"></i>
                        </div>
                        <h5 class="fw-bold">Rising Trends</h5>
                        <p class="text-muted mb-0">{{ collect($weeklyTrends)->where('trend_level', 'Rising Fast')->count() }} trends gaining momentum</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="analysis-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-crown fa-3x text-warning"></i>
                        </div>
                        <h5 class="fw-bold">Mainstream</h5>
                        <p class="text-muted mb-0">{{ collect($weeklyTrends)->where('trend_level', 'Mainstream')->count() }} established trends</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="analysis-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-trending-up fa-3x text-primary"></i>
                        </div>
                        <h5 class="fw-bold">Average Score</h5>
                        <p class="text-muted mb-0">{{ round(collect($weeklyTrends)->avg('popularity')) }}% popularity rating</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="analysis-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-calendar-week fa-3x text-info"></i>
                        </div>
                        <h5 class="fw-bold">This Week</h5>
                        <p class="text-muted mb-0">{{ date('F j, Y') }} update</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Navigation Section -->
    <section class="trends-navigation py-5 bg-dark text-white">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <h3 class="mb-5 fw-bold">Explore More Trends</h3>
                </div>
            </div>
            <div class="row g-4 text-center">
                <div class="col-lg-4 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-calendar-alt fa-3x mb-3 text-info"></i>
                        <h5 class="fw-bold">Seasonal Forecast</h5>
                        <p class="text-muted">Upcoming seasonal trends</p>
                        <a href="{{ route('trends.seasonal') }}" class="btn btn-outline-info">View Forecast</a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-newspaper fa-3x mb-3 text-success"></i>
                        <h5 class="fw-bold">Fashion News</h5>
                        <p class="text-muted">Latest industry updates</p>
                        <a href="{{ route('trends.news') }}" class="btn btn-outline-success">Read News</a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-crystal-ball fa-3x mb-3 text-danger"></i>
                        <h5 class="fw-bold">Style Predictions</h5>
                        <p class="text-muted">Future fashion forecasts</p>
                        <a href="{{ route('trends.predictions') }}" class="btn btn-outline-danger">See Predictions</a>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-12 text-center">
                    <a href="{{ route('trends.index') }}" class="btn btn-outline-light btn-lg px-5 rounded-pill">
                        <i class="fas fa-arrow-left me-2"></i> Back to Trends Overview
                    </a>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
.trend-item {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.trend-item:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.1) !important;
}

.analysis-card {
    transition: transform 0.3s ease, border-color 0.3s ease;
}

.analysis-card:hover {
    transform: translateY(-3px);
    border-color: #3b82f6 !important;
}

.nav-item {
    transition: transform 0.3s ease, border-color 0.3s ease;
}

.nav-item:hover {
    transform: translateY(-5px);
    border-color: #fff !important;
}

.progress-bar {
    animation: progressAnimation 2s ease-in-out;
}

@keyframes progressAnimation {
    0% { width: 0; }
    100% { width: var(--progress-width); }
}

.score-circle {
    animation: bounceIn 1s ease-in-out;
}

@keyframes bounceIn {
    0% { transform: scale(0); }
    50% { transform: scale(1.1); }
    100% { transform: scale(1); }
}

.trend-level-badge .badge {
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
}

.weekly-trends-hero {
    position: relative;
    overflow: hidden;
}

.weekly-trends-hero::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.1);
    z-index: 1;
}

.weekly-trends-hero .container {
    position: relative;
    z-index: 2;
}
</style>
@endsection