<?php $__env->startSection('title', 'Trends Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3">Trends Management Dashboard</h1>
        <div>
            <a href="<?php echo e(route('trends.index')); ?>" class="btn btn-info" target="_blank">
                <i class="fas fa-eye me-2"></i>View Live Site
            </a>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card border-start border-primary border-4 py-2">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-primary text-uppercase mb-1">Weekly Trends</div>
                            <div class="h5"><?php echo e($stats['weekly_trends']); ?></div>
                        </div>
                        <div class="fa-2x text-gray-300">
                            <i class="fas fa-chart-trending-up text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-start border-success border-4 py-2">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-success text-uppercase mb-1">Seasonal Forecasts</div>
                            <div class="h5"><?php echo e($stats['seasonal_forecasts']); ?></div>
                        </div>
                        <div class="fa-2x text-gray-300">
                            <i class="fas fa-calendar-alt text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-start border-info border-4 py-2">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-info text-uppercase mb-1">Fashion News</div>
                            <div class="h5"><?php echo e($stats['fashion_news']); ?></div>
                        </div>
                        <div class="fa-2x text-gray-300">
                            <i class="fas fa-newspaper text-info"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-start border-warning border-4 py-2">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-warning text-uppercase mb-1">Predictions</div>
                            <div class="h5"><?php echo e($stats['predictions']); ?></div>
                        </div>
                        <div class="fa-2x text-gray-300">
                            <i class="fas fa-crystal-ball text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <a href="<?php echo e(route('admin.trends.create-weekly')); ?>" class="btn btn-primary w-100">
                                <i class="fas fa-plus me-2"></i>Add Weekly Trend
                            </a>
                        </div>
                        <div class="col-md-3 mb-3">
                            <a href="<?php echo e(route('admin.trends.create-news')); ?>" class="btn btn-success w-100">
                                <i class="fas fa-plus me-2"></i>Add News Article
                            </a>
                        </div>
                        <div class="col-md-3 mb-3">
                            <a href="<?php echo e(route('admin.trends.create-seasonal')); ?>" class="btn btn-info w-100">
                                <i class="fas fa-plus me-2"></i>Add Seasonal Forecast
                            </a>
                        </div>
                        <div class="col-md-3 mb-3">
                            <a href="<?php echo e(route('admin.trends.create-predictions')); ?>" class="btn btn-warning w-100">
                                <i class="fas fa-plus me-2"></i>Add Prediction
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Content Sections -->
    <div class="row">
        <!-- Weekly Trends -->
        <div class="col-lg-6 mb-4">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Recent Weekly Trends</h5>
                    <a href="<?php echo e(route('admin.trends.weekly')); ?>" class="btn btn-sm btn-primary">
                        <i class="fas fa-cog me-1"></i>Manage
                    </a>
                </div>
                <div class="card-body">
                    <?php $__currentLoopData = $weeklyTrends; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $trend): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="d-flex align-items-center mb-3 <?php echo e($index < count($weeklyTrends) - 1 ? 'border-bottom pb-3' : ''); ?>">
                        <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($trend['image'])); ?>" 
                             class="rounded me-3" 
                             style="width: 60px; height: 60px; object-fit: cover;" 
                             alt="<?php echo e($trend['title']); ?>">
                        <div class="flex-grow-1">
                            <h6 class="mb-1"><?php echo e(Str::limit($trend['title'], 50)); ?></h6>
                            <div class="d-flex align-items-center gap-2">
                                <span class="badge 
                                    <?php if($trend['trend_level'] === 'Rising Fast'): ?> bg-danger
                                    <?php elseif($trend['trend_level'] === 'Mainstream'): ?> bg-success
                                    <?php else: ?> bg-warning text-dark
                                    <?php endif; ?>
                                "><?php echo e($trend['trend_level']); ?></span>
                                <small class="text-muted"><?php echo e($trend['popularity']); ?>% popularity</small>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <!-- Recent News -->
        <div class="col-lg-6 mb-4">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Recent Fashion News</h5>
                    <a href="<?php echo e(route('admin.trends.news')); ?>" class="btn btn-sm btn-success">
                        <i class="fas fa-cog me-1"></i>Manage
                    </a>
                </div>
                <div class="card-body">
                    <?php $__currentLoopData = array_slice($fashionNews, 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="d-flex align-items-center mb-3 <?php echo e($index < 2 ? 'border-bottom pb-3' : ''); ?>">
                        <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($article['image'])); ?>" 
                             class="rounded me-3" 
                             style="width: 60px; height: 60px; object-fit: cover;" 
                             alt="<?php echo e($article['title']); ?>">
                        <div class="flex-grow-1">
                            <h6 class="mb-1"><?php echo e(Str::limit($article['title'], 50)); ?></h6>
                            <div class="d-flex align-items-center gap-2">
                                <span class="badge 
                                    <?php if($article['category'] === 'Brand News'): ?> bg-primary
                                    <?php elseif($article['category'] === 'Industry News'): ?> bg-success  
                                    <?php else: ?> bg-warning text-dark
                                    <?php endif; ?>
                                "><?php echo e($article['category']); ?></span>
                                <small class="text-muted"><?php echo e($article['read_time']); ?> min read</small>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Additional Content Row -->
    <div class="row">
        <!-- Seasonal Forecasts -->
        <div class="col-lg-6 mb-4">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Seasonal Forecasts</h5>
                    <a href="<?php echo e(route('admin.trends.seasonal')); ?>" class="btn btn-sm btn-info">
                        <i class="fas fa-cog me-1"></i>Manage
                    </a>
                </div>
                <div class="card-body">
                    <?php $__currentLoopData = $seasonalForecasts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $forecast): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="mb-3 <?php echo e(!$loop->last ? 'border-bottom pb-3' : ''); ?>">
                        <h6 class="mb-1"><?php echo e($forecast['title']); ?></h6>
                        <p class="text-muted small mb-2"><?php echo e(Str::limit($forecast['description'], 100)); ?></p>
                        <div class="d-flex gap-2">
                            <span class="badge bg-info"><?php echo e($forecast['season']); ?></span>
                            <small class="text-muted"><?php echo e(count($forecast['key_trends'])); ?> trends</small>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <!-- Predictions -->
        <div class="col-lg-6 mb-4">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Style Predictions</h5>
                    <a href="<?php echo e(route('admin.trends.predictions')); ?>" class="btn btn-sm btn-warning">
                        <i class="fas fa-cog me-1"></i>Manage
                    </a>
                </div>
                <div class="card-body">
                    <?php $__currentLoopData = $predictions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prediction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="mb-3 <?php echo e(!$loop->last ? 'border-bottom pb-3' : ''); ?>">
                        <div class="d-flex justify-content-between align-items-start mb-1">
                            <h6 class="mb-1"><?php echo e($prediction['title']); ?></h6>
                            <span class="badge 
                                <?php if($prediction['confidence'] >= 90): ?> bg-success
                                <?php elseif($prediction['confidence'] >= 80): ?> bg-warning text-dark
                                <?php else: ?> bg-secondary
                                <?php endif; ?>
                            "><?php echo e($prediction['confidence']); ?>%</span>
                        </div>
                        <p class="text-muted small mb-2"><?php echo e(Str::limit($prediction['description'], 80)); ?></p>
                        <small class="text-muted">Timeline: <?php echo e($prediction['timeline']); ?></small>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio7\resources\views/admin/trends/index.blade.php ENDPATH**/ ?>