

<?php $__env->startSection('title', 'Categories'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Categories</h1>
    <a href="<?php echo e(route('admin.categories.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Add New Category
    </a>
</div>

<?php if(session('success')): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <?php echo e(session('success')); ?>

    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if(session('error')): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <?php echo e(session('error')); ?>

    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Image</th>
                        <th>Name</th>
                        <th>Slug</th>
                        <th>Products</th>
                        <th>Sort Order</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($category->id); ?></td>
                        <td>
                            <?php if($category->image): ?>
                            <img src="<?php echo e(asset('storage/' . $category->image)); ?>" 
                                 alt="<?php echo e($category->name); ?>" 
                                 width="50" height="50" 
                                 class="rounded"
                                 onerror="this.src='<?php echo e(asset('images/placeholder-category.jpg')); ?>'">
                            <?php else: ?>
                            <span class="text-muted">No image</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <strong><?php echo e($category->name); ?></strong>
                            <?php if($category->parent): ?>
                            <br>
                            <small class="text-muted">Parent: <?php echo e($category->parent->name); ?></small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <code><?php echo e($category->slug); ?></code>
                        </td>
                        <td>
                            <span class="badge bg-info"><?php echo e($category->products_count); ?></span>
                        </td>
                        <td><?php echo e($category->sort_order ?? '-'); ?></td>
                        <td>
                            <form action="<?php echo e(route('admin.categories.toggle-active', $category)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-sm btn-<?php echo e($category->is_active ? 'success' : 'secondary'); ?>">
                                    <?php echo e($category->is_active ? 'Active' : 'Inactive'); ?>

                                </button>
                            </form>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="<?php echo e(route('admin.categories.show', $category)); ?>" 
                                   class="btn btn-sm btn-info" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('admin.categories.edit', $category)); ?>" 
                                   class="btn btn-sm btn-warning" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <?php if($category->products_count == 0): ?>
                                <form action="<?php echo e(route('admin.categories.destroy', $category)); ?>" 
                                      method="POST" class="d-inline" 
                                      onsubmit="return confirm('Are you sure you want to delete this category?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                                <?php else: ?>
                                <button class="btn btn-sm btn-danger" disabled title="Cannot delete category with products">
                                    <i class="fas fa-trash"></i>
                                </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <p class="mb-0">No categories found</p>
                            <a href="<?php echo e(route('admin.categories.create')); ?>" class="btn btn-primary mt-2">
                                <i class="fas fa-plus me-2"></i>Create First Category
                            </a>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Pagination Links - Fixed version -->
        <?php if($categories instanceof \Illuminate\Pagination\LengthAwarePaginator && $categories->total() > $categories->perPage()): ?>
        <div class="d-flex justify-content-center mt-4">
            <?php echo e($categories->links('pagination::bootstrap-5')); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/admin/categories/index.blade.php ENDPATH**/ ?>