<?php $__env->startSection('title', 'Lookbook - Style Inspiration'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="Explore Edition By Punjab's lookbook featuring street culture, Punjabi fusion, sustainable style, and Australian streetwear collections.">
<meta name="keywords" content="streetwear lookbook, fashion inspiration, style guide, cultural fashion, sustainable streetwear, australian streetwear">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if (isset($component)) { $__componentOriginal269900abaed345884ce342681cdc99f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal269900abaed345884ce342681cdc99f6 = $attributes; } ?>
<?php $component = App\View\Components\Breadcrumb::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $attributes = $__attributesOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__attributesOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $component = $__componentOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__componentOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>

<!-- Hero Section -->
<section class="lookbook-hero py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h1 class="display-4 text-white fw-bold mb-4">Style Inspiration</h1>
                <p class="lead text-white mb-4">Discover how to style our pieces with our curated lookbook collections. From street culture to cultural fusion, find your perfect style inspiration.</p>
            </div>
            <div class="col-lg-6">
                <div class="hero-image text-center">
                    <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => 'lookbooks/hero-collage.jpg','alt' => 'Edition By Punjab Lookbook Collections','class' => 'img-fluid rounded shadow-lg'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Lookbook Collections -->
<section class="lookbook-collections py-5">
    <div class="container">
        <div class="row">
            <?php $__currentLoopData = $lookbooks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lookbook): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 mb-5">
                    <div class="lookbook-card h-100 border-0 shadow-sm overflow-hidden">
                        <div class="position-relative">
                            <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => ''.e($lookbook['image']).'','alt' => ''.e($lookbook['title']).'','class' => 'card-img-top lookbook-image','style' => 'height: 400px; object-fit: cover;'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                            <div class="lookbook-overlay d-flex align-items-end p-4">
                                <div class="text-white">
                                    <h3 class="mb-2"><?php echo e($lookbook['title']); ?></h3>
                                    <p class="mb-3"><?php echo e($lookbook['description']); ?></p>
                                    <a href="<?php echo e(route('lookbook.show', $lookbook['slug'])); ?>" class="btn btn-light">
                                        Explore Collection <i class="fas fa-arrow-right ms-2"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Featured Products Preview -->
                        <div class="card-body">
                            <h5 class="card-title mb-3">Featured Pieces</h5>
                            <div class="row g-2">
                                <?php $__currentLoopData = $lookbook['products']->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-4">
                                        <div class="product-preview">
                                            <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => $product->featured_image ?? 'placeholder-product.jpg','alt' => $product->name,'class' => 'img-fluid rounded','style' => 'height: 80px; object-fit: cover;'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                                            <small class="text-muted d-block mt-1"><?php echo e(Str::limit($product->name, 15)); ?></small>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="lookbook-cta py-5 bg-light">
    <div class="container text-center">
        <h2 class="mb-4">Ready to Create Your Look?</h2>
        <p class="lead mb-4">Shop our collections and create your own unique style story</p>
        <a href="<?php echo e(route('shop.index')); ?>" class="btn btn-primary btn-lg me-3">
            Shop Now <i class="fas fa-shopping-bag ms-2"></i>
        </a>
        <a href="<?php echo e(route('community.index')); ?>" class="btn btn-outline-primary btn-lg">
            Share Your Style <i class="fas fa-camera ms-2"></i>
        </a>
    </div>
</section>

<?php $__env->startPush('styles'); ?>
<style>
    .lookbook-hero {
        min-height: 500px;
        display: flex;
        align-items: center;
    }
    
    .lookbook-card {
        transition: transform 0.3s ease;
        border-radius: 1rem;
        overflow: hidden;
    }
    
    .lookbook-card:hover {
        transform: translateY(-5px);
    }
    
    .lookbook-image {
        transition: transform 0.5s ease;
    }
    
    .lookbook-card:hover .lookbook-image {
        transform: scale(1.05);
    }
    
    .lookbook-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(transparent, rgba(0,0,0,0.8));
        opacity: 0;
        transition: opacity 0.3s ease;
    }
    
    .lookbook-card:hover .lookbook-overlay {
        opacity: 1;
    }
    
    .product-preview {
        transition: transform 0.2s ease;
    }
    
    .product-preview:hover {
        transform: scale(1.05);
    }
</style>
<?php $__env->stopPush(); ?>

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "CollectionPage",
    "name": "Edition By Punjab Lookbook",
    "description": "Style inspiration and lookbook collections featuring streetwear, cultural fusion, and sustainable fashion",
    "url": "<?php echo e(route('lookbook.index')); ?>",
    "mainEntity": {
        "@type": "ItemList",
        "itemListElement": [
            <?php $__currentLoopData = $lookbooks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $lookbook): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            {
                "@type": "CreativeWork",
                "position": <?php echo e($index + 1); ?>,
                "name": "<?php echo e($lookbook['title']); ?>",
                "description": "<?php echo e($lookbook['description']); ?>",
                "url": "<?php echo e(route('lookbook.show', $lookbook['slug'])); ?>"
            }<?php echo e(!$loop->last ? ',' : ''); ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ]
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/lookbook/index.blade.php ENDPATH**/ ?>