<?php $__env->startSection('title', $blog->meta_title); ?>
<?php $__env->startSection('meta_description', $blog->meta_description); ?>
<?php $__env->startSection('meta_keywords', $blog->meta_keywords); ?>

<?php $__env->startPush('styles'); ?>
<link rel="canonical" href="<?php echo e(route('blogs.show', $blog->slug)); ?>">

<!-- Open Graph Meta Tags -->
<meta property="og:title" content="<?php echo e($blog->meta_title); ?>">
<meta property="og:description" content="<?php echo e($blog->meta_description); ?>">
<meta property="og:image" content="<?php echo e($blog->featured_image ? asset('storage/' . $blog->featured_image) : asset('images/editionbypunjab.png')); ?>">
<meta property="og:url" content="<?php echo e(route('blogs.show', $blog->slug)); ?>">
<meta property="og:type" content="article">
<meta property="article:published_time" content="<?php echo e($blog->published_at->toISOString()); ?>">
<meta property="article:author" content="<?php echo e($blog->author); ?>">
<?php if($blog->tags): ?>
    <?php $__currentLoopData = $blog->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <meta property="article:tag" content="<?php echo e($tag); ?>">
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?php echo e($blog->meta_title); ?>">
<meta name="twitter:description" content="<?php echo e($blog->meta_description); ?>">
<meta name="twitter:image" content="<?php echo e($blog->featured_image ? asset('storage/' . $blog->featured_image) : asset('images/editionbypunjab.png')); ?>">

<!-- JSON-LD Schema -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "BlogPosting",
    "headline": "<?php echo e($blog->title); ?>",
    "description": "<?php echo e($blog->meta_description); ?>",
    "image": "<?php echo e($blog->featured_image ? asset('storage/' . $blog->featured_image) : asset('images/editionbypunjab.png')); ?>",
    "author": {
        "@type": "Organization",
        "name": "<?php echo e($blog->author); ?>",
        "url": "<?php echo e(route('home')); ?>"
    },
    "publisher": {
        "@type": "Organization",
        "name": "<?php echo e(optional($companyInfo)->company_name ?? 'Edition By Punjab'); ?>",
        "logo": {
            "@type": "ImageObject",
            "url": "<?php echo e(asset('images/editionbypunjab.png')); ?>"
        }
    },
    "datePublished": "<?php echo e($blog->published_at->toISOString()); ?>",
    "dateModified": "<?php echo e($blog->updated_at->toISOString()); ?>",
    "mainEntityOfPage": {
        "@type": "WebPage",
        "@id": "<?php echo e(route('blogs.show', $blog->slug)); ?>"
    },
    "wordCount": "<?php echo e(str_word_count(strip_tags($blog->content))); ?>",
    "keywords": [
        <?php if($blog->tags): ?>
            <?php $__currentLoopData = $blog->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                "<?php echo e($tag); ?>"<?php echo e(!$loop->last ? ',' : ''); ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    ]
}
</script>

<style>
    .blog-header {
        background: linear-gradient(135deg, var(--bg-dark) 0%, var(--secondary-color) 100%);
        color: white;
        padding: 3rem 0;
        position: relative;
    }
    
    .blog-content {
        line-height: 1.8;
        font-size: 1.1rem;
    }
    
    .blog-content h1, .blog-content h2, .blog-content h3, 
    .blog-content h4, .blog-content h5, .blog-content h6 {
        color: var(--text-primary);
        font-weight: 700;
        margin: 2rem 0 1rem;
        line-height: 1.3;
    }
    
    .blog-content h2 {
        font-size: 1.8rem;
        border-left: 4px solid var(--accent-color);
        padding-left: 1rem;
    }
    
    .blog-content h3 {
        font-size: 1.4rem;
        color: var(--text-secondary);
    }
    
    .blog-content p {
        margin-bottom: 1.5rem;
        text-align: justify;
    }
    
    .blog-content blockquote {
        background: var(--bg-secondary);
        border-left: 4px solid var(--accent-color);
        padding: 1.5rem;
        margin: 2rem 0;
        font-style: italic;
        font-size: 1.2rem;
    }
    
    .blog-content ul, .blog-content ol {
        margin: 1.5rem 0;
        padding-left: 2rem;
    }
    
    .blog-content li {
        margin-bottom: 0.5rem;
    }
    
    .blog-content a {
        color: var(--accent-color);
        text-decoration: underline;
        transition: var(--transition-fast);
    }
    
    .blog-content a:hover {
        color: var(--text-primary);
    }
    
    .blog-meta {
        background: var(--bg-secondary);
        padding: 1.5rem;
        border-radius: 12px;
        margin: 2rem 0;
    }
    
    .blog-meta .meta-item {
        display: flex;
        align-items: center;
        margin-bottom: 0.5rem;
        color: var(--text-secondary);
    }
    
    .blog-meta .meta-item:last-child {
        margin-bottom: 0;
    }
    
    .blog-meta i {
        width: 20px;
        color: var(--accent-color);
        margin-right: 0.5rem;
    }
    
    .tag-list {
        margin: 2rem 0;
    }
    
    .tag-list .badge {
        margin: 0.25rem;
        padding: 0.5rem 1rem;
        background: var(--text-primary);
        color: white;
        text-decoration: none;
        border-radius: 20px;
        font-weight: 500;
        transition: var(--transition-fast);
    }
    
    .tag-list .badge:hover {
        background: var(--accent-color);
        transform: translateY(-2px);
    }
    
    .social-share {
        background: var(--bg-secondary);
        padding: 1.5rem;
        border-radius: 12px;
        text-align: center;
        margin: 2rem 0;
    }
    
    .social-share h5 {
        margin-bottom: 1rem;
        color: var(--text-primary);
    }
    
    .social-share .btn {
        margin: 0.25rem;
        border-radius: 50px;
        padding: 0.5rem 1.5rem;
    }
    
    .related-posts .card {
        transition: var(--transition-base);
        border: none;
        border-radius: 12px;
        overflow: hidden;
    }
    
    .related-posts .card:hover {
        transform: translateY(-5px);
        box-shadow: var(--shadow-lg);
    }
    
    .related-posts .card-img-top {
        height: 150px;
        object-fit: cover;
    }
    
    .breadcrumb {
        background: transparent;
        padding: 1rem 0;
    }
    
    .breadcrumb-item a {
        color: var(--text-secondary);
        text-decoration: none;
    }
    
    .breadcrumb-item a:hover {
        color: var(--text-primary);
    }
    
    .breadcrumb-item.active {
        color: var(--text-primary);
    }
    
    .table-of-contents {
        background: var(--bg-secondary);
        padding: 1.5rem;
        border-radius: 12px;
        margin: 2rem 0;
        position: sticky;
        top: 100px;
    }
    
    .table-of-contents h5 {
        color: var(--text-primary);
        margin-bottom: 1rem;
        font-weight: 700;
    }
    
    .table-of-contents ul {
        list-style: none;
        padding: 0;
    }
    
    .table-of-contents li {
        margin: 0.5rem 0;
    }
    
    .table-of-contents a {
        color: var(--text-secondary);
        text-decoration: none;
        transition: var(--transition-fast);
        display: block;
        padding: 0.25rem 0;
    }
    
    .table-of-contents a:hover {
        color: var(--text-primary);
        padding-left: 0.5rem;
    }
    
    @media (max-width: 768px) {
        .blog-content {
            font-size: 1rem;
        }
        
        .blog-header {
            padding: 2rem 0;
        }
        
        .table-of-contents {
            position: static;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav aria-label="breadcrumb" class="bg-light">
    <div class="container">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('blogs.index')); ?>">Blog</a></li>
            <li class="breadcrumb-item active" aria-current="page"><?php echo e($blog->title); ?></li>
        </ol>
    </div>
</nav>

<!-- Blog Header -->
<section class="blog-header">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h1 class="display-5 fw-bold mb-4" data-aos="fade-up"><?php echo e($blog->title); ?></h1>
                
                <div class="blog-meta">
                    <div class="row g-3 text-center">
                        <div class="col-md-3">
                            <div class="meta-item">
                                <i class="fas fa-calendar"></i>
                                <span><?php echo e($blog->readable_published_date); ?></span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="meta-item">
                                <i class="fas fa-user"></i>
                                <span><?php echo e($blog->author); ?></span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="meta-item">
                                <i class="fas fa-clock"></i>
                                <span><?php echo e($blog->estimated_read_time); ?> min read</span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="meta-item">
                                <i class="fas fa-eye"></i>
                                <span><?php echo e(number_format($blog->views)); ?> views</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Main Content -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <article class="blog-post">
                    <!-- Featured Image -->
                    <?php if($blog->featured_image): ?>
                        <div class="text-center mb-4" data-aos="fade-up">
                            <img src="<?php echo e(asset('storage/' . $blog->featured_image)); ?>" 
                                 alt="<?php echo e($blog->title); ?>" 
                                 class="img-fluid rounded shadow-lg">
                        </div>
                    <?php endif; ?>
                    
                    <!-- Blog Content -->
                    <div class="blog-content" data-aos="fade-up" data-aos-delay="100">
                        <?php echo $blog->content; ?>

                    </div>
                    
                    <!-- Tags -->
                    <?php if($blog->tags): ?>
                        <div class="tag-list" data-aos="fade-up">
                            <h5 class="mb-3">Related Topics:</h5>
                            <?php $__currentLoopData = $blog->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('blogs.index', ['tag' => $tag])); ?>" class="badge"><?php echo e($tag); ?></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Social Share -->
                    <div class="social-share" data-aos="fade-up">
                        <h5>Share this article</h5>
                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(route('blogs.show', $blog->slug))); ?>" 
                           target="_blank" class="btn btn-primary">
                            <i class="fab fa-facebook-f me-1"></i>Facebook
                        </a>
                        <a href="https://twitter.com/intent/tweet?url=<?php echo e(urlencode(route('blogs.show', $blog->slug))); ?>&text=<?php echo e(urlencode($blog->title)); ?>" 
                           target="_blank" class="btn btn-info">
                            <i class="fab fa-twitter me-1"></i>Twitter
                        </a>
                        <a href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo e(urlencode(route('blogs.show', $blog->slug))); ?>" 
                           target="_blank" class="btn btn-primary">
                            <i class="fab fa-linkedin-in me-1"></i>LinkedIn
                        </a>
                        <button onclick="copyToClipboard('<?php echo e(route('blogs.show', $blog->slug)); ?>')" class="btn btn-secondary">
                            <i class="fas fa-link me-1"></i>Copy Link
                        </button>
                    </div>
                </article>
            </div>
            
            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Recent Posts -->
                <?php if($recentBlogs->count() > 0): ?>
                <div class="table-of-contents" data-aos="fade-up">
                    <h5><i class="fas fa-clock me-2"></i>Recent Articles</h5>
                    <ul>
                        <?php $__currentLoopData = $recentBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <a href="<?php echo e(route('blogs.show', $recent->slug)); ?>"><?php echo e($recent->title); ?></a>
                            <small class="text-muted d-block"><?php echo e($recent->readable_published_date); ?></small>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>
                
                <!-- Popular Tags -->
                <?php if(count($popularTags) > 0): ?>
                <div class="table-of-contents" data-aos="fade-up" data-aos-delay="100">
                    <h5><i class="fas fa-tags me-2"></i>Popular Topics</h5>
                    <div class="tag-cloud">
                        <?php $__currentLoopData = $popularTags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('blogs.index', ['tag' => $tag])); ?>" class="badge bg-light text-dark text-decoration-none me-1 mb-1">
                                <?php echo e($tag); ?> (<?php echo e($count); ?>)
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <!-- Newsletter -->
                <div class="table-of-contents" data-aos="fade-up" data-aos-delay="200">
                    <h5><i class="fas fa-envelope me-2"></i>Stay Updated</h5>
                    <p class="small text-muted">Get the latest export insights delivered to your inbox.</p>
                    <form action="<?php echo e(route('newsletter.subscribe')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <input type="email" class="form-control" name="email" placeholder="Your email address" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Subscribe</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Related Posts -->
<?php if($relatedBlogs->count() > 0): ?>
<section class="py-5 bg-light related-posts">
    <div class="container">
        <h2 class="text-center mb-5" data-aos="fade-up">Related Articles</h2>
        <div class="row g-4">
            <?php $__currentLoopData = $relatedBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4" data-aos="fade-up" data-aos-delay="<?php echo e($loop->index * 100); ?>">
                <div class="card h-100">
                    <?php if($related->featured_image): ?>
                        <img src="<?php echo e(asset('storage/' . $related->featured_image)); ?>" class="card-img-top" alt="<?php echo e($related->title); ?>">
                    <?php endif; ?>
                    <div class="card-body d-flex flex-column">
                        <small class="text-muted mb-2"><?php echo e($related->readable_published_date); ?></small>
                        <h5 class="card-title">
                            <a href="<?php echo e(route('blogs.show', $related->slug)); ?>" class="text-decoration-none text-dark">
                                <?php echo e($related->title); ?>

                            </a>
                        </h5>
                        <p class="card-text text-muted flex-grow-1"><?php echo e($related->excerpt); ?></p>
                        <div class="d-flex justify-content-between align-items-center">
                            <small class="text-muted"><?php echo e($related->estimated_read_time); ?> min read</small>
                            <a href="<?php echo e(route('blogs.show', $related->slug)); ?>" class="btn btn-outline-primary btn-sm">
                                Read More
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    function copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(function() {
            toastr.success('Link copied to clipboard!');
        }, function(err) {
            console.error('Could not copy text: ', err);
            toastr.error('Failed to copy link');
        });
    }
    
    // Generate table of contents dynamically if needed
    document.addEventListener('DOMContentLoaded', function() {
        const content = document.querySelector('.blog-content');
        const headings = content.querySelectorAll('h2, h3');
        
        if (headings.length > 2) {
            let tocHtml = '<div class="table-of-contents" data-aos="fade-up"><h5><i class="fas fa-list me-2"></i>Table of Contents</h5><ul>';
            
            headings.forEach(function(heading, index) {
                const id = 'heading-' + index;
                heading.id = id;
                const level = heading.tagName === 'H2' ? '' : 'ms-3';
                tocHtml += `<li class="${level}"><a href="#${id}">${heading.textContent}</a></li>`;
            });
            
            tocHtml += '</ul></div>';
            
            const sidebar = document.querySelector('.col-lg-4');
            if (sidebar) {
                sidebar.insertAdjacentHTML('afterbegin', tocHtml);
            }
        }
        
        // Smooth scroll for TOC links
        document.querySelectorAll('.table-of-contents a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });
        
        // Newsletter subscription handling for blog sidebar
        const blogNewsletterForm = document.querySelector('.table-of-contents form[action*="newsletter.subscribe"]');
        if (blogNewsletterForm) {
            blogNewsletterForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                const emailInput = this.querySelector('input[name="email"]');
                const submitBtn = this.querySelector('button[type="submit"]');
                const email = emailInput.value.trim();
                
                if (!email) {
                    if (window.toastr) {
                        toastr.error('Please enter a valid email address');
                    } else {
                        alert('Please enter a valid email address');
                    }
                    return;
                }
                
                // Show loading state
                const originalBtnContent = submitBtn.innerHTML;
                submitBtn.disabled = true;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
                
                fetch('<?php echo e(route("newsletter.subscribe")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify({ email: email })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        if (window.toastr) {
                            toastr.success(data.message);
                            if (data.discount_code) {
                                setTimeout(() => {
                                    toastr.info('Your discount code: ' + data.discount_code);
                                }, 1000);
                            }
                        } else {
                            alert(data.message + (data.discount_code ? '\nYour discount code: ' + data.discount_code : ''));
                        }
                        emailInput.value = '';
                        
                        // Set cookie to remember subscription
                        document.cookie = 'newsletter_subscribed=true; path=/; max-age=' + (365 * 24 * 60 * 60);
                    } else {
                        const errorMsg = data.message || 'Subscription failed. Please try again.';
                        if (window.toastr) {
                            toastr.error(errorMsg);
                        } else {
                            alert(errorMsg);
                        }
                    }
                })
                .catch(error => {
                    console.error('Newsletter subscription error:', error);
                    const errorMsg = 'An error occurred. Please try again.';
                    if (window.toastr) {
                        toastr.error(errorMsg);
                    } else {
                        alert(errorMsg);
                    }
                })
                .finally(() => {
                    // Reset button state
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalBtnContent;
                });
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/blogs/show.blade.php ENDPATH**/ ?>