

<?php $__env->startSection('title', 'Edition By Punjab - Premium Fashion & Lifestyle'); ?>

<?php $__env->startSection('content'); ?>

<?php
    $activeCampaign = $activeCampaign ?? null;
    if (!$activeCampaign && ($activeSale ?? false)) {
        $activeCampaign = (object) [
            'name' => 'FLASH SALE - UP TO 40% OFF',
            'discount_percentage' => 40,
            'ends_at' => $saleEndDate ?? '2025-01-31 23:59:59'
        ];
    }
    if ($activeCampaign && isset($activeCampaign->ends_at) && $activeCampaign->ends_at instanceof \DateTimeInterface) {
        $activeCampaign->ends_at = $activeCampaign->ends_at->format('Y-m-d H:i:s');
    }
?>

<!-- Premium Newsletter Modal -->
<div class="modal fade" id="newsletterModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <div class="modal-content border-0 overflow-hidden">
            <button type="button" class="btn-close-premium position-absolute" data-bs-dismiss="modal" aria-label="Close">
                <span></span>
                <span></span>
            </button>
            <div class="row g-0">
                <div class="col-lg-6 newsletter-image-premium">
                    <div class="newsletter-content-overlay">
                        <div class="newsletter-brand-showcase">
                            <h1 class="brand-title">EDITION</h1>
                            <div class="brand-subtitle">BY PUNJAB</div>
                            <div class="brand-tagline">STREETWEAR REIMAGINED</div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 bg-white p-5 d-flex align-items-center">
                    <div class="newsletter-form-content w-100">
                        <h2 class="newsletter-title mb-3">UNLOCK 10% OFF</h2>
                        <p class="newsletter-subtitle mb-4">Join the Edition family for exclusive drops & early access</p>
                        
                        <form id="newsletterForm" class="premium-form">
                            <?php echo csrf_field(); ?>
                            <div class="form-floating mb-3">
                                <input type="email" class="form-control premium-input" id="newsletter_email" name="email" placeholder="Enter your email" required>
                                <label for="newsletter_email">Email Address</label>
                            </div>
                            <button type="submit" class="btn btn-dark btn-lg w-100 premium-submit">
                                <span class="btn-text">CLAIM YOUR DISCOUNT</span>
                                <span class="btn-loader d-none">
                                    <span class="spinner-border spinner-border-sm"></span>
                                </span>
                            </button>
                        </form>
                        
                        <button type="button" class="btn btn-link text-muted mt-3 p-0 skip-btn" data-bs-dismiss="modal">
                            Maybe later
                        </button>
                        
                        <div class="alert alert-success premium-alert d-none mt-3" id="newsletterSuccess">
                            <span id="successMessage"></span>
                        </div>
                        
                        <div class="alert alert-danger premium-alert d-none mt-3" id="newsletterError">
                            <span id="errorMessage"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Premium Campaign Banner -->
<?php if($activeCampaign): ?>
<section class="campaign-banner-premium">
    <div class="container">
        <div class="campaign-content">
            <div class="campaign-text">
                <span class="campaign-label">LIMITED TIME</span>
                <h3 class="campaign-title"><?php echo e($activeCampaign->name); ?></h3>
            </div>
            
            <div class="countdown-premium" data-end-time="<?php echo e($activeCampaign->ends_at); ?>">
                <div class="countdown-block">
                    <div class="countdown-number" id="countdown-days">00</div>
                    <div class="countdown-text">DAYS</div>
                </div>
                <div class="countdown-separator">:</div>
                <div class="countdown-block">
                    <div class="countdown-number" id="countdown-hours">00</div>
                    <div class="countdown-text">HRS</div>
                </div>
                <div class="countdown-separator">:</div>
                <div class="countdown-block">
                    <div class="countdown-number" id="countdown-minutes">00</div>
                    <div class="countdown-text">MIN</div>
                </div>
                <div class="countdown-separator">:</div>
                <div class="countdown-block">
                    <div class="countdown-number" id="countdown-seconds">00</div>
                    <div class="countdown-text">SEC</div>
                </div>
            </div>
            
            <a href="<?php echo e(route('shop.discounted')); ?>" class="campaign-cta">
                SHOP SALE
                <i class="fas fa-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Premium Hero Section -->
<section class="hero-premium">
    <div class="hero-slider-container">
        <div class="swiper heroSwiper">
            <div class="swiper-wrapper">
                <?php $__empty_1 = true; $__currentLoopData = $heroBanners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="swiper-slide">
                    <div class="hero-slide-premium" style="background-image: url('<?php echo e(\App\Helpers\ImageHelper::getImageUrl($banner->image)); ?>');">
                        <div class="hero-overlay"></div>
                        <div class="container h-100">
                            <div class="row h-100 align-items-center">
                                <div class="col-lg-7">
                                    <div class="hero-content-premium">
                                        <?php if($banner->subtitle): ?>
                                        <span class="hero-label" data-aos="fade-up" data-aos-delay="100"><?php echo e($banner->subtitle); ?></span>
                                        <?php endif; ?>
                                        <h1 class="hero-title" data-aos="fade-up" data-aos-delay="200">
                                            <?php echo e($banner->title); ?>

                                        </h1>
                                        <?php if($banner->description): ?>
                                        <p class="hero-description" data-aos="fade-up" data-aos-delay="300">
                                            <?php echo e($banner->description); ?>

                                        </p>
                                        <?php endif; ?>
                                        <?php if($banner->button_text && $banner->button_link): ?>
                                        <div class="hero-buttons" data-aos="fade-up" data-aos-delay="400">
                                            <a href="<?php echo e($banner->button_link); ?>" class="btn-hero-primary">
                                                <?php echo e($banner->button_text); ?>

                                            </a>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <!-- Default slide if no banners -->
                <div class="swiper-slide">
                    <div class="hero-slide-premium" style="background-image: url('/images/hero-1.jpg');">
                        <!-- Default content -->
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <div class="swiper-pagination"></div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>
    </div>
</section>

<!-- Home Hero Slider Banners -->
<?php if($homeHeroSliders->count() > 0): ?>
<section class="home-hero-slider-section">
    <?php $__currentLoopData = $homeHeroSliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sliderBanner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="banner-slider-container" data-slider-id="<?php echo e($sliderBanner->id); ?>">
        <div class="banner-slider"
             data-settings="<?php echo e(json_encode($sliderBanner->getSlideSettings())); ?>">

            <!-- Slider Images -->
            <div class="slider-wrapper">
                <?php $__currentLoopData = $sliderBanner->getSlideImages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $imageUrl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="slide <?php echo e($index === 0 ? 'active' : ''); ?>"
                     style="background-image: url('<?php echo e($imageUrl); ?>');">
                    <div class="slide-overlay"></div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Slider Content -->
            <div class="slider-content">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="slider-text" data-aos="fade-right">
                                <?php if($sliderBanner->title): ?>
                                    <h2 class="slider-title"><?php echo e($sliderBanner->title); ?></h2>
                                <?php endif; ?>
                                <?php if($sliderBanner->subtitle): ?>
                                    <h3 class="slider-subtitle"><?php echo e($sliderBanner->subtitle); ?></h3>
                                <?php endif; ?>
                                <?php if($sliderBanner->description): ?>
                                    <p class="slider-description"><?php echo e($sliderBanner->description); ?></p>
                                <?php endif; ?>
                                <?php if($sliderBanner->button_text): ?>
                                    <a href="<?php echo e($sliderBanner->getButtonUrl()); ?>"
                                       class="btn btn-primary btn-lg slider-btn">
                                        <?php echo e($sliderBanner->button_text); ?>

                                        <i class="fas fa-arrow-right ms-2"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Slider Controls -->
            <?php if(count($sliderBanner->getSlideImages()) > 1): ?>
            <div class="slider-controls">
                <!-- Dots Navigation -->
                <div class="slider-dots">
                    <?php $__currentLoopData = $sliderBanner->getSlideImages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $imageUrl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button class="dot <?php echo e($index === 0 ? 'active' : ''); ?>"
                            data-slide="<?php echo e($index); ?>"></button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Arrow Navigation -->
                <div class="slider-arrows">
                    <button class="slider-arrow prev" aria-label="Previous slide">
                        <i class="fas fa-chevron-left"></i>
                    </button>
                    <button class="slider-arrow next" aria-label="Next slide">
                        <i class="fas fa-chevron-right"></i>
                    </button>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</section>
<?php endif; ?>

<!-- Train Slider Section -->
<?php if($trainSliders->count() > 0): ?>
<section class="train-slider-section">
    <?php $__currentLoopData = $trainSliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trainSlider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="train-slider-container" data-slider-id="<?php echo e($trainSlider->id); ?>">
        <div class="train-wrapper" data-settings="<?php echo e(json_encode($trainSlider->getSlideSettings())); ?>">
            <div class="train-track">
                <?php $__currentLoopData = $trainSlider->getSlideImages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $imageUrl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php for($i = 0; $i < 3; $i++): ?> 
                    <div class="train-car">
                        <div class="train-car-content">
                            <img src="<?php echo e($imageUrl); ?>"
                                 alt="<?php echo e($trainSlider->title); ?>"
                                 class="train-car-image"
                                 loading="lazy">
                            <?php if($trainSlider->button_text && $loop->first && $i === 0): ?>
                            <div class="train-car-overlay">
                                <a href="<?php echo e($trainSlider->getButtonUrl()); ?>"
                                   class="train-cta-btn">
                                    <?php echo e($trainSlider->button_text); ?>

                                    <i class="fas fa-arrow-right ms-2"></i>
                                </a>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endfor; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</section>
<?php endif; ?>

<!-- Premium Categories Grid - FIXED WITH PROPER IMAGES -->
<section class="categories-premium py-5">
    <div class="container">
        <div class="section-header text-center mb-5" data-aos="fade-up">
            <span class="section-label">SHOP BY</span>
            <h2 class="section-title">CATEGORIES</h2>
        </div>
        
        <div class="categories-grid">
            <?php $__currentLoopData = $categories->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="category-item-premium" data-aos="zoom-in" data-aos-delay="<?php echo e($index * 100); ?>">
                <a href="<?php echo e(route('shop.category', $category->slug)); ?>" class="category-link-premium">
                    <div class="category-image-wrapper">
                        <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($category->image)); ?>" 
                             alt="<?php echo e($category->name); ?>" 
                             class="category-image-premium"
                             loading="lazy"
                             onerror="this.src='/images/placeholder-category.jpg'">
                        <div class="category-overlay-premium">
                            <div class="category-content-premium">
                                <h3 class="category-name"><?php echo e(strtoupper($category->name)); ?></h3>
                                <span class="category-count"><?php echo e($category->products_count ?? 0); ?> ITEMS</span>
                                <div class="category-arrow">
                                    <i class="fas fa-arrow-right"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Below Categories Slider Banners -->
<?php if($belowCategoriesSliders->count() > 0): ?>
<section class="below-categories-slider-section">
    <?php $__currentLoopData = $belowCategoriesSliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sliderBanner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="banner-slider-container below-categories" data-slider-id="<?php echo e($sliderBanner->id); ?>">
        <div class="banner-slider"
             data-settings="<?php echo e(json_encode($sliderBanner->getSlideSettings())); ?>">

            <!-- Slider Images -->
            <div class="slider-wrapper">
                <?php $__currentLoopData = $sliderBanner->getSlideImages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $imageUrl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="slide <?php echo e($index === 0 ? 'active' : ''); ?>"
                     style="background-image: url('<?php echo e($imageUrl); ?>');">
                    <div class="slide-overlay"></div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Slider Content -->
            <div class="slider-content">
                <div class="container">
                    <div class="row align-items-center justify-content-center">
                        <div class="col-lg-8 text-center">
                            <div class="slider-text" data-aos="fade-up">
                                <?php if($sliderBanner->title): ?>
                                    <h2 class="slider-title"><?php echo e($sliderBanner->title); ?></h2>
                                <?php endif; ?>
                                <?php if($sliderBanner->subtitle): ?>
                                    <h3 class="slider-subtitle"><?php echo e($sliderBanner->subtitle); ?></h3>
                                <?php endif; ?>
                                <?php if($sliderBanner->description): ?>
                                    <p class="slider-description"><?php echo e($sliderBanner->description); ?></p>
                                <?php endif; ?>
                                <?php if($sliderBanner->button_text): ?>
                                    <a href="<?php echo e($sliderBanner->getButtonUrl()); ?>"
                                       class="btn btn-primary btn-lg slider-btn">
                                        <?php echo e($sliderBanner->button_text); ?>

                                        <i class="fas fa-arrow-right ms-2"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Slider Controls -->
            <?php if(count($sliderBanner->getSlideImages()) > 1): ?>
            <div class="slider-controls">
                <!-- Dots Navigation -->
                <div class="slider-dots">
                    <?php $__currentLoopData = $sliderBanner->getSlideImages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $imageUrl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button class="dot <?php echo e($index === 0 ? 'active' : ''); ?>"
                            data-slide="<?php echo e($index); ?>"></button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Arrow Navigation -->
                <div class="slider-arrows">
                    <button class="slider-arrow prev" aria-label="Previous slide">
                        <i class="fas fa-chevron-left"></i>
                    </button>
                    <button class="slider-arrow next" aria-label="Next slide">
                        <i class="fas fa-chevron-right"></i>
                    </button>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</section>
<?php endif; ?>

<!-- Premium Featured Products -->
<section class="featured-products-premium py-5">
    <div class="container">
        <div class="section-header text-center mb-5" data-aos="fade-up">
            <span class="section-label">CURATED FOR YOU</span>
            <h2 class="section-title">FEATURED DROPS</h2>
        </div>
        
        <div class="products-premium-grid">
            <?php $__currentLoopData = $featuredProducts->take(8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="product-card-premium" data-aos="fade-up" data-aos-delay="<?php echo e($index * 50); ?>">
                <div class="product-image-container">
                    <?php if($product->compare_price && $product->compare_price > $product->price): ?>
                    <span class="product-badge sale">
                        -<?php echo e(round((($product->compare_price - $product->price) / $product->compare_price) * 100)); ?>%
                    </span>
                    <?php endif; ?>
                    <?php if($product->is_featured): ?>
                    <span class="product-badge featured">HOT</span>
                    <?php endif; ?>
                    
                    <a href="<?php echo e(route('shop.product', $product->slug)); ?>" class="product-image-link">
                        <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($product->featured_image)); ?>" 
                             class="product-image-main" 
                             alt="<?php echo e($product->name); ?>"
                             loading="lazy"
                             onerror="this.src='/images/placeholder-product.jpg'">
                        <?php if($product->hover_image): ?>
                        <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($product->hover_image)); ?>" 
                             class="product-image-hover" 
                             alt="<?php echo e($product->name); ?>"
                             loading="lazy"
                             onerror="this.src='/images/placeholder-product.jpg'">
                        <?php endif; ?>
                    </a>
                </div>
                
                <div class="product-details">
                    <div class="product-category"><?php echo e(strtoupper($product->category->name ?? 'UNCATEGORIZED')); ?></div>
                    <h3 class="product-name">
                        <a href="<?php echo e(route('shop.product', $product->slug)); ?>"><?php echo e($product->name); ?></a>
                    </h3>
                    <div class="product-price">
                        <?php if($product->compare_price && $product->compare_price > $product->price): ?>
                        <span class="price-old">$<?php echo e(number_format($product->compare_price, 2)); ?></span>
                        <?php endif; ?>
                        <span class="price-current">$<?php echo e(number_format($product->price, 2)); ?></span>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <div class="text-center mt-5" data-aos="fade-up">
            <a href="<?php echo e(route('shop.index')); ?>" class="btn-view-all">
                VIEW ALL PRODUCTS
                <i class="fas fa-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</section>

<!-- Promotional Banners -->
<section class="promo-banners-premium py-5">
    <div class="container">
        <div class="row g-4">
            <?php $__currentLoopData = $promoBanners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-6" data-aos="fade-<?php echo e($banner->position == 'promo_left' ? 'right' : 'left'); ?>">
                <div class="banner-card-premium">
                    <div class="banner-image" style="background-image: url('<?php echo e(\App\Helpers\ImageHelper::getImageUrl($banner->image)); ?>');">
                        <div class="banner-overlay"></div>
                        <div class="banner-content">
                            <?php if($banner->subtitle): ?>
                            <span class="banner-label"><?php echo e($banner->subtitle); ?></span>
                            <?php endif; ?>
                            <h3 class="banner-title"><?php echo e($banner->title); ?></h3>
                            <?php if($banner->button_text && $banner->button_link): ?>
                            <a href="<?php echo e($banner->button_link); ?>" class="banner-link">
                                <?php echo e($banner->button_text); ?> <i class="fas fa-arrow-right"></i>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Premium Instagram Feed -->
<section class="instagram-premium py-5">
    <div class="container">
        <div class="section-header text-center mb-5" data-aos="fade-up">
            <span class="section-label">FOLLOW US</span>
            <h2 class="section-title">@EDITIONBYPUNJAB</h2>
        </div>
        
        <div class="instagram-grid">
            <?php if(isset($instagramFeeds) && $instagramFeeds->count() > 0): ?>
                <?php $__currentLoopData = $instagramFeeds->take(8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $feed): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="instagram-item-premium" data-aos="zoom-in" data-aos-delay="<?php echo e($index * 50); ?>">
                    <a href="<?php echo e($feed->link); ?>" target="_blank" class="instagram-link">
                        <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($feed->image)); ?>" 
                             alt="<?php echo e($feed->caption ?? 'Instagram post'); ?>" 
                             class="instagram-image"
                             loading="lazy"
                             onerror="this.src='/images/placeholder-square.jpg'">
                        <div class="instagram-hover">
                            <i class="fab fa-instagram"></i>
                        </div>
                    </a>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <?php for($i = 1; $i <= 8; $i++): ?>
                <div class="instagram-item-premium" data-aos="zoom-in" data-aos-delay="<?php echo e($i * 50); ?>">
                    <a href="https://instagram.com/editionbypunjab" target="_blank" class="instagram-link">
                        <img src="/images/instagram-<?php echo e($i); ?>.jpg" 
                             alt="Instagram post" 
                             class="instagram-image"
                             loading="lazy"
                             onerror="this.src='/images/placeholder-square.jpg'">
                        <div class="instagram-hover">
                            <i class="fab fa-instagram"></i>
                        </div>
                    </a>
                </div>
                <?php endfor; ?>
            <?php endif; ?>
        </div>
        
        <div class="text-center mt-5" data-aos="fade-up">
            <a href="https://instagram.com/editionbypunjab" target="_blank" class="btn-follow">
                <i class="fab fa-instagram me-2"></i>
                FOLLOW US ON INSTAGRAM
            </a>
        </div>
    </div>
</section>

<!-- Premium Newsletter Section -->
<section class="newsletter-section-premium">
    <div class="container">
        <div class="newsletter-box" data-aos="zoom-in">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h3 class="newsletter-heading">STAY IN THE LOOP</h3>
                    <p class="newsletter-text">Get exclusive access to new drops and member-only offers</p>
                </div>
                <div class="col-lg-6">
                    <form action="<?php echo e(route('newsletter.subscribe')); ?>" method="POST" class="newsletter-inline-form">
                        <?php echo csrf_field(); ?>
                        <div class="input-group-premium">
                            <input type="email" name="email" placeholder="Enter your email" required>
                            <button type="submit">
                                SUBSCRIBE
                                <i class="fas fa-arrow-right ms-2"></i>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    /* Root Variables */
    :root {
        --accent-color: #ff3333;
        --text-secondary: #666666;
        --bg-secondary: #f5f5f5;
    }

    /* Premium Hero Styles */
    .hero-premium {
        height: 100vh;
        min-height: 500px;
        position: relative;
        overflow: hidden;
    }

    .hero-slider-container {
        height: 100%;
    }

    .heroSwiper {
        height: 100%;
    }

    .hero-slide-premium {
        height: 100vh;
        min-height: 500px;
        background-size: cover;
        background-position: center;
        position: relative;
    }

    .hero-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(0,0,0,0.6) 0%, rgba(0,0,0,0.3) 100%);
    }

    .hero-content-premium {
        position: relative;
        z-index: 2;
        color: white;
    }

    .hero-label {
        display: inline-block;
        padding: 8px 20px;
        background: rgba(255,255,255,0.1);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255,255,255,0.2);
        font-size: 0.75rem;
        letter-spacing: 0.2em;
        margin-bottom: 2rem;
        font-weight: 600;
    }

    .hero-title {
        font-size: clamp(2.5rem, 8vw, 6rem);
        font-weight: 900;
        line-height: 0.9;
        margin-bottom: 1.5rem;
        font-family: 'Space Grotesk', sans-serif;
    }

    .text-outline {
        -webkit-text-stroke: 2px white;
        -webkit-text-fill-color: transparent;
    }

    .hero-description {
        font-size: clamp(1rem, 2vw, 1.25rem);
        margin-bottom: 3rem;
        opacity: 0.9;
    }

    .hero-buttons {
        display: flex;
        gap: 1rem;
        flex-wrap: wrap;
    }

    .btn-hero-primary,
    .btn-hero-secondary {
        padding: 1rem 2.5rem;
        font-size: 0.875rem;
        letter-spacing: 0.1em;
        font-weight: 600;
        transition: all 0.3s;
        text-decoration: none;
        display: inline-block;
    }

    .btn-hero-primary {
        background: white;
        color: black;
        border: 2px solid white;
    }

    .btn-hero-primary:hover {
        background: transparent;
        color: white;
        transform: translateY(-2px);
    }

    .btn-hero-secondary {
        background: transparent;
        color: white;
        border: 2px solid white;
    }

    .btn-hero-secondary:hover {
        background: white;
        color: black;
        transform: translateY(-2px);
    }

    /* Premium Campaign Banner */
    .campaign-banner-premium {
        background: linear-gradient(90deg, #000 0%, #1a1a1a 100%);
        padding: 1rem 0;
        position: sticky;
        top: 0;
        z-index: 999;
    }

    .campaign-content {
        display: flex;
        align-items: center;
        justify-content: space-between;
        flex-wrap: wrap;
        gap: 1rem;
    }

    .campaign-text {
        display: flex;
        align-items: center;
        gap: 1rem;
    }

    .campaign-label {
        background: var(--accent-color);
        color: white;
        padding: 0.25rem 0.75rem;
        font-size: 0.75rem;
        font-weight: 600;
        letter-spacing: 0.1em;
    }

    .campaign-title {
        color: white;
        font-size: clamp(0.875rem, 2vw, 1rem);
        margin: 0;
        font-weight: 600;
    }

    .countdown-premium {
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .countdown-block {
        text-align: center;
        color: white;
    }

    .countdown-number {
        font-size: clamp(1.25rem, 2vw, 1.5rem);
        font-weight: 700;
        font-family: 'Space Grotesk', sans-serif;
    }

    .countdown-text {
        font-size: 0.625rem;
        letter-spacing: 0.1em;
        opacity: 0.7;
    }

    .countdown-separator {
        color: white;
        font-size: 1.5rem;
        font-weight: 700;
    }

    .campaign-cta {
        background: white;
        color: black;
        padding: 0.5rem 1.5rem;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.875rem;
        letter-spacing: 0.05em;
        transition: all 0.3s;
    }

    .campaign-cta:hover {
        background: var(--accent-color);
        color: white;
        transform: translateX(5px);
    }

    /* Premium Newsletter Modal */
    .btn-close-premium {
        top: 2rem;
        right: 2rem;
        z-index: 1000;
        width: 30px;
        height: 30px;
        cursor: pointer;
    }

    .btn-close-premium span {
        position: absolute;
        width: 100%;
        height: 2px;
        background: white;
        transform: rotate(45deg);
        transition: all 0.3s;
    }

    .btn-close-premium span:last-child {
        transform: rotate(-45deg);
    }

    .btn-close-premium:hover span {
        background: var(--accent-color);
    }

    .newsletter-image-premium {
        background: linear-gradient(135deg, #000 0%, #1a1a1a 100%);
        min-height: 500px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .newsletter-brand-showcase {
        text-align: center;
        color: white;
    }

    .brand-title {
        font-size: clamp(2.5rem, 5vw, 4rem);
        font-weight: 900;
        letter-spacing: 0.1em;
        margin-bottom: 0.5rem;
        font-family: 'Space Grotesk', sans-serif;
    }

    .brand-subtitle {
        font-size: clamp(1rem, 3vw, 1.5rem);
        letter-spacing: 0.3em;
        margin-bottom: 2rem;
        opacity: 0.8;
    }

    .brand-tagline {
        font-size: 0.875rem;
        letter-spacing: 0.2em;
        opacity: 0.6;
    }

    .newsletter-title {
        font-size: 2rem;
        font-weight: 800;
        font-family: 'Space Grotesk', sans-serif;
    }

    .newsletter-subtitle {
        color: var(--text-secondary);
    }

    .premium-input {
        border: none;
        border-bottom: 2px solid #e0e0e0;
        border-radius: 0;
        padding: 1rem 0;
        background: transparent;
        transition: all 0.3s;
    }

    .premium-input:focus {
        border-color: #000;
        box-shadow: none;
    }

    .premium-submit {
        background: #000;
        border: 2px solid #000;
        position: relative;
        overflow: hidden;
        transition: all 0.3s;
    }

    .premium-submit:hover {
        background: transparent;
        color: #000;
    }

    /* Premium Categories - ENHANCED MOBILE SUPPORT */
    .categories-premium {
        background: var(--bg-secondary);
        padding: 3rem 0;
    }

    .section-header {
        margin-bottom: 3rem;
    }

    .section-label {
        display: inline-block;
        padding: 0.5rem 1rem;
        background: #000;
        color: white;
        font-size: 0.75rem;
        letter-spacing: 0.2em;
        font-weight: 600;
        margin-bottom: 1rem;
    }

    .section-title {
        font-size: clamp(2rem, 5vw, 3rem);
        font-weight: 900;
        font-family: 'Space Grotesk', sans-serif;
        margin: 0;
    }

    .categories-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 1.5rem;
    }

    .category-item-premium {
        position: relative;
        overflow: hidden;
        height: 350px;
        cursor: pointer;
        border-radius: 8px;
    }

    .category-image-wrapper {
        position: relative;
        height: 100%;
        overflow: hidden;
        border-radius: 8px;
    }

    .category-image-premium {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.8s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .category-item-premium:hover .category-image-premium {
        transform: scale(1.1);
    }

    .category-overlay-premium {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(to bottom, transparent 50%, rgba(0,0,0,0.8) 100%);
        display: flex;
        align-items: flex-end;
        padding: 2rem;
        transition: all 0.5s;
    }

    .category-item-premium:hover .category-overlay-premium {
        background: linear-gradient(to bottom, rgba(0,0,0,0.3) 0%, rgba(0,0,0,0.9) 100%);
    }

    .category-content-premium {
        color: white;
        width: 100%;
    }

    .category-name {
        font-size: clamp(1.25rem, 3vw, 1.5rem);
        font-weight: 700;
        margin-bottom: 0.5rem;
        letter-spacing: 0.05em;
    }

    .category-count {
        font-size: 0.875rem;
        opacity: 0.8;
        display: block;
        margin-bottom: 1rem;
    }

    .category-arrow {
        opacity: 0;
        transform: translateX(-10px);
        transition: all 0.3s;
    }

    .category-item-premium:hover .category-arrow {
        opacity: 1;
        transform: translateX(0);
    }

    /* Premium Products Grid - ENHANCED MOBILE */
    .products-premium-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 1.5rem;
    }

    .product-card-premium {
        position: relative;
        background: white;
        transition: all 0.3s;
        border-radius: 8px;
        overflow: hidden;
    }

    .product-card-premium:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 40px rgba(0,0,0,0.1);
    }

    .product-image-container {
        position: relative;
        overflow: hidden;
        aspect-ratio: 3/4;
        background: #f5f5f5;
    }

    .product-image-main,
    .product-image-hover {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: all 0.5s;
    }

    .product-image-hover {
        position: absolute;
        top: 0;
        left: 0;
        opacity: 0;
    }

    .product-card-premium:hover .product-image-hover {
        opacity: 1;
    }

    .product-card-premium:hover .product-image-main {
        transform: scale(1.1);
    }

    .product-badge {
        position: absolute;
        top: 1rem;
        z-index: 2;
        padding: 0.25rem 0.75rem;
        font-size: 0.75rem;
        font-weight: 600;
        letter-spacing: 0.05em;
    }

    .product-badge.sale {
        left: 1rem;
        background: var(--accent-color);
        color: white;
    }

    .product-badge.featured {
        right: 1rem;
        background: #000;
        color: white;
    }

    .product-details {
        padding: 1.5rem;
    }

    .product-category {
        font-size: 0.75rem;
        letter-spacing: 0.1em;
        color: var(--text-secondary);
        margin-bottom: 0.5rem;
    }

    .product-name {
        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 0.75rem;
    }

    .product-name a {
        color: #000;
        text-decoration: none;
        transition: all 0.3s;
    }

    .product-name a:hover {
        color: var(--accent-color);
    }

    .product-price {
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .price-old {
        text-decoration: line-through;
        color: var(--text-secondary);
    }

    .price-current {
        font-size: 1.125rem;
        font-weight: 700;
    }

    /* Premium Banners */
    .banner-card-premium {
        position: relative;
        overflow: hidden;
        height: 400px;
        border-radius: 8px;
    }

    .banner-image {
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center;
        position: relative;
        transition: transform 0.8s;
    }

    .banner-card-premium:hover .banner-image {
        transform: scale(1.05);
    }

    .banner-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(0,0,0,0.7) 0%, rgba(0,0,0,0.3) 100%);
    }

    .banner-content {
        position: absolute;
        bottom: 2rem;
        left: 2rem;
        color: white;
    }

    .banner-label {
        display: inline-block;
        padding: 0.25rem 0.75rem;
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(10px);
        font-size: 0.75rem;
        letter-spacing: 0.1em;
        margin-bottom: 0.5rem;
    }

    .banner-title {
        font-size: clamp(1.5rem, 3vw, 2rem);
        font-weight: 700;
        margin-bottom: 1rem;
    }

    .banner-link {
        color: white;
        text-decoration: none;
        font-weight: 600;
        letter-spacing: 0.05em;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        transition: all 0.3s;
    }

    .banner-link:hover {
        transform: translateX(5px);
        color: white;
    }

    /* Instagram Grid - MOBILE OPTIMIZED */
    .instagram-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        gap: 1rem;
    }

    .instagram-item-premium {
        position: relative;
        overflow: hidden;
        aspect-ratio: 1;
        border-radius: 8px;
    }

    .instagram-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s;
    }

    .instagram-hover {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0,0,0,0.8);
        display: flex;
        align-items: center;
        justify-content: center;
        opacity: 0;
        transition: all 0.3s;
    }

    .instagram-hover i {
        color: white;
        font-size: 2rem;
        transform: scale(0);
        transition: transform 0.3s;
    }

    .instagram-item-premium:hover .instagram-hover {
        opacity: 1;
    }

    .instagram-item-premium:hover .instagram-hover i {
        transform: scale(1);
    }

    .instagram-item-premium:hover .instagram-image {
        transform: scale(1.1);
    }

    .btn-follow {
        display: inline-block;
        padding: 1rem 2rem;
        background: #000;
        color: white;
        text-decoration: none;
        font-weight: 600;
        letter-spacing: 0.05em;
        transition: all 0.3s;
        border-radius: 4px;
    }

    .btn-follow:hover {
        background: var(--accent-color);
        color: white;
        transform: translateY(-2px);
    }

    /* Newsletter Section */
    .newsletter-section-premium {
        background: linear-gradient(135deg, #f5f5f5 0%, #fff 100%);
        padding: 5rem 0;
    }

    .newsletter-box {
        background: #000;
        color: white;
        padding: 3rem;
        border-radius: 8px;
    }

    .newsletter-heading {
        font-size: clamp(1.5rem, 3vw, 2rem);
        font-weight: 700;
        margin-bottom: 0.5rem;
    }

    .newsletter-text {
        opacity: 0.8;
        margin-bottom: 0;
    }

    .input-group-premium {
        display: flex;
        background: white;
        overflow: hidden;
        border-radius: 4px;
    }

    .input-group-premium input {
        flex: 1;
        border: none;
        padding: 1rem 1.5rem;
        outline: none;
    }

    .input-group-premium button {
        background: var(--accent-color);
        color: white;
        border: none;
        padding: 1rem 2rem;
        font-weight: 600;
        letter-spacing: 0.05em;
        cursor: pointer;
        transition: all 0.3s;
        white-space: nowrap;
    }

    .input-group-premium button:hover {
        background: #ff0000;
    }

    /* View All Button */
    .btn-view-all {
        display: inline-block;
        padding: 1rem 3rem;
        border: 2px solid #000;
        color: #000;
        text-decoration: none;
        font-weight: 600;
        letter-spacing: 0.1em;
        position: relative;
        overflow: hidden;
        transition: all 0.3s;
        border-radius: 4px;
    }

    .btn-view-all::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: #000;
        transition: left 0.3s;
        z-index: -1;
    }

    .btn-view-all:hover {
        color: white;
    }

    .btn-view-all:hover::before {
        left: 0;
    }

    /* Swiper Customization */
    .swiper-button-next,
    .swiper-button-prev {
        color: white;
        width: 50px;
        height: 50px;
        background: rgba(0,0,0,0.5);
        backdrop-filter: blur(10px);
        border-radius: 4px;
    }

    .swiper-button-next:after,
    .swiper-button-prev:after {
        font-size: 1.25rem;
    }

    .swiper-pagination-bullet {
        background: white;
        opacity: 0.5;
    }

    .swiper-pagination-bullet-active {
        opacity: 1;
    }

    /* Mobile Responsive - ENHANCED */
    @media (max-width: 991px) {
        .campaign-content {
            justify-content: center;
            text-align: center;
        }

        .campaign-text {
            width: 100%;
            justify-content: center;
        }

        .countdown-premium {
            width: 100%;
            justify-content: center;
        }

        .categories-grid {
            grid-template-columns: repeat(2, 1fr);
            gap: 1rem;
        }

        .products-premium-grid {
            grid-template-columns: repeat(2, 1fr);
            gap: 1rem;
        }

        .instagram-grid {
            grid-template-columns: repeat(3, 1fr);
        }
    }

    @media (max-width: 768px) {
        .hero-premium {
            height: 70vh;
            min-height: 400px;
        }

        .hero-slide-premium {
            height: 70vh;
            min-height: 400px;
        }

        .hero-title {
            font-size: 2.5rem;
        }

        .hero-buttons {
            flex-direction: column;
            align-items: flex-start;
        }

        .btn-hero-primary,
        .btn-hero-secondary {
            width: 100%;
            text-align: center;
        }

        .categories-grid {
            grid-template-columns: 1fr;
        }

        .category-item-premium {
            height: 300px;
        }

        .products-premium-grid {
            grid-template-columns: repeat(2, 1fr);
        }

        .instagram-grid {
            grid-template-columns: repeat(2, 1fr);
        }

        .newsletter-box {
            padding: 2rem 1.5rem;
        }

        .input-group-premium {
            flex-direction: column;
        }

        .input-group-premium button {
            width: 100%;
        }

        .banner-card-premium {
            height: 300px;
        }

        .swiper-button-next,
        .swiper-button-prev {
            width: 40px;
            height: 40px;
        }

        .swiper-button-next:after,
        .swiper-button-prev:after {
            font-size: 1rem;
        }
    }

    @media (max-width: 576px) {
        .hero-title {
            font-size: 2rem;
        }

        .campaign-banner-premium {
            padding: 0.75rem 0;
        }

        .countdown-block {
            margin: 0 0.25rem;
        }

        .countdown-number {
            font-size: 1rem;
        }

        .countdown-text {
            font-size: 0.5rem;
        }

        .categories-grid {
            gap: 0.75rem;
        }

        .products-premium-grid {
            grid-template-columns: 1fr;
            gap: 1rem;
        }

        .product-details {
            padding: 1rem;
        }

        .instagram-grid {
            gap: 0.5rem;
        }

        .btn-view-all {
            padding: 0.75rem 2rem;
            font-size: 0.875rem;
        }
    }

    /* Fix for Safari */
    @supports (-webkit-appearance: none) {
        .category-image-premium,
        .product-image-main,
        .product-image-hover {
            -webkit-transform: translateZ(0);
            -webkit-backface-visibility: hidden;
        }
    }

    /* Loading States */
    .category-image-premium,
    .product-image-main {
        background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
        background-size: 200% 100%;
        animation: loading 1.5s infinite;
    }

    @keyframes loading {
        0% { background-position: 200% 0; }
        100% { background-position: -200% 0; }
    }

    /* Accessibility */
    .btn-hero-primary:focus,
    .btn-hero-secondary:focus,
    .btn-view-all:focus,
    .btn-follow:focus {
        outline: 2px solid var(--accent-color);
        outline-offset: 2px;
    }

    /* Print Styles */
    @media print {
        .campaign-banner-premium,
        .newsletter-section-premium,
        .instagram-premium {
            display: none;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Initialize Swiper with mobile optimization
    var heroSwiper = new Swiper('.heroSwiper', {
        loop: true,
        effect: 'fade',
        autoplay: {
            delay: 5000,
            disableOnInteraction: false,
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        touchRatio: 1,
        touchAngle: 45,
        simulateTouch: true,
        allowTouchMove: true,
        threshold: 5,
    });

    // Newsletter functionality
    (function() {
        function setCookie(name, value, days) {
            var expires = "";
            if (days) {
                var date = new Date();
                date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
                expires = "; expires=" + date.toUTCString();
            }
            document.cookie = name + "=" + (value || "") + expires + "; path=/";
        }

        function getCookie(name) {
            var nameEQ = name + "=";
            var ca = document.cookie.split(';');
            for (var i = 0; i < ca.length; i++) {
                var c = ca[i];
                while (c.charAt(0) == ' ') c = c.substring(1, c.length);
                if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
            }
            return null;
        }

        document.addEventListener('DOMContentLoaded', function() {
            // Newsletter popup - disabled on mobile for better UX
            if (window.innerWidth > 768) {
                try {
                    var shown = sessionStorage.getItem('newsletterShown');
                    var subscribed = getCookie('newsletter_subscribed');
                    if (!shown && !subscribed) {
                        setTimeout(function() {
                            var modalEl = document.getElementById('newsletterModal');
                            if (modalEl) {
                                var bsModal = new bootstrap.Modal(modalEl);
                                bsModal.show();
                                sessionStorage.setItem('newsletterShown', 'true');
                            }
                        }, 3000);
                    }
                } catch (e) {
                    console.warn('newsletter popup error', e);
                }
            }
        });

        var newsletterForm = document.getElementById('newsletterForm');
        if (newsletterForm) {
            newsletterForm.addEventListener('submit', function(e) {
                e.preventDefault();
                var emailInput = document.getElementById('newsletter_email');
                if (!emailInput) return;
                var email = emailInput.value.trim();
                if (!email) return;

                var submitBtn = newsletterForm.querySelector('button[type="submit"]');
                if (submitBtn) {
                    submitBtn.disabled = true;
                    submitBtn.querySelector('.btn-text').classList.add('d-none');
                    submitBtn.querySelector('.btn-loader').classList.remove('d-none');
                }

                fetch('<?php echo e(route("newsletter.subscribe")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify({ email: email })
                })
                .then(function(res) { return res.json().catch(function(){ return {}; }); })
                .then(function(data) {
                    if (data && data.success) {
                        var successBox = document.getElementById('newsletterSuccess');
                        var successMessage = document.getElementById('successMessage');
                        var errorBox = document.getElementById('newsletterError');

                        if (successBox && successMessage) {
                            successBox.classList.remove('d-none');
                            successMessage.innerHTML = (data.message || 'Thanks for subscribing!') + 
                                (data.discount_code ? '<br><strong>Your discount code: ' + data.discount_code + '</strong>' : '');
                        }
                        if (errorBox) errorBox.classList.add('d-none');

                        setCookie('newsletter_subscribed', 'true', 365);
                        newsletterForm.style.display = 'none';

                        setTimeout(function() {
                            var modalEl = document.getElementById('newsletterModal');
                            if (modalEl) {
                                var bs = bootstrap.Modal.getInstance(modalEl);
                                if (bs) bs.hide();
                            }
                        }, 4000);
                    } else {
                        handleError(data);
                    }
                })
                .catch(function(err) {
                    handleError(null);
                });

                function handleError(data) {
                    var errorText = 'An error occurred. Please try again.';
                    if (data && data.errors) {
                        try {
                            var firstKey = Object.keys(data.errors)[0];
                            errorText = data.errors[firstKey][0];
                        } catch (e) {}
                    } else if (data && data.message) {
                        errorText = data.message;
                    }
                    var errorBox = document.getElementById('newsletterError');
                    var errorMessage = document.getElementById('errorMessage');
                    if (errorBox && errorMessage) {
                        errorBox.classList.remove('d-none');
                        errorMessage.textContent = errorText;
                    }
                    if (submitBtn) {
                        submitBtn.disabled = false;
                        submitBtn.querySelector('.btn-text').classList.remove('d-none');
                        submitBtn.querySelector('.btn-loader').classList.add('d-none');
                    }
                }
            });
        }
    })();

    // Countdown functionality
    (function() {
        function parseDateFromString(s) {
            if (!s) return null;
            var iso = s.indexOf('T') === -1 && s.indexOf(' ') !== -1 ? s.replace(' ', 'T') : s;
            if (/^\d{4}-\d{2}-\d{2}$/.test(iso)) iso = iso + 'T23:59:59';
            var parsed = Date.parse(iso);
            if (!isNaN(parsed)) return parsed;
            return Date.parse(iso);
        }

        function updateCountdownElements(endTimeMs) {
            var now = new Date().getTime();
            var distance = endTimeMs - now;
            if (distance <= 0) {
                document.querySelectorAll('.countdown-premium').forEach(function(el) {
                    el.innerHTML = '<div class="text-white">Campaign Ended</div>';
                });
                return false;
            }

            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);

            var elDays = document.getElementById('countdown-days');
            var elHours = document.getElementById('countdown-hours');
            var elMinutes = document.getElementById('countdown-minutes');
            var elSeconds = document.getElementById('countdown-seconds');

            if (elDays) elDays.textContent = String(days).padStart(2, '0');
            if (elHours) elHours.textContent = String(hours).padStart(2, '0');
            if (elMinutes) elMinutes.textContent = String(minutes).padStart(2, '0');
            if (elSeconds) elSeconds.textContent = String(seconds).padStart(2, '0');

            return true;
        }

        function startCountdown() {
            var banner = document.querySelector('.countdown-premium[data-end-time]');
            var endTimeStr = null;
            if (banner) endTimeStr = banner.getAttribute('data-end-time');

            <?php if(isset($saleEndDate) && !$activeCampaign): ?>
                endTimeStr = "<?php echo e($saleEndDate); ?>";
            <?php endif; ?>

            if (!endTimeStr) return;

            var endMs = parseDateFromString(endTimeStr);
            if (!endMs) return;

            updateCountdownElements(endMs);
            setInterval(function() {
                updateCountdownElements(endMs);
            }, 1000);
        }

        document.addEventListener('DOMContentLoaded', startCountdown);
    })();

    // Add to Cart, Wishlist, Quick View with mobile optimization
    document.addEventListener('DOMContentLoaded', function() {
        // Add to Cart
        document.querySelectorAll('.add-to-cart-quick').forEach(function(button) {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                var productId = this.dataset.productId;
                if (!productId) return;

                // Visual feedback
                this.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
                var btn = this;

                fetch('<?php echo e(route("cart.add")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify({
                        product_id: productId,
                        quantity: 1
                    })
                })
                .then(function(response) { return response.json(); })
                .then(function(data) {
                    btn.innerHTML = '<i class="fas fa-check"></i>';
                    setTimeout(function() {
                        btn.innerHTML = '<i class="fas fa-shopping-bag"></i>';
                    }, 1000);

                    if (data && data.success) {
                        updateCartCount();
                        showNotification('Product added to cart!', 'success');
                    } else {
                        showNotification('Could not add to cart', 'danger');
                    }
                })
                .catch(function() {
                    btn.innerHTML = '<i class="fas fa-shopping-bag"></i>';
                    showNotification('Network error', 'danger');
                });
            });
        });

        // Wishlist with mobile optimization
        document.querySelectorAll('.add-to-wishlist').forEach(function(button) {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                var productId = this.dataset.productId;
                if (!productId) return;
                var btn = this;

                fetch('<?php echo e(route("shop.wishlist.toggle")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify({ product_id: productId })
                })
                .then(function(res) { return res.json(); })
                .then(function(data) {
                    if (data && data.added) {
                        btn.querySelector('i').classList.remove('far');
                        btn.querySelector('i').classList.add('fas');
                        showNotification('Added to wishlist!', 'success');
                    } else {
                        btn.querySelector('i').classList.remove('fas');
                        btn.querySelector('i').classList.add('far');
                        showNotification('Removed from wishlist!', 'info');
                    }
                })
                .catch(function() {
                    showNotification('Network error', 'danger');
                });
            });
        });

        // Quick view - optimized for mobile
        document.querySelectorAll('.quick-view').forEach(function(button) {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                var productId = this.dataset.productId;
                if (!productId) return;
                
                // On mobile, go directly to product page
                if (window.innerWidth <= 768) {
                    window.location.href = '<?php echo e(url("/shop/product")); ?>/' + productId;
                    return;
                }

                fetch(`<?php echo e(url('/shop/quick-view')); ?>/${productId}`)
                    .then(function(res) { return res.text(); })
                    .then(function(html) {
                        var modal = document.createElement('div');
                        modal.className = 'modal fade';
                        modal.innerHTML = html;
                        document.body.appendChild(modal);
                        var bs = new bootstrap.Modal(modal);
                        bs.show();
                        modal.addEventListener('hidden.bs.modal', function() {
                            modal.remove();
                        });
                    })
                    .catch(function() {
                        showNotification('Could not load product details', 'danger');
                    });
            });
        });

        // Helper functions
        window.updateCartCount = function() {
            fetch('<?php echo e(route("cart.count")); ?>')
                .then(function(res) { return res.json(); })
                .then(function(data) {
                    document.querySelectorAll('.cart-count').forEach(function(el) {
                        el.textContent = data.count || 0;
                    });
                });
        };

        window.showNotification = function(message, type) {
            // Mobile-friendly notification
            if (typeof toastr !== 'undefined') {
                toastr.options = {
                    "positionClass": window.innerWidth <= 768 ? "toast-bottom-center" : "toast-top-right",
                    "timeOut": "3000",
                    "progressBar": true
                };
                toastr[type](message);
            } else {
                // Fallback for mobile
                var notification = document.createElement('div');
                notification.className = 'mobile-notification ' + type;
                notification.textContent = message;
                notification.style.cssText = 'position:fixed;bottom:20px;left:50%;transform:translateX(-50%);background:#333;color:white;padding:12px 20px;border-radius:4px;z-index:9999;';
                document.body.appendChild(notification);
                setTimeout(function() {
                    notification.remove();
                }, 3000);
            }
        };

        // Lazy loading for images
        if ('IntersectionObserver' in window) {
            var imageObserver = new IntersectionObserver(function(entries, observer) {
                entries.forEach(function(entry) {
                    if (entry.isIntersecting) {
                        var img = entry.target;
                        img.src = img.dataset.src || img.src;
                        img.classList.add('loaded');
                        observer.unobserve(img);
                    }
                });
            });

            document.querySelectorAll('img[loading="lazy"]').forEach(function(img) {
                imageObserver.observe(img);
            });
        }
    });

    // Mobile menu optimization
    document.addEventListener('DOMContentLoaded', function() {
        // Smooth scroll for mobile
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Newsletter inline form handling (home page section)
        const newsletterInlineForm = document.querySelector('.newsletter-inline-form');
        if (newsletterInlineForm) {
            newsletterInlineForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                const emailInput = this.querySelector('input[name="email"]');
                const submitBtn = this.querySelector('button[type="submit"]');
                const email = emailInput.value.trim();
                
                if (!email) {
                    showNotification('Please enter a valid email address', 'warning');
                    return;
                }
                
                // Show loading state
                const originalBtnContent = submitBtn.innerHTML;
                submitBtn.disabled = true;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
                
                fetch('<?php echo e(route("newsletter.subscribe")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify({ email: email })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        showNotification(data.message, 'success');
                        if (data.discount_code) {
                            setTimeout(() => {
                                showNotification('Your discount code: ' + data.discount_code, 'info');
                            }, 1500);
                        }
                        emailInput.value = '';
                        
                        // Set cookie to remember subscription
                        document.cookie = 'newsletter_subscribed=true; path=/; max-age=' + (365 * 24 * 60 * 60);
                    } else {
                        showNotification(data.message || 'Subscription failed. Please try again.', 'danger');
                    }
                })
                .catch(error => {
                    console.error('Newsletter subscription error:', error);
                    showNotification('An error occurred. Please try again.', 'danger');
                })
                .finally(() => {
                    // Reset button state
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalBtnContent;
                });
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Banner Slider Styles */
.home-hero-slider-section,
.below-categories-slider-section {
    position: relative;
    overflow: hidden;
}

.banner-slider-container {
    position: relative;
    width: 100%;
    height: 600px;
    overflow: hidden;
}

.below-categories .banner-slider-container {
    height: 400px;
}

.banner-slider {
    position: relative;
    width: 100%;
    height: 100%;
}

.slider-wrapper {
    position: relative;
    width: 100%;
    height: 100%;
}

.slide {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    opacity: 0;
    transition: opacity 0.8s ease-in-out;
    z-index: 1;
}

.slide.active {
    opacity: 1;
    z-index: 2;
}

.slide-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.4) 0%, rgba(0, 0, 0, 0.2) 100%);
    z-index: 1;
}

.slider-content {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    z-index: 3;
}

.slider-text {
    color: white;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
}

.slider-title {
    font-size: 3.5rem;
    font-weight: 700;
    line-height: 1.2;
    margin-bottom: 1rem;
    text-transform: uppercase;
    letter-spacing: -0.02em;
}

.slider-subtitle {
    font-size: 1.5rem;
    font-weight: 300;
    margin-bottom: 1.5rem;
    opacity: 0.9;
}

.slider-description {
    font-size: 1.125rem;
    line-height: 1.6;
    margin-bottom: 2rem;
    max-width: 600px;
    opacity: 0.85;
}

.slider-btn {
    padding: 1rem 2rem;
    font-size: 1rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-radius: 0;
    border: 2px solid transparent;
    transition: all 0.3s ease;
    background: #ffffff;
    color: #000000;
}

.slider-btn:hover {
    background: transparent;
    color: #ffffff;
    border-color: #ffffff;
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
}

/* Slider Controls */
.slider-controls {
    position: absolute;
    bottom: 2rem;
    left: 50%;
    transform: translateX(-50%);
    z-index: 4;
    display: flex;
    align-items: center;
    gap: 2rem;
}

.slider-dots {
    display: flex;
    gap: 0.75rem;
}

.dot {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    border: 2px solid rgba(255, 255, 255, 0.5);
    background: transparent;
    cursor: pointer;
    transition: all 0.3s ease;
}

.dot.active,
.dot:hover {
    background: white;
    border-color: white;
    transform: scale(1.2);
}

.slider-arrows {
    display: flex;
    gap: 0.5rem;
}

.slider-arrow {
    width: 40px;
    height: 40px;
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.3);
    border-radius: 50%;
    color: white;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    backdrop-filter: blur(10px);
}

.slider-arrow:hover {
    background: rgba(255, 255, 255, 0.2);
    border-color: rgba(255, 255, 255, 0.5);
    transform: scale(1.1);
}

.slider-arrow i {
    font-size: 0.875rem;
}

/* Below Categories Slider Adjustments */
.below-categories .slider-title {
    font-size: 2.5rem;
}

.below-categories .slider-subtitle {
    font-size: 1.25rem;
}

.below-categories .slider-description {
    font-size: 1rem;
}

/* Responsive Design */
@media (max-width: 1200px) {
    .slider-title {
        font-size: 3rem;
    }

    .below-categories .slider-title {
        font-size: 2.25rem;
    }
}

@media (max-width: 992px) {
    .banner-slider-container {
        height: 500px;
    }

    .below-categories .banner-slider-container {
        height: 350px;
    }

    .slider-title {
        font-size: 2.5rem;
    }

    .below-categories .slider-title {
        font-size: 2rem;
    }

    .slider-subtitle {
        font-size: 1.25rem;
    }

    .below-categories .slider-subtitle {
        font-size: 1.125rem;
    }
}

@media (max-width: 768px) {
    .banner-slider-container {
        height: 400px;
    }

    .below-categories .banner-slider-container {
        height: 300px;
    }

    .slider-title {
        font-size: 2rem;
    }

    .below-categories .slider-title {
        font-size: 1.75rem;
    }

    .slider-subtitle {
        font-size: 1.125rem;
    }

    .slider-description {
        font-size: 1rem;
        margin-bottom: 1.5rem;
    }

    .slider-btn {
        padding: 0.875rem 1.5rem;
        font-size: 0.9rem;
    }

    .slider-controls {
        bottom: 1.5rem;
        gap: 1.5rem;
    }

    .slider-arrows {
        display: none; /* Hide arrows on mobile, rely on touch */
    }
}

@media (max-width: 576px) {
    .banner-slider-container {
        height: 350px;
    }

    .below-categories .banner-slider-container {
        height: 250px;
    }

    .slider-title {
        font-size: 1.75rem;
    }

    .below-categories .slider-title {
        font-size: 1.5rem;
    }

    .slider-subtitle {
        font-size: 1rem;
        margin-bottom: 1rem;
    }

    .slider-description {
        font-size: 0.9rem;
        margin-bottom: 1.25rem;
    }

    .slider-controls {
        bottom: 1rem;
    }

    .dot {
        width: 10px;
        height: 10px;
    }
}

/* Animation Enhancements */
.slide {
    animation: slideAnimation 0.8s ease-in-out;
}

@keyframes slideAnimation {
    0% {
        opacity: 0;
        transform: scale(1.05);
    }
    100% {
        opacity: 1;
        transform: scale(1);
    }
}

.slider-text {
    animation: textSlideIn 1s ease-out 0.3s both;
}

@keyframes textSlideIn {
    0% {
        opacity: 0;
        transform: translateY(30px);
    }
    100% {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Accessibility */
@media (prefers-reduced-motion: reduce) {
    .slide,
    .dot,
    .slider-arrow,
    .slider-btn,
    .slider-text {
        transition: none;
        animation: none;
    }
}

/* Loading state */
.banner-slider-container[data-loading="true"] {
    background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
    background-size: 200% 100%;
    animation: loading 1.5s infinite;
}

@keyframes loading {
    0% {
        background-position: 200% 0;
    }
    100% {
        background-position: -200% 0;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Banner Slider Animation System
class BannerSlider {
    constructor(container) {
        this.container = container;
        this.slider = container.querySelector('.banner-slider');
        this.slides = container.querySelectorAll('.slide');
        this.dots = container.querySelectorAll('.dot');
        this.prevBtn = container.querySelector('.slider-arrow.prev');
        this.nextBtn = container.querySelector('.slider-arrow.next');

        // Get slider settings from data attribute
        this.settings = JSON.parse(this.slider.dataset.settings || '{}');
        this.currentSlide = 0;
        this.slideCount = this.slides.length;
        this.isPlaying = this.settings.autoPlay;
        this.intervalId = null;

        this.init();
    }

    init() {
        if (this.slideCount <= 1) return;

        this.bindEvents();
        if (this.isPlaying) {
            this.startAutoPlay();
        }
    }

    bindEvents() {
        // Dot navigation
        this.dots.forEach((dot, index) => {
            dot.addEventListener('click', () => {
                this.goToSlide(index);
            });
        });

        // Arrow navigation
        if (this.prevBtn) {
            this.prevBtn.addEventListener('click', () => {
                this.previousSlide();
            });
        }

        if (this.nextBtn) {
            this.nextBtn.addEventListener('click', () => {
                this.nextSlide();
            });
        }

        // Pause on hover
        this.container.addEventListener('mouseenter', () => {
            this.pauseAutoPlay();
        });

        this.container.addEventListener('mouseleave', () => {
            if (this.isPlaying) {
                this.startAutoPlay();
            }
        });

        // Touch/swipe support
        this.addTouchSupport();
    }

    goToSlide(slideIndex) {
        if (slideIndex === this.currentSlide || slideIndex >= this.slideCount) return;

        // Remove active class from current slide and dot
        this.slides[this.currentSlide].classList.remove('active');
        this.dots[this.currentSlide].classList.remove('active');

        // Add active class to new slide and dot
        this.currentSlide = slideIndex;
        this.slides[this.currentSlide].classList.add('active');
        this.dots[this.currentSlide].classList.add('active');

        // Apply animation based on type
        this.applySlideAnimation();
    }

    nextSlide() {
        const nextIndex = (this.currentSlide + 1) % this.slideCount;
        this.goToSlide(nextIndex);
    }

    previousSlide() {
        const prevIndex = (this.currentSlide - 1 + this.slideCount) % this.slideCount;
        this.goToSlide(prevIndex);
    }

    applySlideAnimation() {
        const currentSlide = this.slides[this.currentSlide];

        if (this.settings.animation === 'slide') {
            // Apply slide animation
            currentSlide.style.transform = 'translateX(0)';
            currentSlide.style.opacity = '1';
        } else {
            // Apply fade animation (default)
            currentSlide.style.opacity = '1';
        }
    }

    startAutoPlay() {
        if (this.slideCount <= 1) return;

        this.intervalId = setInterval(() => {
            this.nextSlide();
        }, this.settings.duration || 5000);
    }

    pauseAutoPlay() {
        if (this.intervalId) {
            clearInterval(this.intervalId);
            this.intervalId = null;
        }
    }

    addTouchSupport() {
        let startX = null;
        let startY = null;

        this.container.addEventListener('touchstart', (e) => {
            startX = e.touches[0].clientX;
            startY = e.touches[0].clientY;
        });

        this.container.addEventListener('touchend', (e) => {
            if (!startX || !startY) return;

            const endX = e.changedTouches[0].clientX;
            const endY = e.changedTouches[0].clientY;
            const diffX = startX - endX;
            const diffY = startY - endY;

            // Only trigger swipe if horizontal movement is greater than vertical
            if (Math.abs(diffX) > Math.abs(diffY)) {
                if (Math.abs(diffX) > 50) { // Minimum swipe distance
                    if (diffX > 0) {
                        this.nextSlide(); // Swipe left - next slide
                    } else {
                        this.previousSlide(); // Swipe right - previous slide
                    }
                }
            }

            startX = null;
            startY = null;
        });
    }
}

// Initialize all banner sliders when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    const sliderContainers = document.querySelectorAll('.banner-slider-container');

    sliderContainers.forEach(container => {
        new BannerSlider(container);
    });

    // Intersection Observer for performance optimization
    if ('IntersectionObserver' in window) {
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                const container = entry.target;
                const slider = container.bannerSliderInstance;

                if (entry.isIntersecting) {
                    // Slider is visible, start auto-play if enabled
                    if (slider && slider.isPlaying) {
                        slider.startAutoPlay();
                    }
                } else {
                    // Slider is not visible, pause auto-play
                    if (slider) {
                        slider.pauseAutoPlay();
                    }
                }
            });
        }, {
            threshold: 0.5 // Trigger when 50% of slider is visible
        });

        sliderContainers.forEach(container => {
            observer.observe(container);
        });
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Train Slider Styles */
.train-slider-section {
    background: #f8f9fa;
    padding: 2rem 0;
    overflow: hidden;
    position: relative;
}

.train-slider-container {
    width: 100%;
    height: 300px;
    position: relative;
    overflow: hidden;
}

.train-wrapper {
    width: 100%;
    height: 100%;
    position: relative;
}

.train-track {
    display: flex;
    align-items: center;
    height: 100%;
    animation: trainMove 30s linear infinite;
    width: max-content;
}

.train-car {
    width: 500px;
    height: 250px;
    margin-right: 25px;
    position: relative;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    transition: transform 0.3s ease;
    background: white;
}

.train-car:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
}

.train-car-content {
    width: 100%;
    height: 100%;
    position: relative;
    overflow: hidden;
}

.train-car-image {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.5s ease;
}

.train-car:hover .train-car-image {
    transform: scale(1.05);
}

.train-car-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6) 0%, rgba(0, 0, 0, 0.3) 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.train-car:hover .train-car-overlay {
    opacity: 1;
}

.train-cta-btn {
    background: white;
    color: #000;
    padding: 0.75rem 1.5rem;
    text-decoration: none;
    font-weight: 600;
    font-size: 0.875rem;
    letter-spacing: 0.05em;
    border-radius: 6px;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    text-transform: uppercase;
}

.train-cta-btn:hover {
    background: #ff3333;
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(255, 51, 51, 0.3);
}

/* Train Animation Keyframes */
@keyframes trainMove {
    0% {
        transform: translateX(100vw);
    }
    100% {
        transform: translateX(-100%);
    }
}

/* Pause animation on hover */
.train-slider-container:hover .train-track {
    animation-play-state: paused;
}

/* Responsive Design */
@media (max-width: 1200px) {
    .train-car {
        width: 450px;
        height: 220px;
    }

    .train-slider-container {
        height: 270px;
    }
}

@media (max-width: 992px) {
    .train-car {
        width: 380px;
        height: 190px;
        margin-right: 20px;
    }

    .train-slider-container {
        height: 240px;
    }

    .train-track {
        animation-duration: 25s;
    }
}

@media (max-width: 768px) {
    .train-car {
        width: 320px;
        height: 160px;
        margin-right: 15px;
    }

    .train-slider-container {
        height: 210px;
    }

    .train-track {
        animation-duration: 20s;
    }

    .train-cta-btn {
        padding: 0.5rem 1rem;
        font-size: 0.75rem;
    }
}

@media (max-width: 576px) {
    .train-car {
        width: 280px;
        height: 140px;
        margin-right: 12px;
    }

    .train-slider-container {
        height: 190px;
    }

    .train-slider-section {
        padding: 1.5rem 0;
    }
}

/* Performance optimizations */
.train-track {
    will-change: transform;
    backface-visibility: hidden;
}

.train-car-image {
    will-change: transform;
    backface-visibility: hidden;
}

/* Accessibility */
@media (prefers-reduced-motion: reduce) {
    .train-track {
        animation: none;
    }

    .train-car,
    .train-car-image,
    .train-cta-btn {
        transition: none;
    }
}

/* Loading state */
.train-slider-container[data-loading="true"] {
    background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
    background-size: 200% 100%;
    animation: loading 1.5s infinite;
}

@keyframes loading {
    0% {
        background-position: 200% 0;
    }
    100% {
        background-position: -200% 0;
    }
}

/* High-performance CSS */
.train-track * {
    transform: translateZ(0);
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Train Slider Animation System
class TrainSlider {
    constructor(container) {
        this.container = container;
        this.wrapper = container.querySelector('.train-wrapper');
        this.track = container.querySelector('.train-track');
        this.settings = JSON.parse(this.wrapper.dataset.settings || '{}');

        this.isPlaying = true;
        this.currentSpeed = this.settings.duration || 30000; // milliseconds

        this.init();
    }

    init() {
        this.setupAnimation();
        this.bindEvents();
        this.setupIntersectionObserver();
    }

    setupAnimation() {
        // Set dynamic animation duration based on settings
        if (this.track) {
            this.track.style.animationDuration = `${this.currentSpeed}ms`;

            // Calculate optimal track width for seamless loop
            this.calculateTrackWidth();
        }
    }

    calculateTrackWidth() {
        const cars = this.track.querySelectorAll('.train-car');
        const carWidth = 500; // Updated base width
        const margin = 25; // Updated margin between cars
        const totalWidth = cars.length * (carWidth + margin);

        // Ensure track is wide enough for seamless scrolling
        this.track.style.width = `${totalWidth * 2}px`;
    }

    bindEvents() {
        // Pause on hover
        this.container.addEventListener('mouseenter', () => {
            this.pauseAnimation();
        });

        this.container.addEventListener('mouseleave', () => {
            this.resumeAnimation();
        });

        // Touch support for mobile
        this.addTouchSupport();

        // Speed control based on viewport
        this.adjustSpeedForViewport();
        window.addEventListener('resize', () => {
            this.adjustSpeedForViewport();
        });
    }

    addTouchSupport() {
        let startX = null;
        let startTime = null;

        this.container.addEventListener('touchstart', (e) => {
            startX = e.touches[0].clientX;
            startTime = Date.now();
            this.pauseAnimation();
        }, { passive: true });

        this.container.addEventListener('touchmove', (e) => {
            if (!startX) return;

            const currentX = e.touches[0].clientX;
            const diff = startX - currentX;

            // Apply slight resistance effect on swipe
            if (Math.abs(diff) > 10) {
                const transform = `translateX(calc(-100% + ${-diff * 0.1}px))`;
                this.track.style.transform = transform;
            }
        }, { passive: true });

        this.container.addEventListener('touchend', (e) => {
            if (!startX) return;

            const endX = e.changedTouches[0].clientX;
            const endTime = Date.now();
            const distance = startX - endX;
            const duration = endTime - startTime;
            const velocity = distance / duration;

            // Reset transform and resume animation
            this.track.style.transform = '';
            this.resumeAnimation();

            // Adjust speed based on swipe velocity
            if (Math.abs(velocity) > 0.5) {
                const speedMultiplier = Math.min(Math.abs(velocity) * 2, 3);
                this.adjustSpeed(speedMultiplier);

                // Reset speed after 3 seconds
                setTimeout(() => {
                    this.resetSpeed();
                }, 3000);
            }

            startX = null;
            startTime = null;
        }, { passive: true });
    }

    adjustSpeedForViewport() {
        const viewportWidth = window.innerWidth;
        let speedMultiplier = 1;

        if (viewportWidth <= 576) {
            speedMultiplier = 0.7; // Slower on mobile
        } else if (viewportWidth <= 768) {
            speedMultiplier = 0.8;
        } else if (viewportWidth <= 992) {
            speedMultiplier = 0.9;
        }

        const adjustedSpeed = this.settings.duration * speedMultiplier || 30000 * speedMultiplier;
        this.track.style.animationDuration = `${adjustedSpeed}ms`;
    }

    adjustSpeed(multiplier) {
        const newSpeed = (this.settings.duration || 30000) / multiplier;
        this.track.style.animationDuration = `${newSpeed}ms`;
    }

    resetSpeed() {
        this.setupAnimation();
    }

    pauseAnimation() {
        if (this.track) {
            this.track.style.animationPlayState = 'paused';
            this.isPlaying = false;
        }
    }

    resumeAnimation() {
        if (this.track) {
            this.track.style.animationPlayState = 'running';
            this.isPlaying = true;
        }
    }

    setupIntersectionObserver() {
        if ('IntersectionObserver' in window) {
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        this.resumeAnimation();
                    } else {
                        this.pauseAnimation();
                    }
                });
            }, {
                threshold: 0.1
            });

            observer.observe(this.container);
        }
    }
}

// Initialize Train Sliders
document.addEventListener('DOMContentLoaded', function() {
    const trainContainers = document.querySelectorAll('.train-slider-container');

    trainContainers.forEach(container => {
        new TrainSlider(container);
    });

    // Performance optimization: Preload images
    const trainImages = document.querySelectorAll('.train-car-image');
    trainImages.forEach(img => {
        const imageUrl = img.src;
        const preloadImage = new Image();
        preloadImage.src = imageUrl;
    });

    // CTA button interaction
    const ctaButtons = document.querySelectorAll('.train-cta-btn');
    ctaButtons.forEach(button => {
        button.addEventListener('click', function(e) {
            // Add click animation
            this.style.transform = 'scale(0.95)';
            setTimeout(() => {
                this.style.transform = '';
            }, 150);
        });
    });

    // Lazy loading optimization
    if ('IntersectionObserver' in window) {
        const imageObserver = new IntersectionObserver((entries, observer) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const img = entry.target;
                    if (img.dataset.src) {
                        img.src = img.dataset.src;
                        img.removeAttribute('data-src');
                        observer.unobserve(img);
                    }
                }
            });
        });

        trainImages.forEach(img => {
            if (img.dataset.src) {
                imageObserver.observe(img);
            }
        });
    }

    // Handle window focus/blur for performance
    document.addEventListener('visibilitychange', function() {
        const trainTracks = document.querySelectorAll('.train-track');

        if (document.hidden) {
            // Pause all animations when tab is not visible
            trainTracks.forEach(track => {
                track.style.animationPlayState = 'paused';
            });
        } else {
            // Resume animations when tab becomes visible
            trainTracks.forEach(track => {
                track.style.animationPlayState = 'running';
            });
        }
    });

    // Error handling for images
    trainImages.forEach(img => {
        img.addEventListener('error', function() {
            this.src = '/images/placeholder-train.jpg'; // Fallback image
            this.alt = 'Train slider image unavailable';
        });
    });

    // Accessibility improvements
    const trainSections = document.querySelectorAll('.train-slider-section');
    trainSections.forEach(section => {
        // Add keyboard navigation support
        section.setAttribute('tabindex', '0');
        section.setAttribute('role', 'region');
        section.setAttribute('aria-label', 'Train slider carousel');

        // Space bar to pause/resume
        section.addEventListener('keydown', function(e) {
            if (e.code === 'Space') {
                e.preventDefault();
                const track = this.querySelector('.train-track');
                const currentState = track.style.animationPlayState;

                if (currentState === 'paused') {
                    track.style.animationPlayState = 'running';
                } else {
                    track.style.animationPlayState = 'paused';
                }
            }
        });
    });
});

// Utility function for smooth performance
function requestAnimationFrame(callback) {
    return window.requestAnimationFrame ||
           window.webkitRequestAnimationFrame ||
           window.mozRequestAnimationFrame ||
           function(callback) { window.setTimeout(callback, 1000/60); };
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/home.blade.php ENDPATH**/ ?>