

<?php $__env->startSection('title', 'Community Posts'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Community Posts</h1>
    <a href="<?php echo e(route('admin.community.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Add New Post
    </a>
</div>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Search</label>
                <input type="text" name="search" class="form-control" value="<?php echo e(request('search')); ?>" placeholder="Name, location, or caption...">
            </div>
            <div class="col-md-3">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                    <option value="approved" <?php echo e(request('status') === 'approved' ? 'selected' : ''); ?>>Approved</option>
                    <option value="rejected" <?php echo e(request('status') === 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                </select>
            </div>
            <div class="col-md-3 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-outline-primary">
                    <i class="fas fa-search me-1"></i>Filter
                </button>
                <a href="<?php echo e(route('admin.community.index')); ?>" class="btn btn-outline-secondary">
                    <i class="fas fa-times me-1"></i>Clear
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title mb-0">Total Posts</h6>
                        <h2 class="mt-2 mb-0"><?php echo e(App\Models\CommunityPost::count()); ?></h2>
                    </div>
                    <i class="fas fa-images fa-2x opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title mb-0">Approved</h6>
                        <h2 class="mt-2 mb-0"><?php echo e(App\Models\CommunityPost::where('status', 'approved')->count()); ?></h2>
                    </div>
                    <i class="fas fa-check-circle fa-2x opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title mb-0">Pending</h6>
                        <h2 class="mt-2 mb-0"><?php echo e(App\Models\CommunityPost::where('status', 'pending')->count()); ?></h2>
                    </div>
                    <i class="fas fa-clock fa-2x opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title mb-0">Featured</h6>
                        <h2 class="mt-2 mb-0"><?php echo e(App\Models\CommunityPost::where('featured', true)->count()); ?></h2>
                    </div>
                    <i class="fas fa-star fa-2x opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bulk Actions -->
<div class="card">
    <div class="card-body">
        <form id="bulkForm" method="POST" action="<?php echo e(route('admin.community.bulk-action')); ?>">
            <?php echo csrf_field(); ?>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center gap-2">
                    <select name="action" class="form-select" style="width: auto;">
                        <option value="">Bulk Actions</option>
                        <option value="approve">Approve Selected</option>
                        <option value="reject">Reject Selected</option>
                        <option value="toggle_featured">Toggle Featured</option>
                        <option value="delete">Delete Selected</option>
                    </select>
                    <button type="submit" class="btn btn-outline-secondary" onclick="return confirmBulkAction()">Apply</button>
                </div>
                <span class="text-muted"><?php echo e($communityPosts->total()); ?> total posts</span>
            </div>

            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th style="width:50px;">
                                <input type="checkbox" id="selectAll" class="form-check-input">
                            </th>
                            <th style="width:100px;">Image</th>
                            <th>Name</th>
                            <th>Location</th>
                            <th>Caption</th>
                            <th>Status</th>
                            <th>Featured</th>
                            <th>Likes</th>
                            <th>Date</th>
                            <th style="width:200px;">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $communityPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <input type="checkbox" name="posts[]" value="<?php echo e($post->id); ?>" class="form-check-input post-checkbox">
                            </td>
                            <td>
                                <?php if($post->image_path): ?>
                                    <img src="<?php echo e(asset('images/' . $post->image_path)); ?>" alt="<?php echo e($post->name); ?>" width="60" height="60" class="rounded" style="object-fit:cover;">
                                <?php else: ?>
                                    <div class="bg-light text-center text-muted rounded" style="width:60px;height:60px;display:flex;align-items:center;justify-content:center;">
                                        <i class="fas fa-image"></i>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <strong><?php echo e($post->name); ?></strong>
                                <?php if($post->instagram_handle): ?>
                                    <br><small class="text-muted"><i class="fab fa-instagram"></i> <?php echo e($post->instagram_handle); ?></small>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($post->location); ?></td>
                            <td>
                                <span title="<?php echo e($post->caption); ?>">
                                    <?php echo e(Str::limit($post->caption, 50)); ?>

                                </span>
                                <?php if($post->products_featured): ?>
                                    <br><small class="text-info">Products: <?php echo e($post->products_featured); ?></small>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php switch($post->status):
                                    case ('approved'): ?>
                                        <span class="badge bg-success">Approved</span>
                                        <?php break; ?>
                                    <?php case ('pending'): ?>
                                        <span class="badge bg-warning">Pending</span>
                                        <?php break; ?>
                                    <?php case ('rejected'): ?>
                                        <span class="badge bg-danger">Rejected</span>
                                        <?php break; ?>
                                <?php endswitch; ?>
                            </td>
                            <td>
                                <button type="button" class="btn btn-sm <?php echo e($post->featured ? 'btn-warning' : 'btn-outline-warning'); ?>" 
                                        onclick="toggleFeatured(<?php echo e($post->id); ?>)">
                                    <i class="fas fa-star"></i>
                                </button>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark">
                                    <i class="fas fa-heart text-danger"></i> <?php echo e($post->likes); ?>

                                </span>
                            </td>
                            <td>
                                <small><?php echo e($post->created_at->format('M d, Y')); ?></small>
                                <?php if($post->approved_at): ?>
                                    <br><small class="text-success">Approved: <?php echo e($post->approved_at->format('M d')); ?></small>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="<?php echo e(route('admin.community.show', $post)); ?>" class="btn btn-outline-info" title="View">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.community.edit', $post)); ?>" class="btn btn-outline-primary" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <?php if($post->status === 'pending'): ?>
                                        <form method="POST" action="<?php echo e(route('admin.community.approve', $post)); ?>" style="display:inline;">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-outline-success" title="Approve">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                        <form method="POST" action="<?php echo e(route('admin.community.reject', $post)); ?>" style="display:inline;">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-outline-danger" title="Reject">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                    <form method="POST" action="<?php echo e(route('admin.community.destroy', $post)); ?>" style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-outline-danger" title="Delete" 
                                                onclick="return confirm('Are you sure you want to delete this post?')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10" class="text-center py-4">
                                <i class="fas fa-images fa-3x text-muted mb-3"></i>
                                <p class="text-muted">No community posts found.</p>
                                <a href="<?php echo e(route('admin.community.create')); ?>" class="btn btn-primary">
                                    <i class="fas fa-plus me-2"></i>Create First Post
                                </a>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </form>
        
        <?php if($communityPosts->hasPages()): ?>
            <div class="d-flex justify-content-center mt-4">
                <?php echo e($communityPosts->withQueryString()->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Select All functionality
document.getElementById('selectAll').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.post-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});

// Toggle featured status
function toggleFeatured(postId) {
    fetch(`<?php echo e(url('admin/community')); ?>/${postId}/toggle-featured`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Content-Type': 'application/json',
        },
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while updating featured status.');
    });
}

// Confirm bulk actions
function confirmBulkAction() {
    const selectedAction = document.querySelector('select[name="action"]').value;
    const checkedBoxes = document.querySelectorAll('.post-checkbox:checked');
    
    if (!selectedAction) {
        alert('Please select an action.');
        return false;
    }
    
    if (checkedBoxes.length === 0) {
        alert('Please select at least one post.');
        return false;
    }
    
    const actionNames = {
        'approve': 'approve',
        'reject': 'reject', 
        'toggle_featured': 'toggle featured status for',
        'delete': 'delete'
    };
    
    return confirm(`Are you sure you want to ${actionNames[selectedAction]} ${checkedBoxes.length} selected post(s)?`);
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/admin/community/index.blade.php ENDPATH**/ ?>