<!-- login.blade.php -->


<?php $__env->startSection('title', 'Login'); ?>
<?php $__env->startSection('meta_description', 'Login to your Edition By Punjab account'); ?>

<?php $__env->startSection('content'); ?>
<div class="auth-page-premium">
    <div class="auth-background">
        <div class="auth-pattern"></div>
        <div class="auth-gradient"></div>
    </div>
    
    <div class="container">
        <div class="auth-container" data-aos="zoom-in">
            <div class="auth-card-premium">
                <!-- Logo Section -->
                <div class="auth-header">
                    <h2 class="auth-title">Welcome Back</h2>
                    <p class="auth-subtitle">Login to your account to continue</p>
                </div>

                <!-- Login Form -->
                <form method="POST" action="<?php echo e(route('login')); ?>" class="auth-form-premium">
                    <?php echo csrf_field(); ?>

                    <div class="form-group-auth">
                        <label for="email" class="form-label-auth">Email Address</label>
                        <div class="input-group-auth">
                            <span class="input-icon"><i class="fas fa-envelope"></i></span>
                            <input id="email" 
                                   type="email" 
                                   class="form-control-auth <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="email" 
                                   value="<?php echo e(old('email')); ?>" 
                                   placeholder="Enter your email"
                                   required 
                                   autocomplete="email" 
                                   autofocus>
                        </div>
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-text"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group-auth">
                        <label for="password" class="form-label-auth">Password</label>
                        <div class="input-group-auth">
                            <span class="input-icon"><i class="fas fa-lock"></i></span>
                            <input id="password" 
                                   type="password" 
                                   class="form-control-auth <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="password" 
                                   placeholder="Enter your password"
                                   required 
                                   autocomplete="current-password">
                            <button type="button" class="password-toggle-auth" onclick="toggleAuthPassword('password')">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-text"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-options">
                        <div class="form-check-auth">
                            <input class="check-input-auth" 
                                   type="checkbox" 
                                   name="remember" 
                                   id="remember" 
                                   <?php echo e(old('remember') ? 'checked' : ''); ?>>
                            <label class="check-label-auth" for="remember">
                                Remember Me
                            </label>
                        </div>
                        
                        <?php if(Route::has('password.request')): ?>
                            <a href="<?php echo e(route('password.request')); ?>" class="forgot-link">
                                Forgot Password?
                            </a>
                        <?php endif; ?>
                    </div>

                    <button type="submit" class="btn-auth-submit">
                        <span class="btn-text">LOGIN</span>
                        <i class="fas fa-arrow-right"></i>
                    </button>
                </form>

                <!-- Register Link -->
                <div class="auth-footer">
                    <p>Don't have an account?</p>
                    <a href="<?php echo e(route('register')); ?>" class="auth-link">
                        Create New Account
                        <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
/* Auth Page Styles */
.auth-page-premium {
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    padding: 2rem 0;
}

.auth-background {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    overflow: hidden;
}

.auth-pattern {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-image: repeating-linear-gradient(
        45deg,
        transparent,
        transparent 35px,
        rgba(0,0,0,.02) 35px,
        rgba(0,0,0,.02) 70px
    );
}

.auth-gradient {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    opacity: 0.95;
}

.auth-container {
    position: relative;
    z-index: 1;
    width: 100%;
    max-width: 480px;
    margin: 0 auto;
}

.auth-card-premium {
    background: white;
    padding: 3rem;
    box-shadow: 0 20px 60px rgba(0,0,0,0.3);
    overflow: hidden;
    position: relative;
}

.auth-card-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 5px;
    background: linear-gradient(90deg, #000 0%, #666 50%, #000 100%);
    animation: shimmer 2s infinite;
}

@keyframes shimmer {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

/* Auth Header */
.auth-header {
    text-align: center;
    margin-bottom: 2.5rem;
}

.auth-logo {
    height: 60px;
    margin-bottom: 1.5rem;
}

.auth-title {
    font-size: 2rem;
    font-weight: 800;
    color: #000;
    margin-bottom: 0.5rem;
    font-family: 'Space Grotesk', sans-serif;
}

.auth-subtitle {
    color: #666;
}

/* Form Elements */
.form-group-auth {
    margin-bottom: 1.5rem;
}

.form-label-auth {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #333;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.input-group-auth {
    position: relative;
}

.input-icon {
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #999;
    border-right: 1px solid #e0e0e0;
}

.form-control-auth {
    width: 100%;
    padding: 1rem 1rem 1rem 60px;
    border: 2px solid #e0e0e0;
    font-size: 1rem;
    transition: all 0.3s;
}

.form-control-auth:focus {
    outline: none;
    border-color: #000;
    box-shadow: 0 0 0 3px rgba(0,0,0,0.05);
}

.form-control-auth.is-invalid {
    border-color: #f44336;
}

.password-toggle-auth {
    position: absolute;
    right: 1rem;
    top: 50%;
    transform: translateY(-50%);
    background: none;
    border: none;
    color: #999;
    cursor: pointer;
    transition: color 0.3s;
}

.password-toggle-auth:hover {
    color: #333;
}

.error-text {
    display: block;
    color: #f44336;
    font-size: 0.875rem;
    margin-top: 0.5rem;
}

/* Form Options */
.form-options {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2rem;
}

.form-check-auth {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.check-input-auth {
    width: 18px;
    height: 18px;
    cursor: pointer;
}

.check-label-auth {
    cursor: pointer;
    user-select: none;
    font-size: 0.875rem;
}

.forgot-link {
    color: #666;
    text-decoration: none;
    font-size: 0.875rem;
    transition: color 0.3s;
}

.forgot-link:hover {
    color: #000;
}

/* Submit Button */
.btn-auth-submit {
    width: 100%;
    padding: 1rem;
    background: #000;
    color: white;
    border: none;
    font-weight: 700;
    letter-spacing: 0.1em;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    position: relative;
    overflow: hidden;
}

.btn-auth-submit::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
    transition: left 0.5s;
}

.btn-auth-submit:hover::before {
    left: 100%;
}

.btn-auth-submit:hover {
    background: #333;
    transform: translateY(-2px);
}

/* Auth Divider */
.auth-divider {
    text-align: center;
    margin: 2rem 0;
    position: relative;
}

.auth-divider::before,
.auth-divider::after {
    content: '';
    position: absolute;
    top: 50%;
    width: calc(50% - 30px);
    height: 1px;
    background: #e0e0e0;
}

.auth-divider::before {
    left: 0;
}

.auth-divider::after {
    right: 0;
}

.auth-divider span {
    padding: 0 1rem;
    background: white;
    color: #999;
    font-size: 0.875rem;
}

/* Social Auth */
.social-auth {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.btn-social {
    padding: 0.875rem;
    background: white;
    border: 2px solid #e0e0e0;
    color: #333;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.75rem;
}

.btn-social:hover {
    transform: translateY(-2px);
}

.btn-social.google:hover {
    background: #4285F4;
    border-color: #4285F4;
    color: white;
}

.btn-social.facebook:hover {
    background: #1877F2;
    border-color: #1877F2;
    color: white;
}

/* Auth Footer */
.auth-footer {
    text-align: center;
    margin-top: 2rem;
    padding-top: 2rem;
    border-top: 1px solid #e0e0e0;
}

.auth-footer p {
    color: #666;
    margin-bottom: 0.5rem;
}

.auth-link {
    color: #000;
    text-decoration: none;
    font-weight: 600;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    transition: all 0.3s;
}

.auth-link:hover {
    transform: translateX(5px);
    color: #333;
}

/* Responsive */
@media (max-width: 576px) {
    .auth-card-premium {
        padding: 2rem 1.5rem;
    }
    
    .auth-title {
        font-size: 1.5rem;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function toggleAuthPassword(fieldId) {
    const field = document.getElementById(fieldId);
    const icon = field.parentElement.querySelector('.password-toggle-auth i');
    
    if (field.type === 'password') {
        field.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        field.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

// Form submission animation
document.querySelector('.auth-form-premium')?.addEventListener('submit', function(e) {
    const button = this.querySelector('.btn-auth-submit');
    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Logging in...';
    button.disabled = true;
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio8\resources\views/auth/login.blade.php ENDPATH**/ ?>