<?php $__env->startSection('title', $story['meta_title']); ?>
<?php $__env->startSection('meta_description', $story['meta_description']); ?>
<?php $__env->startSection('meta_keywords', $story['keywords']); ?>

<?php $__env->startPush('meta-tags'); ?>
<!-- Open Graph / Facebook -->
<meta property="og:type" content="article">
<meta property="og:title" content="<?php echo e($story['title']); ?>">
<meta property="og:description" content="<?php echo e($story['excerpt']); ?>">
<meta property="og:image" content="<?php echo e(asset('storage/' . $story['image'])); ?>">
<meta property="og:url" content="<?php echo e(request()->url()); ?>">
<meta property="og:site_name" content="Edition By Punjab">

<!-- Twitter -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?php echo e($story['title']); ?>">
<meta name="twitter:description" content="<?php echo e($story['excerpt']); ?>">
<meta name="twitter:image" content="<?php echo e(asset('storage/' . $story['image'])); ?>">

<!-- Article specific -->
<meta property="article:author" content="<?php echo e($story['author']); ?>">
<meta property="article:published_time" content="<?php echo e($story['published_date']); ?>T09:00:00+10:00">
<meta property="article:section" content="Fashion News">
<meta property="article:tag" content="Australian Fashion">
<meta property="article:tag" content="Streetwear Australia">
<meta property="article:tag" content="Cultural Fashion">

<!-- Schema.org structured data -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "NewsArticle",
    "headline": "<?php echo e($story['title']); ?>",
    "image": "<?php echo e(asset('storage/' . $story['image'])); ?>",
    "datePublished": "<?php echo e($story['published_date']); ?>T09:00:00+10:00",
    "dateModified": "<?php echo e($story['published_date']); ?>T09:00:00+10:00",
    "author": {
        "@type": "Person",
        "name": "<?php echo e($story['author']); ?>"
    },
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "logo": {
            "@type": "ImageObject",
            "url": "<?php echo e(asset('images/logo.png')); ?>"
        }
    },
    "description": "<?php echo e($story['excerpt']); ?>",
    "mainEntityOfPage": {
        "@type": "WebPage",
        "@id": "<?php echo e(request()->url()); ?>"
    },
    "keywords": "<?php echo e($story['keywords']); ?>",
    "articleSection": "Fashion News",
    "wordCount": "<?php echo e(str_word_count(strip_tags($story['content']))); ?>",
    "timeRequired": "PT<?php echo e($story['read_time']); ?>M"
}
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
    <!-- Breadcrumb -->
    <section class="breadcrumb-section py-3 bg-light">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('trends.index')); ?>">Fashion Trends</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('trends.news')); ?>">Fashion News</a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(Str::limit($story['title'], 50)); ?></li>
                </ol>
            </nav>
        </div>
    </section>

    <!-- Article Header -->
    <article class="news-article">
        <header class="article-header py-5" style="background: linear-gradient(rgba(0,0,0,0.6), rgba(0,0,0,0.6)), url('<?php echo e(asset('storage/' . $story['image'])); ?>') center/cover;">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="article-meta mb-3 text-center">
                            <!-- Category Badge -->
                            <span class="badge 
                                <?php if($story['category'] === 'Brand News'): ?>
                                    bg-primary
                                <?php elseif($story['category'] === 'Industry News'): ?>
                                    bg-success
                                <?php else: ?>
                                    bg-warning text-dark
                                <?php endif; ?>
                                px-3 py-2 me-3">
                                <?php echo e($story['category']); ?>

                            </span>
                            
                            <!-- Publication Date -->
                            <span class="text-light">
                                <i class="fas fa-calendar me-2"></i>
                                <?php echo e(date('F j, Y', strtotime($story['published_date']))); ?>

                            </span>
                        </div>

                        <!-- Article Title -->
                        <h1 class="article-title display-4 fw-bold text-white text-center mb-4">
                            <?php echo e($story['title']); ?>

                        </h1>

                        <!-- Article Meta -->
                        <div class="article-info d-flex justify-content-center align-items-center gap-4 text-light">
                            <div class="author-info">
                                <i class="fas fa-user-circle me-2"></i>
                                <span><?php echo e($story['author']); ?></span>
                            </div>
                            <div class="read-time">
                                <i class="fas fa-clock me-2"></i>
                                <span><?php echo e($story['read_time']); ?> min read</span>
                            </div>
                            <div class="share-buttons">
                                <button class="btn btn-outline-light btn-sm" onclick="shareArticle()">
                                    <i class="fas fa-share-alt me-2"></i>Share
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <!-- Article Content -->
        <section class="article-content py-5">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <!-- Article Excerpt -->
                        <div class="article-excerpt mb-5">
                            <p class="lead text-muted fs-5 lh-lg"><?php echo e($story['excerpt']); ?></p>
                        </div>

                        <!-- Main Content -->
                        <div class="article-body">
                            <?php echo $story['content']; ?>

                        </div>

                        <!-- Article Tags -->
                        <div class="article-tags mt-5 pt-4 border-top">
                            <h6 class="fw-bold mb-3">Related Topics:</h6>
                            <div class="d-flex flex-wrap gap-2">
                                <?php $__currentLoopData = explode(', ', $story['keywords']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keyword): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge bg-light text-dark border px-3 py-2"><?php echo e($keyword); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                        <!-- Social Share -->
                        <div class="social-share mt-4 pt-4 border-top">
                            <h6 class="fw-bold mb-3">Share This Article:</h6>
                            <div class="d-flex gap-3">
                                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(request()->url())); ?>" 
                                   target="_blank" class="btn btn-outline-primary">
                                    <i class="fab fa-facebook-f me-2"></i>Facebook
                                </a>
                                <a href="https://twitter.com/intent/tweet?text=<?php echo e(urlencode($story['title'])); ?>&url=<?php echo e(urlencode(request()->url())); ?>" 
                                   target="_blank" class="btn btn-outline-info">
                                    <i class="fab fa-twitter me-2"></i>Twitter
                                </a>
                                <a href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo e(urlencode(request()->url())); ?>" 
                                   target="_blank" class="btn btn-outline-primary">
                                    <i class="fab fa-linkedin-in me-2"></i>LinkedIn
                                </a>
                                <button class="btn btn-outline-secondary" onclick="copyToClipboard()">
                                    <i class="fas fa-copy me-2"></i>Copy Link
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Related Articles -->
        <?php if($relatedStories && $relatedStories->count() > 0): ?>
        <section class="related-articles py-5 bg-light">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h3 class="text-center mb-5 fw-bold">Related Articles</h3>
                    </div>
                </div>
                <div class="row g-4">
                    <?php $__currentLoopData = $relatedStories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedStory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-6">
                        <article class="related-card card border-0 shadow-sm h-100">
                            <img src="<?php echo e(asset('storage/' . $relatedStory['image'])); ?>" 
                                 class="card-img-top" 
                                 alt="<?php echo e($relatedStory['title']); ?>"
                                 style="height: 200px; object-fit: cover;">
                            
                            <div class="card-body d-flex flex-column">
                                <div class="article-meta mb-2">
                                    <span class="badge bg-light text-dark"><?php echo e($relatedStory['category']); ?></span>
                                    <small class="text-muted ms-2">
                                        <?php echo e(date('M j, Y', strtotime($relatedStory['published_date']))); ?>

                                    </small>
                                </div>
                                <h5 class="card-title">
                                    <a href="<?php echo e(route('trends.news.story', $relatedStory['slug'])); ?>" 
                                       class="text-decoration-none text-dark">
                                        <?php echo e($relatedStory['title']); ?>

                                    </a>
                                </h5>
                                <p class="card-text text-muted flex-grow-1"><?php echo e($relatedStory['excerpt']); ?></p>
                                <a href="<?php echo e(route('trends.news.story', $relatedStory['slug'])); ?>" 
                                   class="btn btn-outline-primary mt-auto">
                                    Read More
                                </a>
                            </div>
                        </article>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
        <?php endif; ?>

        <!-- Newsletter Subscription -->
        <section class="newsletter-cta py-5 bg-primary text-white">
            <div class="container">
                <div class="row justify-content-center text-center">
                    <div class="col-lg-8">
                        <h3 class="fw-bold mb-3">Stay Updated with Fashion News</h3>
                        <p class="lead mb-4">Get the latest Australian fashion news and trends delivered to your inbox</p>
                        <form class="newsletter-form d-flex gap-3 justify-content-center">
                            <input type="email" class="form-control form-control-lg" 
                                   placeholder="Enter your email" style="max-width: 400px;" required>
                            <button type="submit" class="btn btn-light btn-lg px-4">
                                <i class="fas fa-paper-plane me-2"></i>Subscribe
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </section>

        <!-- Navigation Links -->
        <section class="article-navigation py-4 bg-dark text-white">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <a href="<?php echo e(route('trends.news')); ?>" class="btn btn-outline-light">
                            <i class="fas fa-arrow-left me-2"></i>Back to Fashion News
                        </a>
                    </div>
                    <div class="col-md-6 text-md-end mt-3 mt-md-0">
                        <a href="<?php echo e(route('trends.index')); ?>" class="btn btn-outline-light me-3">
                            All Trends
                        </a>
                        <a href="<?php echo e(route('shop.index')); ?>" class="btn btn-light">
                            Shop Now
                        </a>
                    </div>
                </div>
            </div>
        </section>
    </article>
</div>

<style>
.story-content h3 {
    color: #2c3e50;
    font-weight: 700;
    margin: 2rem 0 1rem 0;
    font-size: 1.5rem;
}

.story-content p {
    line-height: 1.8;
    margin-bottom: 1.2rem;
    color: #4a4a4a;
    font-size: 1.1rem;
}

.story-content .lead {
    font-size: 1.3rem;
    line-height: 1.6;
    color: #2c3e50;
    font-weight: 400;
}

.story-content blockquote {
    background: #f8f9fa;
    border-left: 4px solid #3b82f6;
    padding: 1.5rem;
    margin: 2rem 0;
    font-style: italic;
}

.story-content blockquote p {
    margin-bottom: 0.5rem;
    font-size: 1.2rem;
}

.story-content blockquote .blockquote-footer {
    color: #6c757d;
    margin-top: 0.5rem;
}

.article-body {
    font-family: Georgia, 'Times New Roman', serif;
    font-size: 1.1rem;
    line-height: 1.8;
}

.related-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.related-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15) !important;
}

.article-header {
    position: relative;
}

.article-header::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(45deg, rgba(59, 130, 246, 0.8), rgba(147, 51, 234, 0.8));
    z-index: -1;
}

.social-share .btn:hover {
    transform: translateY(-2px);
}

@media (max-width: 768px) {
    .article-title {
        font-size: 2rem !important;
    }
    
    .article-info {
        flex-direction: column;
        gap: 1rem !important;
    }
}
</style>

<script>
function shareArticle() {
    if (navigator.share) {
        navigator.share({
            title: '<?php echo e($story['title']); ?>',
            text: '<?php echo e($story['excerpt']); ?>',
            url: window.location.href
        });
    } else {
        copyToClipboard();
    }
}

function copyToClipboard() {
    navigator.clipboard.writeText(window.location.href).then(() => {
        // Show success message
        const btn = event.target.closest('button');
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check me-2"></i>Copied!';
        btn.classList.remove('btn-outline-secondary');
        btn.classList.add('btn-success');
        
        setTimeout(() => {
            btn.innerHTML = originalText;
            btn.classList.remove('btn-success');
            btn.classList.add('btn-outline-secondary');
        }, 2000);
    });
}

// Newsletter subscription
document.querySelector('.newsletter-form').addEventListener('submit', function(e) {
    e.preventDefault();
    const email = this.querySelector('input[type="email"]').value;
    
    // Here you would typically send to your newsletter service
    alert('Thank you for subscribing! We\'ll keep you updated with the latest fashion news.');
    this.querySelector('input[type="email"]').value = '';
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/trends/news-story.blade.php ENDPATH**/ ?>