<?php $__env->startSection('title', 'Submit Your Style - Community Gallery | Edition By Punjab'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="Share your Edition By Punjab streetwear style with our Australian community. Submit photos and join our gallery of fashion-forward customers.">
<meta name="keywords" content="submit photos, community gallery, user generated content, streetwear community, fashion submission, style sharing">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if (isset($component)) { $__componentOriginal269900abaed345884ce342681cdc99f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal269900abaed345884ce342681cdc99f6 = $attributes; } ?>
<?php $component = App\View\Components\Breadcrumb::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $attributes = $__attributesOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__attributesOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $component = $__componentOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__componentOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>

<!-- Premium Submit Hero -->
<section class="submit-hero-premium">
    <div class="hero-pattern"></div>
    <div class="container">
        <div class="hero-content-center" data-aos="fade-up">
            <span class="hero-label">SUBMIT</span>
            <h1 class="hero-title-premium">SHARE YOUR STYLE</h1>
            <p class="hero-subtitle">Join our community of fashion-forward Australians and showcase how you style your Edition By Punjab pieces</p>
        </div>
    </div>
    <div class="scroll-indicator">
        <span></span>
    </div>
</section>

<!-- Submission Guidelines -->
<section class="guidelines py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="text-center mb-5">
                    <h2 class="mb-3">Submission Guidelines</h2>
                    <p class="lead text-muted">Follow these simple guidelines to get your style featured</p>
                </div>
                
                <div class="row g-4">
                    <div class="col-md-4">
                        <div class="guideline-card text-center p-4">
                            <div class="guideline-icon mb-3">
                                <i class="fas fa-camera fa-3x text-primary"></i>
                            </div>
                            <h5 class="mb-3">High Quality Photos</h5>
                            <ul class="text-start text-muted">
                                <li>Minimum 1080px resolution</li>
                                <li>Good lighting (natural preferred)</li>
                                <li>Clear focus on the outfit</li>
                                <li>Full body or detailed shots</li>
                            </ul>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="guideline-card text-center p-4">
                            <div class="guideline-icon mb-3">
                                <i class="fas fa-tshirt fa-3x text-primary"></i>
                            </div>
                            <h5 class="mb-3">Feature Our Products</h5>
                            <ul class="text-start text-muted">
                                <li>At least one Edition By Punjab piece</li>
                                <li>Show styling creativity</li>
                                <li>Mix with other brands welcome</li>
                                <li>Tag the products you're wearing</li>
                            </ul>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="guideline-card text-center p-4">
                            <div class="guideline-icon mb-3">
                                <i class="fas fa-heart fa-3x text-primary"></i>
                            </div>
                            <h5 class="mb-3">Share Your Story</h5>
                            <ul class="text-start text-muted">
                                <li>Tell us about your outfit</li>
                                <li>Where are you from in Australia?</li>
                                <li>What's the occasion?</li>
                                <li>Style inspiration or tips</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Submission Form -->
<section class="submission-form-premium">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="form-card-premium" data-aos="fade-up">
                    <div class="form-header-premium">
                        <span class="form-label">SUBMIT STYLE</span>
                        <h2 class="form-title">Share Your Look</h2>
                        <p class="form-subtitle">Show us how you style Edition By Punjab pieces</p>
                    </div>
                    
                    <?php if(session('success')): ?>
                    <div class="alert alert-success premium-alert" data-aos="fade-down">
                        <i class="fas fa-check-circle"></i>
                        <span><?php echo e(session('success')); ?></span>
                        <button class="alert-close" onclick="this.parentElement.style.display='none'">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                    <div class="alert alert-danger premium-alert" data-aos="fade-down">
                        <i class="fas fa-exclamation-circle"></i>
                        <span><?php echo e(session('error')); ?></span>
                        <button class="alert-close" onclick="this.parentElement.style.display='none'">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    <?php endif; ?>

                    <?php if($errors->any()): ?>
                    <div class="alert alert-danger premium-alert" data-aos="fade-down">
                        <i class="fas fa-exclamation-circle"></i>
                        <span>Please correct the errors below</span>
                    </div>
                    <?php endif; ?>
                    
                    <form id="styleSubmissionForm" action="<?php echo e(route('community.submit.store')); ?>" method="POST" enctype="multipart/form-data" class="contact-form-premium">
                        <?php echo csrf_field(); ?>
                        
                        <!-- Photo Upload -->
                        <div class="form-group-premium upload-group">
                            <label class="form-label-premium">Upload Your Photo *</label>
                            <div class="upload-area-premium <?php $__errorArgs = ['photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="uploadArea">
                                <input type="file" id="photo" name="photo" class="upload-input" accept="image/*" required>
                                <div class="upload-content" id="uploadContent">
                                    <i class="fas fa-cloud-upload-alt"></i>
                                    <h4>Click to upload or drag and drop</h4>
                                    <p>JPG, PNG or GIF (max 10MB)</p>
                                </div>
                                <div class="image-preview d-none" id="imagePreview">
                                    <img id="previewImg" class="preview-image">
                                    <button type="button" class="remove-image" id="removeImage">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                            <?php $__errorArgs = ['photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-text"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="row">
                            <!-- Personal Info -->
                            <div class="col-md-6">
                                <div class="form-group-premium">
                                    <input type="text" 
                                           class="form-input-premium <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="name" 
                                           name="name" 
                                           value="<?php echo e(old('name')); ?>" 
                                           placeholder="" 
                                           required>
                                    <label for="name" class="form-label-premium">Your Name *</label>
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-text"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group-premium">
                                    <select class="form-select-premium <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="location" name="location" required>
                                        <option value="">Select your city</option>
                                        <option value="Melbourne, VIC" <?php echo e(old('location') == 'Melbourne, VIC' ? 'selected' : ''); ?>>Melbourne, VIC</option>
                                        <option value="Sydney, NSW" <?php echo e(old('location') == 'Sydney, NSW' ? 'selected' : ''); ?>>Sydney, NSW</option>
                                        <option value="Brisbane, QLD" <?php echo e(old('location') == 'Brisbane, QLD' ? 'selected' : ''); ?>>Brisbane, QLD</option>
                                        <option value="Perth, WA" <?php echo e(old('location') == 'Perth, WA' ? 'selected' : ''); ?>>Perth, WA</option>
                                        <option value="Adelaide, SA" <?php echo e(old('location') == 'Adelaide, SA' ? 'selected' : ''); ?>>Adelaide, SA</option>
                                        <option value="Canberra, ACT" <?php echo e(old('location') == 'Canberra, ACT' ? 'selected' : ''); ?>>Canberra, ACT</option>
                                        <option value="Darwin, NT" <?php echo e(old('location') == 'Darwin, NT' ? 'selected' : ''); ?>>Darwin, NT</option>
                                        <option value="Hobart, TAS" <?php echo e(old('location') == 'Hobart, TAS' ? 'selected' : ''); ?>>Hobart, TAS</option>
                                        <option value="Gold Coast, QLD" <?php echo e(old('location') == 'Gold Coast, QLD' ? 'selected' : ''); ?>>Gold Coast, QLD</option>
                                        <option value="Newcastle, NSW" <?php echo e(old('location') == 'Newcastle, NSW' ? 'selected' : ''); ?>>Newcastle, NSW</option>
                                        <option value="Wollongong, NSW" <?php echo e(old('location') == 'Wollongong, NSW' ? 'selected' : ''); ?>>Wollongong, NSW</option>
                                        <option value="Other" <?php echo e(old('location') == 'Other' ? 'selected' : ''); ?>>Other Australian City</option>
                                    </select>
                                    <label for="location" class="form-label-premium">Location *</label>
                                    <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-text"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Products Featured -->
                        <div class="form-group-premium">
                            <input type="text" 
                                   class="form-input-premium" 
                                   id="products" 
                                   name="products" 
                                   value="<?php echo e(old('products')); ?>" 
                                   placeholder="">
                            <label for="products" class="form-label-premium">Edition By Punjab Products Featured</label>
                            <span class="form-hint">List the Edition By Punjab items you're wearing</span>
                        </div>
                        
                        <!-- Story/Caption -->
                        <div class="form-group-premium">
                            <textarea class="form-textarea-premium <?php $__errorArgs = ['caption'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="caption" 
                                      name="caption" 
                                      rows="5" 
                                      placeholder="" 
                                      required><?php echo e(old('caption')); ?></textarea>
                            <label for="caption" class="form-label-premium">Tell Us About Your Style *</label>
                            <span class="form-hint">Minimum 50 characters. Share your styling story!</span>
                            <?php $__errorArgs = ['caption'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-text"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <!-- Instagram Handle -->
                        <div class="form-group-premium">
                            <div class="input-group-premium">
                                <span class="input-prefix">@</span>
                                <input type="text" 
                                       class="form-input-premium" 
                                       id="instagram" 
                                       name="instagram" 
                                       value="<?php echo e(old('instagram')); ?>" 
                                       placeholder="">
                                <label for="instagram" class="form-label-premium">Instagram Handle (Optional)</label>
                            </div>
                            <span class="form-hint">We'll tag you if we share your photo on our social media</span>
                        </div>
                        
                        <!-- Consent Checkboxes -->
                        <div class="consent-section-premium">
                            <h4 class="consent-title">Permissions</h4>
                            
                            <div class="form-check-premium">
                                <input class="form-check-input" type="checkbox" id="consent_gallery" name="consent_gallery" required <?php echo e(old('consent_gallery') ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="consent_gallery">
                                    <span class="checkmark"></span>
                                    I consent to my photo being displayed in the Edition By Punjab community gallery *
                                </label>
                                <?php $__errorArgs = ['consent_gallery'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-text"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            
                            <div class="form-check-premium">
                                <input class="form-check-input" type="checkbox" id="consent_social" name="consent_social" <?php echo e(old('consent_social') ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="consent_social">
                                    <span class="checkmark"></span>
                                    I consent to my photo being shared on Edition By Punjab social media channels
                                </label>
                            </div>
                            
                            <div class="form-check-premium">
                                <input class="form-check-input" type="checkbox" id="consent_marketing" name="consent_marketing" <?php echo e(old('consent_marketing') ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="consent_marketing">
                                    <span class="checkmark"></span>
                                    I consent to being contacted about potential collaborations or features
                                </label>
                            </div>
                        </div>
                        
                        <!-- Submit Button -->
                        <div class="form-actions">
                            <button type="submit" class="btn-submit-form primary submit-btn">
                                <span class="btn-text">SUBMIT MY STYLE</span>
                                <span class="btn-loader d-none">
                                    <span class="spinner"></span>
                                </span>
                                <i class="fas fa-paper-plane"></i>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Recent Submissions Preview -->
<section class="recent-submissions-premium">
    <div class="container">
        <div class="section-header-premium text-center" data-aos="fade-up">
            <span class="section-label-premium">RECENT</span>
            <h2 class="section-title-premium">Community Submissions</h2>
            <p class="section-subtitle">See what others are sharing</p>
        </div>
        
        <div class="recent-grid-premium">
            <div class="recent-item-premium" data-aos="zoom-in">
                <div class="recent-image-wrapper">
                    <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => 'community/recent-1.jpg','alt' => 'Recent submission from Sarah M.','class' => 'recent-image'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['loading' => 'lazy']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                    <div class="recent-overlay">
                        <div class="recent-info">
                            <h6>SARAH M.</h6>
                            <span>MELBOURNE</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="recent-item-premium" data-aos="zoom-in" data-aos-delay="100">
                <div class="recent-image-wrapper">
                    <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => 'community/recent-2.jpg','alt' => 'Recent submission from Jake K.','class' => 'recent-image'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['loading' => 'lazy']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                    <div class="recent-overlay">
                        <div class="recent-info">
                            <h6>JAKE K.</h6>
                            <span>SYDNEY</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="recent-item-premium" data-aos="zoom-in" data-aos-delay="200">
                <div class="recent-image-wrapper">
                    <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => 'community/recent-3.jpg','alt' => 'Recent submission from Preet D.','class' => 'recent-image'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['loading' => 'lazy']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                    <div class="recent-overlay">
                        <div class="recent-info">
                            <h6>PREET D.</h6>
                            <span>BRISBANE</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="recent-item-premium" data-aos="zoom-in" data-aos-delay="300">
                <div class="recent-image-wrapper">
                    <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => 'community/recent-4.jpg','alt' => 'Recent submission from Alex R.','class' => 'recent-image'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['loading' => 'lazy']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                    <div class="recent-overlay">
                        <div class="recent-info">
                            <h6>ALEX R.</h6>
                            <span>PERTH</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="text-center mt-5">
            <a href="<?php echo e(route('community.gallery')); ?>" class="btn-submit-cta secondary">
                <span>VIEW FULL GALLERY</span>
                <i class="fas fa-images"></i>
            </a>
        </div>
    </div>
</section>

<?php $__env->startPush('styles'); ?>
<style>
    /* Premium Submit Hero */
    .submit-hero-premium {
        min-height: 80vh;
        background: linear-gradient(135deg, var(--primary-black) 0%, var(--secondary-black) 100%);
        position: relative;
        display: flex;
        align-items: center;
        overflow: hidden;
    }
    
    .submit-hero-premium .hero-pattern::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: 
            radial-gradient(circle at 30% 70%, rgba(120, 119, 198, 0.2) 0%, transparent 50%),
            radial-gradient(circle at 70% 30%, rgba(255, 119, 198, 0.2) 0%, transparent 50%);
    }
    
    .hero-content-center {
        text-align: center;
        position: relative;
        z-index: 2;
    }
    
    .hero-label {
        display: inline-block;
        font-size: 0.8rem;
        font-weight: 700;
        letter-spacing: 0.2em;
        color: rgba(255,255,255,0.7);
        text-transform: uppercase;
        margin-bottom: 1rem;
    }
    
    .hero-title-premium {
        font-size: clamp(2.5rem, 6vw, 4.5rem);
        font-weight: 900;
        color: white;
        margin-bottom: 1.5rem;
        line-height: 0.9;
        text-shadow: 0 4px 20px rgba(0,0,0,0.3);
        font-family: 'Space Grotesk', sans-serif;
        letter-spacing: -0.02em;
    }
    
    .hero-subtitle {
        font-size: 1.1rem;
        color: rgba(255,255,255,0.8);
        margin-bottom: 2rem;
        line-height: 1.6;
        max-width: 600px;
        margin-left: auto;
        margin-right: auto;
    }
    
    .scroll-indicator {
        position: absolute;
        bottom: 2rem;
        left: 50%;
        transform: translateX(-50%);
        color: white;
    }
    
    .scroll-indicator span {
        display: block;
        width: 2px;
        height: 30px;
        background: white;
        animation: scroll-bounce 2s infinite;
    }
    
    @keyframes scroll-bounce {
        0%, 20%, 50%, 80%, 100% {
            transform: translateY(0);
        }
        40% {
            transform: translateY(-10px);
        }
        60% {
            transform: translateY(-5px);
        }
    }
    
    /* Guidelines Section */
    .guidelines {
        background: var(--bg-gray);
    }
    
    .guideline-card {
        background: white;
        border-radius: 0;
        transition: all var(--transition-base);
        border: 1px solid var(--border-gray);
        height: 100%;
    }
    
    .guideline-card:hover {
        transform: translateY(-5px);
        box-shadow: var(--shadow-md);
    }
    
    .guideline-icon i {
        color: var(--primary-black) !important;
    }
    
    /* Submission Form */
    .submission-form-premium {
        padding: 120px 0;
        background: white;
    }
    
    .form-card-premium {
        background: white;
        padding: 4rem;
        box-shadow: var(--shadow-lg);
        border: 1px solid var(--border-gray);
        position: relative;
    }
    
    .form-header-premium {
        text-align: center;
        margin-bottom: 3rem;
    }
    
    .form-label {
        display: inline-block;
        font-size: 0.8rem;
        font-weight: 700;
        letter-spacing: 0.2em;
        color: var(--medium-gray);
        text-transform: uppercase;
        margin-bottom: 1rem;
    }
    
    .form-title {
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--primary-black);
        margin-bottom: 1rem;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .form-subtitle {
        color: var(--medium-gray);
        font-size: 1.1rem;
    }
    
    /* Premium Alert */
    .premium-alert {
        border: none;
        border-radius: 0;
        padding: 1.5rem;
        margin-bottom: 2rem;
        display: flex;
        align-items: center;
        gap: 1rem;
        position: relative;
    }
    
    .premium-alert.alert-success {
        background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
        color: var(--success-green);
        border-left: 4px solid var(--success-green);
    }
    
    .premium-alert.alert-danger {
        background: linear-gradient(135deg, #f8d7da 0%, #f1b9be 100%);
        color: var(--accent-red);
        border-left: 4px solid var(--accent-red);
    }
    
    .alert-close {
        background: none;
        border: none;
        color: inherit;
        cursor: pointer;
        padding: 0;
        margin-left: auto;
        font-size: 1.2rem;
        opacity: 0.7;
        transition: opacity var(--transition-base);
    }
    
    .alert-close:hover {
        opacity: 1;
    }
    
    /* Form Fields */
    .form-group-premium {
        position: relative;
        margin-bottom: 2rem;
    }
    
    .form-input-premium,
    .form-textarea-premium,
    .form-select-premium {
        width: 100%;
        padding: 1rem;
        border: 2px solid var(--border-gray);
        background: white;
        font-size: 1rem;
        transition: all var(--transition-base);
        border-radius: 0;
    }
    
    .form-input-premium:focus,
    .form-textarea-premium:focus,
    .form-select-premium:focus {
        outline: none;
        border-color: var(--primary-black);
        box-shadow: 0 0 0 3px rgba(0,0,0,0.1);
    }
    
    .form-input-premium.error,
    .form-textarea-premium.error,
    .form-select-premium.error {
        border-color: var(--accent-red);
    }
    
    .form-label-premium {
        position: absolute;
        top: 1rem;
        left: 1rem;
        background: white;
        padding: 0 0.5rem;
        color: var(--medium-gray);
        font-size: 1rem;
        transition: all var(--transition-base);
        pointer-events: none;
    }
    
    .form-input-premium:focus + .form-label-premium,
    .form-input-premium:not(:placeholder-shown) + .form-label-premium,
    .form-textarea-premium:focus + .form-label-premium,
    .form-textarea-premium:not(:placeholder-shown) + .form-label-premium,
    .form-select-premium:focus + .form-label-premium,
    .form-select-premium:not([value=""]) + .form-label-premium {
        top: -0.5rem;
        left: 0.75rem;
        font-size: 0.9rem;
        color: var(--primary-black);
        font-weight: 600;
    }
    
    .form-hint {
        display: block;
        font-size: 0.9rem;
        color: var(--medium-gray);
        margin-top: 0.5rem;
    }
    
    .error-text {
        display: block;
        color: var(--accent-red);
        font-size: 0.9rem;
        margin-top: 0.5rem;
    }
    
    /* Upload Area */
    .upload-area-premium {
        border: 3px dashed var(--border-gray);
        background: var(--bg-gray);
        padding: 3rem;
        text-align: center;
        transition: all var(--transition-base);
        cursor: pointer;
        position: relative;
        min-height: 300px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .upload-area-premium:hover {
        border-color: var(--primary-black);
        background: white;
    }
    
    .upload-area-premium.error {
        border-color: var(--accent-red);
        background: #fff5f5;
    }
    
    .upload-input {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        opacity: 0;
        cursor: pointer;
    }
    
    .upload-content {
        pointer-events: none;
    }
    
    .upload-content i {
        font-size: 3rem;
        color: var(--medium-gray);
        margin-bottom: 1rem;
        display: block;
    }
    
    .upload-content h4 {
        font-size: 1.2rem;
        font-weight: 600;
        color: var(--primary-black);
        margin-bottom: 0.5rem;
    }
    
    .upload-content p {
        color: var(--medium-gray);
        font-size: 0.9rem;
    }
    
    .image-preview {
        width: 100%;
        height: 100%;
        position: relative;
    }
    
    .preview-image {
        width: 100%;
        height: 250px;
        object-fit: cover;
    }
    
    .remove-image {
        position: absolute;
        top: 10px;
        right: 10px;
        width: 35px;
        height: 35px;
        background: rgba(0,0,0,0.7);
        color: white;
        border: none;
        border-radius: 50%;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: background-color var(--transition-base);
    }
    
    .remove-image:hover {
        background: var(--accent-red);
    }
    
    /* Input Group */
    .input-group-premium {
        position: relative;
        display: flex;
        align-items: center;
    }
    
    .input-prefix {
        position: absolute;
        left: 1rem;
        z-index: 2;
        color: var(--medium-gray);
        font-weight: 600;
        background: white;
        padding: 0 0.25rem;
    }
    
    .input-group-premium .form-input-premium {
        padding-left: 2.5rem;
    }
    
    .input-group-premium .form-label-premium {
        left: 2.5rem;
    }
    
    /* Consent Section */
    .consent-section-premium {
        background: var(--bg-gray);
        padding: 2rem;
        margin: 3rem 0;
        border-left: 4px solid var(--primary-black);
    }
    
    .consent-title {
        font-size: 1.2rem;
        font-weight: 700;
        margin-bottom: 1.5rem;
        color: var(--primary-black);
    }
    
    .form-check-premium {
        position: relative;
        margin-bottom: 1rem;
        padding-left: 0;
    }
    
    .form-check-premium .form-check-input {
        position: absolute;
        opacity: 0;
        cursor: pointer;
    }
    
    .form-check-premium .form-check-label {
        display: flex;
        align-items: flex-start;
        cursor: pointer;
        font-size: 0.95rem;
        line-height: 1.5;
        color: var(--primary-black);
        padding-left: 2.5rem;
        position: relative;
    }
    
    .checkmark {
        position: absolute;
        left: 0;
        top: 2px;
        height: 20px;
        width: 20px;
        border: 2px solid var(--border-gray);
        background: white;
        transition: all var(--transition-base);
    }
    
    .checkmark::after {
        content: "";
        position: absolute;
        left: 6px;
        top: 2px;
        width: 6px;
        height: 10px;
        border: solid white;
        border-width: 0 2px 2px 0;
        transform: rotate(45deg);
        opacity: 0;
        transition: opacity var(--transition-base);
    }
    
    .form-check-input:checked ~ .form-check-label .checkmark {
        background: var(--primary-black);
        border-color: var(--primary-black);
    }
    
    .form-check-input:checked ~ .form-check-label .checkmark::after {
        opacity: 1;
    }
    
    /* Submit Button */
    .form-actions {
        text-align: center;
        margin-top: 3rem;
    }
    
    .submit-btn {
        position: relative;
        overflow: hidden;
    }
    
    .btn-loader {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
    }
    
    .spinner {
        width: 20px;
        height: 20px;
        border: 2px solid rgba(255,255,255,0.3);
        border-radius: 50%;
        border-top-color: white;
        animation: spin 1s ease-in-out infinite;
    }
    
    @keyframes spin {
        to { transform: rotate(360deg); }
    }
    
    /* Submit Page Button Styles */
    .btn-submit-form,
    .btn-submit-cta {
        display: inline-flex;
        align-items: center;
        gap: 0.75rem;
        padding: 1rem 2.5rem;
        font-weight: 600;
        font-size: 0.9rem;
        letter-spacing: 0.05em;
        text-transform: uppercase;
        text-decoration: none;
        transition: all var(--transition-base);
        position: relative;
        overflow: hidden;
        border-radius: 0;
        cursor: pointer;
        border: none;
    }
    
    .btn-submit-form.primary {
        background: var(--primary-black);
        color: white;
        border: 2px solid var(--primary-black);
    }
    
    .btn-submit-form.primary:hover {
        background: transparent;
        color: var(--primary-black);
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    }
    
    .btn-submit-cta.secondary {
        background: transparent;
        color: var(--primary-black);
        border: 2px solid var(--primary-black);
    }
    
    .btn-submit-cta.secondary:hover {
        background: var(--primary-black);
        color: white;
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    }
    
    /* Recent Submissions */
    .recent-submissions-premium {
        padding: 120px 0;
        background: var(--bg-gray);
    }
    
    .recent-grid-premium {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 2rem;
        margin-top: 60px;
    }
    
    .recent-item-premium {
        transition: all var(--transition-base);
    }
    
    .recent-item-premium:hover {
        transform: translateY(-5px);
    }
    
    .recent-image-wrapper {
        position: relative;
        overflow: hidden;
        height: 300px;
        background: white;
        box-shadow: var(--shadow-sm);
    }
    
    .recent-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform var(--transition-base);
    }
    
    .recent-item-premium:hover .recent-image {
        transform: scale(1.05);
    }
    
    .recent-overlay {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: linear-gradient(transparent, rgba(0,0,0,0.8));
        padding: 2rem 1rem 1rem;
        transform: translateY(100%);
        transition: transform var(--transition-base);
    }
    
    .recent-item-premium:hover .recent-overlay {
        transform: translateY(0);
    }
    
    .recent-info h6 {
        color: white;
        font-weight: 700;
        margin-bottom: 0.25rem;
    }
    
    .recent-info span {
        color: rgba(255,255,255,0.8);
        font-size: 0.9rem;
    }
    
    /* Responsive */
    @media (max-width: 768px) {
        .form-card-premium {
            padding: 2rem;
        }
        
        .recent-grid-premium {
            grid-template-columns: repeat(2, 1fr);
            gap: 1rem;
        }
        
        .recent-image-wrapper {
            height: 200px;
        }
    }
    
    @media (max-width: 480px) {
        .recent-grid-premium {
            grid-template-columns: 1fr;
        }
        
        .hero-title-premium {
            font-size: 2.5rem;
        }
        
        .form-card-premium {
            padding: 1.5rem;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize AOS
    AOS.init({
        duration: 1000,
        easing: 'ease-out-cubic',
        once: true,
        offset: 100
    });
    
    const uploadArea = document.querySelector('.upload-area-premium');
    const photoInput = document.getElementById('photo');
    const imagePreview = document.getElementById('imagePreview');
    const previewImg = document.getElementById('previewImg');
    const uploadContent = document.getElementById('uploadContent');
    
    // Click to upload
    uploadArea.addEventListener('click', function() {
        photoInput.click();
    });
    
    // File input change
    photoInput.addEventListener('change', function(e) {
        handleFileSelect(e.target.files[0]);
    });
    
    // Drag and drop
    uploadArea.addEventListener('dragover', function(e) {
        e.preventDefault();
        uploadArea.style.borderColor = 'var(--primary-black)';
        uploadArea.style.background = 'white';
    });
    
    uploadArea.addEventListener('dragleave', function(e) {
        e.preventDefault();
        uploadArea.style.borderColor = 'var(--border-gray)';
        uploadArea.style.background = 'var(--bg-gray)';
    });
    
    uploadArea.addEventListener('drop', function(e) {
        e.preventDefault();
        uploadArea.style.borderColor = 'var(--border-gray)';
        uploadArea.style.background = 'var(--bg-gray)';
        const files = e.dataTransfer.files;
        if (files.length > 0) {
            photoInput.files = files;
            handleFileSelect(files[0]);
        }
    });
    
    function handleFileSelect(file) {
        if (file && file.type.startsWith('image/')) {
            const reader = new FileReader();
            reader.onload = function(e) {
                previewImg.src = e.target.result;
                imagePreview.classList.remove('d-none');
                uploadContent.classList.add('d-none');
            };
            reader.readAsDataURL(file);
        }
    }
    
    // Remove image
    document.getElementById('removeImage').addEventListener('click', function(e) {
        e.stopPropagation();
        photoInput.value = '';
        imagePreview.classList.add('d-none');
        uploadContent.classList.remove('d-none');
    });
    
    // Form validation
    const form = document.getElementById('styleSubmissionForm');
    const captionInput = document.getElementById('caption');
    
    captionInput.addEventListener('input', function() {
        const minLength = 50;
        const currentLength = this.value.length;
        
        if (currentLength < minLength && currentLength > 0) {
            this.classList.add('error');
        } else {
            this.classList.remove('error');
        }
    });
    
    // Form submission
    form.addEventListener('submit', function(e) {
        const submitBtn = this.querySelector('.submit-btn');
        const btnText = submitBtn.querySelector('.btn-text');
        const btnLoader = submitBtn.querySelector('.btn-loader');
        
        btnText.classList.add('d-none');
        btnLoader.classList.remove('d-none');
        submitBtn.disabled = true;
    });
    
    // Auto-hide alerts
    document.querySelectorAll('.premium-alert').forEach(alert => {
        setTimeout(() => {
            alert.style.opacity = '0';
            alert.style.transform = 'translateY(-20px)';
            setTimeout(() => {
                alert.style.display = 'none';
            }, 300);
        }, 5000);
    });
});
</script>
<?php $__env->stopPush(); ?>

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "WebPage",
    "name": "Submit Your Style - Edition By Punjab Community",
    "description": "Share your streetwear style with the Edition By Punjab community in Australia",
    "url": "<?php echo e(route('community.submit')); ?>",
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "<?php echo e(route('home')); ?>"
    },
    "potentialAction": {
        "@type": "UploadAction",
        "target": "<?php echo e(route('community.submit')); ?>",
        "description": "Submit your style photo to the community gallery"
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio7\resources\views/community/submit.blade.php ENDPATH**/ ?>