<?php $__env->startSection('title', 'Legal Information'); ?>
<?php $__env->startSection('meta_description', 'Access important legal information, terms of service, privacy policy, and other legal documents.'); ?>

<?php $__env->startSection('content'); ?>
<!-- Premium Legal Hero -->
<section class="legal-hero-premium">
    <div class="hero-overlay"></div>
    <div class="container">
        <div class="hero-content-center" data-aos="fade-up">
            <span class="hero-label">LEGAL</span>
            <h1 class="hero-title-premium">Legal Information</h1>
            <p class="hero-subtitle">Important legal documents and policies</p>
        </div>
    </div>
    <div class="scroll-indicator">
        <span></span>
    </div>
</section>

<!-- Legal Pages Listing -->
<section class="legal-content-premium">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <?php if($legalPages->count() > 0): ?>
                    <div class="legal-pages-grid">
                        <?php $__currentLoopData = $legalPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="legal-page-card" data-aos="fade-up">
                                <div class="card-icon">
                                    <i class="fas fa-file-contract"></i>
                                </div>
                                <div class="card-content">
                                    <h3><?php echo e($page->title); ?></h3>
                                    <?php if($page->meta_description): ?>
                                        <p><?php echo e($page->meta_description); ?></p>
                                    <?php endif; ?>
                                    <a href="<?php echo e(route('legal.show', $page->slug)); ?>" class="read-more-btn">
                                        Read Document
                                        <i class="fas fa-arrow-right"></i>
                                    </a>
                                </div>
                                <div class="card-meta">
                                    <small>Last updated: <?php echo e($page->updated_at->format('F d, Y')); ?></small>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="no-legal-pages">
                        <div class="text-center py-5">
                            <i class="fas fa-file-contract fa-3x text-muted mb-3"></i>
                            <h5>No Legal Documents Available</h5>
                            <p class="text-muted">Legal documents will be available here soon.</p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="legal-cta-premium">
    <div class="container">
        <div class="cta-content" data-aos="zoom-in">
            <h2 class="cta-title">Have Legal Questions?</h2>
            <p class="cta-subtitle">We're here to help clarify any concerns</p>
            <div class="cta-buttons">
                <a href="<?php echo e(route('contact')); ?>" class="btn-cta-primary">
                    CONTACT US
                </a>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('styles'); ?>
<style>
/* Legal Hero */
.legal-hero-premium {
    height: 50vh;
    min-height: 400px;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
}

.legal-hero-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-image: url('/images/legal-hero.jpg');
    background-size: cover;
    background-position: center;
    opacity: 0.2;
}

.hero-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: radial-gradient(circle at center, transparent 0%, rgba(0,0,0,0.7) 100%);
}

.hero-content-center {
    text-align: center;
    color: white;
    position: relative;
    z-index: 2;
}

.hero-label {
    display: inline-block;
    padding: 0.5rem 1.5rem;
    background: rgba(255,255,255,0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255,255,255,0.2);
    font-size: 0.75rem;
    letter-spacing: 0.2em;
    font-weight: 600;
    margin-bottom: 2rem;
}

.hero-title-premium {
    font-size: clamp(2.5rem, 6vw, 4rem);
    font-weight: 900;
    margin-bottom: 1rem;
    font-family: 'Space Grotesk', sans-serif;
}

.hero-subtitle {
    font-size: 1.25rem;
    opacity: 0.9;
    margin-bottom: 1rem;
}

.scroll-indicator {
    position: absolute;
    bottom: 2rem;
    left: 50%;
    transform: translateX(-50%);
}

.scroll-indicator span {
    display: block;
    width: 24px;
    height: 36px;
    border: 2px solid white;
    border-radius: 12px;
    position: relative;
}

.scroll-indicator span::after {
    content: '';
    position: absolute;
    top: 6px;
    left: 50%;
    transform: translateX(-50%);
    width: 4px;
    height: 8px;
    background: white;
    border-radius: 2px;
    animation: scroll-down 2s infinite;
}

@keyframes scroll-down {
    0% { transform: translateX(-50%) translateY(0); opacity: 1; }
    100% { transform: translateX(-50%) translateY(12px); opacity: 0; }
}

/* Legal Content */
.legal-content-premium {
    padding: 5rem 0;
    background: white;
    position: relative;
}

/* Legal Pages Grid */
.legal-pages-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
    gap: 2rem;
    margin-top: 2rem;
}

.legal-page-card {
    background: white;
    border: 1px solid #e0e0e0;
    padding: 2rem;
    transition: all 0.3s ease;
    position: relative;
}

.legal-page-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.1);
    border-color: #000;
}

.card-icon {
    width: 60px;
    height: 60px;
    background: #f8f8f8;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 1.5rem;
    transition: all 0.3s ease;
}

.legal-page-card:hover .card-icon {
    background: #000;
    color: white;
}

.card-icon i {
    font-size: 1.5rem;
    color: #000;
}

.legal-page-card:hover .card-icon i {
    color: white;
}

.card-content h3 {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: #000;
}

.card-content p {
    color: #666;
    line-height: 1.6;
    margin-bottom: 1.5rem;
}

.read-more-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    color: #000;
    text-decoration: none;
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border: 2px solid #000;
    transition: all 0.3s ease;
}

.read-more-btn:hover {
    background: #000;
    color: white;
    transform: translateX(5px);
}

.card-meta {
    margin-top: 1.5rem;
    padding-top: 1.5rem;
    border-top: 1px solid #e0e0e0;
}

.card-meta small {
    color: #999;
    font-size: 0.875rem;
}

/* Legal CTA */
.legal-cta-premium {
    padding: 4rem 0;
    background: #f8f8f8;
}

.cta-content {
    text-align: center;
}

.cta-title {
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 1rem;
}

.cta-subtitle {
    font-size: 1.125rem;
    color: #666;
    margin-bottom: 2rem;
}

.cta-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
}

.btn-cta-primary {
    padding: 1rem 2.5rem;
    background: #000;
    color: white;
    text-decoration: none;
    font-weight: 700;
    letter-spacing: 0.05em;
    transition: all 0.3s;
}

.btn-cta-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
}

/* Responsive */
@media (max-width: 768px) {
    .legal-pages-grid {
        grid-template-columns: 1fr;
    }
    
    .hero-title-premium {
        font-size: 2rem;
    }
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/legal/index.blade.php ENDPATH**/ ?>