<?php $__env->startSection('title', 'Community Style - Share Your Edition By Punjab Look'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="Join the Edition By Punjab community! Share your style, discover inspiration from fellow streetwear enthusiasts, and connect with Australian fashion culture.">
<meta name="keywords" content="streetwear community, user generated content, fashion inspiration, australian street style, edition by punjab community, style sharing">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if (isset($component)) { $__componentOriginal269900abaed345884ce342681cdc99f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal269900abaed345884ce342681cdc99f6 = $attributes; } ?>
<?php $component = App\View\Components\Breadcrumb::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $attributes = $__attributesOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__attributesOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $component = $__componentOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__componentOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>

<!-- Premium Community Hero -->
<section class="community-hero-premium">
    <div class="hero-pattern"></div>
    <div class="container">
        <div class="hero-content-center" data-aos="fade-up">
            <span class="hero-label">COMMUNITY</span>
            <h1 class="hero-title-premium">STYLE COLLECTIVE</h1>
            <p class="hero-subtitle">Join thousands of Australian streetwear enthusiasts sharing their unique style stories</p>
            <div class="hero-actions">
                <a href="<?php echo e(route('community.submit')); ?>" class="btn-community-hero primary">
                    <span>SHARE YOUR STYLE</span>
                    <i class="fas fa-camera"></i>
                </a>
                <a href="<?php echo e(route('community.gallery')); ?>" class="btn-community-hero secondary">
                    <span>BROWSE GALLERY</span>
                    <i class="fas fa-images"></i>
                </a>
            </div>
        </div>
    </div>
    <div class="scroll-indicator">
        <span></span>
    </div>
</section>

<!-- Latest Community Posts -->
<section class="community-posts-premium">
    <div class="container">
        <div class="section-header-premium" data-aos="fade-up">
            <span class="section-label-premium">LATEST STYLES</span>
            <h2 class="section-title-premium">Community Spotlight</h2>
            <p class="section-subtitle">See how our community is styling their Edition By Punjab pieces across Australia</p>
        </div>
        
        <div class="posts-grid-premium">
            <?php $__currentLoopData = $communityPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="community-post-premium" data-aos="fade-up" data-aos-delay="<?php echo e($index * 100); ?>">
                    <div class="post-image-wrapper">
                        <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => ''.e($post['image']).'','alt' => ''.e($post['user']).' style post','class' => 'post-image'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                        <div class="post-overlay">
                            <a href="<?php echo e($post['instagram_url']); ?>" class="post-link" target="_blank" rel="noopener">
                                <i class="fab fa-instagram"></i>
                            </a>
                        </div>
                    </div>
                    
                    <div class="post-content-premium">
                        <div class="post-header-premium">
                            <div class="user-avatar-premium">
                                <?php echo e(substr($post['user'], 0, 1)); ?>

                            </div>
                            <div class="user-info-premium">
                                <h6 class="user-name"><?php echo e($post['user']); ?></h6>
                                <span class="user-location">
                                    <i class="fas fa-map-marker-alt"></i><?php echo e($post['location']); ?>

                                </span>
                            </div>
                        </div>
                        
                        <p class="post-caption-premium"><?php echo e($post['caption']); ?></p>
                        
                        <div class="post-meta">
                            <span class="product-tag">
                                <i class="fas fa-tshirt"></i><?php echo e($post['product']); ?>

                            </span>
                            <div class="post-stats">
                                <span class="likes-count">
                                    <i class="far fa-heart"></i><?php echo e($post['likes']); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <div class="section-action" data-aos="fade-up">
            <a href="<?php echo e(route('community.gallery')); ?>" class="btn-community-action primary">
                <span>VIEW ALL POSTS</span>
                <i class="fas fa-arrow-right"></i>
            </a>
        </div>
    </div>
</section>

<!-- Featured Products -->
<section class="featured-products-premium">
    <div class="container">
        <div class="section-header-premium" data-aos="fade-up">
            <span class="section-label-premium">TRENDING</span>
            <h2 class="section-title-premium">Community Favorites</h2>
            <p class="section-subtitle">The most loved pieces from our community members</p>
        </div>
        
        <div class="products-grid-premium">
            <?php $__currentLoopData = $featuredProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="product-card-premium" data-aos="fade-up" data-aos-delay="<?php echo e($index * 100); ?>">
                    <div class="product-image-wrapper-premium">
                        <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => $product->featured_image ?? 'placeholder-product.jpg','alt' => $product->name,'class' => 'product-image-premium'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                        <div class="product-overlay-premium">
                            <a href="<?php echo e(route('shop.product', $product->slug)); ?>" class="product-link-premium">
                                <span>SHOP NOW</span>
                            </a>
                        </div>
                    </div>
                    <div class="product-info-premium">
                        <h6 class="product-name-premium"><?php echo e(Str::limit($product->name, 25)); ?></h6>
                        <div class="product-price-premium">
                            $<?php echo e(number_format($product->price, 2)); ?>

                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- How to Submit -->
<section class="submit-guide-premium">
    <div class="container">
        <div class="section-header-premium" data-aos="fade-up">
            <span class="section-label-premium">JOIN US</span>
            <h2 class="section-title-premium">How to Join Our Community</h2>
            <p class="section-subtitle">Share your style and inspire others in the Edition By Punjab community</p>
        </div>
        
        <div class="steps-grid-premium">
            <div class="step-card-premium" data-aos="fade-up" data-aos-delay="0">
                <div class="step-number-premium">
                    <span>01</span>
                </div>
                <div class="step-content-premium">
                    <h5 class="step-title-premium">Style Your Look</h5>
                    <p class="step-text-premium">Put together your favorite Edition By Punjab pieces and create an outfit that represents your unique style.</p>
                </div>
            </div>
            
            <div class="step-card-premium" data-aos="fade-up" data-aos-delay="100">
                <div class="step-number-premium">
                    <span>02</span>
                </div>
                <div class="step-content-premium">
                    <h5 class="step-title-premium">Capture the Moment</h5>
                    <p class="step-text-premium">Take a great photo of your outfit. Natural lighting and authentic poses work best for showcasing your style.</p>
                </div>
            </div>
            
            <div class="step-card-premium" data-aos="fade-up" data-aos-delay="200">
                <div class="step-number-premium">
                    <span>03</span>
                </div>
                <div class="step-content-premium">
                    <h5 class="step-title-premium">Share with Us</h5>
                    <p class="step-text-premium">Post on Instagram with #EditionByPunjab or submit directly through our community page to be featured!</p>
                </div>
            </div>
        </div>
        
        <div class="section-actions-premium" data-aos="fade-up">
            <a href="<?php echo e(route('community.submit')); ?>" class="btn-community-action primary">
                <span>SUBMIT YOUR STYLE</span>
                <i class="fas fa-upload"></i>
            </a>
            <a href="<?php echo e(route('community.spotlight')); ?>" class="btn-community-action secondary">
                <span>CUSTOMER SPOTLIGHT</span>
                <i class="fas fa-star"></i>
            </a>
        </div>
    </div>
</section>

<?php $__env->startPush('styles'); ?>
<style>
    /* Premium Community Hero */
    .community-hero-premium {
        min-height: 100vh;
        background: linear-gradient(135deg, var(--primary-black) 0%, var(--secondary-black) 100%);
        position: relative;
        display: flex;
        align-items: center;
        overflow: hidden;
    }
    
    .community-hero-premium .hero-pattern::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: 
            radial-gradient(circle at 20% 80%, rgba(120, 119, 198, 0.3) 0%, transparent 50%),
            radial-gradient(circle at 80% 20%, rgba(255, 119, 198, 0.3) 0%, transparent 50%);
    }
    
    .hero-content-center {
        text-align: center;
        position: relative;
        z-index: 2;
    }
    
    .hero-label {
        display: inline-block;
        font-size: 0.8rem;
        font-weight: 700;
        letter-spacing: 0.2em;
        color: rgba(255,255,255,0.7);
        text-transform: uppercase;
        margin-bottom: 1rem;
        position: relative;
        overflow: hidden;
    }
    
    .hero-title-premium {
        font-size: clamp(3rem, 8vw, 6rem);
        font-weight: 900;
        color: white;
        margin-bottom: 2rem;
        line-height: 0.9;
        text-shadow: 0 4px 20px rgba(0,0,0,0.3);
        font-family: 'Space Grotesk', sans-serif;
        letter-spacing: -0.02em;
    }
    
    .hero-subtitle {
        font-size: 1.2rem;
        color: rgba(255,255,255,0.8);
        margin-bottom: 3rem;
        line-height: 1.6;
        max-width: 600px;
        margin-left: auto;
        margin-right: auto;
    }
    
    .hero-actions {
        display: flex;
        gap: 1.5rem;
        justify-content: center;
        align-items: center;
        flex-wrap: wrap;
    }
    
    .btn-community-hero,
    .btn-community-action {
        display: inline-flex;
        align-items: center;
        gap: 0.75rem;
        padding: 1rem 2.5rem;
        font-weight: 600;
        font-size: 0.9rem;
        letter-spacing: 0.05em;
        text-transform: uppercase;
        text-decoration: none;
        transition: all var(--transition-base);
        position: relative;
        overflow: hidden;
        min-width: 200px;
        justify-content: center;
        border-radius: 0;
    }
    
    .btn-community-hero.primary {
        background: white;
        color: var(--primary-black);
        border: 2px solid white;
    }
    
    .btn-community-hero.primary:hover {
        background: transparent;
        color: white;
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(255,255,255,0.2);
    }
    
    .btn-community-hero.secondary {
        background: transparent;
        color: white;
        border: 2px solid white;
    }
    
    .btn-community-hero.secondary:hover {
        background: white;
        color: var(--primary-black);
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(255,255,255,0.2);
    }
    
    .btn-community-action.primary {
        background: var(--primary-black);
        color: white;
        border: 2px solid var(--primary-black);
    }
    
    .btn-community-action.primary:hover {
        background: transparent;
        color: var(--primary-black);
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    }
    
    .btn-community-action.secondary {
        background: transparent;
        color: var(--primary-black);
        border: 2px solid var(--primary-black);
    }
    
    .btn-community-action.secondary:hover {
        background: var(--primary-black);
        color: white;
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    }
    
    .scroll-indicator {
        position: absolute;
        bottom: 2rem;
        left: 50%;
        transform: translateX(-50%);
        color: white;
    }
    
    .scroll-indicator span {
        display: block;
        width: 2px;
        height: 30px;
        background: white;
        animation: scroll-bounce 2s infinite;
    }
    
    @keyframes scroll-bounce {
        0%, 20%, 50%, 80%, 100% {
            transform: translateY(0);
        }
        40% {
            transform: translateY(-10px);
        }
        60% {
            transform: translateY(-5px);
        }
    }
    
    /* Premium Community Posts */
    .community-posts-premium {
        padding: 120px 0;
        background: var(--bg-gray);
    }
    
    .section-header-premium {
        text-align: center;
        margin-bottom: 80px;
    }
    
    .section-label-premium {
        display: inline-block;
        font-size: 0.8rem;
        font-weight: 700;
        letter-spacing: 0.2em;
        color: var(--medium-gray);
        text-transform: uppercase;
        margin-bottom: 1rem;
    }
    
    .section-title-premium {
        font-size: clamp(2.5rem, 5vw, 4rem);
        font-weight: 800;
        color: var(--primary-black);
        margin-bottom: 1.5rem;
        line-height: 1.2;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .section-subtitle {
        font-size: 1.1rem;
        color: var(--medium-gray);
        line-height: 1.6;
        max-width: 600px;
        margin: 0 auto;
    }
    
    .posts-grid-premium {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
        gap: 3rem;
        margin-top: 80px;
    }
    
    .community-post-premium {
        background: white;
        border-radius: 0;
        overflow: hidden;
        transition: all var(--transition-slow);
        position: relative;
        box-shadow: var(--shadow-sm);
    }
    
    .community-post-premium:hover {
        transform: translateY(-15px);
        box-shadow: var(--shadow-xl);
    }
    
    .post-image-wrapper {
        position: relative;
        overflow: hidden;
        height: 300px;
    }
    
    .post-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform var(--transition-slow);
    }
    
    .community-post-premium:hover .post-image {
        transform: scale(1.05);
    }
    
    .post-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0.6) 100%);
        opacity: 0;
        transition: opacity var(--transition-base);
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .community-post-premium:hover .post-overlay {
        opacity: 1;
    }
    
    .post-link {
        color: white;
        font-size: 2rem;
        padding: 1rem;
        border: 2px solid white;
        border-radius: 50%;
        width: 60px;
        height: 60px;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        transition: all var(--transition-base);
    }
    
    .post-link:hover {
        color: var(--primary-black);
        background: white;
        transform: scale(1.1);
    }
    
    .post-content-premium {
        padding: 2rem;
    }
    
    .post-header-premium {
        display: flex;
        align-items: center;
        margin-bottom: 1.5rem;
    }
    
    .user-avatar-premium {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        font-size: 1.2rem;
        margin-right: 1rem;
    }
    
    .user-name {
        font-weight: 700;
        margin-bottom: 0.25rem;
        color: var(--primary-black);
    }
    
    .user-location {
        color: var(--medium-gray);
        font-size: 0.9rem;
    }
    
    .user-location i {
        margin-right: 0.5rem;
    }
    
    .post-caption-premium {
        color: var(--medium-gray);
        line-height: 1.6;
        margin-bottom: 1.5rem;
        font-size: 0.95rem;
    }
    
    .post-meta {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    
    .product-tag {
        background: var(--bg-gray);
        color: var(--primary-black);
        padding: 0.5rem 1rem;
        font-size: 0.8rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }
    
    .product-tag i {
        margin-right: 0.5rem;
    }
    
    .likes-count {
        color: var(--medium-gray);
        font-size: 0.9rem;
    }
    
    .likes-count i {
        color: var(--accent-red);
        margin-right: 0.5rem;
    }
    
    .section-action {
        text-align: center;
        margin-top: 80px;
    }
    
    /* Featured Products Premium */
    .featured-products-premium {
        padding: 120px 0;
        background: white;
    }
    
    .products-grid-premium {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 2rem;
        margin-top: 80px;
    }
    
    .product-card-premium {
        background: white;
        transition: all var(--transition-slow);
        position: relative;
    }
    
    .product-card-premium:hover {
        transform: translateY(-10px);
    }
    
    .product-image-wrapper-premium {
        position: relative;
        overflow: hidden;
        height: 300px;
    }
    
    .product-image-premium {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform var(--transition-slow);
    }
    
    .product-card-premium:hover .product-image-premium {
        transform: scale(1.1);
    }
    
    .product-overlay-premium {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0,0,0,0.8);
        opacity: 0;
        transition: opacity var(--transition-base);
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .product-card-premium:hover .product-overlay-premium {
        opacity: 1;
    }
    
    .product-link-premium {
        color: white;
        text-decoration: none;
        padding: 1rem 2rem;
        border: 2px solid white;
        font-weight: 600;
        letter-spacing: 0.05em;
        transition: all var(--transition-base);
    }
    
    .product-link-premium:hover {
        background: white;
        color: var(--primary-black);
    }
    
    .product-info-premium {
        padding: 1.5rem 0;
        text-align: center;
    }
    
    .product-name-premium {
        font-weight: 600;
        margin-bottom: 0.5rem;
        color: var(--primary-black);
    }
    
    .product-price-premium {
        font-weight: 700;
        color: var(--primary-black);
        font-size: 1.1rem;
    }
    
    /* Submit Guide Premium */
    .submit-guide-premium {
        padding: 120px 0;
        background: var(--bg-gray);
    }
    
    .steps-grid-premium {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
        gap: 3rem;
        margin-top: 80px;
    }
    
    .step-card-premium {
        background: white;
        padding: 3rem;
        display: flex;
        align-items: flex-start;
        transition: all var(--transition-slow);
        position: relative;
        box-shadow: var(--shadow-sm);
    }
    
    .step-card-premium:hover {
        transform: translateY(-10px);
        box-shadow: var(--shadow-lg);
    }
    
    .step-number-premium {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        font-size: 1.5rem;
        margin-right: 2rem;
        flex-shrink: 0;
    }
    
    .step-content-premium {
        flex: 1;
    }
    
    .step-title-premium {
        font-weight: 700;
        margin-bottom: 1rem;
        color: var(--primary-black);
    }
    
    .step-text-premium {
        color: var(--medium-gray);
        line-height: 1.6;
    }
    
    .section-actions-premium {
        display: flex;
        gap: 2rem;
        justify-content: center;
        margin-top: 80px;
        flex-wrap: wrap;
    }
    
    /* Responsive */
    @media (max-width: 768px) {
        .posts-grid-premium {
            grid-template-columns: 1fr;
            gap: 2rem;
        }
        
        .products-grid-premium {
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        }
        
        .steps-grid-premium {
            grid-template-columns: 1fr;
            gap: 2rem;
        }
        
        .step-card-premium {
            padding: 2rem;
            flex-direction: column;
            text-align: center;
        }
        
        .step-number-premium {
            margin-right: 0;
            margin-bottom: 1rem;
        }
        
        .section-actions-premium {
            flex-direction: column;
            align-items: center;
        }
        
        .hero-actions {
            flex-direction: column;
            gap: 1rem;
            align-items: center;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize AOS
    AOS.init({
        duration: 1000,
        easing: 'ease-out-cubic',
        once: true,
        offset: 100
    });
    
    // Smooth scrolling for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "CollectionPage",
    "name": "Community Style - Edition By Punjab",
    "description": "Join the Edition By Punjab community! Share your style, discover inspiration from fellow streetwear enthusiasts, and connect with Australian fashion culture",
    "url": "<?php echo e(route('community.index')); ?>",
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "<?php echo e(route('home')); ?>"
    },
    "mainEntity": {
        "@type": "ItemList",
        "name": "Community Style Posts"
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/community/index.blade.php ENDPATH**/ ?>