

<?php $__env->startSection('title', 'Discount Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Discount Campaigns</h1>
    <a href="<?php echo e(route('admin.discounts.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Create New Campaign
    </a>
</div>

<!-- Active Campaigns -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">Active Campaigns</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Discount</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($campaign->name); ?></td>
                        <td><?php echo e($campaign->discount_percentage); ?>%</td>
                        <td><?php echo e($campaign->starts_at->format('M d, Y H:i')); ?></td>
                        <td><?php echo e($campaign->ends_at->format('M d, Y H:i')); ?></td>
                        <td>
                            <?php if($campaign->isActive()): ?>
                                <span class="badge bg-success">Active</span>
                            <?php elseif($campaign->starts_at > now()): ?>
                                <span class="badge bg-info">Upcoming</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Ended</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.discounts.edit', $campaign)); ?>" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="<?php echo e(route('admin.discounts.toggle', $campaign)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-sm btn-<?php echo e($campaign->is_active ? 'danger' : 'success'); ?>">
                                    <i class="fas fa-<?php echo e($campaign->is_active ? 'pause' : 'play'); ?>"></i>
                                </button>
                            </form>
                            <form action="<?php echo e(route('admin.discounts.destroy', $campaign)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center">No campaigns found</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php echo e($campaigns->links()); ?>

    </div>
</div>

<!-- User Discounts -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Newsletter Subscriber Discounts</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Email</th>
                        <th>Discount Code</th>
                        <th>Percentage</th>
                        <th>Status</th>
                        <th>Used At</th>
                        <th>Expires At</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $userDiscounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $discount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($discount->email); ?></td>
                        <td><code><?php echo e($discount->discount_code); ?></code></td>
                        <td><?php echo e($discount->discount_percentage); ?>%</td>
                        <td>
                            <?php if($discount->is_used): ?>
                                <span class="badge bg-secondary">Used</span>
                            <?php elseif($discount->expires_at && $discount->expires_at < now()): ?>
                                <span class="badge bg-danger">Expired</span>
                            <?php else: ?>
                                <span class="badge bg-success">Active</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($discount->used_at ? $discount->used_at->format('M d, Y') : '-'); ?></td>
                        <td><?php echo e($discount->expires_at ? $discount->expires_at->format('M d, Y') : 'Never'); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center">No user discounts found</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php echo e($userDiscounts->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio8\resources\views/admin/discounts/index.blade.php ENDPATH**/ ?>