<?php $__env->startSection('title', 'Community Pages'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Community Pages</h1>
    <a href="<?php echo e(route('admin.community-pages.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Add New Page
    </a>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title mb-0">Total Pages</h6>
                        <h2 class="mt-2 mb-0"><?php echo e(App\Models\CommunityPage::count()); ?></h2>
                    </div>
                    <i class="fas fa-file-alt fa-2x opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title mb-0">Active Pages</h6>
                        <h2 class="mt-2 mb-0"><?php echo e(App\Models\CommunityPage::where('is_active', true)->count()); ?></h2>
                    </div>
                    <i class="fas fa-check-circle fa-2x opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title mb-0">Inactive Pages</h6>
                        <h2 class="mt-2 mb-0"><?php echo e(App\Models\CommunityPage::where('is_active', false)->count()); ?></h2>
                    </div>
                    <i class="fas fa-pause-circle fa-2x opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title mb-0">With Images</h6>
                        <h2 class="mt-2 mb-0"><?php echo e(App\Models\CommunityPage::whereJsonLength('images', '>', 0)->count()); ?></h2>
                    </div>
                    <i class="fas fa-images fa-2x opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Community Pages List -->
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead>
                    <tr>
                        <th style="width:100px;">Images</th>
                        <th>Page Key</th>
                        <th>Title</th>
                        <th>Status</th>
                        <th>Images Count</th>
                        <th>Last Updated</th>
                        <th style="width:200px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <?php if($page->images && count($page->images) > 0): ?>
                                <div class="d-flex gap-1">
                                    <?php $__currentLoopData = array_slice($page->images, 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($image)); ?>" alt="<?php echo e($page->title); ?>" width="30" height="30" class="rounded" style="object-fit:cover;">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(count($page->images) > 3): ?>
                                        <span class="badge bg-secondary">+<?php echo e(count($page->images) - 3); ?></span>
                                    <?php endif; ?>
                                </div>
                            <?php else: ?>
                                <div class="bg-light text-center text-muted rounded" style="width:30px;height:30px;display:flex;align-items:center;justify-content:center;">
                                    <i class="fas fa-image"></i>
                                </div>
                            <?php endif; ?>
                        </td>
                        <td>
                            <code><?php echo e($page->page_key); ?></code>
                        </td>
                        <td>
                            <strong><?php echo e($page->title); ?></strong>
                            <?php if($page->meta_title): ?>
                                <br><small class="text-muted"><?php echo e(Str::limit($page->meta_title, 50)); ?></small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <button type="button" class="btn btn-sm <?php echo e($page->is_active ? 'btn-success' : 'btn-outline-secondary'); ?>" 
                                    onclick="toggleStatus(<?php echo e($page->id); ?>)">
                                <?php if($page->is_active): ?>
                                    <i class="fas fa-check"></i> Active
                                <?php else: ?>
                                    <i class="fas fa-pause"></i> Inactive
                                <?php endif; ?>
                            </button>
                        </td>
                        <td>
                            <span class="badge bg-light text-dark">
                                <i class="fas fa-images"></i> <?php echo e(count($page->images ?? [])); ?>

                            </span>
                        </td>
                        <td>
                            <small><?php echo e($page->updated_at->format('M d, Y')); ?></small>
                            <br><small class="text-muted"><?php echo e($page->updated_at->format('g:i A')); ?></small>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="<?php echo e(route('admin.community-pages.show', $page)); ?>" class="btn btn-outline-info" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('admin.community-pages.edit', $page)); ?>" class="btn btn-outline-primary" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form method="POST" action="<?php echo e(route('admin.community-pages.destroy', $page)); ?>" style="display:inline;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-outline-danger" title="Delete" 
                                            onclick="return confirm('Are you sure you want to delete this page and all its images?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center py-4">
                            <i class="fas fa-file-alt fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No community pages found.</p>
                            <a href="<?php echo e(route('admin.community-pages.create')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus me-2"></i>Create First Page
                            </a>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Toggle page status
function toggleStatus(pageId) {
    fetch(`<?php echo e(url('admin/community-pages')); ?>/${pageId}/toggle-status`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Content-Type': 'application/json',
        },
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while updating page status.');
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio6\resources\views/admin/community-pages/index.blade.php ENDPATH**/ ?>