<?php $__env->startSection('title', 'Legal Pages Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">Legal Pages Management</h1>
    <a href="<?php echo e(route('admin.legal-pages.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Legal Page
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if($legalPages->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Slug</th>
                            <th>Status</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $legalPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <strong><?php echo e($page->title); ?></strong>
                                    <?php if($page->meta_description): ?>
                                        <small class="d-block text-muted"><?php echo e(Str::limit($page->meta_description, 60)); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <code><?php echo e($page->slug); ?></code>
                                </td>
                                <td>
                                    <?php if($page->is_active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($page->updated_at->format('M d, Y')); ?></td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="<?php echo e(route('admin.legal-pages.show', $page)); ?>" 
                                           class="btn btn-sm btn-outline-primary" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.legal-pages.edit', $page)); ?>" 
                                           class="btn btn-sm btn-outline-secondary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.legal-pages.toggle-status', $page)); ?>" 
                                              method="POST" style="display: inline;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                            <button type="submit" 
                                                    class="btn btn-sm <?php echo e($page->is_active ? 'btn-outline-warning' : 'btn-outline-success'); ?>" 
                                                    title="<?php echo e($page->is_active ? 'Deactivate' : 'Activate'); ?>">
                                                <i class="fas fa-<?php echo e($page->is_active ? 'eye-slash' : 'eye'); ?>"></i>
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('admin.legal-pages.destroy', $page)); ?>" 
                                              method="POST" style="display: inline;"
                                              onsubmit="return confirm('Are you sure you want to delete this legal page?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            
            <div class="d-flex justify-content-center">
                <?php echo e($legalPages->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="fas fa-file-contract fa-3x text-muted mb-3"></i>
                <h5>No Legal Pages Found</h5>
                <p class="text-muted">Create your first legal page to get started.</p>
                <a href="<?php echo e(route('admin.legal-pages.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add Legal Page
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio6\resources\views/admin/legal-pages/index.blade.php ENDPATH**/ ?>