

<?php $__env->startSection('title', 'Orders Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Orders Management</h1>
        <div class="btn-group">
            <button type="button" class="btn btn-outline-primary" onclick="exportOrders()">
                <i class="fas fa-download"></i> Export
            </button>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('admin.orders.index')); ?>" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Search</label>
                    <input type="text" name="search" class="form-control" 
                           placeholder="Order #, Customer, Email..." 
                           value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-select">
                        <option value="all">All Status</option>
                        <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                        <option value="processing" <?php echo e(request('status') == 'processing' ? 'selected' : ''); ?>>Processing</option>
                        <option value="shipped" <?php echo e(request('status') == 'shipped' ? 'selected' : ''); ?>>Shipped</option>
                        <option value="out_for_delivery" <?php echo e(request('status') == 'out_for_delivery' ? 'selected' : ''); ?>>Out for Delivery</option>
                        <option value="delivered" <?php echo e(request('status') == 'delivered' ? 'selected' : ''); ?>>Delivered</option>
                        <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                        <option value="refunded" <?php echo e(request('status') == 'refunded' ? 'selected' : ''); ?>>Refunded</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">From Date</label>
                    <input type="date" name="from_date" class="form-control" value="<?php echo e(request('from_date')); ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">To Date</label>
                    <input type="date" name="to_date" class="form-control" value="<?php echo e(request('to_date')); ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">&nbsp;</label>
                    <div>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search"></i> Filter
                        </button>
                        <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Orders Table -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Order #</th>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Items</th>
                            <th>Total</th>
                            <th>Payment</th>
                            <th>Status</th>
                            <th>Tracking</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <strong><?php echo e($order->order_number); ?></strong>
                            </td>
                            <td><?php echo e($order->created_at->format('M d, Y')); ?></td>
                            <td>
                                <div><?php echo e($order->customer_name); ?></div>
                                <small class="text-muted"><?php echo e($order->customer_email); ?></small>
                            </td>
                            <td><?php echo e($order->items->count()); ?> items</td>
                            <td>$<?php echo e(number_format($order->total_amount, 2)); ?></td>
                            <td>
                                <span class="badge bg-<?php echo e($order->payment_status_badge); ?>">
                                    <?php echo e(ucfirst($order->payment_status)); ?>

                                </span>
                                <br>
                                <small><?php echo e(ucfirst($order->payment_method ?? 'N/A')); ?></small>
                            </td>
                            <td>
                                <span class="badge bg-<?php echo e($order->status_badge); ?>">
                                    <?php echo e(ucfirst(str_replace('_', ' ', $order->status))); ?>

                                </span>
                            </td>
                            <td>
                                <?php if($order->tracking_number): ?>
                                    <span class="badge bg-info" title="<?php echo e($order->tracking_number); ?>">
                                        <i class="fas fa-truck"></i> Tracked
                                    </span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">No Tracking</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('admin.orders.show', $order)); ?>" 
                                       class="btn btn-sm btn-primary" title="View Details">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    
                                    <?php if($order->canBeCancelled()): ?>
                                    <button type="button" class="btn btn-sm btn-warning" 
                                            onclick="updateOrderStatus(<?php echo e($order->id); ?>, 'cancelled')"
                                            title="Cancel Order">
                                        <i class="fas fa-times"></i>
                                    </button>
                                    <?php endif; ?>
                                    
                                    <?php if($order->status == 'processing'): ?>
                                    <button type="button" class="btn btn-sm btn-info" 
                                            onclick="showShippingModal(<?php echo e($order->id); ?>)"
                                            title="Mark as Shipped">
                                        <i class="fas fa-shipping-fast"></i>
                                    </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center py-4">
                                <i class="fas fa-box-open fa-3x text-muted mb-3"></i>
                                <p>No orders found</p>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-between align-items-center mt-4">
                <div>
                    Showing <?php echo e($orders->firstItem() ?? 0); ?> to <?php echo e($orders->lastItem() ?? 0); ?> 
                    of <?php echo e($orders->total()); ?> results
                </div>
                <?php echo e($orders->links()); ?>

            </div>
        </div>
    </div>
</div>

<!-- Shipping Modal -->
<div class="modal fade" id="shippingModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="shippingForm" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Mark Order as Shipped</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Tracking Number *</label>
                        <input type="text" name="tracking_number" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Carrier *</label>
                        <select name="carrier" class="form-select" required>
                            <option value="">Select Carrier</option>
                            <option value="fedex">FedEx</option>
                            <option value="ups">UPS</option>
                            <option value="usps">USPS</option>
                            <option value="dhl">DHL</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Estimated Delivery Date *</label>
                        <input type="date" name="estimated_delivery" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Mark as Shipped</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function showShippingModal(orderId) {
    const modal = new bootstrap.Modal(document.getElementById('shippingModal'));
    document.getElementById('shippingForm').action = `/admin/orders/${orderId}/ship`;
    modal.show();
}

function updateOrderStatus(orderId, status) {
    if (!confirm(`Are you sure you want to ${status} this order?`)) return;
    
    fetch(`/admin/orders/${orderId}/status`, {
        method: 'PATCH',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: JSON.stringify({ status: status })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}

function exportOrders() {
    const params = new URLSearchParams(window.location.search);
    window.location.href = `/admin/reports/export/orders?${params.toString()}`;
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/admin/orders/index.blade.php ENDPATH**/ ?>