<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['src', 'alt', 'class' => '', 'loading' => 'lazy', 'style' => '']) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['src', 'alt', 'class' => '', 'loading' => 'lazy', 'style' => '']); ?>
<?php foreach (array_filter((['src', 'alt', 'class' => '', 'loading' => 'lazy', 'style' => '']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<?php
    // Simple and reliable image handling - skip ImageOptimizer to avoid dependency issues
    $finalSrc = $src;
    $webpSrc = null;
    $srcset = null;

    // Handle different image source types
    if (str_starts_with($finalSrc, 'http') || str_starts_with($finalSrc, '//')) {
        // External URL
        $imageSrc = $finalSrc;
        $fallbackSrc = $finalSrc;
    } elseif (class_exists('\App\Helpers\ImageHelper')) {
        // Use existing ImageHelper if available
        $imageSrc = \App\Helpers\ImageHelper::getImageUrl($finalSrc);
        $fallbackSrc = \App\Helpers\ImageHelper::getImageUrl($src);
    } else {
        // Default to asset helper
        $imageSrc = asset('images/' . $finalSrc);
        $fallbackSrc = asset('images/' . $src);
    }
?>

<div class="lazy-image-container <?php echo e($class); ?>">
    <img 
        src="<?php echo e($imageSrc); ?>" 
        alt="<?php echo e($alt); ?>" 
        loading="<?php echo e($loading); ?>"
        decoding="async"
        class="img-fluid <?php echo e($class); ?>"
        <?php if($style): ?>
        style="transition: opacity 0.3s ease-in-out; <?php echo e($style); ?>"
        <?php else: ?>
        style="transition: opacity 0.3s ease-in-out;"
        <?php endif; ?>
        onload="this.style.opacity=1;"
        onerror="this.src='<?php echo e($fallbackSrc); ?>'"
        <?php echo e($attributes); ?>

    >
</div>

<?php if (! $__env->hasRenderedOnce('e2d173a6-323e-4e7a-86c1-7dde37ccb437')): $__env->markAsRenderedOnce('e2d173a6-323e-4e7a-86c1-7dde37ccb437'); ?>
<?php $__env->startPush('styles'); ?>
<style>
    .lazy-image-container img {
        opacity: 0;
        transition: opacity 0.3s ease-in-out;
    }
    
    .lazy-image-container img[loading="lazy"] {
        opacity: 1;
    }
    
    .lazy-image-container img.loaded {
        opacity: 1;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Enhanced lazy loading with Intersection Observer
    document.addEventListener('DOMContentLoaded', function() {
        if ('IntersectionObserver' in window) {
            const imageObserver = new IntersectionObserver((entries, observer) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const img = entry.target;
                        img.classList.add('loaded');
                        observer.unobserve(img);
                    }
                });
            }, {
                rootMargin: '50px 0px',
                threshold: 0.01
            });

            document.querySelectorAll('.lazy-image-container img[loading="lazy"]').forEach(img => {
                imageObserver.observe(img);
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php endif; ?><?php /**PATH C:\xampp\htdocs\export-portfolio6\resources\views/components/lazy-image.blade.php ENDPATH**/ ?>