<?php $__env->startSection('title', 'Seasonal Fashion Forecast - Edition By Punjab'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
    <!-- Hero Section -->
    <section class="seasonal-forecast-hero py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4">Seasonal Style Forecast</h1>
                        <p class="lead mb-4">Your guide to upcoming seasonal trends and must-have pieces for Australian streetwear</p>
                        <div class="hero-stats d-flex justify-content-center gap-5 mt-4">
                            <div class="stat-item">
                                <h3 class="fw-bold"><?php echo e(count($seasonalForecasts)); ?></h3>
                                <p class="mb-0">Season Forecasts</p>
                            </div>
                            <div class="stat-item">
                                <h3 class="fw-bold"><?php echo e(date('Y')); ?></h3>
                                <p class="mb-0">Current Year</p>
                            </div>
                            <div class="stat-item">
                                <h3 class="fw-bold">100%</h3>
                                <p class="mb-0">Trend Accuracy</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Seasonal Forecasts Section -->
    <section class="seasonal-forecasts py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="section-header text-center mb-5">
                        <h2 class="display-5 fw-bold text-dark">Upcoming Seasons</h2>
                        <p class="lead text-muted">Stay ahead of the curve with our detailed seasonal predictions</p>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                <?php $__currentLoopData = $seasonalForecasts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $forecastKey => $forecast): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-6">
                    <div class="forecast-card card border-0 shadow-lg h-100 overflow-hidden">
                        <!-- Season Header -->
                        <div class="forecast-header p-4 text-white position-relative" 
                             style="background: linear-gradient(135deg, 
                                    <?php if($forecastKey === 'spring_2024'): ?> 
                                        #a8edea 0%, #fed6e3 100%
                                    <?php else: ?> 
                                        #ff9a9e 0%, #fecfef 100%
                                    <?php endif; ?>
                                    );">
                            <div class="season-badge position-absolute top-0 end-0 mt-3 me-3">
                                <span class="badge bg-white text-dark px-3 py-2"><?php echo e($forecast['season']); ?></span>
                            </div>
                            <h3 class="fw-bold mb-3 text-dark"><?php echo e($forecast['title']); ?></h3>
                            <p class="mb-0 text-dark"><?php echo e($forecast['description']); ?></p>
                        </div>

                        <div class="card-body p-4">
                            <!-- Key Trends -->
                            <div class="key-trends mb-4">
                                <h5 class="fw-bold text-dark mb-3">
                                    <i class="fas fa-star text-warning me-2"></i>Key Trends
                                </h5>
                                <div class="row g-2">
                                    <?php $__currentLoopData = $forecast['key_trends']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trend): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-12">
                                        <div class="trend-item d-flex align-items-center p-2 border rounded">
                                            <i class="fas fa-check-circle text-success me-3"></i>
                                            <span><?php echo e($trend); ?></span>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>

                            <!-- Color Palette -->
                            <div class="color-palette mb-4">
                                <h5 class="fw-bold text-dark mb-3">
                                    <i class="fas fa-palette text-info me-2"></i>Color Palette
                                </h5>
                                <div class="d-flex flex-wrap gap-3">
                                    <?php $__currentLoopData = $forecast['color_palette']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="color-item text-center">
                                        <div class="color-swatch mx-auto mb-2 rounded-circle border shadow-sm" 
                                             style="width: 50px; height: 50px; background: 
                                             <?php switch($color):
                                                 case ('Sage Green'): ?> #9CAF88 <?php break; ?>
                                                 <?php case ('Ocean Blue'): ?> #006994 <?php break; ?>
                                                 <?php case ('Sunset Orange'): ?> #FF6B35 <?php break; ?>
                                                 <?php case ('Natural Beige'): ?> #F5F5DC <?php break; ?>
                                                 <?php case ('Electric Blue'): ?> #0080FF <?php break; ?>
                                                 <?php case ('Coral Pink'): ?> #FF7F7F <?php break; ?>
                                                 <?php case ('Lime Green'): ?> #32CD32 <?php break; ?>
                                                 <?php case ('Pure White'): ?> #FFFFFF <?php break; ?>
                                                 <?php default: ?> #cccccc
                                             <?php endswitch; ?>
                                             ;"></div>
                                        <small class="text-muted"><?php echo e($color); ?></small>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>

                            <!-- Must-Have Pieces -->
                            <div class="must-have-pieces">
                                <h5 class="fw-bold text-dark mb-3">
                                    <i class="fas fa-shopping-bag text-primary me-2"></i>Must-Have Pieces
                                </h5>
                                <div class="row g-2">
                                    <?php $__currentLoopData = $forecast['must_have_pieces']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $piece): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-6">
                                        <div class="piece-item badge bg-light text-dark w-100 text-start p-3 border">
                                            <i class="fas fa-tshirt me-2 text-primary"></i><?php echo e($piece); ?>

                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="action-buttons mt-4 d-flex gap-3">
                                <a href="<?php echo e(route('shop.index')); ?>" class="btn btn-primary flex-fill">
                                    <i class="fas fa-shopping-cart me-2"></i>Shop Collection
                                </a>
                                <a href="<?php echo e(route('style-guide.index')); ?>" class="btn btn-outline-primary flex-fill">
                                    <i class="fas fa-map-marked-alt me-2"></i>Style Guide
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <!-- Seasonal Tips Section -->
    <section class="seasonal-tips py-5">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h3 class="text-center mb-5 fw-bold">Seasonal Styling Tips</h3>
                </div>
            </div>
            <div class="row g-4">
                <div class="col-lg-3 col-md-6">
                    <div class="tip-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-sun fa-3x text-warning"></i>
                        </div>
                        <h5 class="fw-bold">Layer Smart</h5>
                        <p class="text-muted mb-0">Australian weather can be unpredictable. Master the art of layering for versatility.</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="tip-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-leaf fa-3x text-success"></i>
                        </div>
                        <h5 class="fw-bold">Sustainable Choices</h5>
                        <p class="text-muted mb-0">Invest in quality pieces that will last multiple seasons and trends.</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="tip-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-palette fa-3x text-info"></i>
                        </div>
                        <h5 class="fw-bold">Color Coordination</h5>
                        <p class="text-muted mb-0">Learn to mix seasonal colors with your existing wardrobe pieces.</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="tip-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-thermometer-half fa-3x text-danger"></i>
                        </div>
                        <h5 class="fw-bold">Climate Ready</h5>
                        <p class="text-muted mb-0">Choose fabrics and fits appropriate for Australian climate conditions.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Navigation Section -->
    <section class="trends-navigation py-5 bg-dark text-white">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <h3 class="mb-5 fw-bold">Explore More Trends</h3>
                </div>
            </div>
            <div class="row g-4 text-center">
                <div class="col-lg-4 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-chart-trending-up fa-3x mb-3 text-warning"></i>
                        <h5 class="fw-bold">Weekly Trends</h5>
                        <p class="text-muted">Latest weekly streetwear trends</p>
                        <a href="<?php echo e(route('trends.weekly')); ?>" class="btn btn-outline-warning">View Trends</a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-newspaper fa-3x mb-3 text-success"></i>
                        <h5 class="fw-bold">Fashion News</h5>
                        <p class="text-muted">Latest industry updates</p>
                        <a href="<?php echo e(route('trends.news')); ?>" class="btn btn-outline-success">Read News</a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-crystal-ball fa-3x mb-3 text-danger"></i>
                        <h5 class="fw-bold">Style Predictions</h5>
                        <p class="text-muted">Future fashion forecasts</p>
                        <a href="<?php echo e(route('trends.predictions')); ?>" class="btn btn-outline-danger">See Predictions</a>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-12 text-center">
                    <a href="<?php echo e(route('trends.index')); ?>" class="btn btn-outline-light btn-lg px-5 rounded-pill">
                        <i class="fas fa-arrow-left me-2"></i> Back to Trends Overview
                    </a>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
.forecast-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.forecast-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.15) !important;
}

.tip-card {
    transition: transform 0.3s ease, border-color 0.3s ease;
}

.tip-card:hover {
    transform: translateY(-3px);
    border-color: #3b82f6 !important;
}

.nav-item {
    transition: transform 0.3s ease, border-color 0.3s ease;
}

.nav-item:hover {
    transform: translateY(-5px);
    border-color: #fff !important;
}

.color-swatch {
    transition: transform 0.3s ease;
}

.color-swatch:hover {
    transform: scale(1.1);
}

.trend-item {
    transition: background-color 0.3s ease;
}

.trend-item:hover {
    background-color: rgba(59, 130, 246, 0.1);
}

.piece-item {
    transition: transform 0.3s ease, background-color 0.3s ease;
}

.piece-item:hover {
    transform: scale(1.02);
    background-color: rgba(59, 130, 246, 0.1) !important;
}

.seasonal-forecast-hero {
    position: relative;
    overflow: hidden;
}

.seasonal-forecast-hero::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.1);
    z-index: 1;
}

.seasonal-forecast-hero .container {
    position: relative;
    z-index: 2;
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/trends/seasonal.blade.php ENDPATH**/ ?>