<!-- resources/views/admin/inquiries/index.blade.php -->


<?php $__env->startSection('title', 'Inquiries'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Inquiries</h1>
    <div>
        <span class="badge bg-warning">New: <?php echo e($inquiries->where('status', 'new')->count()); ?></span>
        <span class="badge bg-info">In Progress: <?php echo e($inquiries->where('status', 'in_progress')->count()); ?></span>
        <span class="badge bg-success">Completed: <?php echo e($inquiries->where('status', 'completed')->count()); ?></span>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Country</th>
                        <th>Subject</th>
                        <th>Product</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $inquiries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inquiry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($inquiry->created_at->format('Y-m-d')); ?></td>
                        <td><?php echo e($inquiry->name); ?></td>
                        <td><?php echo e($inquiry->email); ?></td>
                        <td><?php echo e($inquiry->country); ?></td>
                        <td><?php echo e(Str::limit($inquiry->subject, 30)); ?></td>
                        <td>
                            <?php if($inquiry->product): ?>
                                <a href="<?php echo e(route('product.detail', $inquiry->product->slug)); ?>" target="_blank">
                                    <?php echo e($inquiry->product->name); ?>

                                </a>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($inquiry->status == 'new' ? 'warning' : ($inquiry->status == 'in_progress' ? 'info' : 'success')); ?>">
                                <?php echo e(ucfirst(str_replace('_', ' ', $inquiry->status))); ?>

                            </span>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.inquiries.show', $inquiry)); ?>" class="btn btn-sm btn-primary">
                                <i class="fas fa-eye"></i>
                            </a>
                            <form action="<?php echo e(route('admin.inquiries.destroy', $inquiry)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center">No inquiries found</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php echo e($inquiries->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/admin/inquiries/index.blade.php ENDPATH**/ ?>