<?php $__env->startSection('title', 'Size Guide - Find Your Perfect Fit | Edition By Punjab'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="Complete size guide for Edition By Punjab streetwear. Find your perfect fit for hoodies, tees, bottoms and accessories with detailed measurements and fit tips.">
<meta name="keywords" content="size guide, streetwear sizing, hoodie size chart, t-shirt measurements, joggers sizing, australian streetwear sizes">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if (isset($component)) { $__componentOriginal269900abaed345884ce342681cdc99f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal269900abaed345884ce342681cdc99f6 = $attributes; } ?>
<?php $component = App\View\Components\Breadcrumb::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $attributes = $__attributesOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__attributesOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $component = $__componentOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__componentOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>

<!-- Hero Section -->
<section class="size-guide-hero py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8 mx-auto text-center text-white">
                <h1 class="display-4 fw-bold mb-4">Size Guide</h1>
                <p class="lead mb-4">Find your perfect fit with our comprehensive sizing guide. Get the right size the first time for ultimate comfort and style.</p>
                <div class="hero-stats d-flex justify-content-center gap-4 mb-4">
                    <div class="stat-item">
                        <div class="stat-number h4 mb-0">97%</div>
                        <small>Fit Satisfaction</small>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number h4 mb-0">24/7</div>
                        <small>Size Support</small>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number h4 mb-0">Free</div>
                        <small>Exchange Policy</small>
                    </div>
                </div>
                <a href="<?php echo e(route('size-guide.finder')); ?>" class="btn btn-light btn-lg">
                    Find My Size <i class="fas fa-ruler ms-2"></i>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Size Guide Navigation -->
<section class="size-navigation py-4 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="nav nav-pills justify-content-center gap-3" id="size-guide-tabs" role="tablist">
                    <?php $__currentLoopData = $sizeGuides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $guide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button class="nav-link <?php echo e($loop->first ? 'active' : ''); ?>" 
                            id="<?php echo e($key); ?>-tab" 
                            data-bs-toggle="pill" 
                            data-bs-target="#<?php echo e($key); ?>" 
                            type="button" 
                            role="tab">
                        <?php echo e($guide['name']); ?>

                    </button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Size Guide Content -->
<section class="size-guide-content py-5">
    <div class="container">
        <div class="tab-content" id="size-guide-content">
            <?php $__currentLoopData = $sizeGuides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $guide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="tab-pane fade <?php echo e($loop->first ? 'show active' : ''); ?>" 
                 id="<?php echo e($key); ?>" 
                 role="tabpanel" 
                 aria-labelledby="<?php echo e($key); ?>-tab">
                
                <div class="row align-items-center mb-5">
                    <div class="col-lg-6">
                        <div class="size-guide-intro">
                            <h2 class="mb-3"><?php echo e($guide['name']); ?></h2>
                            <p class="lead text-muted mb-4"><?php echo e($guide['description']); ?></p>
                            <div class="fit-info p-3 bg-light rounded">
                                <h6 class="fw-semibold mb-2">Fit Style: <?php echo e($guide['fit_type']); ?></h6>
                                <p class="mb-0 text-sm">All measurements are in centimeters and based on garment measurements, not body measurements.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="size-guide-image">
                            <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => ''.e($guide['image']).'','alt' => 'Size guide for '.e($guide['name']).'','class' => 'img-fluid rounded-lg shadow','style' => 'width: 100%; height: 400px; object-fit: cover;'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <!-- Size Chart -->
                <div class="size-chart mb-5">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h4>Size Chart</h4>
                        <button class="btn btn-outline-primary btn-sm" onclick="toggleMeasurements('<?php echo e($key); ?>')">
                            <i class="fas fa-ruler-horizontal me-1"></i>
                            <span id="toggle-text-<?php echo e($key); ?>">Show in Inches</span>
                        </button>
                    </div>
                    
                    <div class="table-responsive">
                        <?php if($key === 'hoodies'): ?>
                        <table class="size-table-premium" id="chart-<?php echo e($key); ?>">
                            <thead class="table-dark">
                                <tr>
                                    <th>Size</th>
                                    <th>Chest (cm)</th>
                                    <th>Length (cm)</th>
                                    <th>Sleeve (cm)</th>
                                    <th>Shoulder (cm)</th>
                                    <th>Australian Size</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><strong>XS</strong></td>
                                    <td class="measurement" data-cm="50" data-in="19.7">50</td>
                                    <td class="measurement" data-cm="66" data-in="26.0">66</td>
                                    <td class="measurement" data-cm="59" data-in="23.2">59</td>
                                    <td class="measurement" data-cm="44" data-in="17.3">44</td>
                                    <td>6-8</td>
                                </tr>
                                <tr>
                                    <td><strong>S</strong></td>
                                    <td class="measurement" data-cm="53" data-in="20.9">53</td>
                                    <td class="measurement" data-cm="68" data-in="26.8">68</td>
                                    <td class="measurement" data-cm="61" data-in="24.0">61</td>
                                    <td class="measurement" data-cm="46" data-in="18.1">46</td>
                                    <td>8-10</td>
                                </tr>
                                <tr>
                                    <td><strong>M</strong></td>
                                    <td class="measurement" data-cm="56" data-in="22.0">56</td>
                                    <td class="measurement" data-cm="70" data-in="27.6">70</td>
                                    <td class="measurement" data-cm="63" data-in="24.8">63</td>
                                    <td class="measurement" data-cm="48" data-in="18.9">48</td>
                                    <td>10-12</td>
                                </tr>
                                <tr>
                                    <td><strong>L</strong></td>
                                    <td class="measurement" data-cm="59" data-in="23.2">59</td>
                                    <td class="measurement" data-cm="72" data-in="28.3">72</td>
                                    <td class="measurement" data-cm="65" data-in="25.6">65</td>
                                    <td class="measurement" data-cm="50" data-in="19.7">50</td>
                                    <td>12-14</td>
                                </tr>
                                <tr>
                                    <td><strong>XL</strong></td>
                                    <td class="measurement" data-cm="62" data-in="24.4">62</td>
                                    <td class="measurement" data-cm="74" data-in="29.1">74</td>
                                    <td class="measurement" data-cm="67" data-in="26.4">67</td>
                                    <td class="measurement" data-cm="52" data-in="20.5">52</td>
                                    <td>14-16</td>
                                </tr>
                                <tr>
                                    <td><strong>XXL</strong></td>
                                    <td class="measurement" data-cm="65" data-in="25.6">65</td>
                                    <td class="measurement" data-cm="76" data-in="29.9">76</td>
                                    <td class="measurement" data-cm="69" data-in="27.2">69</td>
                                    <td class="measurement" data-cm="54" data-in="21.3">54</td>
                                    <td>16-18</td>
                                </tr>
                            </tbody>
                        </table>
                        <?php elseif($key === 'tees'): ?>
                        <table class="size-table-premium" id="chart-<?php echo e($key); ?>">
                            <thead class="table-dark">
                                <tr>
                                    <th>Size</th>
                                    <th>Chest (cm)</th>
                                    <th>Length (cm)</th>
                                    <th>Sleeve (cm)</th>
                                    <th>Shoulder (cm)</th>
                                    <th>Australian Size</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><strong>XS</strong></td>
                                    <td class="measurement" data-cm="47" data-in="18.5">47</td>
                                    <td class="measurement" data-cm="66" data-in="26.0">66</td>
                                    <td class="measurement" data-cm="19" data-in="7.5">19</td>
                                    <td class="measurement" data-cm="42" data-in="16.5">42</td>
                                    <td>6-8</td>
                                </tr>
                                <tr>
                                    <td><strong>S</strong></td>
                                    <td class="measurement" data-cm="50" data-in="19.7">50</td>
                                    <td class="measurement" data-cm="68" data-in="26.8">68</td>
                                    <td class="measurement" data-cm="20" data-in="7.9">20</td>
                                    <td class="measurement" data-cm="44" data-in="17.3">44</td>
                                    <td>8-10</td>
                                </tr>
                                <tr>
                                    <td><strong>M</strong></td>
                                    <td class="measurement" data-cm="53" data-in="20.9">53</td>
                                    <td class="measurement" data-cm="70" data-in="27.6">70</td>
                                    <td class="measurement" data-cm="21" data-in="8.3">21</td>
                                    <td class="measurement" data-cm="46" data-in="18.1">46</td>
                                    <td>10-12</td>
                                </tr>
                                <tr>
                                    <td><strong>L</strong></td>
                                    <td class="measurement" data-cm="56" data-in="22.0">56</td>
                                    <td class="measurement" data-cm="72" data-in="28.3">72</td>
                                    <td class="measurement" data-cm="22" data-in="8.7">22</td>
                                    <td class="measurement" data-cm="48" data-in="18.9">48</td>
                                    <td>12-14</td>
                                </tr>
                                <tr>
                                    <td><strong>XL</strong></td>
                                    <td class="measurement" data-cm="59" data-in="23.2">59</td>
                                    <td class="measurement" data-cm="74" data-in="29.1">74</td>
                                    <td class="measurement" data-cm="23" data-in="9.1">23</td>
                                    <td class="measurement" data-cm="50" data-in="19.7">50</td>
                                    <td>14-16</td>
                                </tr>
                                <tr>
                                    <td><strong>XXL</strong></td>
                                    <td class="measurement" data-cm="62" data-in="24.4">62</td>
                                    <td class="measurement" data-cm="76" data-in="29.9">76</td>
                                    <td class="measurement" data-cm="24" data-in="9.4">24</td>
                                    <td class="measurement" data-cm="52" data-in="20.5">52</td>
                                    <td>16-18</td>
                                </tr>
                            </tbody>
                        </table>
                        <?php elseif($key === 'bottoms'): ?>
                        <table class="size-table-premium" id="chart-<?php echo e($key); ?>">
                            <thead class="table-dark">
                                <tr>
                                    <th>Size</th>
                                    <th>Waist (cm)</th>
                                    <th>Hip (cm)</th>
                                    <th>Inseam (cm)</th>
                                    <th>Outseam (cm)</th>
                                    <th>Australian Size</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><strong>XS</strong></td>
                                    <td class="measurement" data-cm="66" data-in="26.0">66</td>
                                    <td class="measurement" data-cm="96" data-in="37.8">96</td>
                                    <td class="measurement" data-cm="76" data-in="29.9">76</td>
                                    <td class="measurement" data-cm="102" data-in="40.2">102</td>
                                    <td>6-8</td>
                                </tr>
                                <tr>
                                    <td><strong>S</strong></td>
                                    <td class="measurement" data-cm="71" data-in="28.0">71</td>
                                    <td class="measurement" data-cm="101" data-in="39.8">101</td>
                                    <td class="measurement" data-cm="76" data-in="29.9">76</td>
                                    <td class="measurement" data-cm="102" data-in="40.2">102</td>
                                    <td>8-10</td>
                                </tr>
                                <tr>
                                    <td><strong>M</strong></td>
                                    <td class="measurement" data-cm="76" data-in="29.9">76</td>
                                    <td class="measurement" data-cm="106" data-in="41.7">106</td>
                                    <td class="measurement" data-cm="76" data-in="29.9">76</td>
                                    <td class="measurement" data-cm="102" data-in="40.2">102</td>
                                    <td>10-12</td>
                                </tr>
                                <tr>
                                    <td><strong>L</strong></td>
                                    <td class="measurement" data-cm="81" data-in="31.9">81</td>
                                    <td class="measurement" data-cm="111" data-in="43.7">111</td>
                                    <td class="measurement" data-cm="76" data-in="29.9">76</td>
                                    <td class="measurement" data-cm="102" data-in="40.2">102</td>
                                    <td>12-14</td>
                                </tr>
                                <tr>
                                    <td><strong>XL</strong></td>
                                    <td class="measurement" data-cm="86" data-in="33.9">86</td>
                                    <td class="measurement" data-cm="116" data-in="45.7">116</td>
                                    <td class="measurement" data-cm="76" data-in="29.9">76</td>
                                    <td class="measurement" data-cm="102" data-in="40.2">102</td>
                                    <td>14-16</td>
                                </tr>
                                <tr>
                                    <td><strong>XXL</strong></td>
                                    <td class="measurement" data-cm="91" data-in="35.8">91</td>
                                    <td class="measurement" data-cm="121" data-in="47.6">121</td>
                                    <td class="measurement" data-cm="76" data-in="29.9">76</td>
                                    <td class="measurement" data-cm="102" data-in="40.2">102</td>
                                    <td>16-18</td>
                                </tr>
                            </tbody>
                        </table>
                        <?php else: ?>
                        <table class="size-table-premium" id="chart-<?php echo e($key); ?>">
                            <thead class="table-dark">
                                <tr>
                                    <th>Item</th>
                                    <th>One Size Fits</th>
                                    <th>Adjustable Range</th>
                                    <th>Material</th>
                                    <th>Australian Size</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><strong>Snapback Caps</strong></td>
                                    <td>54-60cm</td>
                                    <td>Adjustable snapback</td>
                                    <td>Cotton/Polyester</td>
                                    <td>One Size</td>
                                </tr>
                                <tr>
                                    <td><strong>Beanies</strong></td>
                                    <td>54-62cm</td>
                                    <td>Stretch fit</td>
                                    <td>Acrylic knit</td>
                                    <td>One Size</td>
                                </tr>
                                <tr>
                                    <td><strong>Bucket Hats</strong></td>
                                    <td>56-60cm</td>
                                    <td>Fixed size</td>
                                    <td>Cotton twill</td>
                                    <td>One Size</td>
                                </tr>
                                <tr>
                                    <td><strong>Tote Bags</strong></td>
                                    <td>38cm x 42cm</td>
                                    <td>N/A</td>
                                    <td>Canvas</td>
                                    <td>One Size</td>
                                </tr>
                            </tbody>
                        </table>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Fit Tips -->
                <div class="fit-tips p-4 bg-light rounded">
                    <h5 class="mb-3"><i class="fas fa-lightbulb text-warning me-2"></i>Fit Tips</h5>
                    <div class="row g-3">
                        <?php if($key === 'hoodies'): ?>
                        <div class="col-md-6">
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success me-2"></i>Designed for a relaxed, oversized fit</li>
                                <li><i class="fas fa-check text-success me-2"></i>Size down for a more fitted look</li>
                                <li><i class="fas fa-check text-success me-2"></i>Pre-shrunk cotton blend</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success me-2"></i>Double-lined hood for structure</li>
                                <li><i class="fas fa-check text-success me-2"></i>Ribbed cuffs and hem</li>
                                <li><i class="fas fa-check text-success me-2"></i>Kangaroo pocket placement optimized</li>
                            </ul>
                        </div>
                        <?php elseif($key === 'tees'): ?>
                        <div class="col-md-6">
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success me-2"></i>True to size with slight room</li>
                                <li><i class="fas fa-check text-success me-2"></i>Shoulder seams sit naturally</li>
                                <li><i class="fas fa-check text-success me-2"></i>Pre-shrunk for consistency</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success me-2"></i>Tapered cut through body</li>
                                <li><i class="fas fa-check text-success me-2"></i>Reinforced neck construction</li>
                                <li><i class="fas fa-check text-success me-2"></i>Perfect for layering</li>
                            </ul>
                        </div>
                        <?php elseif($key === 'bottoms'): ?>
                        <div class="col-md-6">
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success me-2"></i>Tapered fit from hip to ankle</li>
                                <li><i class="fas fa-check text-success me-2"></i>Adjustable drawstring waistband</li>
                                <li><i class="fas fa-check text-success me-2"></i>Ribbed ankle cuffs</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success me-2"></i>Side pockets and back pocket</li>
                                <li><i class="fas fa-check text-success me-2"></i>Stretch fabric blend</li>
                                <li><i class="fas fa-check text-success me-2"></i>Machine washable</li>
                            </ul>
                        </div>
                        <?php else: ?>
                        <div class="col-md-6">
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success me-2"></i>All accessories designed for comfort</li>
                                <li><i class="fas fa-check text-success me-2"></i>Adjustable options where applicable</li>
                                <li><i class="fas fa-check text-success me-2"></i>Quality materials for durability</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success me-2"></i>Unisex designs</li>
                                <li><i class="fas fa-check text-success me-2"></i>Easy care instructions</li>
                                <li><i class="fas fa-check text-success me-2"></i>Suitable for all seasons</li>
                            </ul>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- How to Measure -->
<section class="how-to-measure-premium">
    <div class="container">
        <div class="section-header-center" data-aos="fade-up">
            <span class="section-label-premium">MEASUREMENT GUIDE</span>
            <h2 class="section-title-premium">How to Measure</h2>
            <p class="section-subtitle">Follow these simple steps to get accurate measurements</p>
        </div>
        
        <div class="measure-grid">
            <div class="measure-card-premium" data-aos="fade-up">
                <div class="measure-icon">
                    <i class="fas fa-tshirt"></i>
                </div>
                <h5 class="measure-title">Chest/Bust</h5>
                <p class="measure-text">Measure around the fullest part of your chest, keeping the tape parallel to the ground.</p>
            </div>
            
            <div class="measure-card-premium" data-aos="fade-up" data-aos-delay="100">
                <div class="measure-icon">
                    <i class="fas fa-arrows-alt-v"></i>
                </div>
                <h5 class="measure-title">Length</h5>
                <p class="measure-text">For tops: measure from the highest point of shoulder to desired length.</p>
            </div>
            
            <div class="measure-card-premium" data-aos="fade-up" data-aos-delay="200">
                <div class="measure-icon">
                    <i class="fas fa-grip-lines"></i>
                </div>
                <h5 class="measure-title">Waist</h5>
                <p class="measure-text">Measure around your natural waistline, where you normally wear your pants.</p>
            </div>
            
            <div class="measure-card-premium" data-aos="fade-up" data-aos-delay="300">
                <div class="measure-icon">
                    <i class="fas fa-ruler"></i>
                </div>
                <h5 class="measure-title">Inseam</h5>
                <p class="measure-text">Measure from crotch seam to bottom of ankle for accurate pant length.</p>
            </div>
        </div>
        
        <div class="pro-tip-premium" data-aos="fade-up" data-aos-delay="400">
            <div class="tip-card">
                <div class="tip-icon">
                    <i class="fas fa-info-circle"></i>
                </div>
                <div class="tip-content">
                    <strong>Pro Tip:</strong> Use a flexible measuring tape and have someone help you for the most accurate measurements.
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Size Exchange Policy -->
<section class="exchange-policy-premium">
    <div class="container">
        <div class="policy-wrapper" data-aos="zoom-in">
            <div class="policy-card-premium">
                <div class="policy-header">
                    <div class="policy-icon">
                        <i class="fas fa-shield-check"></i>
                    </div>
                    <h3 class="policy-title">Perfect Fit Guarantee</h3>
                    <p class="policy-subtitle">Not sure about your size? Don't worry! We offer free size exchanges within 30 days of purchase.</p>
                </div>
                
                <div class="policy-features">
                    <div class="feature-item-premium">
                        <div class="feature-icon">
                            <i class="fas fa-shipping-fast"></i>
                        </div>
                        <h6>Free Exchange Shipping</h6>
                        <span>Both ways across Australia</span>
                    </div>
                    <div class="feature-item-premium">
                        <div class="feature-icon">
                            <i class="fas fa-calendar-alt"></i>
                        </div>
                        <h6>30 Day Window</h6>
                        <span>Plenty of time to decide</span>
                    </div>
                    <div class="feature-item-premium">
                        <div class="feature-icon">
                            <i class="fas fa-thumbs-up"></i>
                        </div>
                        <h6>Hassle-Free Process</h6>
                        <span>Simple online returns</span>
                    </div>
                    </div>
                    
                <div class="policy-actions">
                    <a href="<?php echo e(route('size-guide.finder')); ?>" class="btn-premium-primary">
                        <span class="btn-text">FIND MY PERFECT SIZE</span>
                        <i class="fas fa-ruler"></i>
                    </a>
                    <a href="<?php echo e(route('contact')); ?>" class="btn-premium-secondary">
                        <span class="btn-text">SIZE HELP & SUPPORT</span>
                        <i class="fas fa-headset"></i>
                    </a>
                </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('styles'); ?>
<style>
/* Premium Size Guide Styles */
.size-guide-hero-premium {
    position: relative;
    min-height: 100vh;
    display: flex;
    align-items: center;
    background: linear-gradient(135deg, rgba(26, 35, 126, 0.95) 0%, rgba(74, 86, 226, 0.95) 100%), url('/api/placeholder/1920/1080') center/cover;
    color: white;
    overflow: hidden;
}

.size-guide-hero-premium .hero-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, rgba(26, 35, 126, 0.8) 0%, rgba(74, 86, 226, 0.6) 100%);
}

.hero-content-center {
    position: relative;
    z-index: 2;
    text-align: center;
    max-width: 800px;
    margin: 0 auto;
}

.hero-label {
    display: inline-block;
    padding: 0.5rem 1.5rem;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50px;
    font-size: 0.875rem;
    font-weight: 600;
    letter-spacing: 0.1em;
    margin-bottom: 1.5rem;
    backdrop-filter: blur(10px);
}

.hero-title-premium {
    font-size: clamp(2.5rem, 5vw, 4rem);
    font-weight: 700;
    margin-bottom: 1.5rem;
    line-height: 1.1;
}

.hero-subtitle {
    font-size: 1.25rem;
    margin-bottom: 3rem;
    opacity: 0.9;
    line-height: 1.6;
}

.hero-stats-premium {
    display: flex;
    justify-content: center;
    gap: 2rem;
    margin-bottom: 3rem;
    flex-wrap: wrap;
}

.stat-item-premium {
    text-align: center;
    padding: 1rem;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 15px;
    backdrop-filter: blur(10px);
    min-width: 120px;
}

.stat-number {
    display: block;
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
    color: #ffffff;
}

.stat-label {
    font-size: 0.875rem;
    opacity: 0.9;
}

.btn-premium-primary {
    display: inline-flex;
    align-items: center;
    gap: 0.75rem;
    padding: 1rem 2rem;
    background: #ffffff;
    color: #1a237e;
    border: none;
    border-radius: 50px;
    font-weight: 600;
    font-size: 1rem;
    text-decoration: none;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.btn-premium-primary:hover {
    transform: translateY(-3px);
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
    color: #1a237e;
}

.btn-premium-secondary {
    display: inline-flex;
    align-items: center;
    gap: 0.75rem;
    padding: 1rem 2rem;
    background: transparent;
    color: #ffffff;
    border: 2px solid rgba(255, 255, 255, 0.3);
    border-radius: 50px;
    font-weight: 600;
    font-size: 1rem;
    text-decoration: none;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.btn-premium-secondary:hover {
    background: rgba(255, 255, 255, 0.1);
    border-color: rgba(255, 255, 255, 0.5);
    color: #ffffff;
    transform: translateY(-2px);
}

.scroll-indicator {
    position: absolute;
    bottom: 30px;
    left: 50%;
    transform: translateX(-50%);
    width: 2px;
    height: 60px;
    background: rgba(255, 255, 255, 0.3);
    border-radius: 1px;
    overflow: hidden;
}

.scroll-indicator span {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: #ffffff;
    animation: scrollIndicator 2s infinite;
}

@keyframes scrollIndicator {
    0% { transform: translateY(-100%); }
    50% { transform: translateY(0%); }
    100% { transform: translateY(100%); }
}

/* Navigation Premium */
.size-navigation-premium {
    padding: 3rem 0;
    background: #f8f9fa;
}

.navigation-wrapper {
    max-width: 800px;
    margin: 0 auto;
}

.nav-pills-premium {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.nav-link-premium {
    position: relative;
    padding: 1rem 2rem;
    background: #ffffff;
    border: 2px solid transparent;
    border-radius: 50px;
    color: #6c757d;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
    overflow: hidden;
}

.nav-link-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, #4a56e2 0%, #1a237e 100%);
    transition: left 0.3s ease;
    z-index: 0;
}

.nav-link-premium .nav-text {
    position: relative;
    z-index: 1;
    transition: color 0.3s ease;
}

.nav-link-premium:hover,
.nav-link-premium.active {
    color: #ffffff;
    border-color: #4a56e2;
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(74, 86, 226, 0.3);
}

.nav-link-premium:hover::before,
.nav-link-premium.active::before {
    left: 0;
}

/* Content Premium */
.size-guide-content-premium {
    padding: 5rem 0;
}

.size-guide-intro-premium {
    margin-bottom: 5rem;
}

.section-label-premium {
    display: inline-block;
    padding: 0.5rem 1.5rem;
    background: linear-gradient(135deg, #4a56e2 0%, #1a237e 100%);
    color: white;
    border-radius: 50px;
    font-size: 0.875rem;
    font-weight: 600;
    letter-spacing: 0.1em;
    margin-bottom: 1.5rem;
}

.section-title-premium {
    font-size: clamp(2rem, 4vw, 3rem);
    font-weight: 700;
    margin-bottom: 1.5rem;
    color: #1a237e;
    line-height: 1.2;
}

.intro-text {
    font-size: 1.125rem;
    line-height: 1.8;
    color: #6c757d;
    margin-bottom: 2rem;
}

.fit-info-card {
    padding: 1.5rem;
    background: linear-gradient(135deg, #f8f9ff 0%, #e8eeff 100%);
    border-radius: 15px;
    border-left: 4px solid #4a56e2;
}

.fit-info-header {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin-bottom: 1rem;
}

.fit-info-header i {
    color: #4a56e2;
    font-size: 1.25rem;
}

.fit-info-header h6 {
    margin: 0;
    font-weight: 600;
    color: #1a237e;
}

.fit-info-text {
    margin: 0;
    color: #6c757d;
    line-height: 1.6;
}

.intro-image-wrapper {
    position: relative;
}

.image-frame {
    position: relative;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 50px rgba(0, 0, 0, 0.1);
}

.intro-image {
    width: 100%;
    height: 500px;
    object-fit: cover;
    transition: transform 0.3s ease;
}

.image-frame:hover .intro-image {
    transform: scale(1.05);
}

.size-badge {
    position: absolute;
    top: 20px;
    right: 20px;
    padding: 0.75rem 1.5rem;
    background: linear-gradient(135deg, #4a56e2 0%, #1a237e 100%);
    color: white;
    border-radius: 50px;
    font-weight: 600;
    font-size: 0.875rem;
    letter-spacing: 0.05em;
}

/* Chart Premium */
.size-chart-premium {
    margin-bottom: 4rem;
    background: #ffffff;
    border-radius: 20px;
    padding: 2rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
}

.chart-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 2rem;
    flex-wrap: wrap;
    gap: 1rem;
}

.chart-title {
    margin: 0;
    font-size: 1.5rem;
    font-weight: 600;
    color: #1a237e;
}

.btn-toggle-premium {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: linear-gradient(135deg, #4a56e2 0%, #1a237e 100%);
    color: white;
    border: none;
    border-radius: 50px;
    font-weight: 600;
    font-size: 0.875rem;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-toggle-premium:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(74, 86, 226, 0.3);
}

.table-responsive-premium {
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
}

.size-table-premium {
    width: 100%;
    background: white;
    margin: 0;
    border-collapse: separate;
    border-spacing: 0;
}

.table-header-premium th {
    background: linear-gradient(135deg, #1a237e 0%, #4a56e2 100%);
    color: white;
    font-weight: 600;
    text-align: center;
    vertical-align: middle;
    padding: 1.25rem 1rem;
    border: none;
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.size-table-premium td {
    text-align: center;
    vertical-align: middle;
    padding: 1.25rem 1rem;
    border-bottom: 1px solid #e9ecef;
    font-weight: 500;
    transition: background-color 0.3s ease;
}

.size-table-premium tbody tr:hover td {
    background-color: #f8f9ff;
}

.size-table-premium td:first-child {
    font-weight: 700;
    color: #1a237e;
}

/* Tips Premium */
.fit-tips-premium {
    padding: 2rem;
    background: linear-gradient(135deg, #f8f9ff 0%, #e8eeff 100%);
    border-radius: 20px;
    border: 2px solid #e3e8ff;
}

.tips-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 2rem;
}

.tips-icon {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, #4a56e2 0%, #1a237e 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.tips-icon i {
    color: white;
    font-size: 1.25rem;
}

.tips-title {
    margin: 0;
    font-size: 1.25rem;
    font-weight: 600;
    color: #1a237e;
}

.tips-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 2rem;
}

.tips-column {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.tip-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem;
    background: white;
    border-radius: 10px;
    transition: transform 0.3s ease;
}

.tip-item:hover {
    transform: translateX(5px);
}

.tip-item i {
    width: 20px;
    height: 20px;
    background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.75rem;
    flex-shrink: 0;
}

.tip-item span {
    color: #374151;
    font-weight: 500;
    line-height: 1.5;
}

/* Measure Guide Premium */
.how-to-measure-premium {
    padding: 5rem 0;
    background: #f8f9fa;
}

.section-header-center {
    text-align: center;
    max-width: 600px;
    margin: 0 auto 4rem;
}

.section-subtitle {
    font-size: 1.125rem;
    color: #6c757d;
    line-height: 1.6;
    margin: 0;
}

.measure-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 2rem;
}

.measure-card-premium {
    background: white;
    padding: 2rem;
    border-radius: 20px;
    text-align: center;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
    border: 2px solid transparent;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.measure-card-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 4px;
    background: linear-gradient(135deg, #4a56e2 0%, #1a237e 100%);
    transition: left 0.3s ease;
}

.measure-card-premium:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 50px rgba(0, 0, 0, 0.1);
    border-color: #4a56e2;
}

.measure-card-premium:hover::before {
    left: 0;
}

.measure-icon {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, #4a56e2 0%, #1a237e 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    transition: transform 0.3s ease;
}

.measure-card-premium:hover .measure-icon {
    transform: scale(1.1);
}

.measure-icon i {
    color: white;
    font-size: 2rem;
}

.measure-title {
    font-size: 1.25rem;
    font-weight: 600;
    color: #1a237e;
    margin-bottom: 1rem;
}

.measure-text {
    color: #6c757d;
    line-height: 1.6;
    margin: 0;
}

.pro-tip-premium {
    text-align: center;
    margin-top: 4rem;
}

.tip-card {
    display: inline-flex;
    align-items: center;
    gap: 1rem;
    padding: 1.5rem 2rem;
    background: linear-gradient(135deg, #4a56e2 0%, #1a237e 100%);
    color: white;
    border-radius: 50px;
    box-shadow: 0 10px 30px rgba(74, 86, 226, 0.3);
}

.tip-icon {
    width: 40px;
    height: 40px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.tip-icon i {
    font-size: 1.25rem;
}

.tip-content {
    font-size: 1rem;
    font-weight: 500;
}

/* Exchange Policy Premium */
.exchange-policy-premium {
    padding: 5rem 0;
    background: linear-gradient(135deg, #1a237e 0%, #4a56e2 100%);
    color: white;
}

.policy-wrapper {
    max-width: 1000px;
    margin: 0 auto;
}

.policy-card-premium {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    border-radius: 30px;
    padding: 4rem 3rem;
    text-align: center;
    border: 2px solid rgba(255, 255, 255, 0.2);
}

.policy-header {
    margin-bottom: 3rem;
}

.policy-icon {
    width: 100px;
    height: 100px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 2rem;
}

.policy-icon i {
    font-size: 3rem;
    color: white;
}

.policy-title {
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
}

.policy-subtitle {
    font-size: 1.25rem;
    opacity: 0.9;
    line-height: 1.6;
    margin: 0;
}

.policy-features {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 2rem;
    margin-bottom: 3rem;
}

.feature-item-premium {
    background: rgba(255, 255, 255, 0.1);
    padding: 2rem 1.5rem;
    border-radius: 20px;
    text-align: center;
    transition: transform 0.3s ease;
}

.feature-item-premium:hover {
    transform: translateY(-5px);
}

.feature-item-premium .feature-icon {
    width: 60px;
    height: 60px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
}

.feature-item-premium .feature-icon i {
    font-size: 1.5rem;
}

.feature-item-premium h6 {
    font-size: 1.1rem;
    font-weight: 600;
    margin-bottom: 0.5rem;
}

.feature-item-premium span {
    font-size: 0.9rem;
    opacity: 0.8;
}

.policy-actions {
    display: flex;
    justify-content: center;
    gap: 1.5rem;
    flex-wrap: wrap;
}

/* Responsive Design */
@media (max-width: 768px) {
    .hero-stats-premium {
        gap: 1rem;
    }
    
    .stat-item-premium {
        min-width: 100px;
        padding: 0.75rem;
    }
    
    .tips-grid {
        grid-template-columns: 1fr;
    }
    
    .chart-header {
        flex-direction: column;
        align-items: stretch;
    }
    
    .policy-card-premium {
        padding: 2rem 1.5rem;
    }
    
    .policy-actions {
        flex-direction: column;
        align-items: center;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function toggleMeasurements(category) {
    const table = document.getElementById('chart-' + category);
    const toggleText = document.getElementById('toggle-text-' + category);
    const measurements = table.querySelectorAll('.measurement');
    const isInCm = toggleText.textContent.includes('Show in Inches');
    
    measurements.forEach(cell => {
        const cmValue = cell.dataset.cm;
        const inValue = cell.dataset.in;
        
        if (isInCm) {
            cell.textContent = inValue;
        } else {
            cell.textContent = cmValue;
        }
    });
    
    // Update headers
    const headers = table.querySelectorAll('th');
    headers.forEach(header => {
        const text = header.textContent;
        if (text.includes('(cm)')) {
            header.textContent = text.replace('(cm)', isInCm ? '(in)' : '(cm)');
        } else if (text.includes('(in)')) {
            header.textContent = text.replace('(in)', isInCm ? '(in)' : '(cm)');
        }
    });
    
    toggleText.textContent = isInCm ? 'Show in Centimeters' : 'Show in Inches';
}

// Add smooth scrolling to tab changes
document.addEventListener('DOMContentLoaded', function() {
    const tabButtons = document.querySelectorAll('[data-bs-toggle="pill"]');
    
    tabButtons.forEach(button => {
        button.addEventListener('click', function() {
            setTimeout(() => {
                document.querySelector('.size-guide-content').scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }, 100);
        });
    });
});
</script>
<?php $__env->stopPush(); ?>

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "WebPage",
    "name": "Edition By Punjab Size Guide",
    "description": "Complete size guide for Edition By Punjab streetwear including hoodies, t-shirts, bottoms and accessories",
    "url": "<?php echo e(route('size-guide.index')); ?>",
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "<?php echo e(route('home')); ?>"
    },
    "mainEntity": {
        "@type": "SizeSystemEnumeration",
        "name": "Australian Streetwear Sizes",
        "description": "Comprehensive sizing information for streetwear in Australian sizes"
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/size-guide/index.blade.php ENDPATH**/ ?>