<?php $__env->startSection('title', $lookbook['meta_title']); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="<?php echo e($lookbook['meta_description']); ?>">
<meta name="keywords" content="<?php echo e($lookbook['keywords']); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if (isset($component)) { $__componentOriginal269900abaed345884ce342681cdc99f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal269900abaed345884ce342681cdc99f6 = $attributes; } ?>
<?php $component = App\View\Components\Breadcrumb::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $attributes = $__attributesOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__attributesOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $component = $__componentOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__componentOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>

<!-- Hero Section -->
<section class="lookbook-hero py-5" style="background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), url('<?php echo e(asset('images/' . $lookbook['hero_image'])); ?>'); background-size: cover; background-position: center;">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center text-white">
                <h1 class="display-4 fw-bold mb-4"><?php echo e($lookbook['title']); ?></h1>
                <p class="lead mb-4"><?php echo e($lookbook['description']); ?></p>
                <div class="lookbook-stats d-flex justify-content-center gap-4 mb-4">
                    <div class="stat-item">
                        <div class="stat-number h5 mb-0"><?php echo e($lookbook['product_count']); ?></div>
                        <small>Featured Pieces</small>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number h5 mb-0"><?php echo e($lookbook['style_count']); ?></div>
                        <small>Style Looks</small>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number h5 mb-0"><?php echo e($lookbook['inspiration_count']); ?></div>
                        <small>Inspirations</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Lookbook Gallery -->
<section class="lookbook-gallery py-5">
    <div class="container">
        <!-- Style Looks -->
        <div class="row mb-5">
            <div class="col-12">
                <h2 class="mb-4"><?php echo e($lookbook['title']); ?> Looks</h2>
                <div class="row g-4">
                    <?php $__currentLoopData = $lookbook['looks']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $look): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4">
                            <div class="look-card position-relative">
                                <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => ''.e($look['image']).'','alt' => ''.e($look['title']).'','class' => 'img-fluid rounded','style' => 'height: 400px; object-fit: cover;'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                                <div class="look-overlay position-absolute bottom-0 start-0 end-0 p-3 text-white">
                                    <h5 class="mb-1"><?php echo e($look['title']); ?></h5>
                                    <p class="small mb-2"><?php echo e($look['description']); ?></p>
                                    <div class="look-products">
                                        <?php $__currentLoopData = $look['products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge bg-light text-dark me-1"><?php echo e($product); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <!-- Featured Products from this Collection -->
        <div class="row mb-5">
            <div class="col-12">
                <h3 class="mb-4">Shop This Collection</h3>
                <div class="row g-4">
                    <?php $__currentLoopData = $lookbook['featured_products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-3 col-sm-6">
                            <div class="product-card h-100">
                                <div class="product-image-wrapper position-relative">
                                    <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => ''.e($product['image']).'','alt' => ''.e($product['name']).'','class' => 'img-fluid product-image rounded','style' => 'height: 250px; object-fit: cover;'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                                    <div class="product-overlay position-absolute top-0 start-0 end-0 bottom-0 d-flex align-items-center justify-content-center opacity-0">
                                        <a href="<?php echo e($product['url']); ?>" class="btn btn-primary">Shop Now</a>
                                    </div>
                                </div>
                                <div class="product-info p-3">
                                    <h6 class="product-name mb-2"><?php echo e($product['name']); ?></h6>
                                    <div class="product-price">
                                        <span class="fw-bold">$<?php echo e($product['price']); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <!-- Styling Tips -->
        <div class="row mb-5">
            <div class="col-lg-8">
                <h3 class="mb-4">Styling Tips for <?php echo e($lookbook['title']); ?></h3>
                <div class="styling-tips">
                    <?php $__currentLoopData = $lookbook['styling_tips']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tip-item mb-4 p-4 bg-light rounded">
                            <h5 class="text-primary mb-2"><?php echo e($tip['title']); ?></h5>
                            <p class="mb-0"><?php echo e($tip['description']); ?></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="lookbook-sidebar">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Get The Look</h5>
                            <p class="card-text">Complete your style with these essential pieces from our <?php echo e($lookbook['title']); ?> collection.</p>
                            <a href="<?php echo e(route('shop.index')); ?>" class="btn btn-primary w-100 mb-2">
                                Shop Collection
                            </a>
                            <a href="<?php echo e(route('community.submit')); ?>" class="btn btn-outline-primary w-100">
                                Share Your Style
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- More Collections -->
<section class="related-collections py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <h3 class="mb-4 text-center">Explore More Collections</h3>
                <div class="row g-4">
                    <?php $__currentLoopData = $relatedLookbooks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4">
                            <div class="collection-card h-100">
                                <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => ''.e($related['image']).'','alt' => ''.e($related['title']).'','class' => 'card-img-top','style' => 'height: 200px; object-fit: cover;'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                                <div class="card-body d-flex flex-column">
                                    <h5 class="card-title"><?php echo e($related['title']); ?></h5>
                                    <p class="card-text flex-grow-1"><?php echo e($related['description']); ?></p>
                                    <a href="<?php echo e(route('lookbook.show', $related['slug'])); ?>" class="btn btn-outline-primary">
                                        Explore Collection
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('styles'); ?>
<style>
    .lookbook-hero {
        min-height: 500px;
        display: flex;
        align-items: center;
    }
    
    .look-card {
        border-radius: 1rem;
        overflow: hidden;
        cursor: pointer;
        transition: transform 0.3s ease;
    }
    
    .look-card:hover {
        transform: translateY(-5px);
    }
    
    .look-overlay {
        background: linear-gradient(transparent, rgba(0,0,0,0.8));
        border-radius: 0 0 1rem 1rem;
    }
    
    .product-card {
        transition: transform 0.3s ease;
        border: 1px solid #e9ecef;
        border-radius: 1rem;
        overflow: hidden;
    }
    
    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    }
    
    .product-card:hover .product-overlay {
        opacity: 1 !important;
    }
    
    .product-overlay {
        background: rgba(0,0,0,0.7);
        border-radius: 1rem;
        transition: opacity 0.3s ease;
    }
    
    .tip-item {
        border-left: 4px solid #007bff;
    }
    
    .collection-card {
        border: none;
        border-radius: 1rem;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        transition: transform 0.3s ease;
    }
    
    .collection-card:hover {
        transform: translateY(-5px);
    }
</style>
<?php $__env->stopPush(); ?>

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "CreativeWork",
    "name": "<?php echo e($lookbook['title']); ?>",
    "description": "<?php echo e($lookbook['description']); ?>",
    "url": "<?php echo e(route('lookbook.show', $lookbook['slug'])); ?>",
    "image": "<?php echo e(asset('images/' . $lookbook['hero_image'])); ?>",
    "author": {
        "@type": "Organization",
        "name": "Edition By Punjab"
    },
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "<?php echo e(route('home')); ?>"
    },
    "mainEntity": {
        "@type": "ItemList",
        "itemListElement": [
            <?php $__currentLoopData = $lookbook['featured_products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            {
                "@type": "Product",
                "position": <?php echo e($index + 1); ?>,
                "name": "<?php echo e($product['name']); ?>",
                "image": "<?php echo e(asset('images/' . $product['image'])); ?>",
                "offers": {
                    "@type": "Offer",
                    "price": "<?php echo e($product['price']); ?>",
                    "priceCurrency": "AUD"
                }
            }<?php echo e(!$loop->last ? ',' : ''); ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ]
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/lookbook/show.blade.php ENDPATH**/ ?>