

<?php $__env->startSection('title', 'Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <h1 class="mb-4">System Settings</h1>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        
        <!-- General Settings -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">General Settings</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="site_name" class="form-label">Site Name *</label>
                        <input type="text" class="form-control <?php $__errorArgs = ['site_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="site_name" name="site_name" value="<?php echo e(old('site_name', $settings['site_name'])); ?>" required>
                        <?php $__errorArgs = ['site_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label for="admin_email" class="form-label">Admin Email *</label>
                        <input type="email" class="form-control <?php $__errorArgs = ['admin_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="admin_email" name="admin_email" value="<?php echo e(old('admin_email', $settings['admin_email'])); ?>" required>
                        <?php $__errorArgs = ['admin_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="timezone" class="form-label">Timezone</label>
                        <select class="form-select" id="timezone" name="timezone">
                            <option value="UTC" <?php echo e($settings['timezone'] == 'UTC' ? 'selected' : ''); ?>>UTC</option>
                            <option value="America/New_York" <?php echo e($settings['timezone'] == 'America/New_York' ? 'selected' : ''); ?>>America/New York</option>
                            <option value="America/Chicago" <?php echo e($settings['timezone'] == 'America/Chicago' ? 'selected' : ''); ?>>America/Chicago</option>
                            <option value="America/Los_Angeles" <?php echo e($settings['timezone'] == 'America/Los_Angeles' ? 'selected' : ''); ?>>America/Los Angeles</option>
                            <option value="Europe/London" <?php echo e($settings['timezone'] == 'Europe/London' ? 'selected' : ''); ?>>Europe/London</option>
                            <option value="Asia/Karachi" <?php echo e($settings['timezone'] == 'Asia/Karachi' ? 'selected' : ''); ?>>Asia/Karachi</option>
                            <option value="Asia/Kolkata" <?php echo e($settings['timezone'] == 'Asia/Kolkata' ? 'selected' : ''); ?>>Asia/Kolkata</option>
                        </select>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label for="products_per_page" class="form-label">Products Per Page *</label>
                        <input type="number" class="form-control <?php $__errorArgs = ['products_per_page'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="products_per_page" name="products_per_page" 
                               value="<?php echo e(old('products_per_page', $settings['products_per_page'])); ?>" 
                               min="1" max="100" required>
                        <?php $__errorArgs = ['products_per_page'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Shop Settings -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Shop Settings</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label for="currency" class="form-label">Currency Code *</label>
                        <input type="text" class="form-control <?php $__errorArgs = ['currency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="currency" name="currency" value="<?php echo e(old('currency', $settings['currency'])); ?>" 
                               maxlength="3" required>
                        <?php $__errorArgs = ['currency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label for="currency_symbol" class="form-label">Currency Symbol *</label>
                        <input type="text" class="form-control <?php $__errorArgs = ['currency_symbol'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="currency_symbol" name="currency_symbol" 
                               value="<?php echo e(old('currency_symbol', $settings['currency_symbol'])); ?>" required>
                        <?php $__errorArgs = ['currency_symbol'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label for="tax_rate" class="form-label">Tax Rate (%) *</label>
                        <input type="number" class="form-control <?php $__errorArgs = ['tax_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="tax_rate" name="tax_rate" value="<?php echo e(old('tax_rate', $settings['tax_rate'])); ?>" 
                               min="0" max="100" step="0.01" required>
                        <?php $__errorArgs = ['tax_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label for="low_stock_threshold" class="form-label">Low Stock Alert *</label>
                        <input type="number" class="form-control <?php $__errorArgs = ['low_stock_threshold'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="low_stock_threshold" name="low_stock_threshold" 
                               value="<?php echo e(old('low_stock_threshold', $settings['low_stock_threshold'])); ?>" 
                               min="1" required>
                        <?php $__errorArgs = ['low_stock_threshold'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="shipping_rate" class="form-label">Shipping Rate ($) *</label>
                        <input type="number" class="form-control <?php $__errorArgs = ['shipping_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="shipping_rate" name="shipping_rate" 
                               value="<?php echo e(old('shipping_rate', $settings['shipping_rate'])); ?>" 
                               min="0" step="0.01" required>
                        <?php $__errorArgs = ['shipping_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label for="free_shipping_threshold" class="form-label">Free Shipping Threshold ($) *</label>
                        <input type="number" class="form-control <?php $__errorArgs = ['free_shipping_threshold'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="free_shipping_threshold" name="free_shipping_threshold" 
                               value="<?php echo e(old('free_shipping_threshold', $settings['free_shipping_threshold'])); ?>" 
                               min="0" step="0.01" required>
                        <?php $__errorArgs = ['free_shipping_threshold'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <hr>

                <h6 class="mb-3">Feature Toggles</h6>
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="allow_guest_checkout" 
                                   name="allow_guest_checkout" value="1" 
                                   <?php echo e($settings['allow_guest_checkout'] ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="allow_guest_checkout">
                                Allow Guest Checkout
                            </label>
                        </div>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="enable_reviews" 
                                   name="enable_reviews" value="1" 
                                   <?php echo e($settings['enable_reviews'] ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="enable_reviews">
                                Enable Product Reviews
                            </label>
                        </div>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="enable_wishlist" 
                                   name="enable_wishlist" value="1" 
                                   <?php echo e($settings['enable_wishlist'] ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="enable_wishlist">
                                Enable Wishlist
                            </label>
                        </div>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="enable_coupons" 
                                   name="enable_coupons" value="1" 
                                   <?php echo e($settings['enable_coupons'] ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="enable_coupons">
                                Enable Coupons
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Email Settings (Optional) -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Email Settings (SMTP)</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="smtp_host" class="form-label">SMTP Host</label>
                        <input type="text" class="form-control" id="smtp_host" name="smtp_host" 
                               value="<?php echo e(old('smtp_host', $settings['smtp_host'])); ?>"
                               placeholder="e.g., smtp.gmail.com">
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label for="smtp_port" class="form-label">SMTP Port</label>
                        <input type="text" class="form-control" id="smtp_port" name="smtp_port" 
                               value="<?php echo e(old('smtp_port', $settings['smtp_port'])); ?>"
                               placeholder="e.g., 587">
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label for="smtp_encryption" class="form-label">Encryption</label>
                        <select class="form-select" id="smtp_encryption" name="smtp_encryption">
                            <option value="">None</option>
                            <option value="tls" <?php echo e($settings['smtp_encryption'] == 'tls' ? 'selected' : ''); ?>>TLS</option>
                            <option value="ssl" <?php echo e($settings['smtp_encryption'] == 'ssl' ? 'selected' : ''); ?>>SSL</option>
                        </select>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="smtp_username" class="form-label">SMTP Username</label>
                        <input type="text" class="form-control" id="smtp_username" name="smtp_username" 
                               value="<?php echo e(old('smtp_username', $settings['smtp_username'])); ?>">
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label for="smtp_password" class="form-label">SMTP Password</label>
                        <input type="password" class="form-control" id="smtp_password" name="smtp_password" 
                               placeholder="Leave blank to keep current">
                        <small class="form-text text-muted">Password is encrypted and not shown</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Maintenance Mode -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Maintenance Mode</h5>
            </div>
            <div class="card-body">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="maintenance_mode" 
                           name="maintenance_mode" value="1" 
                           <?php echo e($settings['maintenance_mode'] ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="maintenance_mode">
                        Enable Maintenance Mode
                    </label>
                    <small class="form-text text-muted d-block">
                        When enabled, only administrators can access the site
                    </small>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Save Settings
            </button>
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-secondary">Cancel</a>
        </div>
    </form>

    <!-- Cache Management -->
    <div class="card mt-4">
        <div class="card-header">
            <h5 class="mb-0">Cache Management</h5>
        </div>
        <div class="card-body">
            <p>Clear various caches to ensure settings take effect immediately.</p>
            <div class="btn-group" role="group">
                <form action="<?php echo e(url('/admin/settings/clear-cache')); ?>" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-warning">
                        <i class="fas fa-broom"></i> Clear All Cache
                    </button>
                </form>
                <form action="<?php echo e(url('/admin/settings/optimize')); ?>" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-rocket"></i> Optimize Application
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/admin/settings/index.blade.php ENDPATH**/ ?>