<?php $__env->startSection('title', 'Weekly Trends Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3">Weekly Trends Management</h1>
            <p class="text-muted">Manage weekly fashion trends and streetwear movements</p>
        </div>
        <div>
            <a href="<?php echo e(route('trends.weekly')); ?>" class="btn btn-info me-2" target="_blank">
                <i class="fas fa-eye me-2"></i>View Live
            </a>
            <a href="<?php echo e(route('admin.trends.create-weekly')); ?>" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Add New Trend
            </a>
        </div>
    </div>

    <!-- Trends List -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Weekly Trends (<?php echo e(count($weeklyTrends)); ?>)</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th style="width: 80px;">Image</th>
                            <th>Title</th>
                            <th style="width: 120px;">Trend Level</th>
                            <th style="width: 100px;">Popularity</th>
                            <th style="width: 150px;">Key Pieces</th>
                            <th style="width: 120px;" class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $weeklyTrends; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $trend): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($trend['image'])); ?>" 
                                     class="rounded" 
                                     style="width: 60px; height: 60px; object-fit: cover;" 
                                     alt="<?php echo e($trend['title']); ?>">
                            </td>
                            <td>
                                <h6 class="mb-1"><?php echo e($trend['title']); ?></h6>
                                <p class="text-muted small mb-0"><?php echo e(Str::limit($trend['description'], 80)); ?></p>
                            </td>
                            <td>
                                <span class="badge 
                                    <?php if($trend['trend_level'] === 'Rising Fast'): ?> bg-danger
                                    <?php elseif($trend['trend_level'] === 'Mainstream'): ?> bg-success
                                    <?php else: ?> bg-warning text-dark
                                    <?php endif; ?>
                                ">
                                    <?php if($trend['trend_level'] === 'Rising Fast'): ?>
                                        <i class="fas fa-rocket me-1"></i>
                                    <?php elseif($trend['trend_level'] === 'Mainstream'): ?>
                                        <i class="fas fa-star me-1"></i>
                                    <?php else: ?>
                                        <i class="fas fa-trending-up me-1"></i>
                                    <?php endif; ?>
                                    <?php echo e($trend['trend_level']); ?>

                                </span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="progress me-2" style="width: 50px; height: 8px;">
                                        <div class="progress-bar 
                                            <?php if($trend['popularity'] >= 90): ?> bg-success
                                            <?php elseif($trend['popularity'] >= 70): ?> bg-warning
                                            <?php else: ?> bg-danger
                                            <?php endif; ?>
                                        " 
                                        style="width: <?php echo e($trend['popularity']); ?>%"></div>
                                    </div>
                                    <span class="small fw-bold"><?php echo e($trend['popularity']); ?>%</span>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex flex-wrap gap-1">
                                    <?php $__currentLoopData = array_slice($trend['key_pieces'], 0, 2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $piece): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge bg-light text-dark small"><?php echo e($piece); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(count($trend['key_pieces']) > 2): ?>
                                    <span class="badge bg-light text-muted small">+<?php echo e(count($trend['key_pieces']) - 2); ?></span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="text-center">
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('admin.trends.edit-weekly', $index)); ?>" 
                                       class="btn btn-sm btn-outline-primary" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-outline-danger" 
                                            onclick="confirmDelete('<?php echo e($index); ?>', '<?php echo e($trend['title']); ?>')" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center py-5">
                                <i class="fas fa-chart-trending-up fa-3x text-muted mb-3"></i>
                                <p class="text-muted">No weekly trends found. Create your first trend to get started!</p>
                                <a href="<?php echo e(route('admin.trends.create-weekly')); ?>" class="btn btn-primary">
                                    <i class="fas fa-plus me-2"></i>Add New Trend
                                </a>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Trend Statistics -->
    <div class="row mt-4">
        <div class="col-md-4">
            <div class="card border-start border-danger border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-danger text-uppercase mb-1">Rising Fast</div>
                            <div class="h6"><?php echo e(collect($weeklyTrends)->where('trend_level', 'Rising Fast')->count()); ?> trends</div>
                        </div>
                        <i class="fas fa-rocket fa-2x text-danger"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-start border-success border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-success text-uppercase mb-1">Mainstream</div>
                            <div class="h6"><?php echo e(collect($weeklyTrends)->where('trend_level', 'Mainstream')->count()); ?> trends</div>
                        </div>
                        <i class="fas fa-star fa-2x text-success"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-start border-warning border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-warning text-uppercase mb-1">Average Score</div>
                            <div class="h6"><?php echo e(round(collect($weeklyTrends)->avg('popularity'))); ?>% popularity</div>
                        </div>
                        <i class="fas fa-chart-line fa-2x text-warning"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete the trend "<span id="deleteTrendTitle"></span>"?</p>
                <p class="text-muted small">This action cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Delete Trend</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(id, title) {
    document.getElementById('deleteTrendTitle').textContent = title;
    document.getElementById('deleteForm').action = `/admin/trends/weekly/${id}`;
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/admin/trends/weekly.blade.php ENDPATH**/ ?>