<!-- resources/views/admin/inquiries/show.blade.php -->


<?php $__env->startSection('title', 'View Inquiry'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-4">
    <h1>Inquiry Details</h1>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Message</h5>
            </div>
            <div class="card-body">
                <h6>Subject: <?php echo e($inquiry->subject); ?></h6>
                <hr>
                <p><?php echo e($inquiry->message); ?></p>
                
                <?php if($inquiry->product): ?>
                <hr>
                <div class="alert alert-info">
                    <strong>Related Product:</strong> 
                    <a href="<?php echo e(route('product.detail', $inquiry->product->slug)); ?>" target="_blank">
                        <?php echo e($inquiry->product->name); ?>

                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Reply Section -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Send Reply</h5>
            </div>
            <div class="card-body">
                <form action="mailto:<?php echo e($inquiry->email); ?>" method="get">
                    <div class="mb-3">
                        <label class="form-label">To:</label>
                        <input type="text" class="form-control" value="<?php echo e($inquiry->email); ?>" readonly>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Subject:</label>
                        <input type="text" name="subject" class="form-control" value="Re: <?php echo e($inquiry->subject); ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Message:</label>
                        <textarea name="body" class="form-control" rows="6">
Dear <?php echo e($inquiry->name); ?>,

Thank you for your inquiry regarding <?php echo e($inquiry->product ? $inquiry->product->name : 'our products'); ?>.



Best regards,
<?php echo e($companyInfo->company_name ?? 'Your Company'); ?>

                        </textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-envelope me-2"></i>Open in Email Client
                    </button>
                </form>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Contact Information</h5>
            </div>
            <div class="card-body">
                <p><strong>Name:</strong> <?php echo e($inquiry->name); ?></p>
                <p><strong>Email:</strong> <a href="mailto:<?php echo e($inquiry->email); ?>"><?php echo e($inquiry->email); ?></a></p>
                <p><strong>Phone:</strong> <?php echo e($inquiry->phone ?: 'Not provided'); ?></p>
                <p><strong>Company:</strong> <?php echo e($inquiry->company ?: 'Not provided'); ?></p>
                <p><strong>Country:</strong> <?php echo e($inquiry->country); ?></p>
                <p><strong>Date:</strong> <?php echo e($inquiry->created_at->format('F d, Y H:i')); ?></p>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Update Status</h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.inquiries.status', $inquiry)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>
                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select name="status" id="status" class="form-select">
                            <option value="new" <?php echo e($inquiry->status == 'new' ? 'selected' : ''); ?>>New</option>
                            <option value="in_progress" <?php echo e($inquiry->status == 'in_progress' ? 'selected' : ''); ?>>In Progress</option>
                            <option value="completed" <?php echo e($inquiry->status == 'completed' ? 'selected' : ''); ?>>Completed</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary w-100">Update Status</button>
                </form>
            </div>
        </div>

        <div class="mt-3">
            <a href="<?php echo e(route('admin.inquiries.index')); ?>" class="btn btn-secondary w-100">
                <i class="fas fa-arrow-left me-2"></i>Back to Inquiries
            </a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/admin/inquiries/show.blade.php ENDPATH**/ ?>