

<?php $__env->startSection('title', $product->name); ?>

<?php $__env->startSection('content'); ?>
<div class="product-detail-premium">
    <!-- Breadcrumb -->
    <div class="container">
        <nav aria-label="breadcrumb" class="breadcrumb-wrapper">
            <ol class="breadcrumb-premium">
                <li><a href="<?php echo e(route('home')); ?>">HOME</a></li>
                <li class="separator">/</li>
                <li><a href="<?php echo e(route('shop.index')); ?>">SHOP</a></li>
                <li class="separator">/</li>
                <li><a href="<?php echo e(route('shop.category', $product->category->slug)); ?>"><?php echo e(strtoupper($product->category->name)); ?></a></li>
                <li class="separator">/</li>
                <li class="active"><?php echo e(strtoupper($product->name)); ?></li>
            </ol>
        </nav>
    </div>

    <!-- Product Main -->
    <section class="product-main">
        <div class="container">
            <div class="row">
                <!-- Product Gallery -->
                <div class="col-lg-7">
                    <div class="product-gallery-premium">
                        <div class="gallery-main">
                            <div class="gallery-badges">
                                <?php if($product->compare_price && $product->compare_price > $product->price): ?>
                                <span class="badge-premium sale">
                                    -<?php echo e(round((($product->compare_price - $product->price) / $product->compare_price) * 100)); ?>%
                                </span>
                                <?php endif; ?>
                                <?php if($product->is_featured): ?>
                                <span class="badge-premium featured">FEATURED</span>
                                <?php endif; ?>
                                <?php if($product->created_at->diffInDays() < 7): ?>
                                <span class="badge-premium new">NEW</span>
                                <?php endif; ?>
                            </div>
                            
                            <div class="swiper galleryMain">
                                <div class="swiper-wrapper">
                                    <div class="swiper-slide">
                                        <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($product->featured_image)); ?>" 
                                             alt="<?php echo e($product->name); ?>"
                                             class="gallery-image"
                                             onerror="this.src='/images/placeholder-product.jpg'">
                                    </div>
                                    <?php if($galleryImages && count($galleryImages) > 0): ?>
                                        <?php $__currentLoopData = $galleryImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="swiper-slide">
                                            <img src="<?php echo e(Storage::url($image)); ?>" 
                                                 alt="<?php echo e($product->name); ?>"
                                                 class="gallery-image"
                                                 onerror="this.src='/images/placeholder-product.jpg'">
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <button class="gallery-zoom" id="zoomBtn">
                                <i class="fas fa-search-plus"></i>
                            </button>
                        </div>
                        
                        <?php if($galleryImages && count($galleryImages) > 0): ?>
                        <div class="gallery-thumbs">
                            <div class="swiper galleryThumbs">
                                <div class="swiper-wrapper">
                                    <div class="swiper-slide">
                                        <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($product->featured_image)); ?>" 
                                             alt="<?php echo e($product->name); ?>"
                                             class="thumb-image">
                                    </div>
                                    <?php $__currentLoopData = $galleryImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide">
                                        <img src="<?php echo e(Storage::url($image)); ?>" 
                                             alt="<?php echo e($product->name); ?>"
                                             class="thumb-image">
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Product Info -->
                <div class="col-lg-5">
                    <div class="product-info-premium">
                        <div class="product-meta">
                            <span class="product-sku">SKU: <?php echo e($product->sku ?? 'N/A'); ?></span>
                            <?php if($product->stock > 0): ?>
                            <span class="product-availability in-stock">
                                <i class="fas fa-check-circle"></i> IN STOCK
                            </span>
                            <?php else: ?>
                            <span class="product-availability out-stock">
                                <i class="fas fa-times-circle"></i> OUT OF STOCK
                            </span>
                            <?php endif; ?>
                        </div>

                        <h1 class="product-title-premium"><?php echo e($product->name); ?></h1>
                        
                        <div class="product-rating">
                            <?php if($product->total_reviews > 0): ?>
                            <div class="rating-stars">
                                <?php for($i = 1; $i <= 5; $i++): ?>
                                    <?php if($i <= round($product->average_rating)): ?>
                                        <i class="fas fa-star"></i>
                                    <?php else: ?>
                                        <i class="far fa-star"></i>
                                    <?php endif; ?>
                                <?php endfor; ?>
                                <span class="rating-text">(<?php echo e($product->total_reviews); ?> reviews)</span>
                            </div>
                            <?php else: ?>
                            <div class="no-rating">
                                <i class="far fa-star"></i>
                                <span>No reviews yet</span>
                            </div>
                            <?php endif; ?>
                        </div>

                        <div class="product-price-premium">
                            <?php if($product->compare_price && $product->compare_price > $product->price): ?>
                            <span class="price-was">$<?php echo e(number_format($product->compare_price, 2)); ?></span>
                            <?php endif; ?>
                            <span class="price-now">$<?php echo e(number_format($product->price, 2)); ?></span>
                            <?php if($product->discount_percentage > 0): ?>
                            <span class="price-save">SAVE <?php echo e($product->discount_percentage); ?>%</span>
                            <?php endif; ?>
                        </div>

                        <?php if($product->short_description): ?>
                        <div class="product-description-short">
                            <p><?php echo e($product->short_description); ?></p>
                        </div>
                        <?php endif; ?>

                        <!-- Product Form -->
                        <?php if($product->stock > 0): ?>
                        <form id="addToCartForm" action="<?php echo e(route('cart.add')); ?>" method="POST" class="product-form">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">

                            <!-- Size Selection -->
                            <?php if($sizes && count($sizes) > 0): ?>
                            <div class="form-group-premium">
                                <label class="form-label-premium">SIZE</label>
                                <div class="size-selector">
                                    <?php $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="radio" name="size" id="size_<?php echo e($size); ?>" value="<?php echo e($size); ?>" required>
                                    <label for="size_<?php echo e($size); ?>" class="size-option"><?php echo e($size); ?></label>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <a href="#" class="size-guide-link" data-bs-toggle="modal" data-bs-target="#sizeGuideModal">
                                    <i class="fas fa-ruler"></i> Size Guide
                                </a>
                            </div>
                            <?php endif; ?>

                            <!-- Color Selection -->
                            <?php if($colors && count($colors) > 0): ?>
                            <div class="form-group-premium">
                                <label class="form-label-premium">COLOR</label>
                                <div class="color-selector">
                                    <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="radio" name="color" id="color_<?php echo e($color); ?>" value="<?php echo e($color); ?>" required>
                                    <label for="color_<?php echo e($color); ?>" class="color-option" style="background-color: <?php echo e($color); ?>" title="<?php echo e($color); ?>"></label>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <?php endif; ?>

                            <!-- Quantity -->
                            <div class="form-group-premium">
                                <label class="form-label-premium">QUANTITY</label>
                                <div class="quantity-selector">
                                    <button type="button" class="qty-btn minus" onclick="decreaseQty()">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    <input type="number" name="quantity" id="quantity" value="1" min="1" max="<?php echo e($product->stock); ?>" class="qty-input" readonly>
                                    <button type="button" class="qty-btn plus" onclick="increaseQty()">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                                <?php if($product->stock <= 5): ?>
                                <div class="stock-alert">
                                    <i class="fas fa-fire"></i> Only <?php echo e($product->stock); ?> left in stock!
                                </div>
                                <?php endif; ?>
                            </div>

                            <!-- Action Buttons -->
                            <div class="product-actions-premium">
                                <button type="submit" class="btn-add-cart">
                                    <i class="fas fa-shopping-bag"></i>
                                    ADD TO CART
                                </button>
                                
                                <?php if(auth()->guard()->check()): ?>
                                <button type="button" class="btn-wishlist <?php echo e($inWishlist ? 'active' : ''); ?>" data-product-id="<?php echo e($product->id); ?>">
                                    <i class="<?php echo e($inWishlist ? 'fas' : 'far'); ?> fa-heart"></i>
                                </button>
                                <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>" class="btn-wishlist">
                                    <i class="far fa-heart"></i>
                                </a>
                                <?php endif; ?>
                            </div>
                        </form>
                        <?php else: ?>
                        <div class="out-of-stock-notice">
                            <h4>OUT OF STOCK</h4>
                            <p>This product is currently unavailable.</p>
                            <button class="btn-notify" data-bs-toggle="modal" data-bs-target="#notifyModal">
                                <i class="fas fa-bell"></i> NOTIFY ME
                            </button>
                        </div>
                        <?php endif; ?>

                        <!-- Product Features -->
                        <div class="product-features">
                            <div class="feature-item">
                                <i class="fas fa-truck"></i>
                                <span>Free shipping on orders over $100</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-undo"></i>
                                <span>30-day return policy</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-shield-alt"></i>
                                <span>Secure checkout</span>
                            </div>
                        </div>

                        <!-- Share -->
                        <div class="product-share">
                            <span class="share-label">SHARE:</span>
                            <div class="share-buttons">
                                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(request()->url())); ?>" target="_blank" class="share-btn">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                                <a href="https://twitter.com/intent/tweet?url=<?php echo e(urlencode(request()->url())); ?>&text=<?php echo e(urlencode($product->name)); ?>" target="_blank" class="share-btn">
                                    <i class="fab fa-twitter"></i>
                                </a>
                                <a href="https://pinterest.com/pin/create/button/?url=<?php echo e(urlencode(request()->url())); ?>" target="_blank" class="share-btn">
                                    <i class="fab fa-pinterest"></i>
                                </a>
                                <a href="mailto:?subject=<?php echo e(urlencode($product->name)); ?>&body=<?php echo e(urlencode(request()->url())); ?>" class="share-btn">
                                    <i class="fas fa-envelope"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Product Tabs -->
    <section class="product-tabs-section">
        <div class="container">
            <div class="tabs-premium">
                <ul class="nav nav-tabs-premium" role="tablist">
                    <li class="nav-item">
                        <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#description">
                            DESCRIPTION
                        </button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#details">
                            DETAILS & CARE
                        </button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#reviews">
                            REVIEWS (<?php echo e($product->total_reviews); ?>)
                        </button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#shipping">
                            SHIPPING
                        </button>
                    </li>
                </ul>

                <div class="tab-content-premium">
                    <div class="tab-pane fade show active" id="description">
                        <div class="tab-inner">
                            <h3>Product Description</h3>
                            <p><?php echo e($product->description); ?></p>
                        </div>
                    </div>
                    
                    <div class="tab-pane fade" id="details">
                        <div class="tab-inner">
                            <div class="row">
                                <div class="col-md-6">
                                    <h4>Product Details</h4>
                                    <ul class="details-list">
                                        <?php if($product->brand): ?>
                                        <li><strong>Brand:</strong> <?php echo e($product->brand); ?></li>
                                        <?php endif; ?>
                                        <li><strong>Category:</strong> <?php echo e($product->category->name); ?></li>
                                        <li><strong>SKU:</strong> <?php echo e($product->sku ?? 'N/A'); ?></li>
                                        <?php if($product->weight): ?>
                                        <li><strong>Weight:</strong> <?php echo e($product->weight); ?> kg</li>
                                        <?php endif; ?>
                                        <?php if($product->dimensions): ?>
                                        <li><strong>Dimensions:</strong> <?php echo e($product->dimensions); ?></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h4>Care Instructions</h4>
                                    <ul class="care-list">
                                        <li><i class="fas fa-tint"></i> Machine wash cold</li>
                                        <li><i class="fas fa-sun"></i> Do not bleach</li>
                                        <li><i class="fas fa-temperature-low"></i> Tumble dry low</li>
                                        <li><i class="fas fa-burn"></i> Cool iron if needed</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tab-pane fade" id="reviews">
                        <div class="tab-inner">
                            <div class="reviews-section">
                                <div class="reviews-header">
                                    <h3>Customer Reviews</h3>
                                    <?php if(auth()->guard()->check()): ?>
                                    <button class="btn-write-review" data-bs-toggle="modal" data-bs-target="#reviewModal">
                                        WRITE A REVIEW
                                    </button>
                                    <?php endif; ?>
                                </div>
                                
                                <?php if($product->approvedReviews && $product->approvedReviews->count() > 0): ?>
                                    <div class="reviews-list">
                                        <?php $__currentLoopData = $product->approvedReviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="review-item">
                                            <div class="review-header">
                                                <div class="reviewer-info">
                                                    <strong class="reviewer-name"><?php echo e($review->user->name); ?></strong>
                                                    <span class="review-date"><?php echo e($review->created_at->format('F d, Y')); ?></span>
                                                </div>
                                                <div class="review-rating">
                                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                                        <?php if($i <= $review->rating): ?>
                                                            <i class="fas fa-star"></i>
                                                        <?php else: ?>
                                                            <i class="far fa-star"></i>
                                                        <?php endif; ?>
                                                    <?php endfor; ?>
                                                </div>
                                            </div>
                                            <?php if($review->title): ?>
                                            <h5 class="review-title"><?php echo e($review->title); ?></h5>
                                            <?php endif; ?>
                                            <p class="review-text"><?php echo e($review->comment); ?></p>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php else: ?>
                                    <div class="no-reviews">
                                        <i class="far fa-comment-alt fa-3x mb-3"></i>
                                        <p>No reviews yet. Be the first to review this product!</p>
                                        <?php if(auth()->guard()->check()): ?>
                                        <button class="btn-write-review" data-bs-toggle="modal" data-bs-target="#reviewModal">
                                            WRITE THE FIRST REVIEW
                                        </button>
                                        <?php else: ?>
                                        <a href="<?php echo e(route('login')); ?>" class="btn-write-review">
                                            LOGIN TO WRITE A REVIEW
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tab-pane fade" id="shipping">
                        <div class="tab-inner">
                            <h3>Shipping Information</h3>
                            <div class="shipping-info">
                                <div class="shipping-option">
                                    <h5><i class="fas fa-truck"></i> Standard Shipping</h5>
                                    <p>5-7 business days - Free on orders over $100</p>
                                </div>
                                <div class="shipping-option">
                                    <h5><i class="fas fa-shipping-fast"></i> Express Shipping</h5>
                                    <p>2-3 business days - $15</p>
                                </div>
                                <div class="shipping-option">
                                    <h5><i class="fas fa-plane"></i> Priority Shipping</h5>
                                    <p>1-2 business days - $25</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Products -->
    <?php if($relatedProducts && $relatedProducts->count() > 0): ?>
    <section class="related-products-section">
        <div class="container">
            <div class="section-header-premium">
                <h2 class="section-title">YOU MAY ALSO LIKE</h2>
            </div>
            
            <div class="swiper relatedSwiper">
                <div class="swiper-wrapper">
                    <?php $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="swiper-slide">
                        <div class="product-card-related">
                            <a href="<?php echo e(route('shop.product', $related->slug)); ?>" class="product-link">
                                <div class="product-image">
                                    <img src="<?php echo e(Storage::url($related->featured_image)); ?>" 
                                         alt="<?php echo e($related->name); ?>"
                                         onerror="this.src='/images/placeholder-product.jpg'">
                                    <?php if($related->compare_price && $related->compare_price > $related->price): ?>
                                    <span class="product-badge">SALE</span>
                                    <?php endif; ?>
                                </div>
                                <div class="product-info">
                                    <h4 class="product-name"><?php echo e($related->name); ?></h4>
                                    <div class="product-price">
                                        <?php if($related->compare_price && $related->compare_price > $related->price): ?>
                                        <span class="price-old">$<?php echo e(number_format($related->compare_price, 2)); ?></span>
                                        <?php endif; ?>
                                        <span class="price-new">$<?php echo e(number_format($related->price, 2)); ?></span>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>
        </div>
    </section>
    <?php endif; ?>
</div>

<!-- Size Guide Modal -->
<div class="modal fade" id="sizeGuideModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">SIZE GUIDE</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Size</th>
                            <th>Chest (in)</th>
                            <th>Waist (in)</th>
                            <th>Length (in)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>S</td>
                            <td>36-38</td>
                            <td>30-32</td>
                            <td>27</td>
                        </tr>
                        <tr>
                            <td>M</td>
                            <td>38-40</td>
                            <td>32-34</td>
                            <td>28</td>
                        </tr>
                        <tr>
                            <td>L</td>
                            <td>40-42</td>
                            <td>34-36</td>
                            <td>29</td>
                        </tr>
                        <tr>
                            <td>XL</td>
                            <td>42-44</td>
                            <td>36-38</td>
                            <td>30</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
/* Product Detail Premium Styles */
.product-detail-premium {
    padding: 2rem 0;
}

/* Breadcrumb */
.breadcrumb-wrapper {
    padding: 1rem 0;
}

.breadcrumb-premium {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    list-style: none;
    margin: 0;
    padding: 0;
    font-size: 0.75rem;
    letter-spacing: 0.05em;
}

.breadcrumb-premium a {
    color: #999;
    text-decoration: none;
    transition: all 0.3s;
}

.breadcrumb-premium a:hover {
    color: #000;
}

.breadcrumb-premium .active {
    color: #000;
    font-weight: 600;
}

/* Product Gallery */
.product-gallery-premium {
    position: relative;
}

.gallery-main {
    position: relative;
    margin-bottom: 1rem;
}

.gallery-badges {
    position: absolute;
    top: 1rem;
    left: 1rem;
    z-index: 10;
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.badge-premium {
    padding: 0.5rem 1rem;
    background: #000;
    color: white;
    font-size: 0.625rem;
    font-weight: 700;
    letter-spacing: 0.1em;
}

.badge-premium.sale {
    background: #ff3333;
}

.badge-premium.new {
    background: #4CAF50;
}

.gallery-image {
    width: 100%;
    height: auto;
    object-fit: cover;
}

.gallery-zoom {
    position: absolute;
    bottom: 1rem;
    right: 1rem;
    width: 50px;
    height: 50px;
    background: white;
    border: 1px solid #ddd;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s;
}

.gallery-zoom:hover {
    background: #000;
    color: white;
}

.gallery-thumbs {
    margin-top: 1rem;
}

.galleryThumbs .swiper-slide {
    cursor: pointer;
    opacity: 0.6;
    transition: all 0.3s;
}

.galleryThumbs .swiper-slide-thumb-active {
    opacity: 1;
    border: 2px solid #000;
}

.thumb-image {
    width: 100%;
    height: 100px;
    object-fit: cover;
}

/* Product Info */
.product-info-premium {
    padding-left: 3rem;
}

.product-meta {
    display: flex;
    align-items: center;
    gap: 2rem;
    margin-bottom: 1rem;
    font-size: 0.875rem;
}

.product-sku {
    color: #999;
}

.product-availability {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
}

.product-availability.in-stock {
    color: #4CAF50;
}

.product-availability.out-stock {
    color: #ff3333;
}

.product-title-premium {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 1rem;
    line-height: 1.2;
}

.product-rating {
    margin-bottom: 1.5rem;
}

.rating-stars {
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.rating-stars i {
    color: #FFB800;
}

.rating-text {
    margin-left: 0.5rem;
    color: #666;
    font-size: 0.875rem;
}

.no-rating {
    color: #999;
    font-size: 0.875rem;
}

.product-price-premium {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.price-was {
    text-decoration: line-through;
    color: #999;
    font-size: 1.25rem;
}

.price-now {
    font-size: 2rem;
    font-weight: 700;
    color: #000;
}

.price-save {
    padding: 0.25rem 0.75rem;
    background: #ff3333;
    color: white;
    font-size: 0.75rem;
    font-weight: 600;
}

.product-description-short {
    margin-bottom: 2rem;
    padding-bottom: 2rem;
    border-bottom: 1px solid #e0e0e0;
}

/* Product Form */
.form-group-premium {
    margin-bottom: 2rem;
}

.form-label-premium {
    display: block;
    margin-bottom: 1rem;
    font-size: 0.875rem;
    font-weight: 700;
    letter-spacing: 0.1em;
}

/* Size Selector */
.size-selector {
    display: flex;
    gap: 0.5rem;
    margin-bottom: 0.5rem;
}

.size-selector input[type="radio"] {
    display: none;
}

.size-option {
    padding: 0.75rem 1.5rem;
    border: 2px solid #ddd;
    cursor: pointer;
    transition: all 0.3s;
    font-weight: 600;
}

.size-selector input[type="radio"]:checked + .size-option {
    background: #000;
    color: white;
    border-color: #000;
}

.size-guide-link {
    font-size: 0.875rem;
    color: #666;
    text-decoration: none;
}

.size-guide-link:hover {
    color: #000;
}

/* Color Selector */
.color-selector {
    display: flex;
    gap: 0.5rem;
}

.color-selector input[type="radio"] {
    display: none;
}

.color-option {
    width: 40px;
    height: 40px;
    border: 2px solid #ddd;
    cursor: pointer;
    transition: all 0.3s;
}

.color-selector input[type="radio"]:checked + .color-option {
    border-color: #000;
    box-shadow: 0 0 0 3px rgba(0,0,0,0.1);
}

/* Quantity Selector */
.quantity-selector {
    display: flex;
    align-items: center;
    max-width: 150px;
}

.qty-btn {
    width: 40px;
    height: 40px;
    border: 1px solid #ddd;
    background: white;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s;
}

.qty-btn:hover {
    background: #000;
    color: white;
}

.qty-input {
    width: 70px;
    height: 40px;
    border: 1px solid #ddd;
    border-left: none;
    border-right: none;
    text-align: center;
    font-weight: 600;
}

.stock-alert {
    margin-top: 0.5rem;
    color: #ff3333;
    font-size: 0.875rem;
    font-weight: 600;
}

/* Product Actions */
.product-actions-premium {
    display: flex;
    gap: 1rem;
    margin-bottom: 2rem;
}

.btn-add-cart {
    flex: 1;
    padding: 1rem 2rem;
    background: #000;
    color: white;
    border: 2px solid #000;
    font-weight: 700;
    letter-spacing: 0.05em;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-add-cart:hover {
    background: transparent;
    color: #000;
}

.btn-wishlist {
    width: 60px;
    height: auto;
    border: 2px solid #000;
    background: white;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-wishlist.active,
.btn-wishlist:hover {
    background: #000;
    color: white;
}

/* Out of Stock Notice */
.out-of-stock-notice {
    padding: 2rem;
    background: #f5f5f5;
    text-align: center;
}

.btn-notify {
    padding: 0.75rem 2rem;
    background: #000;
    color: white;
    border: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-notify:hover {
    background: #333;
}

/* Product Features */
.product-features {
    margin-bottom: 2rem;
    padding-bottom: 2rem;
    border-bottom: 1px solid #e0e0e0;
}

.feature-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1rem;
    font-size: 0.875rem;
}

.feature-item i {
    color: #000;
}

/* Product Share */
.product-share {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.share-label {
    font-size: 0.875rem;
    font-weight: 700;
    letter-spacing: 0.1em;
}

.share-buttons {
    display: flex;
    gap: 0.5rem;
}

.share-btn {
    width: 40px;
    height: 40px;
    border: 1px solid #ddd;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #000;
    text-decoration: none;
    transition: all 0.3s;
}

.share-btn:hover {
    background: #000;
    color: white;
}

/* Product Tabs */
.product-tabs-section {
    padding: 3rem 0;
    background: #f8f8f8;
}

.nav-tabs-premium {
    border: none;
    display: flex;
    justify-content: center;
    gap: 2rem;
    margin-bottom: 3rem;
}

.nav-tabs-premium .nav-link {
    background: none;
    border: none;
    color: #999;
    font-weight: 600;
    letter-spacing: 0.1em;
    padding: 0.75rem 0;
    position: relative;
    transition: all 0.3s;
}

.nav-tabs-premium .nav-link::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    width: 0;
    height: 2px;
    background: #000;
    transition: width 0.3s;
}

.nav-tabs-premium .nav-link.active,
.nav-tabs-premium .nav-link:hover {
    color: #000;
}

.nav-tabs-premium .nav-link.active::after {
    width: 100%;
}

.tab-content-premium {
    background: white;
    padding: 3rem;
}

.tab-inner h3,
.tab-inner h4 {
    margin-bottom: 1.5rem;
    font-weight: 700;
}

.details-list,
.care-list {
    list-style: none;
    padding: 0;
}

.details-list li,
.care-list li {
    padding: 0.5rem 0;
    border-bottom: 1px solid #f0f0f0;
}

.care-list i {
    margin-right: 0.5rem;
    color: #666;
}

/* Reviews */
.reviews-section {
    max-width: 800px;
    margin: 0 auto;
}

.reviews-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2rem;
}

.btn-write-review {
    padding: 0.75rem 1.5rem;
    background: #000;
    color: white;
    border: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    cursor: pointer;
    text-decoration: none;
    display: inline-block;
    transition: all 0.3s;
}

.btn-write-review:hover {
    background: #333;
    color: white;
}

.review-item {
    padding: 2rem 0;
    border-bottom: 1px solid #e0e0e0;
}

.review-header {
    display: flex;
    justify-content: space-between;
    margin-bottom: 1rem;
}

.reviewer-name {
    display: block;
    margin-bottom: 0.25rem;
}

.review-date {
    color: #999;
    font-size: 0.875rem;
}

.review-rating i {
    color: #FFB800;
}

.review-title {
    font-size: 1.125rem;
    margin-bottom: 0.5rem;
}

.no-reviews {
    text-align: center;
    padding: 3rem 0;
    color: #999;
}

/* Shipping Info */
.shipping-info {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 2rem;
}

.shipping-option {
    padding: 1.5rem;
    background: #f8f8f8;
    border-left: 3px solid #000;
}

.shipping-option h5 {
    margin-bottom: 0.5rem;
}

.shipping-option p {
    margin: 0;
    color: #666;
}

/* Related Products */
.related-products-section {
    padding: 4rem 0;
}

.section-header-premium {
    text-align: center;
    margin-bottom: 3rem;
}

.section-title {
    font-size: 2rem;
    font-weight: 700;
    letter-spacing: 0.05em;
}

.product-card-related {
    background: white;
    transition: all 0.3s;
}

.product-card-related:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.product-link {
    text-decoration: none;
    color: inherit;
}

.product-card-related .product-image {
    position: relative;
    overflow: hidden;
    aspect-ratio: 3/4;
}

.product-card-related .product-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s;
}

.product-card-related:hover .product-image img {
    transform: scale(1.05);
}

.product-badge {
    position: absolute;
    top: 1rem;
    left: 1rem;
    padding: 0.25rem 0.75rem;
    background: #ff3333;
    color: white;
    font-size: 0.625rem;
    font-weight: 700;
    letter-spacing: 0.05em;
}

.product-card-related .product-info {
    padding: 1.5rem;
    text-align: center;
}

.product-name {
    font-size: 1rem;
    margin-bottom: 0.5rem;
    color: #000;
}

.product-card-related .product-price {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 0.5rem;
}

.price-old {
    text-decoration: line-through;
    color: #999;
}

.price-new {
    font-weight: 700;
    color: #000;
}

/* Responsive */
@media (max-width: 991px) {
    .product-info-premium {
        padding-left: 0;
        margin-top: 2rem;
    }
    
    .product-actions-premium {
        flex-direction: column;
    }
    
    .btn-wishlist {
        width: 100%;
    }
}

@media (max-width: 576px) {
    .product-title-premium {
        font-size: 1.5rem;
    }
    
    .price-now {
        font-size: 1.5rem;
    }
    
    .nav-tabs-premium {
        gap: 1rem;
        font-size: 0.875rem;
    }
    
    .tab-content-premium {
        padding: 1.5rem;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Initialize Swiper for gallery
var galleryThumbs = new Swiper('.galleryThumbs', {
    spaceBetween: 10,
    slidesPerView: 4,
    freeMode: true,
    watchSlidesProgress: true,
});

var galleryMain = new Swiper('.galleryMain', {
    spaceBetween: 10,
    navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev',
    },
    thumbs: {
        swiper: galleryThumbs,
    },
});

// Related products swiper
var relatedSwiper = new Swiper('.relatedSwiper', {
    slidesPerView: 4,
    spaceBetween: 30,
    navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev',
    },
    breakpoints: {
        320: {
            slidesPerView: 2,
            spaceBetween: 15
        },
        768: {
            slidesPerView: 3,
            spaceBetween: 20
        },
        1024: {
            slidesPerView: 4,
            spaceBetween: 30
        }
    }
});

// Quantity controls
function increaseQty() {
    const input = document.getElementById('quantity');
    const max = parseInt(input.max);
    const current = parseInt(input.value);
    if (current < max) {
        input.value = current + 1;
    }
}

function decreaseQty() {
    const input = document.getElementById('quantity');
    const current = parseInt(input.value);
    if (current > 1) {
        input.value = current - 1;
    }
}

// Wishlist toggle
document.querySelector('.btn-wishlist')?.addEventListener('click', function() {
    const btn = this;
    const productId = btn.dataset.productId;
    
    fetch('<?php echo e(route("shop.wishlist.toggle")); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: JSON.stringify({ product_id: productId })
    })
    .then(response => response.json())
    .then(data => {
        const icon = btn.querySelector('i');
        if (data.added) {
            btn.classList.add('active');
            icon.classList.remove('far');
            icon.classList.add('fas');
            toastr.success('Added to wishlist!');
        } else {
            btn.classList.remove('active');
            icon.classList.remove('fas');
            icon.classList.add('far');
            toastr.info('Removed from wishlist');
        }
    });
});

// Add to cart with AJAX
document.getElementById('addToCartForm')?.addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const submitBtn = this.querySelector('.btn-add-cart');
    const originalText = submitBtn.innerHTML;
    
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> ADDING...';
    submitBtn.disabled = true;
    
    fetch(this.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Update cart count
            document.querySelectorAll('.cart-count').forEach(function(el) {
                el.textContent = data.cartCount || 0;
            });
            
            submitBtn.innerHTML = '<i class="fas fa-check"></i> ADDED!';
            toastr.success('Product added to cart!');
            
            setTimeout(() => {
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            }, 2000);
        } else {
            toastr.error(data.message || 'Error adding to cart');
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        toastr.error('An error occurred');
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
});

// Zoom functionality
document.getElementById('zoomBtn')?.addEventListener('click', function() {
    // Implement zoom modal or lightbox here
    console.log('Zoom clicked');
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/shop/product.blade.php ENDPATH**/ ?>