<div class="row">
    <div class="col-md-6">
        <!-- Styling Tips -->
        <h5 class="mb-3">Styling Tips</h5>
        <div id="styling-tips-container">
            <?php if(old('styling_tips', $styleGuide->styling_tips)): ?>
                <?php $__currentLoopData = old('styling_tips', $styleGuide->styling_tips); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $tip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="array-item mb-2">
                        <div class="input-group">
                            <input type="text" 
                                   class="form-control" 
                                   name="styling_tips[<?php echo e($index); ?>]" 
                                   value="<?php echo e($tip); ?>" 
                                   placeholder="Enter styling tip">
                            <button type="button" class="btn btn-outline-danger remove-item">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
        <button type="button" id="add-styling-tip" class="btn btn-outline-primary btn-sm">
            <i class="fas fa-plus"></i> Add Styling Tip
        </button>

        <hr class="my-4">

        <!-- Key Pieces -->
        <h5 class="mb-3">Key Pieces</h5>
        <div id="key-pieces-container">
            <?php if(old('key_pieces', $styleGuide->key_pieces)): ?>
                <?php $__currentLoopData = old('key_pieces', $styleGuide->key_pieces); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $piece): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="array-item mb-2">
                        <div class="input-group">
                            <input type="text" 
                                   class="form-control" 
                                   name="key_pieces[<?php echo e($index); ?>]" 
                                   value="<?php echo e($piece); ?>" 
                                   placeholder="Enter key piece">
                            <button type="button" class="btn btn-outline-danger remove-item">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
        <button type="button" id="add-key-piece" class="btn btn-outline-primary btn-sm">
            <i class="fas fa-plus"></i> Add Key Piece
        </button>

        <hr class="my-4">

        <!-- Style Characteristics -->
        <h5 class="mb-3">Style Characteristics</h5>
        <div id="characteristics-container">
            <?php if(old('style_characteristics', $styleGuide->style_characteristics)): ?>
                <?php $__currentLoopData = old('style_characteristics', $styleGuide->style_characteristics); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $characteristic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="array-item mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <input type="text" 
                                       class="form-control mb-2" 
                                       name="style_characteristics[<?php echo e($index); ?>][title]" 
                                       value="<?php echo e($characteristic['title'] ?? ''); ?>" 
                                       placeholder="Title">
                            </div>
                            <div class="col-md-7">
                                <textarea class="form-control mb-2" 
                                          name="style_characteristics[<?php echo e($index); ?>][description]" 
                                          rows="2" 
                                          placeholder="Description"><?php echo e($characteristic['description'] ?? ''); ?></textarea>
                            </div>
                            <div class="col-md-1">
                                <button type="button" class="btn btn-outline-danger remove-item">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
        <button type="button" id="add-characteristic" class="btn btn-outline-primary btn-sm">
            <i class="fas fa-plus"></i> Add Characteristic
        </button>
    </div>

    <div class="col-md-6">
        <!-- Color Palette -->
        <h5 class="mb-3">Color Palette</h5>
        <div id="colors-container">
            <?php if(old('color_palette', $styleGuide->color_palette)): ?>
                <?php $__currentLoopData = old('color_palette', $styleGuide->color_palette); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="array-item mb-3">
                        <div class="row align-items-center">
                            <div class="col-md-4">
                                <input type="text" 
                                       class="form-control" 
                                       name="color_palette[<?php echo e($index); ?>][name]" 
                                       value="<?php echo e($color['name'] ?? ''); ?>" 
                                       placeholder="Color name">
                            </div>
                            <div class="col-md-4">
                                <div class="input-group">
                                    <input type="color" 
                                           class="form-control form-control-color" 
                                           value="<?php echo e($color['hex'] ?? '#000000'); ?>">
                                    <input type="text" 
                                           class="form-control" 
                                           name="color_palette[<?php echo e($index); ?>][hex]" 
                                           value="<?php echo e($color['hex'] ?? ''); ?>" 
                                           placeholder="#hex">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="color-swatch" style="background-color: <?php echo e($color['hex'] ?? '#000000'); ?>;"></div>
                            </div>
                            <div class="col-md-1">
                                <button type="button" class="btn btn-outline-danger remove-item">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
        <button type="button" id="add-color" class="btn btn-outline-primary btn-sm">
            <i class="fas fa-plus"></i> Add Color
        </button>

        <hr class="my-4">

        <!-- Cultural Influences -->
        <h5 class="mb-3">Cultural Influences</h5>
        <div id="influences-container">
            <?php if(old('cultural_influences', $styleGuide->cultural_influences)): ?>
                <?php $__currentLoopData = old('cultural_influences', $styleGuide->cultural_influences); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $influence): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="array-item mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <input type="text" 
                                       class="form-control mb-2" 
                                       name="cultural_influences[<?php echo e($index); ?>][aspect]" 
                                       value="<?php echo e($influence['aspect'] ?? ''); ?>" 
                                       placeholder="Aspect">
                            </div>
                            <div class="col-md-7">
                                <textarea class="form-control mb-2" 
                                          name="cultural_influences[<?php echo e($index); ?>][description]" 
                                          rows="2" 
                                          placeholder="Description"><?php echo e($influence['description'] ?? ''); ?></textarea>
                            </div>
                            <div class="col-md-1">
                                <button type="button" class="btn btn-outline-danger remove-item">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
        <button type="button" id="add-influence" class="btn btn-outline-primary btn-sm">
            <i class="fas fa-plus"></i> Add Cultural Influence
        </button>

        <hr class="my-4">

        <!-- Shopping Areas -->
        <h5 class="mb-3">Shopping Areas</h5>
        <div id="shopping-areas-container">
            <?php if(old('shopping_areas', $styleGuide->shopping_areas)): ?>
                <?php $__currentLoopData = old('shopping_areas', $styleGuide->shopping_areas); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="array-item mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <input type="text" 
                                       class="form-control mb-2" 
                                       name="shopping_areas[<?php echo e($index); ?>][name]" 
                                       value="<?php echo e($area['name'] ?? ''); ?>" 
                                       placeholder="Area name">
                            </div>
                            <div class="col-md-7">
                                <textarea class="form-control mb-2" 
                                          name="shopping_areas[<?php echo e($index); ?>][description]" 
                                          rows="2" 
                                          placeholder="Description"><?php echo e($area['description'] ?? ''); ?></textarea>
                            </div>
                            <div class="col-md-1">
                                <button type="button" class="btn btn-outline-danger remove-item">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
        <button type="button" id="add-shopping-area" class="btn btn-outline-primary btn-sm">
            <i class="fas fa-plus"></i> Add Shopping Area
        </button>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Dynamic field management functions
    function getNextIndex(container) {
        return container.children().length;
    }

    // Styling Tips
    $('#add-styling-tip').click(function() {
        const container = $('#styling-tips-container');
        const index = getNextIndex(container);
        const template = `
            <div class="array-item mb-2">
                <div class="input-group">
                    <input type="text" class="form-control" name="styling_tips[${index}]" placeholder="Enter styling tip">
                    <button type="button" class="btn btn-outline-danger remove-item">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
        `;
        container.append(template);
    });

    // Key Pieces
    $('#add-key-piece').click(function() {
        const container = $('#key-pieces-container');
        const index = getNextIndex(container);
        const template = `
            <div class="array-item mb-2">
                <div class="input-group">
                    <input type="text" class="form-control" name="key_pieces[${index}]" placeholder="Enter key piece">
                    <button type="button" class="btn btn-outline-danger remove-item">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
        `;
        container.append(template);
    });

    // Style Characteristics
    $('#add-characteristic').click(function() {
        const container = $('#characteristics-container');
        const index = getNextIndex(container);
        const template = `
            <div class="array-item mb-3">
                <div class="row">
                    <div class="col-md-4">
                        <input type="text" class="form-control mb-2" name="style_characteristics[${index}][title]" placeholder="Title">
                    </div>
                    <div class="col-md-7">
                        <textarea class="form-control mb-2" name="style_characteristics[${index}][description]" rows="2" placeholder="Description"></textarea>
                    </div>
                    <div class="col-md-1">
                        <button type="button" class="btn btn-outline-danger remove-item">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>
            </div>
        `;
        container.append(template);
    });

    // Colors
    $('#add-color').click(function() {
        const container = $('#colors-container');
        const index = getNextIndex(container);
        const template = `
            <div class="array-item mb-3">
                <div class="row align-items-center">
                    <div class="col-md-4">
                        <input type="text" class="form-control" name="color_palette[${index}][name]" placeholder="Color name">
                    </div>
                    <div class="col-md-4">
                        <div class="input-group">
                            <input type="color" class="form-control form-control-color" value="#000000">
                            <input type="text" class="form-control" name="color_palette[${index}][hex]" placeholder="#hex">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="color-swatch" style="background-color: #000000;"></div>
                    </div>
                    <div class="col-md-1">
                        <button type="button" class="btn btn-outline-danger remove-item">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>
            </div>
        `;
        container.append(template);
    });

    // Cultural Influences
    $('#add-influence').click(function() {
        const container = $('#influences-container');
        const index = getNextIndex(container);
        const template = `
            <div class="array-item mb-3">
                <div class="row">
                    <div class="col-md-4">
                        <input type="text" class="form-control mb-2" name="cultural_influences[${index}][aspect]" placeholder="Aspect">
                    </div>
                    <div class="col-md-7">
                        <textarea class="form-control mb-2" name="cultural_influences[${index}][description]" rows="2" placeholder="Description"></textarea>
                    </div>
                    <div class="col-md-1">
                        <button type="button" class="btn btn-outline-danger remove-item">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>
            </div>
        `;
        container.append(template);
    });

    // Shopping Areas
    $('#add-shopping-area').click(function() {
        const container = $('#shopping-areas-container');
        const index = getNextIndex(container);
        const template = `
            <div class="array-item mb-3">
                <div class="row">
                    <div class="col-md-4">
                        <input type="text" class="form-control mb-2" name="shopping_areas[${index}][name]" placeholder="Area name">
                    </div>
                    <div class="col-md-7">
                        <textarea class="form-control mb-2" name="shopping_areas[${index}][description]" rows="2" placeholder="Description"></textarea>
                    </div>
                    <div class="col-md-1">
                        <button type="button" class="btn btn-outline-danger remove-item">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>
            </div>
        `;
        container.append(template);
    });

    // Color picker sync
    $(document).on('change', 'input[type="color"]', function() {
        const hexValue = $(this).val();
        $(this).siblings('input[type="text"]').val(hexValue);
        $(this).closest('.row').find('.color-swatch').css('background-color', hexValue);
    });

    // Hex input sync
    $(document).on('input', 'input[name*="[hex]"]', function() {
        const hexValue = $(this).val();
        if (hexValue.match(/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/)) {
            $(this).siblings('.input-group').find('input[type="color"]').val(hexValue);
            $(this).closest('.row').find('.color-swatch').css('background-color', hexValue);
        }
    });

    // Remove item
    $(document).on('click', '.remove-item', function() {
        $(this).closest('.array-item').remove();
    });
});
</script>
<?php $__env->stopPush(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio7\resources\views/admin/style-guides/partials/style-details.blade.php ENDPATH**/ ?>