<?php $__env->startSection('title', 'Community Style Gallery - Edition By Punjab Fashion Inspiration'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="Browse our community style gallery featuring real customers showcasing their Edition By Punjab streetwear looks across Australia.">
<meta name="keywords" content="streetwear gallery, community style, customer photos, street style australia, fashion gallery, user generated content">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if (isset($component)) { $__componentOriginal269900abaed345884ce342681cdc99f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal269900abaed345884ce342681cdc99f6 = $attributes; } ?>
<?php $component = App\View\Components\Breadcrumb::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $attributes = $__attributesOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__attributesOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $component = $__componentOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__componentOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>

<!-- Premium Gallery Hero -->
<section class="gallery-hero-premium">
    <div class="hero-pattern"></div>
    <div class="container">
        <div class="hero-content-center" data-aos="fade-up">
            <span class="hero-label">GALLERY</span>
            <h1 class="hero-title-premium">STYLE SHOWCASE</h1>
            <p class="hero-subtitle">Discover authentic street style from our Australian community</p>
        </div>
    </div>
    <div class="scroll-indicator">
        <span></span>
    </div>
</section>

<!-- Gallery Stats -->
<section class="gallery-stats-premium">
    <div class="container">
        <div class="stats-glass-container" data-aos="zoom-in">
            <div class="row text-center">
                <div class="col-md-3">
                    <div class="stat-item-premium">
                        <div class="stat-number" data-count="247">0</div>
                        <div class="stat-label">Style Posts</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-item-premium">
                        <div class="stat-number" data-count="15">0</div>
                        <div class="stat-label">Cities</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-item-premium">
                        <div class="stat-number" data-count="1200">0</div>
                        <div class="stat-label">Total Likes</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-item-premium">
                        <div class="stat-number" data-count="89">0</div>
                        <div class="stat-label">Contributors</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Gallery Filters -->
<section class="gallery-filters-premium">
    <div class="container">
        <div class="filters-wrapper" data-aos="fade-up">
            <h3 class="filters-title">Filter by Style</h3>
            <div class="filter-buttons">
                <button class="filter-btn active" data-filter="all">ALL STYLES</button>
                <button class="filter-btn" data-filter="street-style">STREET STYLE</button>
                <button class="filter-btn" data-filter="cultural-pride">CULTURAL PRIDE</button>
                <button class="filter-btn" data-filter="casual">CASUAL</button>
                <button class="filter-btn" data-filter="formal">FORMAL</button>
            </div>
        </div>
    </div>
</section>

<!-- Gallery Grid -->
<?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $galleryKey => $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<section class="gallery-section-premium <?php echo e($galleryKey); ?>-section" data-category="<?php echo e($galleryKey); ?>">
    <div class="container">
        <div class="gallery-header-premium" data-aos="fade-up">
            <h2 class="gallery-section-title"><?php echo e($gallery['title']); ?></h2>
            <p class="gallery-section-description"><?php echo e($gallery['description']); ?></p>
        </div>
        
        <div class="gallery-grid-premium">
            <?php $__currentLoopData = $gallery['images']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="gallery-item-premium" data-aos="zoom-in" data-aos-delay="<?php echo e($index * 100); ?>">
                    <div class="gallery-image-wrapper">
                        <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => ''.e($image['src']).'','alt' => 'Style by '.e($image['user']).' from '.e($image['location']).'','class' => 'gallery-image'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['loading' => 'lazy']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                        <div class="gallery-overlay">
                            <div class="gallery-content">
                                <h5 class="gallery-user"><?php echo e($image['user']); ?></h5>
                                <p class="gallery-location">
                                    <i class="fas fa-map-marker-alt"></i><?php echo e($image['location']); ?>

                                </p>
                                <div class="gallery-actions">
                                    <button class="like-btn" onclick="likeImage(this)">
                                        <i class="far fa-heart"></i>
                                        <span class="like-count"><?php echo e(rand(15, 95)); ?></span>
                                    </button>
                                    <button class="zoom-btn" onclick="openModal('modal<?php echo e($galleryKey); ?><?php echo e($index); ?>')">
                                        <i class="fas fa-expand-alt"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Modal for each image -->
                    <div class="modal fade gallery-modal" id="modal<?php echo e($galleryKey); ?><?php echo e($index); ?>" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title"><?php echo e($image['user']); ?> - <?php echo e($image['location']); ?></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body p-0">
                                    <img src="/images/<?php echo e($image['src']); ?>" alt="Style by <?php echo e($image['user']); ?>" class="modal-image">
                                    <div class="modal-info">
                                        <div class="modal-stats">
                                            <button class="like-btn" onclick="likeImage(this)">
                                                <i class="far fa-heart"></i>
                                                <span class="like-count"><?php echo e(rand(15, 95)); ?></span>
                                            </button>
                                            <button class="share-btn" onclick="shareImage('<?php echo e($image['user']); ?>')">
                                                <i class="fas fa-share"></i> Share
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<!-- Load More Section -->
<section class="load-more-premium">
    <div class="container text-center">
        <button class="btn-gallery-action primary" id="loadMoreBtn" data-aos="fade-up">
            <span>LOAD MORE STYLES</span>
            <i class="fas fa-chevron-down"></i>
        </button>
    </div>
</section>

<!-- Submit Your Style CTA -->
<section class="submit-cta-premium">
    <div class="container">
        <div class="cta-card-premium" data-aos="fade-up">
            <div class="cta-content">
                <div class="cta-icon">
                    <i class="fas fa-camera"></i>
                </div>
                <h3 class="cta-title">Ready to Share Your Style?</h3>
                <p class="cta-text">Join our community and showcase how you style your Edition By Punjab pieces</p>
                <a href="<?php echo e(route('community.submit')); ?>" class="btn-gallery-cta primary">
                    <span>SUBMIT YOUR STYLE</span>
                    <i class="fas fa-upload"></i>
                </a>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('styles'); ?>
<style>
    /* Premium Gallery Hero */
    .gallery-hero-premium {
        min-height: 80vh;
        background: linear-gradient(135deg, var(--primary-black) 0%, var(--secondary-black) 100%);
        position: relative;
        display: flex;
        align-items: center;
        overflow: hidden;
    }
    
    .gallery-hero-premium .hero-pattern::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: 
            radial-gradient(circle at 25% 75%, rgba(120, 119, 198, 0.2) 0%, transparent 50%),
            radial-gradient(circle at 75% 25%, rgba(255, 119, 198, 0.2) 0%, transparent 50%);
    }
    
    .hero-content-center {
        text-align: center;
        position: relative;
        z-index: 2;
    }
    
    .hero-label {
        display: inline-block;
        font-size: 0.8rem;
        font-weight: 700;
        letter-spacing: 0.2em;
        color: rgba(255,255,255,0.7);
        text-transform: uppercase;
        margin-bottom: 1rem;
    }
    
    .hero-title-premium {
        font-size: clamp(2.5rem, 6vw, 4.5rem);
        font-weight: 900;
        color: white;
        margin-bottom: 1.5rem;
        line-height: 0.9;
        text-shadow: 0 4px 20px rgba(0,0,0,0.3);
        font-family: 'Space Grotesk', sans-serif;
        letter-spacing: -0.02em;
    }
    
    .hero-subtitle {
        font-size: 1.1rem;
        color: rgba(255,255,255,0.8);
        margin-bottom: 2rem;
        line-height: 1.6;
        max-width: 600px;
        margin-left: auto;
        margin-right: auto;
    }
    
    .scroll-indicator {
        position: absolute;
        bottom: 2rem;
        left: 50%;
        transform: translateX(-50%);
        color: white;
    }
    
    .scroll-indicator span {
        display: block;
        width: 2px;
        height: 30px;
        background: white;
        animation: scroll-bounce 2s infinite;
    }
    
    @keyframes scroll-bounce {
        0%, 20%, 50%, 80%, 100% {
            transform: translateY(0);
        }
        40% {
            transform: translateY(-10px);
        }
        60% {
            transform: translateY(-5px);
        }
    }
    
    /* Gallery Stats */
    .gallery-stats-premium {
        padding: 60px 0;
        background: var(--bg-gray);
        position: relative;
        margin-top: -50px;
        z-index: 2;
    }
    
    .stats-glass-container {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        padding: 3rem;
        box-shadow: var(--shadow-xl);
        border-radius: 0;
    }
    
    .stat-item-premium {
        padding: 1rem;
    }
    
    .stat-number {
        font-size: 3rem;
        font-weight: 900;
        color: var(--primary-black);
        display: block;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .stat-label {
        font-size: 0.9rem;
        font-weight: 600;
        color: var(--medium-gray);
        text-transform: uppercase;
        letter-spacing: 0.1em;
    }
    
    /* Gallery Filters */
    .gallery-filters-premium {
        padding: 80px 0;
        background: white;
        border-bottom: 1px solid var(--border-gray);
    }
    
    .filters-wrapper {
        text-align: center;
    }
    
    .filters-title {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--primary-black);
        margin-bottom: 2rem;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .filter-buttons {
        display: flex;
        justify-content: center;
        gap: 1rem;
        flex-wrap: wrap;
    }
    
    .filter-btn {
        background: transparent;
        border: 2px solid var(--border-gray);
        color: var(--primary-black);
        padding: 0.75rem 1.5rem;
        font-weight: 600;
        font-size: 0.9rem;
        letter-spacing: 0.05em;
        text-transform: uppercase;
        transition: all var(--transition-base);
        cursor: pointer;
        min-width: 120px;
    }
    
    .filter-btn:hover,
    .filter-btn.active {
        background: var(--primary-black);
        color: white;
        border-color: var(--primary-black);
        transform: translateY(-2px);
    }
    
    /* Gallery Sections */
    .gallery-section-premium {
        padding: 80px 0;
        background: white;
    }
    
    .gallery-section-premium:nth-child(even) {
        background: var(--bg-gray);
    }
    
    .gallery-header-premium {
        text-align: center;
        margin-bottom: 60px;
    }
    
    .gallery-section-title {
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--primary-black);
        margin-bottom: 1rem;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .gallery-section-description {
        font-size: 1.1rem;
        color: var(--medium-gray);
        max-width: 500px;
        margin: 0 auto;
    }
    
    .gallery-grid-premium {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
        gap: 3rem;
    }
    
    .gallery-item-premium {
        position: relative;
        transition: all var(--transition-slow);
    }
    
    .gallery-item-premium:hover {
        transform: translateY(-10px);
    }
    
    .gallery-image-wrapper {
        position: relative;
        overflow: hidden;
        height: 400px;
        background: white;
        box-shadow: var(--shadow-md);
    }
    
    .gallery-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform var(--transition-slow);
    }
    
    .gallery-item-premium:hover .gallery-image {
        transform: scale(1.1);
    }
    
    .gallery-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(transparent, rgba(0,0,0,0.9));
        opacity: 0;
        transition: opacity var(--transition-base);
        display: flex;
        align-items: flex-end;
        padding: 2rem;
    }
    
    .gallery-item-premium:hover .gallery-overlay {
        opacity: 1;
    }
    
    .gallery-content {
        width: 100%;
        color: white;
    }
    
    .gallery-user {
        font-size: 1.2rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
        color: white;
    }
    
    .gallery-location {
        font-size: 0.9rem;
        color: rgba(255,255,255,0.8);
        margin-bottom: 1.5rem;
    }
    
    .gallery-location i {
        margin-right: 0.5rem;
    }
    
    .gallery-actions {
        display: flex;
        gap: 1rem;
        justify-content: space-between;
        align-items: center;
    }
    
    .like-btn,
    .zoom-btn {
        background: rgba(255,255,255,0.2);
        border: 1px solid rgba(255,255,255,0.3);
        color: white;
        padding: 0.5rem 1rem;
        font-size: 0.9rem;
        transition: all var(--transition-base);
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .like-btn:hover {
        background: var(--accent-red);
        border-color: var(--accent-red);
        color: white;
    }
    
    .zoom-btn:hover {
        background: white;
        color: var(--primary-black);
        border-color: white;
    }
    
    /* Gallery Modal */
    .gallery-modal .modal-content {
        border: none;
        border-radius: 0;
        overflow: hidden;
    }
    
    .gallery-modal .modal-image {
        width: 100%;
        height: 400px;
        object-fit: cover;
    }
    
    .modal-info {
        padding: 2rem;
    }
    
    .modal-stats {
        display: flex;
        gap: 1rem;
        justify-content: center;
    }
    
    .modal-stats .like-btn,
    .modal-stats .share-btn {
        background: transparent;
        border: 2px solid var(--border-gray);
        color: var(--primary-black);
        padding: 0.75rem 1.5rem;
        font-weight: 600;
        transition: all var(--transition-base);
        cursor: pointer;
    }
    
    .modal-stats .like-btn:hover {
        background: var(--accent-red);
        color: white;
        border-color: var(--accent-red);
    }
    
    .modal-stats .share-btn:hover {
        background: var(--primary-black);
        color: white;
        border-color: var(--primary-black);
    }
    
    /* Load More Section */
    .load-more-premium {
        padding: 80px 0;
        background: var(--bg-gray);
    }
    
    /* Submit CTA */
    .submit-cta-premium {
        padding: 120px 0;
        background: var(--primary-black);
        color: white;
    }
    
    .cta-card-premium {
        text-align: center;
        max-width: 600px;
        margin: 0 auto;
    }
    
    .cta-icon {
        font-size: 3rem;
        margin-bottom: 2rem;
        color: white;
    }
    
    .cta-title {
        font-size: 2.5rem;
        font-weight: 800;
        margin-bottom: 1rem;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .cta-text {
        font-size: 1.1rem;
        color: rgba(255,255,255,0.8);
        margin-bottom: 3rem;
        line-height: 1.6;
    }
    
    .btn-gallery-action,
    .btn-gallery-cta {
        display: inline-flex;
        align-items: center;
        gap: 0.75rem;
        padding: 1rem 2.5rem;
        font-weight: 600;
        font-size: 0.9rem;
        letter-spacing: 0.05em;
        text-transform: uppercase;
        text-decoration: none;
        transition: all var(--transition-base);
        position: relative;
        overflow: hidden;
        border-radius: 0;
        cursor: pointer;
        border: none;
    }
    
    .btn-gallery-action.primary {
        background: var(--primary-black);
        color: white;
        border: 2px solid var(--primary-black);
    }
    
    .btn-gallery-action.primary:hover {
        background: transparent;
        color: var(--primary-black);
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    }
    
    .btn-gallery-cta.primary {
        background: white;
        color: var(--primary-black);
        border: 2px solid white;
    }
    
    .btn-gallery-cta.primary:hover {
        background: transparent;
        color: white;
        border-color: white;
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(255,255,255,0.2);
    }
    
    /* Filter Animation */
    .gallery-section-premium.hidden {
        display: none;
    }
    
    .gallery-section-premium.fade-out {
        opacity: 0;
        transform: translateY(20px);
    }
    
    .gallery-section-premium.fade-in {
        opacity: 1;
        transform: translateY(0);
        transition: all var(--transition-base);
    }
    
    /* Responsive */
    @media (max-width: 768px) {
        .gallery-grid-premium {
            grid-template-columns: 1fr;
            gap: 2rem;
        }
        
        .gallery-image-wrapper {
            height: 300px;
        }
        
        .filter-buttons {
            gap: 0.5rem;
        }
        
        .filter-btn {
            padding: 0.5rem 1rem;
            font-size: 0.8rem;
            min-width: 100px;
        }
        
        .stats-glass-container {
            padding: 2rem;
        }
        
        .stat-number {
            font-size: 2rem;
        }
    }
    
    @media (max-width: 480px) {
        .hero-title-premium {
            font-size: 2.5rem;
        }
        
        .gallery-section-title {
            font-size: 2rem;
        }
        
        .gallery-image-wrapper {
            height: 250px;
        }
        
        .stats-glass-container {
            padding: 1.5rem;
        }
        
        .cta-title {
            font-size: 2rem;
        }
        
        .gallery-actions {
            flex-direction: column;
            gap: 0.5rem;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize AOS
    AOS.init({
        duration: 1000,
        easing: 'ease-out-cubic',
        once: true,
        offset: 100
    });
    
    // Filter functionality
    const filterBtns = document.querySelectorAll('.filter-btn');
    const gallerySections = document.querySelectorAll('.gallery-section-premium');
    
    filterBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            // Update active button
            filterBtns.forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            
            const filter = this.getAttribute('data-filter');
            
            gallerySections.forEach(section => {
                if (filter === 'all') {
                    section.classList.remove('hidden');
                } else {
                    const category = section.getAttribute('data-category');
                    if (category === filter) {
                        section.classList.remove('hidden');
                    } else {
                        section.classList.add('hidden');
                    }
                }
            });
        });
    });
    
    // Counter animation
    const counters = document.querySelectorAll('.stat-number');
    counters.forEach(counter => {
        const target = parseInt(counter.getAttribute('data-count'));
        const increment = target / 60;
        let current = 0;
        
        const updateCounter = () => {
            if (current < target) {
                current += increment;
                counter.textContent = Math.floor(current);
                requestAnimationFrame(updateCounter);
            } else {
                counter.textContent = target;
            }
        };
        
        // Start animation when element comes into view
        const observer = new IntersectionObserver((entries) => {
            if (entries[0].isIntersecting) {
                updateCounter();
                observer.disconnect();
            }
        });
        
        observer.observe(counter);
    });
    
    // Load more functionality
    const loadMoreBtn = document.getElementById('loadMoreBtn');
    let currentlyShown = 2; // Number of sections currently shown
    
    loadMoreBtn.addEventListener('click', function() {
        // Show more sections or simulate loading
        this.innerHTML = '<span>Loading...</span><i class="fas fa-spinner fa-spin"></i>';
        
        setTimeout(() => {
            this.innerHTML = '<span>LOAD MORE STYLES</span><i class="fas fa-chevron-down"></i>';
            // In a real app, you would load more content here
        }, 1000);
    });
});

function likeImage(btn) {
    const icon = btn.querySelector('i');
    const countSpan = btn.querySelector('.like-count');
    const isLiked = icon.classList.contains('fas');
    
    if (!isLiked) {
        icon.classList.remove('far');
        icon.classList.add('fas');
        btn.style.background = 'var(--accent-red)';
        btn.style.borderColor = 'var(--accent-red)';
        btn.style.color = 'white';
        
        // Increment count
        if (countSpan) {
            const count = parseInt(countSpan.textContent);
            countSpan.textContent = count + 1;
        }
    } else {
        icon.classList.remove('fas');
        icon.classList.add('far');
        btn.style.background = 'rgba(255,255,255,0.2)';
        btn.style.borderColor = 'rgba(255,255,255,0.3)';
        btn.style.color = 'white';
        
        // Decrement count
        if (countSpan) {
            const count = parseInt(countSpan.textContent);
            countSpan.textContent = count - 1;
        }
    }
}

function openModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) {
        const bootstrapModal = new bootstrap.Modal(modal);
        bootstrapModal.show();
    }
}

function shareImage(userName) {
    if (navigator.share) {
        navigator.share({
            title: 'Edition By Punjab Community Style',
            text: `Check out ${userName}'s amazing style from our community!`,
            url: window.location.href
        });
    } else {
        // Fallback for browsers without native sharing
        navigator.clipboard.writeText(window.location.href);
        alert('Link copied to clipboard!');
    }
}
</script>
<?php $__env->stopPush(); ?>

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "CollectionPage",
    "name": "Community Style Gallery - Edition By Punjab",
    "description": "Browse our community style gallery featuring real customers showcasing their Edition By Punjab streetwear looks across Australia",
    "url": "<?php echo e(route('community.gallery')); ?>",
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "<?php echo e(route('home')); ?>"
    },
    "mainEntity": {
        "@type": "ImageGallery",
        "name": "Edition By Punjab Community Gallery"
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio6\resources\views/community/gallery.blade.php ENDPATH**/ ?>