<?php $__env->startSection('title', 'Size Finder - Find Your Perfect Fit | Edition By Punjab'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="Interactive size finder tool for Edition By Punjab streetwear. Answer a few questions to find your perfect fit for hoodies, tees, and bottoms.">
<meta name="keywords" content="size finder, perfect fit, streetwear sizing tool, interactive size guide, clothing fit calculator">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if (isset($component)) { $__componentOriginal269900abaed345884ce342681cdc99f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal269900abaed345884ce342681cdc99f6 = $attributes; } ?>
<?php $component = App\View\Components\Breadcrumb::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $attributes = $__attributesOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__attributesOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $component = $__componentOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__componentOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>

<!-- Hero Section -->
<section class="finder-hero py-5" style="background: linear-gradient(135deg, #43cea2 0%, #185a9d 100%);">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8 mx-auto text-center text-white">
                <h1 class="display-4 fw-bold mb-4">Perfect Size Finder</h1>
                <p class="lead mb-4">Answer a few simple questions and we'll recommend your ideal size for the perfect fit every time</p>
                <div class="finder-benefits d-flex justify-content-center gap-4 mb-4">
                    <div class="benefit-item">
                        <i class="fas fa-magic fa-2x mb-2"></i>
                        <div>AI-Powered</div>
                    </div>
                    <div class="benefit-item">
                        <i class="fas fa-clock fa-2x mb-2"></i>
                        <div>2 Minutes</div>
                    </div>
                    <div class="benefit-item">
                        <i class="fas fa-bullseye fa-2x mb-2"></i>
                        <div>95% Accuracy</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Size Finder Tool -->
<section class="size-finder-tool py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="finder-card bg-white rounded-lg shadow-lg p-5">
                    <!-- Progress Bar -->
                    <div class="progress-section mb-4">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <small class="text-muted">Step <span id="currentStep">1</span> of 6</small>
                            <small class="text-muted"><span id="progressPercent">16</span>% Complete</small>
                        </div>
                        <div class="progress" style="height: 6px;">
                            <div class="progress-bar" id="progressBar" role="progressbar" style="width: 16%"></div>
                        </div>
                    </div>
                    
                    <!-- Step 1: Product Category -->
                    <div class="finder-step active" id="step-1">
                        <h3 class="mb-4 text-center">What are you looking to buy?</h3>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="category-option" data-value="hoodies">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-hoodie fa-3x text-primary mb-3"></i>
                                        <h5>Hoodies & Sweatshirts</h5>
                                        <p class="text-muted mb-0">Oversized streetwear comfort</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="category-option" data-value="tees">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-tshirt fa-3x text-primary mb-3"></i>
                                        <h5>T-Shirts & Tees</h5>
                                        <p class="text-muted mb-0">Comfortable everyday wear</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="category-option" data-value="bottoms">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-user-tie fa-3x text-primary mb-3"></i>
                                        <h5>Bottoms & Joggers</h5>
                                        <p class="text-muted mb-0">Tapered street style</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="category-option" data-value="accessories">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-hat-cowboy fa-3x text-primary mb-3"></i>
                                        <h5>Accessories</h5>
                                        <p class="text-muted mb-0">Caps, beanies & more</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Step 2: Current Size -->
                    <div class="finder-step" id="step-2">
                        <h3 class="mb-4 text-center">What size do you usually wear?</h3>
                        <div class="size-selector">
                            <div class="row g-2 justify-content-center" id="sizeOptions">
                                <div class="col-auto">
                                    <button class="btn btn-outline-primary size-btn" data-value="XS">XS</button>
                                </div>
                                <div class="col-auto">
                                    <button class="btn btn-outline-primary size-btn" data-value="S">S</button>
                                </div>
                                <div class="col-auto">
                                    <button class="btn btn-outline-primary size-btn" data-value="M">M</button>
                                </div>
                                <div class="col-auto">
                                    <button class="btn btn-outline-primary size-btn" data-value="L">L</button>
                                </div>
                                <div class="col-auto">
                                    <button class="btn btn-outline-primary size-btn" data-value="XL">XL</button>
                                </div>
                                <div class="col-auto">
                                    <button class="btn btn-outline-primary size-btn" data-value="XXL">XXL</button>
                                </div>
                            </div>
                        </div>
                        <div class="text-center mt-4">
                            <small class="text-muted">Select the size you typically wear in similar clothing</small>
                        </div>
                    </div>
                    
                    <!-- Step 3: Preferred Fit -->
                    <div class="finder-step" id="step-3">
                        <h3 class="mb-4 text-center">How do you prefer your clothes to fit?</h3>
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="fit-option" data-value="tight">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-compress fa-2x text-primary mb-3"></i>
                                        <h6>Tight/Fitted</h6>
                                        <small class="text-muted">Close to body</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="fit-option" data-value="regular">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-expand fa-2x text-primary mb-3"></i>
                                        <h6>Regular</h6>
                                        <small class="text-muted">True to size</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="fit-option" data-value="loose">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-expand-arrows-alt fa-2x text-primary mb-3"></i>
                                        <h6>Loose/Oversized</h6>
                                        <small class="text-muted">Relaxed fit</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Step 4: Body Build -->
                    <div class="finder-step" id="step-4">
                        <h3 class="mb-4 text-center">What's your body build?</h3>
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="build-option" data-value="slim">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-male fa-2x text-primary mb-3"></i>
                                        <h6>Slim/Lean</h6>
                                        <small class="text-muted">Narrow frame</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="build-option" data-value="average">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-user fa-2x text-primary mb-3"></i>
                                        <h6>Average</h6>
                                        <small class="text-muted">Medium build</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="build-option" data-value="broad">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-user-plus fa-2x text-primary mb-3"></i>
                                        <h6>Broad/Muscular</h6>
                                        <small class="text-muted">Wide shoulders</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Step 5: Height -->
                    <div class="finder-step" id="step-5">
                        <h3 class="mb-4 text-center">What's your height?</h3>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="height-option" data-value="short">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-arrows-alt-v fa-2x text-primary mb-3"></i>
                                        <h6>Under 170cm</h6>
                                        <small class="text-muted">5'7" and below</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="height-option" data-value="average">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-arrows-alt-v fa-2x text-primary mb-3"></i>
                                        <h6>170-185cm</h6>
                                        <small class="text-muted">5'7" - 6'1"</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="height-option" data-value="tall">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-arrows-alt-v fa-2x text-primary mb-3"></i>
                                        <h6>Over 185cm</h6>
                                        <small class="text-muted">6'1" and above</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Step 6: Usage -->
                    <div class="finder-step" id="step-6">
                        <h3 class="mb-4 text-center">How will you primarily wear this?</h3>
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="usage-option" data-value="casual">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-home fa-2x text-primary mb-3"></i>
                                        <h6>Casual/Lounging</h6>
                                        <small class="text-muted">Comfort first</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="usage-option" data-value="street">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-walking fa-2x text-primary mb-3"></i>
                                        <h6>Street/Daily</h6>
                                        <small class="text-muted">Everyday style</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="usage-option" data-value="active">
                                    <div class="option-card p-4 text-center border rounded-lg">
                                        <i class="fas fa-running fa-2x text-primary mb-3"></i>
                                        <h6>Active/Gym</h6>
                                        <small class="text-muted">Movement focused</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Results -->
                    <div class="finder-step" id="results" style="display: none;">
                        <div class="text-center mb-4">
                            <i class="fas fa-check-circle fa-4x text-success mb-3"></i>
                            <h3>Your Perfect Size</h3>
                            <p class="lead text-muted">Based on your preferences, we recommend:</p>
                        </div>
                        
                        <div class="result-card p-4 bg-light rounded-lg text-center mb-4">
                            <h2 class="text-primary mb-3">Size <span id="recommendedSize">M</span></h2>
                            <div class="confidence-score mb-3">
                                <div class="progress mx-auto" style="width: 200px; height: 10px;">
                                    <div class="progress-bar bg-success" id="confidenceBar" style="width: 95%"></div>
                                </div>
                                <small class="text-muted mt-2 d-block"><span id="confidencePercent">95</span>% Confidence Match</small>
                            </div>
                            
                            <div id="sizeExplanation" class="explanation-text mb-3">
                                <p>This size will give you the perfect balance of comfort and style based on your preferences.</p>
                            </div>
                        </div>
                        
                        <div class="size-alternatives mb-4" id="alternatives">
                            <h5 class="mb-3">Alternative Sizes</h5>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="alternative-size p-3 bg-white rounded border">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <strong>Size S</strong>
                                            <small class="text-success">Tighter fit</small>
                                        </div>
                                        <small class="text-muted">For a more fitted look</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="alternative-size p-3 bg-white rounded border">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <strong>Size L</strong>
                                            <small class="text-info">Looser fit</small>
                                        </div>
                                        <small class="text-muted">For extra comfort</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="action-buttons text-center">
                            <a href="<?php echo e(route('shop.index')); ?>" class="btn btn-primary btn-lg me-3">
                                Shop Now <i class="fas fa-shopping-bag ms-2"></i>
                            </a>
                            <button class="btn btn-outline-primary btn-lg" onclick="restartFinder()">
                                Try Another Product <i class="fas fa-redo ms-2"></i>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Navigation Buttons -->
                    <div class="finder-navigation mt-5">
                        <div class="d-flex justify-content-between">
                            <button class="btn btn-outline-secondary" id="prevBtn" onclick="previousStep()" disabled>
                                <i class="fas fa-arrow-left me-2"></i>Previous
                            </button>
                            <button class="btn btn-primary" id="nextBtn" onclick="nextStep()" disabled>
                                Next<i class="fas fa-arrow-right ms-2"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Size Finder Benefits -->
<section class="finder-benefits-section-premium">
    <div class="container">
        <div class="section-header-center" data-aos="fade-up">
            <span class="section-label-premium">WHY USE OUR FINDER</span>
            <h2 class="section-title-premium">Why Use Our Size Finder?</h2>
            <p class="section-subtitle">Get the perfect fit with science-backed recommendations</p>
        </div>
        
        <div class="benefits-grid">
            <div class="benefit-card-premium" data-aos="fade-up">
                <div class="benefit-icon-wrapper">
                    <i class="fas fa-brain"></i>
                </div>
                <h5 class="benefit-title">Smart Algorithm</h5>
                <p class="benefit-text">Our AI considers your body type, preferences, and product specifications to make accurate recommendations.</p>
            </div>
            
            <div class="col-lg-4 col-md-6">
                <div class="benefit-card text-center p-4 bg-white rounded-lg h-100">
                    <i class="fas fa-chart-line fa-3x text-primary mb-3"></i>
                    <h5 class="mb-3">Data-Driven</h5>
                    <p class="text-muted">Based on thousands of customer fits and feedback to continuously improve accuracy.</p>
                </div>
            </div>
            
            <div class="col-lg-4 col-md-6">
                <div class="benefit-card text-center p-4 bg-white rounded-lg h-100">
                    <i class="fas fa-exchange-alt fa-3x text-primary mb-3"></i>
                    <h5 class="mb-3">Exchange Guarantee</h5>
                    <p class="text-muted">Free size exchanges if our recommendation doesn't fit perfectly - we're that confident!</p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('styles'); ?>
<style>
/* Premium Finder Styles */
.finder-hero-premium {
    position: relative;
    min-height: 100vh;
    display: flex;
    align-items: center;
    background: linear-gradient(135deg, rgba(67, 206, 162, 0.95) 0%, rgba(24, 90, 157, 0.95) 100%), url('/api/placeholder/1920/1080') center/cover;
    color: white;
    overflow: hidden;
}

.finder-hero-premium .hero-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, rgba(24, 90, 157, 0.8) 0%, rgba(67, 206, 162, 0.6) 100%);
}

.finder-benefits-premium {
    display: flex;
    justify-content: center;
    gap: 2rem;
    margin-top: 3rem;
    flex-wrap: wrap;
}

.benefit-item-premium {
    text-align: center;
    padding: 1.5rem;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 20px;
    backdrop-filter: blur(10px);
    min-width: 140px;
    transition: transform 0.3s ease;
}

.benefit-item-premium:hover {
    transform: translateY(-5px);
}

.benefit-icon {
    width: 60px;
    height: 60px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
}

.benefit-icon i {
    font-size: 1.5rem;
    color: white;
}

.benefit-text {
    font-weight: 600;
    font-size: 0.9rem;
    opacity: 0.95;
}

.size-finder-tool-premium {
    padding: 5rem 0;
    background: #f8f9fa;
}

.finder-card-premium {
    background: white;
    border-radius: 25px;
    padding: 3rem;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
    min-height: 600px;
    position: relative;
    overflow: hidden;
}

.finder-card-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 6px;
    background: linear-gradient(135deg, #43cea2 0%, #185a9d 100%);
}

.progress-section-premium {
    margin-bottom: 3rem;
}

.progress-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
}

.progress-label,
.progress-percentage {
    font-size: 0.875rem;
    font-weight: 600;
    color: #6c757d;
}

.progress-bar-premium {
    width: 100%;
    height: 8px;
    background: #e9ecef;
    border-radius: 10px;
    overflow: hidden;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(135deg, #43cea2 0%, #185a9d 100%);
    border-radius: 10px;
    transition: width 0.3s ease;
}

.finder-step-premium {
    display: none;
    min-height: 400px;
}

.finder-step-premium.active {
    display: block;
}

.step-title {
    text-align: center;
    font-size: 1.75rem;
    font-weight: 700;
    color: #1a237e;
    margin-bottom: 3rem;
    line-height: 1.3;
}

.options-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
}

.category-option,
.fit-option,
.build-option,
.height-option,
.usage-option {
    cursor: pointer;
}

.option-card-premium {
    background: white;
    border: 2px solid #e9ecef;
    border-radius: 20px;
    padding: 2rem;
    text-align: center;
    transition: all 0.3s ease;
    height: 100%;
    position: relative;
    overflow: hidden;
}

.option-card-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 4px;
    background: linear-gradient(135deg, #43cea2 0%, #185a9d 100%);
    transition: left 0.3s ease;
}

.option-card-premium:hover {
    border-color: #43cea2;
    transform: translateY(-10px);
    box-shadow: 0 20px 40px rgba(67, 206, 162, 0.2);
}

.option-card-premium:hover::before,
.option-card-premium.selected::before {
    left: 0;
}

.option-card-premium.selected {
    border-color: #43cea2;
    background: linear-gradient(135deg, #f0fff4 0%, #e6fffa 100%);
    transform: translateY(-10px);
    box-shadow: 0 20px 40px rgba(67, 206, 162, 0.25);
}

.option-icon {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, #43cea2 0%, #185a9d 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    transition: transform 0.3s ease;
}

.option-card-premium:hover .option-icon {
    transform: scale(1.1);
}

.option-icon i {
    color: white;
    font-size: 2rem;
}

.option-title {
    font-size: 1.25rem;
    font-weight: 600;
    color: #1a237e;
    margin-bottom: 1rem;
}

.option-desc {
    color: #6c757d;
    font-size: 0.95rem;
    line-height: 1.5;
    margin: 0;
}

.size-btn {
    width: 70px;
    height: 70px;
    border-radius: 50%;
    border: 2px solid #e9ecef;
    background: white;
    color: #6c757d;
    font-weight: 700;
    font-size: 1.1rem;
    transition: all 0.3s ease;
    cursor: pointer;
}

.size-btn:hover,
.size-btn.active {
    border-color: #43cea2;
    background: linear-gradient(135deg, #43cea2 0%, #185a9d 100%);
    color: white;
    transform: scale(1.15);
    box-shadow: 0 10px 25px rgba(67, 206, 162, 0.3);
}

.result-card {
    background: linear-gradient(135deg, #f0fff4 0%, #e6fffa 100%);
    border: 2px solid #43cea2;
    border-radius: 20px;
    padding: 2rem;
    text-align: center;
}

.confidence-score .progress {
    height: 12px;
    border-radius: 10px;
    background: #e9ecef;
}

.confidence-score .progress-bar {
    background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%);
    border-radius: 10px;
}

.alternative-size {
    background: white;
    border: 2px solid #e9ecef;
    border-radius: 15px;
    padding: 1.5rem;
    transition: all 0.3s ease;
}

.alternative-size:hover {
    border-color: #43cea2;
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(67, 206, 162, 0.15);
}

.finder-navigation {
    margin-top: 3rem;
}

.btn {
    border-radius: 50px;
    padding: 0.75rem 2rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    transition: all 0.3s ease;
}

.btn-primary {
    background: linear-gradient(135deg, #43cea2 0%, #185a9d 100%);
    border: none;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(67, 206, 162, 0.3);
}

.btn-outline-secondary {
    border: 2px solid #e9ecef;
    color: #6c757d;
}

.btn-outline-secondary:hover {
    border-color: #43cea2;
    background: #43cea2;
    color: white;
    transform: translateY(-2px);
}

/* Benefits Section Premium */
.finder-benefits-section-premium {
    padding: 5rem 0;
    background: #f8f9fa;
}

.benefits-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 2rem;
    margin-top: 3rem;
}

.benefit-card-premium {
    background: white;
    padding: 2.5rem;
    border-radius: 20px;
    text-align: center;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
    border: 2px solid transparent;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.benefit-card-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 4px;
    background: linear-gradient(135deg, #43cea2 0%, #185a9d 100%);
    transition: left 0.3s ease;
}

.benefit-card-premium:hover {
    transform: translateY(-15px);
    box-shadow: 0 25px 50px rgba(0, 0, 0, 0.1);
    border-color: #43cea2;
}

.benefit-card-premium:hover::before {
    left: 0;
}

.benefit-icon-wrapper {
    width: 100px;
    height: 100px;
    background: linear-gradient(135deg, #43cea2 0%, #185a9d 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 2rem;
    transition: transform 0.3s ease;
}

.benefit-card-premium:hover .benefit-icon-wrapper {
    transform: scale(1.1);
}

.benefit-icon-wrapper i {
    color: white;
    font-size: 2.5rem;
}

.benefit-title {
    font-size: 1.5rem;
    font-weight: 700;
    color: #1a237e;
    margin-bottom: 1rem;
}

.benefit-text {
    color: #6c757d;
    line-height: 1.7;
    font-size: 1rem;
    margin: 0;
}

/* Responsive Design */
@media (max-width: 768px) {
    .finder-benefits-premium {
        gap: 1rem;
        margin-top: 2rem;
    }
    
    .benefit-item-premium {
        min-width: 120px;
        padding: 1rem;
    }
    
    .step-title {
        font-size: 1.5rem;
    }
    
    .options-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .finder-card-premium {
        padding: 2rem 1.5rem;
        min-height: auto;
    }
    
    .benefits-grid {
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
let currentStepNumber = 1;
let totalSteps = 6;
let answers = {};

function updateProgress() {
    const progressPercent = Math.round((currentStepNumber / totalSteps) * 100);
    document.getElementById('currentStep').textContent = currentStepNumber;
    document.getElementById('progressPercent').textContent = progressPercent;
    document.getElementById('progressBar').style.width = progressPercent + '%';
}

function showStep(stepNumber) {
    // Hide all steps
    document.querySelectorAll('.finder-step').forEach(step => {
        step.classList.remove('active');
    });
    
    // Show current step
    document.getElementById('step-' + stepNumber).classList.add('active');
    
    // Update navigation
    document.getElementById('prevBtn').disabled = stepNumber === 1;
    document.getElementById('nextBtn').style.display = stepNumber === totalSteps ? 'none' : 'block';
    
    updateProgress();
}

function nextStep() {
    if (currentStepNumber < totalSteps) {
        currentStepNumber++;
        showStep(currentStepNumber);
    } else if (currentStepNumber === totalSteps) {
        calculateResult();
    }
}

function previousStep() {
    if (currentStepNumber > 1) {
        currentStepNumber--;
        showStep(currentStepNumber);
    }
}

function calculateResult() {
    // Simple size recommendation algorithm
    let baseSize = answers.currentSize || 'M';
    let recommendedSize = baseSize;
    
    // Adjust based on preferences
    if (answers.fitPreference === 'tight' && answers.build === 'slim') {
        recommendedSize = getSmallerSize(baseSize);
    } else if (answers.fitPreference === 'loose' || answers.category === 'hoodies') {
        recommendedSize = getLargerSize(baseSize);
    }
    
    // Show results
    showResults(recommendedSize);
}

function getSmallerSize(size) {
    const sizes = ['XS', 'S', 'M', 'L', 'XL', 'XXL'];
    const index = sizes.indexOf(size);
    return index > 0 ? sizes[index - 1] : size;
}

function getLargerSize(size) {
    const sizes = ['XS', 'S', 'M', 'L', 'XL', 'XXL'];
    const index = sizes.indexOf(size);
    return index < sizes.length - 1 ? sizes[index + 1] : size;
}

function showResults(recommendedSize) {
    document.getElementById('recommendedSize').textContent = recommendedSize;
    
    // Generate explanation based on answers
    let explanation = generateExplanation();
    document.getElementById('sizeExplanation').innerHTML = '<p>' + explanation + '</p>';
    
    // Hide current step and show results
    document.querySelectorAll('.finder-step').forEach(step => {
        step.classList.remove('active');
    });
    document.getElementById('results').style.display = 'block';
    
    // Hide navigation
    document.querySelector('.finder-navigation').style.display = 'none';
}

function generateExplanation() {
    let explanation = 'Based on your preferences for ';
    
    if (answers.category === 'hoodies') {
        explanation += 'hoodies and your preference for a ' + answers.fitPreference + ' fit, ';
    } else if (answers.category === 'tees') {
        explanation += 't-shirts and your ' + answers.build + ' build, ';
    } else {
        explanation += answers.category + ' and your sizing preferences, ';
    }
    
    explanation += 'this size will provide the perfect balance of comfort and style.';
    
    return explanation;
}

function restartFinder() {
    currentStepNumber = 1;
    answers = {};
    
    // Reset all selections
    document.querySelectorAll('.option-card').forEach(card => {
        card.classList.remove('selected');
    });
    document.querySelectorAll('.size-btn').forEach(btn => {
        btn.classList.remove('active');
    });
    
    // Show first step
    showStep(1);
    document.getElementById('results').style.display = 'none';
    document.querySelector('.finder-navigation').style.display = 'block';
    document.getElementById('nextBtn').disabled = true;
}

// Event listeners for option selection
document.addEventListener('DOMContentLoaded', function() {
    // Category selection
    document.querySelectorAll('.category-option').forEach(option => {
        option.addEventListener('click', function() {
            document.querySelectorAll('.category-option .option-card').forEach(card => {
                card.classList.remove('selected');
            });
            this.querySelector('.option-card').classList.add('selected');
            answers.category = this.dataset.value;
            document.getElementById('nextBtn').disabled = false;
        });
    });
    
    // Size selection
    document.querySelectorAll('.size-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            document.querySelectorAll('.size-btn').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            answers.currentSize = this.dataset.value;
            document.getElementById('nextBtn').disabled = false;
        });
    });
    
    // Fit preference
    document.querySelectorAll('.fit-option').forEach(option => {
        option.addEventListener('click', function() {
            document.querySelectorAll('.fit-option .option-card').forEach(card => {
                card.classList.remove('selected');
            });
            this.querySelector('.option-card').classList.add('selected');
            answers.fitPreference = this.dataset.value;
            document.getElementById('nextBtn').disabled = false;
        });
    });
    
    // Build selection
    document.querySelectorAll('.build-option').forEach(option => {
        option.addEventListener('click', function() {
            document.querySelectorAll('.build-option .option-card').forEach(card => {
                card.classList.remove('selected');
            });
            this.querySelector('.option-card').classList.add('selected');
            answers.build = this.dataset.value;
            document.getElementById('nextBtn').disabled = false;
        });
    });
    
    // Height selection
    document.querySelectorAll('.height-option').forEach(option => {
        option.addEventListener('click', function() {
            document.querySelectorAll('.height-option .option-card').forEach(card => {
                card.classList.remove('selected');
            });
            this.querySelector('.option-card').classList.add('selected');
            answers.height = this.dataset.value;
            document.getElementById('nextBtn').disabled = false;
        });
    });
    
    // Usage selection
    document.querySelectorAll('.usage-option').forEach(option => {
        option.addEventListener('click', function() {
            document.querySelectorAll('.usage-option .option-card').forEach(card => {
                card.classList.remove('selected');
            });
            this.querySelector('.option-card').classList.add('selected');
            answers.usage = this.dataset.value;
            document.getElementById('nextBtn').textContent = 'Get My Size';
            document.getElementById('nextBtn').innerHTML = 'Get My Size <i class="fas fa-magic ms-2"></i>';
            document.getElementById('nextBtn').disabled = false;
        });
    });
    
    // Initialize first step
    showStep(1);
});
</script>
<?php $__env->stopPush(); ?>

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "WebApplication",
    "name": "Edition By Punjab Size Finder",
    "description": "Interactive size finder tool to help customers find their perfect fit",
    "url": "<?php echo e(route('size-guide.finder')); ?>",
    "applicationCategory": "UtilityApplication",
    "operatingSystem": "Any",
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "<?php echo e(route('home')); ?>"
    },
    "offers": {
        "@type": "Offer",
        "price": "0",
        "priceCurrency": "AUD"
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/size-guide/finder.blade.php ENDPATH**/ ?>